/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.Timer;

class Autoscroller
implements ActionListener {
    private static Autoscroller sharedInstance = new Autoscroller();
    private static MouseEvent event;
    private static Timer timer;
    private static JComponent component;

    public static void stop(JComponent jComponent) {
        sharedInstance._stop(jComponent);
    }

    public static boolean isRunning(JComponent jComponent) {
        return sharedInstance._isRunning(jComponent);
    }

    public static void processMouseDragged(MouseEvent mouseEvent) {
        sharedInstance._processMouseDragged(mouseEvent);
    }

    Autoscroller() {
    }

    private void start(JComponent jComponent, MouseEvent mouseEvent) {
        Point point = jComponent.getLocationOnScreen();
        if (component != jComponent) {
            this._stop(component);
        }
        component = jComponent;
        event = new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() + point.x, mouseEvent.getY() + point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
        if (timer == null) {
            timer = new Timer(100, this);
        }
        if (!timer.isRunning()) {
            timer.start();
        }
    }

    private void _stop(JComponent jComponent) {
        if (component == jComponent) {
            if (timer != null) {
                timer.stop();
            }
            timer = null;
            event = null;
            component = null;
        }
    }

    private boolean _isRunning(JComponent jComponent) {
        return jComponent == component && timer != null && timer.isRunning();
    }

    private void _processMouseDragged(MouseEvent mouseEvent) {
        JComponent jComponent = (JComponent)mouseEvent.getComponent();
        Rectangle rectangle = jComponent.getVisibleRect();
        boolean bl = rectangle.contains(mouseEvent.getX(), mouseEvent.getY());
        if (bl) {
            this._stop(jComponent);
        } else {
            this.start(jComponent, mouseEvent);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JComponent jComponent = component;
        if (jComponent == null || !jComponent.isShowing() || event == null) {
            this._stop(jComponent);
            return;
        }
        Point point = jComponent.getLocationOnScreen();
        MouseEvent mouseEvent = new MouseEvent(jComponent, event.getID(), event.getWhen(), event.getModifiers(), event.getX() - point.x, event.getY() - point.y, event.getClickCount(), event.isPopupTrigger());
        jComponent.superProcessMouseMotionEvent(mouseEvent);
    }
}

