/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import sun.misc.FloatingDecimal;
import sun.misc.FpUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Float
extends Number
implements Comparable<Float> {
    public static final float POSITIVE_INFINITY = 1.0f / 0.0f;
    public static final float NEGATIVE_INFINITY = -1.0f / 0.0f;
    public static final float NaN = 0.0f / 0.0f;
    public static final float MAX_VALUE = 3.4028235E38f;
    public static final float MIN_VALUE = 1.4E-45f;
    public static final int SIZE = 32;
    public static final Class<Float> TYPE = Class.getPrimitiveClass("float");
    private final float value;
    private static final long serialVersionUID = -2671257302660747028L;

    public static String toString(float f) {
        return new FloatingDecimal(f).toJavaFormatString();
    }

    public static String toHexString(float f) {
        if (Math.abs(f) < Float.MIN_NORMAL && f != 0.0f) {
            String string = Double.toHexString(FpUtils.scalb((double)f, -896));
            return string.replaceFirst("p-1022$", "p-126");
        }
        return Double.toHexString(f);
    }

    public static Float valueOf(String string) throws NumberFormatException {
        return new Float(FloatingDecimal.readJavaFormatString(string).floatValue());
    }

    public static Float valueOf(float f) {
        return new Float(f);
    }

    public static float parseFloat(String string) throws NumberFormatException {
        return FloatingDecimal.readJavaFormatString(string).floatValue();
    }

    public static boolean isNaN(float f) {
        return f != f;
    }

    public static boolean isInfinite(float f) {
        return f == Float.POSITIVE_INFINITY || f == Float.NEGATIVE_INFINITY;
    }

    public Float(float f) {
        this.value = f;
    }

    public Float(double d) {
        this.value = (float)d;
    }

    public Float(String string) throws NumberFormatException {
        this(Float.valueOf(string).floatValue());
    }

    public boolean isNaN() {
        return Float.isNaN(this.value);
    }

    public boolean isInfinite() {
        return Float.isInfinite(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    public boolean equals(Object object) {
        return object instanceof Float && Float.floatToIntBits(((Float)object).value) == Float.floatToIntBits(this.value);
    }

    public static native int floatToIntBits(float var0);

    public static native int floatToRawIntBits(float var0);

    public static native float intBitsToFloat(int var0);

    @Override
    public int compareTo(Float f) {
        return Float.compare(this.value, f.value);
    }

    public static int compare(float f, float f2) {
        int n;
        if (f < f2) {
            return -1;
        }
        if (f > f2) {
            return 1;
        }
        int n2 = Float.floatToIntBits(f);
        return n2 == (n = Float.floatToIntBits(f2)) ? 0 : (n2 < n ? -1 : 1);
    }
}

