/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.verifier.structurals;

import com.sun.org.apache.bcel.internal.generic.CodeExceptionGen;
import com.sun.org.apache.bcel.internal.generic.InstructionHandle;
import com.sun.org.apache.bcel.internal.generic.MethodGen;
import com.sun.org.apache.bcel.internal.verifier.structurals.ExceptionHandler;
import java.util.HashSet;
import java.util.Hashtable;

public class ExceptionHandlers {
    private Hashtable exceptionhandlers = new Hashtable();

    public ExceptionHandlers(MethodGen methodGen) {
        CodeExceptionGen[] codeExceptionGenArray = methodGen.getExceptionHandlers();
        for (int i = 0; i < codeExceptionGenArray.length; ++i) {
            ExceptionHandler exceptionHandler = new ExceptionHandler(codeExceptionGenArray[i].getCatchType(), codeExceptionGenArray[i].getHandlerPC());
            for (InstructionHandle instructionHandle = codeExceptionGenArray[i].getStartPC(); instructionHandle != codeExceptionGenArray[i].getEndPC().getNext(); instructionHandle = instructionHandle.getNext()) {
                HashSet<ExceptionHandler> hashSet = (HashSet<ExceptionHandler>)this.exceptionhandlers.get(instructionHandle);
                if (hashSet == null) {
                    hashSet = new HashSet<ExceptionHandler>();
                    this.exceptionhandlers.put(instructionHandle, hashSet);
                }
                hashSet.add(exceptionHandler);
            }
        }
    }

    public ExceptionHandler[] getExceptionHandlers(InstructionHandle instructionHandle) {
        HashSet hashSet = (HashSet)this.exceptionhandlers.get(instructionHandle);
        if (hashSet == null) {
            return new ExceptionHandler[0];
        }
        ExceptionHandler[] exceptionHandlerArray = new ExceptionHandler[hashSet.size()];
        return hashSet.toArray(exceptionHandlerArray);
    }
}

