/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.WindowsGraphicsUtils;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class WindowsButtonUI
extends BasicButtonUI {
    private static final WindowsButtonUI windowsButtonUI = new WindowsButtonUI();
    protected int dashedRectGapX;
    protected int dashedRectGapY;
    protected int dashedRectGapWidth;
    protected int dashedRectGapHeight;
    protected Color focusColor;
    private boolean defaults_initialized = false;
    private static Rectangle viewRect = new Rectangle();

    public static ComponentUI createUI(JComponent jComponent) {
        return windowsButtonUI;
    }

    protected void installDefaults(AbstractButton abstractButton) {
        Object object;
        super.installDefaults(abstractButton);
        if (!this.defaults_initialized) {
            object = this.getPropertyPrefix();
            this.dashedRectGapX = UIManager.getInt((String)object + "dashedRectGapX");
            this.dashedRectGapY = UIManager.getInt((String)object + "dashedRectGapY");
            this.dashedRectGapWidth = UIManager.getInt((String)object + "dashedRectGapWidth");
            this.dashedRectGapHeight = UIManager.getInt((String)object + "dashedRectGapHeight");
            this.focusColor = UIManager.getColor((String)object + "focus");
            this.defaults_initialized = true;
        }
        if ((object = XPStyle.getXP()) != null) {
            abstractButton.setBorder(((XPStyle)object).getBorder(abstractButton, WindowsButtonUI.getXPButtonType(abstractButton)));
            LookAndFeel.installProperty(abstractButton, "rolloverEnabled", Boolean.TRUE);
        }
    }

    protected void uninstallDefaults(AbstractButton abstractButton) {
        super.uninstallDefaults(abstractButton);
        this.defaults_initialized = false;
    }

    protected Color getFocusColor() {
        return this.focusColor;
    }

    protected void paintText(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, String string) {
        WindowsGraphicsUtils.paintText(graphics, abstractButton, rectangle, string, this.getTextShiftOffset());
    }

    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        if (abstractButton.getParent() instanceof JToolBar) {
            return;
        }
        if (XPStyle.getXP() != null) {
            return;
        }
        int n = abstractButton.getWidth();
        int n2 = abstractButton.getHeight();
        graphics.setColor(this.getFocusColor());
        BasicGraphicsUtils.drawDashedRect(graphics, this.dashedRectGapX, this.dashedRectGapY, n - this.dashedRectGapWidth, n2 - this.dashedRectGapHeight);
    }

    protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
        this.setTextShiftOffset();
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        AbstractButton abstractButton = (AbstractButton)jComponent;
        if (dimension != null && abstractButton.isFocusPainted()) {
            if (dimension.width % 2 == 0) {
                ++dimension.width;
            }
            if (dimension.height % 2 == 0) {
                ++dimension.height;
            }
        }
        return dimension;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        if (XPStyle.getXP() != null) {
            WindowsButtonUI.paintXPButtonBackground(graphics, jComponent);
        }
        super.paint(graphics, jComponent);
    }

    static String getXPButtonType(AbstractButton abstractButton) {
        boolean bl = abstractButton.getParent() instanceof JToolBar;
        return bl ? "toolbar.button" : "button.pushbutton";
    }

    static void paintXPButtonBackground(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        XPStyle xPStyle = XPStyle.getXP();
        boolean bl = abstractButton.getParent() instanceof JToolBar;
        String string = WindowsButtonUI.getXPButtonType(abstractButton);
        if (abstractButton.isContentAreaFilled() && xPStyle != null) {
            ButtonModel buttonModel = abstractButton.getModel();
            XPStyle.Skin skin = xPStyle.getSkin(abstractButton, string);
            int n = 0;
            if (bl) {
                if (buttonModel.isArmed() && buttonModel.isPressed()) {
                    n = 2;
                } else if (!buttonModel.isEnabled()) {
                    n = 3;
                } else if (buttonModel.isSelected() && buttonModel.isRollover()) {
                    n = 5;
                } else if (buttonModel.isSelected()) {
                    n = 4;
                } else if (buttonModel.isRollover()) {
                    n = 1;
                }
            } else if (buttonModel.isArmed() && buttonModel.isPressed() || buttonModel.isSelected()) {
                n = 2;
            } else if (!buttonModel.isEnabled()) {
                n = 3;
            } else if (buttonModel.isRollover() || buttonModel.isPressed()) {
                n = 1;
            } else if (abstractButton instanceof JButton && ((JButton)abstractButton).isDefaultButton()) {
                n = 4;
            } else if (jComponent.hasFocus()) {
                n = 1;
            }
            Dimension dimension = jComponent.getSize();
            int n2 = 0;
            int n3 = 0;
            int n4 = dimension.width;
            int n5 = dimension.height;
            Border border = jComponent.getBorder();
            Insets insets = border != null ? WindowsButtonUI.getOpaqueInsets(border, jComponent) : jComponent.getInsets();
            if (insets != null) {
                n2 += insets.left;
                n3 += insets.top;
                n4 -= insets.left + insets.right;
                n5 -= insets.top + insets.bottom;
            }
            skin.paintSkin(graphics, n2, n3, n4, n5, n);
        }
    }

    private static Insets getOpaqueInsets(Border border, Component component) {
        if (border == null) {
            return null;
        }
        if (border.isBorderOpaque()) {
            return border.getBorderInsets(component);
        }
        if (border instanceof CompoundBorder) {
            CompoundBorder compoundBorder = (CompoundBorder)border;
            Insets insets = WindowsButtonUI.getOpaqueInsets(compoundBorder.getOutsideBorder(), component);
            if (insets != null && insets.equals(compoundBorder.getOutsideBorder().getBorderInsets(component))) {
                Insets insets2 = WindowsButtonUI.getOpaqueInsets(compoundBorder.getInsideBorder(), component);
                if (insets2 == null) {
                    return insets;
                }
                return new Insets(insets.top + insets2.top, insets.left + insets2.left, insets.bottom + insets2.bottom, insets.right + insets2.right);
            }
            return insets;
        }
        return null;
    }
}

