/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.panel;

import com.sun.deploy.config.Config;
import com.sun.deploy.panel.DeleteFilesDialog;
import com.sun.deploy.panel.JSmartTextArea;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class CacheSettingsDialog
extends JDialog {
    private String LIB = "lib";
    private String PLUGIN_JAR = "plugin.jar";
    private String DEPLOY_JAR = "deploy.jar";
    private String VIEWER = "sun.plugin.cache.JarCacheViewer";
    private String CLASSPATH = "-classpath";
    private JTextField location;
    private JTextField size;
    private JButton choose;
    private JButton okBtn;
    private JButton cancelBtn;
    private JButton viewJwsCacheBtn;
    private JButton deleteFilesBtn;
    private JButton viewJpiCacheBtn;
    private JRadioButton unlimited;
    private JRadioButton maximum;
    private JComboBox units;
    private JSlider compression;

    public CacheSettingsDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
    }

    private void initComponents() {
        this.setTitle(this.getMessage("cache.settings.dialog.title"));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.deleteFilesBtn = this.makeButton("cache.settings.dialog.delete_btn");
        this.deleteFilesBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CacheSettingsDialog.this.deleteFilesBtnActionPerformed(actionEvent);
            }
        });
        this.deleteFilesBtn.setToolTipText(this.getMessage("temp.files.delete.btn.tooltip"));
        this.viewJwsCacheBtn = this.makeButton("cache.settings.dialog.view_jws_btn");
        this.viewJwsCacheBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CacheSettingsDialog.this.viewJwsCacheBtnActionPerformed(actionEvent);
            }
        });
        this.viewJwsCacheBtn.setToolTipText(this.getMessage("cache.settings.dialog.view_jws_btn.tooltip"));
        this.viewJpiCacheBtn = this.makeButton("cache.settings.dialog.view_jpi_btn");
        this.viewJpiCacheBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CacheSettingsDialog.this.viewJpiCacheBtnActionPerformed(actionEvent);
            }
        });
        this.viewJpiCacheBtn.setToolTipText(this.getMessage("cache.settings.dialog.view_jpi_btn.tooltip"));
        jPanel.add(this.deleteFilesBtn);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.viewJwsCacheBtn);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.viewJpiCacheBtn);
        this.getContentPane().add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel2.setLayout(gridBagLayout);
        Border border = BorderFactory.createEtchedBorder();
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 4, 4, 4), BorderFactory.createTitledBorder(border, this.getMessage("common.settings"), 0, 0)));
        JLabel jLabel = new JLabel(this.getMessage("cache.settings.dialog.cache_location"));
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 3.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel2.add(jLabel);
        this.location = new LocationField();
        this.location.setDocument(new LocationDocument());
        this.location.setEditable(false);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(5, 0, 5, 2);
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.location, gridBagConstraints);
        jPanel2.add(this.location);
        this.choose = this.makeButton("cache.settings.dialog.change_btn");
        this.choose.setMargin(new Insets(0, 10, 0, 10));
        this.choose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CacheSettingsDialog.this.chooseButtonActionPerformed(actionEvent);
            }
        });
        this.choose.setToolTipText(this.getMessage("cache.settings.dialog.change_btn.tooltip"));
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 2, 5, 10);
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.choose, gridBagConstraints);
        jPanel2.add(this.choose);
        JSmartTextArea jSmartTextArea = new JSmartTextArea(this.getMessage("cache.settings.dialog.disk_space"));
        jSmartTextArea.setRows(2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(5, 5, 10, 10);
        gridBagLayout.setConstraints(jSmartTextArea, gridBagConstraints);
        jPanel2.add(jSmartTextArea);
        gridBagConstraints.gridheight = 1;
        ButtonGroup buttonGroup = new ButtonGroup();
        this.unlimited = new JRadioButton(this.getMessage("cache.settings.dialog.unlimited_btn"));
        this.unlimited.setToolTipText(this.getMessage("cache.settings.dialog.unlimited_btn.tooltip"));
        this.unlimited.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CacheSettingsDialog.this.radioButtonActionPerformed(actionEvent);
            }
        });
        this.unlimited.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagLayout.setConstraints(this.unlimited, gridBagConstraints);
        buttonGroup.add(this.unlimited);
        jPanel2.add(this.unlimited);
        this.maximum = new JRadioButton(this.getMessage("cache.settings.dialog.max_btn"));
        this.maximum.setToolTipText(this.getMessage("cache.settings.dialog.max_btn.tooltip"));
        this.maximum.setMargin(new Insets(0, 0, 0, 0));
        this.maximum.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CacheSettingsDialog.this.radioButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        gridBagLayout.setConstraints(this.maximum, gridBagConstraints);
        buttonGroup.add(this.maximum);
        jPanel2.add(this.maximum);
        this.size = new JTextField(7);
        this.size.setDocument(new SizeDocument());
        gridBagConstraints.gridx = -1;
        gridBagLayout.setConstraints(this.size, gridBagConstraints);
        jPanel2.add(this.size);
        String[] stringArray = new String[]{"MB", "KB", "bytes"};
        this.units = new JComboBox<String>(stringArray);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 2, 10, 10);
        gridBagLayout.setConstraints(this.units, gridBagConstraints);
        jPanel2.add(this.units);
        JLabel jLabel2 = new JLabel(this.getMessage("cache.settings.dialog.compression"));
        jLabel2.setToolTipText(this.getMessage("cache.settings.dialog.compression.tooltip"));
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel2.add(jLabel2);
        this.compression = new JSlider(0, 9, 0);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>(2);
        JLabel jLabel3 = new JLabel(this.getMessage("cache.settings.dialog.none"));
        JLabel jLabel4 = new JLabel(this.getMessage("cache.settings.dialog.high"));
        hashtable.put(new Integer(0), jLabel3);
        hashtable.put(new Integer(9), jLabel4);
        this.compression.setLabelTable(hashtable);
        this.compression.setPaintLabels(true);
        this.compression.setMajorTickSpacing(1);
        this.compression.setPaintTicks(true);
        this.compression.setSnapToTicks(true);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 5, 10);
        gridBagLayout.setConstraints(this.compression, gridBagConstraints);
        jPanel2.add(this.compression);
        this.getContentPane().add((Component)jPanel2, "Center");
        this.okBtn = this.makeButton("common.ok_btn");
        this.okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CacheSettingsDialog.this.okBtnActionPerformed(actionEvent);
            }
        });
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                CacheSettingsDialog.this.cancelBtnActionPerformed(actionEvent);
            }
        };
        this.cancelBtn = this.makeButton("common.cancel_btn");
        this.cancelBtn.addActionListener(abstractAction);
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke('\u001b'), "cancel");
        this.getRootPane().getActionMap().put("cancel", abstractAction);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(2));
        jPanel3.add(this.okBtn);
        jPanel3.add(this.cancelBtn);
        this.getContentPane().add((Component)jPanel3, "South");
        this.getRootPane().setDefaultButton(this.okBtn);
        this.pack();
        this.setResizable(false);
        this.initValues();
    }

    public void initValues() {
        this.location.setText(Config.getCacheDirectory());
        this.location.setToolTipText(this.location.getText());
        this.location.setHorizontalAlignment(2);
        boolean bl = !Config.isLocked("deployment.user.cachedir") && !Config.getInstance().isPlatformWindowsVista();
        this.location.setEnabled(bl);
        this.location.setEditable(bl);
        this.choose.setEnabled(bl);
        String string = Config.getProperty("deployment.cache.max.size").trim();
        bl = !Config.isLocked("deployment.cache.max.size");
        try {
            int n = 0;
            if (string.endsWith("M") || string.endsWith("m")) {
                string = string.substring(0, string.length() - 1);
                n = 0;
            } else if (string.endsWith("K") || string.endsWith("k")) {
                string = string.substring(0, string.length() - 1);
                n = 1;
            } else {
                n = 2;
            }
            long l = Long.valueOf(string);
            if (l == -1L) {
                this.unlimited.setSelected(true);
                this.size.setEnabled(false);
                this.size.setEditable(false);
                this.units.setEnabled(false);
            } else {
                this.maximum.setSelected(true);
                this.size.setText(string);
                this.units.setSelectedIndex(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            long l = 50L;
            this.maximum.setSelected(true);
            this.units.setSelectedIndex(0);
        }
        if (!bl) {
            this.unlimited.setEnabled(bl);
            this.maximum.setEnabled(bl);
            this.size.setEnabled(bl);
            this.units.setEnabled(bl);
        }
        bl = !Config.isLocked("deployment.cache.jarcompression");
        this.compression.setValue(Config.getIntProperty("deployment.cache.jarcompression"));
        this.compression.setEnabled(bl);
    }

    private void viewJpiCacheBtnActionPerformed(ActionEvent actionEvent) {
        String string = System.getProperty("java.home");
        String string2 = System.getProperty("javaplugin.user.profile");
        if (string2 == null) {
            string2 = "";
        }
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        String[] stringArray = new String[]{Config.getInstance().toExecArg(Config.getJavaCommand()), this.CLASSPATH, Config.getInstance().toExecArg(string + this.LIB + File.separator + this.PLUGIN_JAR + File.pathSeparator + string + this.LIB + File.separator + this.DEPLOY_JAR), Config.getInstance().toExecArg("-Djavaplugin.user.profile=" + string2), this.VIEWER};
        Trace.println("Launching plug-in Cache Viewer: " + stringArray[0] + " " + stringArray[1] + " " + stringArray[2] + " " + stringArray[3] + " " + stringArray[4]);
        try {
            Runtime.getRuntime().exec(stringArray);
        }
        catch (IOException iOException) {
            Trace.ignoredException(iOException);
        }
    }

    private void viewJwsCacheBtnActionPerformed(ActionEvent actionEvent) {
        String[] stringArray = new String[]{Config.getJavawsCommand(), "-Xnosplash", "-viewer"};
        Trace.println("Launching javaws viewer: " + stringArray[0] + " " + stringArray[1], TraceLevel.BASIC);
        try {
            Runtime.getRuntime().exec(stringArray);
        }
        catch (IOException iOException) {
            Trace.ignoredException(iOException);
        }
    }

    private void chooseButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setDialogTitle(this.getMessage("cache.settings.dialog.chooser_title"));
        jFileChooser.setApproveButtonText(this.getMessage("cache.settings.dialog.select"));
        String string = this.getMessage("cache.settings.dialog.select_tooltip");
        jFileChooser.setApproveButtonToolTipText(string);
        char c = this.getMessage("cache.settings.dialog.select_mnemonic").charAt(0);
        jFileChooser.setApproveButtonMnemonic(c);
        File file = new File(this.location.getText());
        jFileChooser.setCurrentDirectory(file);
        if (jFileChooser.showDialog(this, null) == 0) {
            String string2;
            try {
                string2 = jFileChooser.getSelectedFile().getCanonicalPath();
            }
            catch (IOException iOException) {
                string2 = jFileChooser.getSelectedFile().getPath();
            }
            this.location.setText(string2);
            this.location.setToolTipText(string2);
        }
    }

    private void deleteFilesBtnActionPerformed(ActionEvent actionEvent) {
        new DeleteFilesDialog(this);
    }

    private void radioButtonActionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.unlimited)) {
            this.size.setEnabled(false);
            this.size.setEditable(false);
            this.units.setEnabled(false);
        } else {
            this.size.setEditable(true);
            this.size.setEnabled(true);
            this.units.setEnabled(true);
        }
    }

    private void okBtnActionPerformed(ActionEvent actionEvent) {
        Config.setCacheDirectory(this.location.getText());
        this.updateSize();
        Config.setIntProperty("deployment.cache.jarcompression", this.compression.getValue());
        this.setVisible(false);
        this.dispose();
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private void updateSize() {
        String string;
        if (this.unlimited.isSelected()) {
            string = "-1";
        } else {
            string = this.size.getText().trim();
            if (string.equals("")) {
                string = "0";
            }
            long l = Long.valueOf(string);
            string = Long.toString(l);
            int n = this.units.getSelectedIndex();
            String[] stringArray = new String[]{"m", "k", ""};
            string = string + stringArray[n];
        }
        Config.setProperty("deployment.cache.max.size", string);
    }

    private String getMessage(String string) {
        return ResourceManager.getMessage(string);
    }

    public JButton makeButton(String string) {
        JButton jButton = new JButton(this.getMessage(string));
        jButton.setMnemonic(ResourceManager.getVKCode(string + ".mnemonic"));
        return jButton;
    }

    private class LocationDocument
    extends PlainDocument {
        private LocationDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            super.insertString(n, string, attributeSet);
        }

        public void remove(int n, int n2) throws BadLocationException {
            super.remove(n, n2);
        }
    }

    private class LocationField
    extends JTextField {
        private LocationField() {
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.width = 10;
            return dimension;
        }
    }

    private class SizeDocument
    extends PlainDocument {
        private SizeDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (this.isNumeric(string)) {
                super.insertString(n, string, attributeSet);
                CacheSettingsDialog.this.maximum.setSelected(true);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        public void remove(int n, int n2) throws BadLocationException {
            super.remove(n, n2);
            CacheSettingsDialog.this.maximum.setSelected(true);
        }

        private boolean isNumeric(String string) {
            try {
                Long.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            return true;
        }
    }
}

