/*
 * Decompiled with CFR 0.152.
 */
package com.fdsapi.arrays;

import com.fdsapi.FDSStack;
import com.fdsapi.ResultSetUtils;
import com.fdsapi.arrays.ArrayFilter;
import com.fdsapi.arrays.Conditional;
import com.fdsapi.arrays.FDSArraysRuntimeException;
import com.fdsapi.arrays.WhereClauseParser;
import com.fdsapi.arrays.WhereClauseToken;
import java.util.ArrayList;
import java.util.List;

public class WhereClauseTokens {
    private List tokens = new ArrayList();
    private FDSStack compositeStack;
    private WhereClauseToken[] tokensArray;
    private String validationError = "";
    private static boolean throwValidationExceptions = true;
    private int currentToken = -1;
    private static final WhereClauseToken NULLTOKEN = new WhereClauseToken("null");

    public WhereClauseTokens() {
        this.resetCompositeStack();
    }

    public static void setThrowValidationExceptions(boolean throwExceptions) {
        throwValidationExceptions = throwExceptions;
    }

    public static boolean getThrowValidationExceptions() {
        return throwValidationExceptions;
    }

    public void addConditional(Conditional cond) {
        this.addToken(new WhereClauseToken(cond));
    }

    public void addLeftParen() {
        this.addToken(new WhereClauseToken("("));
    }

    public void addRightParen() {
        this.addToken(new WhereClauseToken(")"));
    }

    public void addAnd() {
        this.addToken(new WhereClauseToken("and"));
    }

    public void addOr() {
        this.addToken(new WhereClauseToken("or"));
    }

    public void addNot() {
        this.addToken(new WhereClauseToken("!"));
    }

    private void addToken(WhereClauseToken token) {
        this.tokensArray = null;
        this.tokens.add(token);
    }

    private void addToken(String token) {
        this.addToken(new WhereClauseToken(token));
    }

    public WhereClauseToken[] getTokens() {
        if (this.tokens.isEmpty()) {
            this.tokensArray = null;
        } else if (this.tokensArray == null) {
            this.tokensArray = new WhereClauseToken[this.tokens.size()];
            this.tokens.toArray(this.tokensArray);
        }
        return this.tokensArray;
    }

    public Object[][] getCreateData() {
        ArrayList<Object[]> createData = new ArrayList<Object[]>();
        this.resetCompositeStack();
        while (this.next()) {
            Object[] row = new Object[]{this.getCurrentToken(), this.getCreateComposite(), this.getConditionalToAdd(), this.getCompositeToAdd(), this.getStackAction(), this.getLastTokenIndicator()};
            createData.add(row);
        }
        ResultSetUtils rsu = ResultSetUtils.createInstance();
        return rsu.listToObjectArray(createData);
    }

    private String getCreateComposite() {
        if (this.getCurrentToken().isLeftParen()) {
            return this.createOrComposite();
        }
        if (this.getCurrentToken().isAnd() && this.getCurrentComposite().isOr()) {
            return this.createAndComposite();
        }
        return "nocreate";
    }

    private String createAndComposite() {
        this.pushComposite(new Composite("and"));
        return "createAndComposite";
    }

    private String createOrComposite() {
        this.pushComposite(new Composite("or"));
        return "createOrComposite";
    }

    private String getConditionalToAdd() {
        if (this.getCurrentToken().isOperator() && this.getPrevToken().isConditional()) {
            return "addConditional";
        }
        if (this.getCurrentToken().isRightParen() && this.getPrevToken().isConditional()) {
            return "addConditional";
        }
        if (this.getCurrentToken().isConditional() && this.isLastToken()) {
            return "addConditional";
        }
        return "noAdd";
    }

    private String getCompositeToAdd() {
        if (this.getCurrentToken().isRightParen() && this.getPrevToken().isRightParen()) {
            return "addComposite";
        }
        if (this.getCurrentToken().isOperator() && this.getPrevToken().isRightParen()) {
            return "addComposite";
        }
        return "noAdd";
    }

    private String getStackAction() {
        if (this.getCurrentToken().isOr() && this.getCurrentComposite().isAnd()) {
            this.popComposite();
            return "pop1";
        }
        if (this.getCurrentToken().isRightParen()) {
            int popCounter = 1;
            if (this.getCurrentComposite().isAnd()) {
                ++popCounter;
                this.popComposite();
            }
            this.popComposite();
            return "pop" + popCounter;
        }
        return "noPop";
    }

    private String getLastTokenIndicator() {
        return this.isLastToken() ? "lastToken" : "notLastToken";
    }

    private WhereClauseToken getFirstToken() {
        return this.getTokens()[0];
    }

    private WhereClauseToken getCurrentToken() {
        return this.getToken(this.currentToken);
    }

    private boolean next() {
        if (this.currentToken < this.getNumTokens() - 1) {
            ++this.currentToken;
            return true;
        }
        this.currentToken = -1;
        return false;
    }

    private WhereClauseToken getNextToken() {
        return this.getToken(this.currentToken + 1);
    }

    private WhereClauseToken getPrevToken() {
        return this.getToken(this.currentToken - 1);
    }

    private WhereClauseToken getLastToken() {
        return this.getTokens()[this.getNumTokens() - 1];
    }

    private int getNumTokens() {
        return this.getTokens() == null ? 0 : this.getTokens().length;
    }

    private WhereClauseToken getToken(int i) {
        return i >= 0 && i < this.getNumTokens() ? this.getTokens()[i] : NULLTOKEN;
    }

    private boolean isLastToken() {
        return this.currentToken == this.getNumTokens() - 1;
    }

    public boolean validate() {
        if (this.getNumTokens() == 0) {
            return true;
        }
        if (!this.generalValidationRule()) {
            return false;
        }
        return this.individualTokenValidationRule();
    }

    private boolean generalValidationRule() {
        if (this.getNumTokens() == 1 && !this.getFirstToken().isConditional()) {
            return this.setValidationError("If there is only one where clause token it must be a conditional.  The token is: " + this.getFirstToken().getValue());
        }
        if (!(this.getFirstToken().isConditional() || this.getFirstToken().isLeftParen() || this.getFirstToken().isNot())) {
            return this.setValidationError("The first where clause token must be a conditional, a left paren, not or !.  The token is: " + this.getFirstToken().getValue());
        }
        if (!this.getLastToken().isConditional() && !this.getLastToken().isRightParen()) {
            return this.setValidationError("The last where clause token must be a conditional, or a right paren.  The token is: " + this.getLastToken().getValue());
        }
        return this.parensRule();
    }

    private boolean parensRule() {
        int leftParens = 0;
        int rightParens = 0;
        for (int i = 0; i < this.getNumTokens(); ++i) {
            if (this.getToken(i).isLeftParen()) {
                ++leftParens;
            } else if (this.getToken(i).isRightParen()) {
                ++rightParens;
            }
            if (rightParens <= leftParens) continue;
            return this.setValidationError("The number of right parens exceeded the number of left parens. There are " + leftParens + " left parens, and " + rightParens + " right parens.");
        }
        if (leftParens != rightParens) {
            return this.setValidationError("The number of left parens must match the number of right parens.  There are " + leftParens + " left parens, and " + rightParens + " right parens.");
        }
        return true;
    }

    private boolean individualTokenValidationRule() {
        for (int i = 0; i < this.getNumTokens() - 1; ++i) {
            WhereClauseToken token = this.getToken(i);
            boolean valid = token.isValid(this.getToken(i + 1));
            if (valid) continue;
            return this.setValidationError(token.getValidationError() + " - token: " + token.getValue() + ", token index: " + i);
        }
        return true;
    }

    public String getValidationError() {
        return this.validationError;
    }

    private boolean setValidationError(String validationError) {
        this.validationError = validationError;
        if (WhereClauseTokens.getThrowValidationExceptions()) {
            throw new FDSArraysRuntimeException(validationError);
        }
        return false;
    }

    private void pushComposite(Composite obj) {
        this.compositeStack.push(obj);
    }

    private Composite popComposite() {
        return (Composite)this.compositeStack.pop();
    }

    private Composite getCurrentComposite() {
        return (Composite)this.compositeStack.getCurrent();
    }

    private void resetCompositeStack() {
        this.compositeStack = new FDSStack();
        this.pushComposite(new Composite("or"));
    }

    public String toString() {
        WhereClauseToken[] array = this.getTokens();
        if (array == null) {
            return "";
        }
        String buffer = " where ";
        for (int i = 0; i < array.length; ++i) {
            buffer = buffer + array[i] + " ";
        }
        return buffer;
    }

    static String getRowString(Object[][] buildData, int i) {
        return "token" + i + " build data:  (token=" + buildData[i][0] + ", " + buildData[i][1] + ", " + buildData[i][2] + ", " + buildData[i][3] + ", " + buildData[i][4] + ", " + buildData[i][5] + ")";
    }

    private static void printDebugInfo(int testNumber, String whereClause) {
        String[] header = new String[]{"fname", "lname", "rank"};
        Object[][] data = new Object[][]{{"jeff", "beck", new Integer(1)}, {"steve", "smith", new Integer(2)}, {"steve", "souza", new Integer(3)}};
        WhereClauseParser p = new WhereClauseParser(data, whereClause, new ArrayFilter(header));
        String[] values = p.parse();
        WhereClauseTokens tokens = new WhereClauseTokens();
        for (int i = 0; i < values.length; ++i) {
            tokens.addToken(values[i]);
        }
        System.out.println("\n" + testNumber + ") whereClause=" + whereClause);
        boolean passedValidation = tokens.validate();
        System.out.println("validate()= " + passedValidation + ", validation error=" + tokens.getValidationError());
        if (passedValidation) {
            Object[][] buildData = tokens.getCreateData();
            for (int i = 0; i < buildData.length; ++i) {
                System.out.println(WhereClauseTokens.getRowString(buildData, i));
            }
        }
        System.out.println("WhereClauseTokens.toString(): " + tokens);
    }

    public static void main(String[] args) {
        WhereClauseTokens.setThrowValidationExceptions(false);
        WhereClauseTokens.printDebugInfo(1, "conditional || conditional && conditional && (conditional || conditional)");
        WhereClauseTokens.printDebugInfo(3, "||");
        WhereClauseTokens.printDebugInfo(4, "conditional || || conditional && conditional && (conditional || conditional)");
        WhereClauseTokens.printDebugInfo(6, "conditional || ");
        WhereClauseTokens.printDebugInfo(7, "(conditional");
        WhereClauseTokens.printDebugInfo(8, "(conditional)) || conditional");
        WhereClauseTokens.printDebugInfo(9, "conditional && conditional && conditional  || conditional && conditional");
        WhereClauseTokens.printDebugInfo(10, "conditional || conditional || conditional && conditional");
        WhereClauseTokens.printDebugInfo(12, "conditional || conditional && conditional && conditional");
        WhereClauseTokens.printDebugInfo(13, "((conditional || conditional) && conditional && conditional)");
        WhereClauseTokens.printDebugInfo(14, "(((conditional || conditional) && conditional) && (conditional && conditional) || conditional && conditional)");
        WhereClauseTokens.printDebugInfo(15, "(((conditional || conditional) && conditional) && (conditional && conditional) && conditional && conditional)");
        WhereClauseTokens.printDebugInfo(16, "(conditional || conditional) && (conditional) &&  conditional && conditional || conditional");
        WhereClauseTokens.printDebugInfo(17, "conditional || (conditional && conditional) || conditional");
        WhereClauseTokens.printDebugInfo(18, "conditional || (conditional && conditional) && conditional");
        WhereClauseTokens.printDebugInfo(19, "conditional && (conditional && conditional) && conditional");
        WhereClauseTokens.printDebugInfo(20, "conditional && (conditional && conditional) || conditional");
        WhereClauseTokens.printDebugInfo(21, "conditional || conditional && conditional");
        WhereClauseTokens.printDebugInfo(22, "conditional || conditional && conditional && conditional || conditional");
    }

    private static class Composite {
        private String type;

        public Composite(String type) {
            this.type = type;
        }

        public boolean isAnd() {
            return "and".equalsIgnoreCase(this.type);
        }

        public boolean isOr() {
            return "or".equalsIgnoreCase(this.type);
        }
    }
}

