/*
 * Decompiled with CFR 0.152.
 */
package com.fdsapi.arrays;

import com.fdsapi.arrays.Conditional;
import com.jamonapi.utils.AppMap;
import java.util.Map;

public class WhereClauseToken {
    private String token = "";
    private Conditional conditional;
    private String action;
    private WhereClauseTokenValidator tokenValidator = new WhereClauseTokenValidator();

    public WhereClauseToken(String token) {
        this.token = token;
        this.tokenValidator = this.tokenValidator.getTokenValidator(token);
    }

    public WhereClauseToken(Conditional conditional) {
        this.conditional = conditional;
        this.tokenValidator = this.tokenValidator.getTokenValidator("conditional");
        this.token = "conditional";
    }

    public String getValue() {
        return this.token;
    }

    public Conditional getConditional() {
        return this.conditional;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public boolean isLeftParen() {
        return "(".equals(this.token);
    }

    public boolean isRightParen() {
        return ")".equals(this.token);
    }

    public boolean isOr() {
        return "||".equals(this.token) || "or".equalsIgnoreCase(this.token);
    }

    public boolean isAnd() {
        return "&&".equals(this.token) || "and".equalsIgnoreCase(this.token);
    }

    public boolean isOperator() {
        return this.isAnd() || this.isOr();
    }

    public boolean isNot() {
        return "!".equals(this.token) || "not".equalsIgnoreCase(this.token);
    }

    public boolean isConditional() {
        return "conditional".equalsIgnoreCase(this.token);
    }

    public boolean isNull() {
        return "null".equalsIgnoreCase(this.token);
    }

    public boolean isTokenType(String argType) {
        return this.token.equalsIgnoreCase(argType);
    }

    public boolean isValid(WhereClauseToken nextToken) {
        return this.tokenValidator.isValid(nextToken);
    }

    public String getValidationError() {
        return this.tokenValidator.getValidationError();
    }

    public String toString() {
        if (this.conditional == null) {
            return this.token;
        }
        return this.conditional.toString();
    }

    private static class WhereClauseConditionalValidator
    extends WhereClauseTokenValidator {
        private WhereClauseConditionalValidator() {
        }

        public boolean isValid(WhereClauseToken nextToken) {
            if (nextToken == null || nextToken.isOperator() || nextToken.isRightParen()) {
                return true;
            }
            this.validationError = "A conditional must be followed by an operator (and, or), or a right paren";
            return false;
        }
    }

    private static class WhereClauseNotValidator
    extends WhereClauseTokenValidator {
        private WhereClauseNotValidator() {
        }

        public boolean isValid(WhereClauseToken nextToken) {
            if (nextToken.isConditional() || nextToken.isLeftParen() || nextToken.isNot()) {
                return true;
            }
            this.validationError = "The not conditional must be followed by a conditional, a left paren, or a not (either 'not' or '!')";
            return false;
        }
    }

    private static class WhereClauseAndValidator
    extends WhereClauseTokenValidator {
        private WhereClauseAndValidator() {
        }

        public boolean isValid(WhereClauseToken nextToken) {
            if (nextToken.isConditional() || nextToken.isLeftParen() || nextToken.isNot()) {
                return true;
            }
            this.validationError = "The 'and' operator must be followed by a conditional, a left paren, or a not (either 'not' or '!')";
            return false;
        }
    }

    private static class WhereClauseOrValidator
    extends WhereClauseTokenValidator {
        private WhereClauseOrValidator() {
        }

        public boolean isValid(WhereClauseToken nextToken) {
            if (nextToken.isConditional() || nextToken.isLeftParen() || nextToken.isNot()) {
                return true;
            }
            this.validationError = "The 'or' operator must be followed by a conditional, a left paren, or a not (either 'not' or '!')";
            return false;
        }
    }

    private static class WhereClauseRightParenValidator
    extends WhereClauseTokenValidator {
        private WhereClauseRightParenValidator() {
        }

        public boolean isValid(WhereClauseToken nextToken) {
            if (nextToken == null || nextToken.isOperator() || nextToken.isRightParen()) {
                return true;
            }
            this.validationError = "A right paren must be followed by an operator, or another right paren";
            return false;
        }
    }

    private static class WhereClauseLeftParenValidator
    extends WhereClauseTokenValidator {
        private WhereClauseLeftParenValidator() {
        }

        public boolean isValid(WhereClauseToken nextToken) {
            if (nextToken.isConditional() || nextToken.isLeftParen() || nextToken.isNot()) {
                return true;
            }
            this.validationError = "A left paren must be followed by a conditional, another left paren, or a not (either 'not' or '!')";
            return false;
        }
    }

    private static class WhereClauseTokenValidator {
        protected String validationError = "";
        private String createComposite = "no";
        private static Map factory = AppMap.createInstance();

        private WhereClauseTokenValidator() {
        }

        public String getValidationError() {
            return this.validationError;
        }

        public WhereClauseTokenValidator getTokenValidator(String token) {
            if (factory.containsKey(token)) {
                return (WhereClauseTokenValidator)factory.get(token);
            }
            return new WhereClauseConditionalValidator();
        }

        private static void addValidator(String key, WhereClauseTokenValidator validator) {
            factory.put(key, validator);
        }

        public boolean isValid(WhereClauseToken nextToken) {
            return false;
        }

        static {
            WhereClauseTokenValidator.addValidator("(", new WhereClauseLeftParenValidator());
            WhereClauseTokenValidator.addValidator(")", new WhereClauseRightParenValidator());
            WhereClauseTokenValidator.addValidator("or", new WhereClauseOrValidator());
            WhereClauseTokenValidator.addValidator("||", new WhereClauseOrValidator());
            WhereClauseTokenValidator.addValidator("and", new WhereClauseAndValidator());
            WhereClauseTokenValidator.addValidator("&&", new WhereClauseAndValidator());
            WhereClauseTokenValidator.addValidator("not", new WhereClauseNotValidator());
            WhereClauseTokenValidator.addValidator("!", new WhereClauseNotValidator());
            WhereClauseTokenValidator.addValidator("conditional", new WhereClauseConditionalValidator());
        }
    }
}

