/*
 * Decompiled with CFR 0.152.
 */
package com.fdsapi.arrays;

import com.fdsapi.Utils;
import com.fdsapi.arrays.ArrayFilter;
import com.fdsapi.arrays.ConditionalParser;
import java.util.ArrayList;
import java.util.List;

public class WhereClauseParser {
    private char[] whereClause;
    private List tokens = new ArrayList();
    private StringBuffer token = new StringBuffer();
    private int currentCharNum = 0;
    private boolean isInString = false;
    private char delim;
    private boolean isEscaped = false;
    private ArrayFilter arrayFilter;
    private boolean ignoreParens;
    private ConditionalParser conditionalParser = null;
    private boolean hasWhereClause;

    public WhereClauseParser(Object[][] data, String whereClauseStr, ArrayFilter arrayFilter) {
        this.hasWhereClause = whereClauseStr != null && !"".equals(whereClauseStr.trim());
        this.whereClause = this.hasWhereClause ? (" " + whereClauseStr + " ").toCharArray() : null;
        this.arrayFilter = arrayFilter;
        this.conditionalParser = new ConditionalParser(data, arrayFilter);
    }

    public WhereClauseParser(Object[][] data, String whereClauseStr) {
        this(data, whereClauseStr, new ArrayFilter());
    }

    public ArrayFilter getArrayFilter() {
        return this.arrayFilter;
    }

    private boolean isInString() {
        return this.isInString;
    }

    private void setIsInString(boolean isInString) {
        this.isInString = isInString;
    }

    private void setStringDelim(char delim) {
        this.delim = delim;
    }

    private char getStringDelim() {
        return this.delim;
    }

    private boolean isEscapeChar() {
        return '\\' == this.getCurrentChar();
    }

    private char getCurrentChar() {
        return this.whereClause[this.currentCharNum];
    }

    private char getNextChar() {
        return this.whereClause[this.currentCharNum + 1];
    }

    private char getPrevChar() {
        return this.whereClause[this.currentCharNum - 1];
    }

    private char getCharTwoForward() {
        return this.whereClause[this.currentCharNum + 2];
    }

    private char getCharThreeForward() {
        return this.whereClause[this.currentCharNum + 3];
    }

    private boolean isEscaped() {
        return this.isEscaped;
    }

    private void setEscaped(boolean isEscaped) {
        this.isEscaped = isEscaped;
    }

    private void setStringDelim() {
        if (!(this.isInString() || this.isEscaped() || this.getCurrentChar() != '\'' && this.getCurrentChar() != '\"')) {
            this.setStringDelim(this.getCurrentChar());
            this.setIsInString(true);
        } else if (this.isInString() && !this.isEscaped() && this.getCurrentChar() == this.getStringDelim()) {
            this.setIsInString(false);
        }
    }

    public void addWhereClause() {
        if (this.hasWhereClause) {
            String[] values = this.parse();
            for (int i = 0; i < values.length; ++i) {
                this.addWhereClauseToken(values[i].trim());
            }
        }
    }

    private void addWhereClauseToken(String token) {
        if ("(".equals(token)) {
            this.arrayFilter.addLeftParen();
        } else if (")".equals(token)) {
            this.arrayFilter.addRightParen();
        } else if ("||".equals(token) || "or".equalsIgnoreCase(token)) {
            this.arrayFilter.addOr();
        } else if ("&&".equals(token) || "and".equalsIgnoreCase(token)) {
            this.arrayFilter.addAnd();
        } else if ("!".equals(token)) {
            this.arrayFilter.addNot();
        } else {
            this.addConditional(token);
        }
    }

    public String[] parse() {
        if (!this.hasWhereClause) {
            return null;
        }
        this.currentCharNum = 1;
        while (this.currentCharNum < this.whereClause.length - 1) {
            if (this.isLeftParen()) {
                this.addLeftParen();
            } else if (this.isRightParen()) {
                this.addRightParen();
            } else if (this.isOr()) {
                this.addOr();
            } else if (this.isAnd()) {
                this.addAnd();
            } else if (this.isNot()) {
                this.addNot();
            } else if (this.isEscapeChar()) {
                this.addEscape();
            } else {
                this.addOtherChar();
            }
            ++this.currentCharNum;
        }
        this.addToken();
        return Utils.convert(this.tokens.toArray());
    }

    private boolean isLeftParen() {
        return !this.isInString() && !this.isIgnoreParens() && this.getCurrentChar() == '(';
    }

    private void addLeftParen() {
        this.setEscaped(false);
        this.addToken();
        this.addTokenChar('(');
        this.addToken();
    }

    private boolean isRightParen() {
        return !this.isInString() && !this.isIgnoreParens() && this.getCurrentChar() == ')';
    }

    private void addRightParen() {
        this.setEscaped(false);
        this.addToken();
        this.addTokenChar(')');
        this.addToken();
    }

    private boolean isNot() {
        return !this.isInString() && this.getCurrentChar() == '!' && this.getNextChar() != '=' && this.getNextChar() != 'l' && this.getNextChar() != 'L';
    }

    private void addNot() {
        this.setEscaped(false);
        this.addToken();
        this.addTokenChar('!');
        this.addToken();
    }

    private boolean isOr() {
        return !this.isInString() && (this.getCurrentChar() == '|' && this.getNextChar() == '|' || this.getPrevChar() == ' ' && (this.getCurrentChar() == 'o' || this.getCurrentChar() == 'O') && (this.getNextChar() == 'r' || this.getNextChar() == 'R') && this.getCharTwoForward() == ' ');
    }

    private void addOr() {
        this.setEscaped(false);
        this.addToken();
        this.addTokenChar('|');
        this.addTokenChar('|');
        this.addToken();
        ++this.currentCharNum;
    }

    private boolean isAnd() {
        return !(this.isInString() || (this.getCurrentChar() != '&' || this.getNextChar() != '&') && (this.getPrevChar() != ' ' || this.getCurrentChar() != 'a' && this.getCurrentChar() != 'A' || this.getNextChar() != 'n' && this.getNextChar() != 'N' || this.getCharTwoForward() != 'd' && this.getCharTwoForward() != 'D' || this.getCharThreeForward() != ' '));
    }

    private void addAnd() {
        this.setEscaped(false);
        this.addToken();
        this.addTokenChar('&');
        this.addTokenChar('&');
        this.addToken();
        this.currentCharNum = this.getCurrentChar() == '&' ? ++this.currentCharNum : (this.currentCharNum += 2);
    }

    private void addEscape() {
        if (this.isEscaped()) {
            this.setEscaped(false);
            this.addTokenChar(this.getCurrentChar());
        } else {
            this.setEscaped(true);
        }
    }

    private void addOtherChar() {
        this.setStringDelim();
        this.setIgnoreParens();
        this.setEscaped(false);
        this.addTokenChar(this.getCurrentChar());
    }

    private void setIgnoreParens() {
        if (!(this.isInString() || this.getPrevChar() != ' ' || this.getCurrentChar() != 'i' && this.getCurrentChar() != 'i' || this.getNextChar() != 'n' && this.getNextChar() != 'N' || this.getCharTwoForward() != ' ' && this.getCharTwoForward() != '(')) {
            this.setIgnoreParens(true);
        } else if (this.isIgnoreParens() && this.getCurrentChar() == ')') {
            this.setIgnoreParens(false);
        }
    }

    private void setIgnoreParens(boolean ignoreParens) {
        this.ignoreParens = ignoreParens;
    }

    private boolean isIgnoreParens() {
        return this.ignoreParens;
    }

    private void addTokenChar(char c) {
        this.token.append(c);
    }

    private void addToken() {
        if (this.token != null) {
            String trimmedToken = this.token.toString().trim();
            if (!"".equals(trimmedToken)) {
                this.tokens.add(trimmedToken);
                this.token.setLength(0);
            }
        } else {
            this.token = new StringBuffer();
        }
    }

    private void addConditional(String conditional) {
        this.conditionalParser.addConditional(conditional);
    }

    public static String getWhereClause(String query) {
        String matchStr = Utils.getREMatch("select +.* +from +array +where +(.*)( +order +by +)", query, 1);
        if (matchStr == null) {
            matchStr = Utils.getREMatch("select +.* +from +array +where +(.*)", query, 1);
        }
        return matchStr;
    }

    private static void printDebugInfo(String whereClauseStr) {
        String[] header = new String[]{"string", "lname", "short", "sand"};
        Object[][] data = new Object[][]{{"steve", "souza", new Integer(20), "sand"}, {"jeff", "beck", new Integer(20), "no sand"}};
        WhereClauseParser p = new WhereClauseParser(data, whereClauseStr, new ArrayFilter(header));
        p.addWhereClause();
        System.out.println("\n***");
        System.out.println("where clause=" + whereClauseStr);
        System.out.println("parsed ArrayFilter=" + p.getArrayFilter());
        p.getArrayFilter().filter(data);
    }

    public static void main(String[] args) {
        WhereClauseParser.printDebugInfo("short=20 || sand='no sand' or short=30 && sand='no sand' and sand='no sand'");
        WhereClauseParser.printDebugInfo("(string ='jeff in z')");
        WhereClauseParser.printDebugInfo("lname='steve' || sand='no sand'");
        WhereClauseParser.printDebugInfo("string='select' or string='from' or string='where' or string='order by' or string='string' or string='col0' or string='jeff'");
        WhereClauseParser.printDebugInfo(null);
        System.out.println("1) parsed where clause=" + WhereClauseParser.getWhereClause("select * from array where (string='select' or string='from' or string='where' or string=' order by ' or string='string' or string='col0' or string='jeff')"));
        System.out.println("2) parsed where clause=" + WhereClauseParser.getWhereClause("select * from array where string=\" order by \" or string=\"steve\""));
        System.out.println("3) parsed where clause=" + WhereClauseParser.getWhereClause("select * from array where (string='select' or string='from' or string='where' or  string='string' or string='col0' or string='jeff')"));
        System.out.println("4) parsed where clause=" + WhereClauseParser.getWhereClause("select * from array where string='select * from array where string=\"string\" order by string'"));
    }
}

