/*
 * Decompiled with CFR 0.152.
 */
package com.fdsapi.arrays;

import com.fdsapi.RegularExpression;
import com.fdsapi.Utils;
import com.fdsapi.arrays.ArrayFilter;

public class SelectColsParser {
    private String selectColsStr;
    private ArrayFilter arrayFilter;
    private int cols;
    private RegularExpression functions;

    public SelectColsParser(Object[][] data, String selectColsStr, ArrayFilter arrayFilter) {
        this.selectColsStr = selectColsStr;
        this.arrayFilter = arrayFilter;
        this.functions = new RegularExpression(arrayFilter.getColumnFunctionFactory().getFunctionREString());
        this.cols = data == null || data[0] == null ? 0 : data[0].length;
    }

    public SelectColsParser(Object[][] data, String selectColsStr) {
        this(data, selectColsStr, new ArrayFilter());
    }

    public void addSelectCols() {
        String[] cols = this.parse();
        for (int i = 0; i < cols.length; ++i) {
            this.addSelectCol(cols[i].trim());
        }
    }

    public void addSelectCol(String colValue) {
        if (this.isFunction(colValue = colValue.trim())) {
            this.arrayFilter.addDisplayFunction(colValue);
        } else if ("*".equals(colValue)) {
            this.addAllColumns();
        } else {
            this.arrayFilter.addDisplayCol(colValue);
        }
    }

    private boolean isFunction(String colValue) {
        this.functions.setSourceString(colValue);
        return this.functions.next();
    }

    private void addAllColumns() {
        for (int i = 0; i < this.cols; ++i) {
            this.arrayFilter.addDisplayCol(i);
        }
    }

    public String[] parse() {
        return Utils.split(",", this.selectColsStr);
    }

    public ArrayFilter getArrayFilter() {
        return this.arrayFilter;
    }

    public static String getSelectCols(String query) {
        return Utils.getREMatch("select +(.*) +from +array", query, 1);
    }

    public static void main(String[] args) {
        String[] header = new String[]{"fname", "lname"};
        Object[][] data = new Object[][]{{"steve", "souza"}, {"jeff", "beck"}};
        SelectColsParser p = new SelectColsParser(data, "lname as name, col1 as fname, rowNum(), date(), 'steve', \"souza\", col1, col2, fname , lname,*,*", new ArrayFilter(header));
        p.addSelectCols();
        System.out.println(p.getArrayFilter());
        String query = "    select string,col1,*,rowNum(),'steve' from array where col0='steve' ordery by col1";
        System.out.println("1) query=" + query);
        System.out.println("  query display cols=" + SelectColsParser.getSelectCols(query));
        query = "    select * from array where string='select' or string='from' or string='where' or string='string' or string='col0' or string='jeff'";
        System.out.println("2) query=" + query);
        System.out.println("  query display cols=" + SelectColsParser.getSelectCols(query));
        query = "    select rowNum() as rowsalias, * from array ";
        System.out.println("3) query=" + query);
        System.out.println("  query display cols=" + SelectColsParser.getSelectCols(query));
    }
}

