/*
 * Decompiled with CFR 0.152.
 */
package com.fdsapi.arrays;

import com.fdsapi.RegularExpression;
import com.fdsapi.Utils;
import com.fdsapi.arrays.ArrayComparator;

public class OrderByParser {
    private String orderByClause;
    private RegularExpression reColMatch1 = new RegularExpression("(\\w+) *(asc|desc|ascending|descending)?");
    private RegularExpression reColMatch2 = new RegularExpression("col([0-9]*)");
    private ArrayComparator arrayComp;

    public OrderByParser(String orderByClause, ArrayComparator arrayComp) {
        this.orderByClause = orderByClause;
        this.arrayComp = arrayComp;
    }

    public OrderByParser(String orderByClause) {
        this.orderByClause = orderByClause;
        this.arrayComp = new ArrayComparator();
    }

    public ArrayComparator getArrayComparator() {
        return this.arrayComp;
    }

    public void addSortCols() {
        String[] orderByCols = this.parse();
        for (int i = 0; i < orderByCols.length; ++i) {
            this.addSortCol(orderByCols[i].trim());
        }
    }

    public String[] parse() {
        if (this.orderByClause == null) {
            return new String[0];
        }
        return Utils.split(",", this.orderByClause);
    }

    public void addSortCol(String orderByCol) {
        this.reColMatch1.setSourceString(orderByCol);
        if (this.reColMatch1.next()) {
            String dir = this.reColMatch1.getParen(2);
            if (dir == null) {
                dir = "asc";
            }
            String col = this.reColMatch1.getParen(1);
            this.reColMatch2.setSourceString(col);
            if (this.reColMatch2.next()) {
                String colNumStr = this.reColMatch2.getParen(1);
                int colNum = Integer.parseInt(colNumStr);
                this.arrayComp.addSortCol(colNum, dir);
            } else {
                this.arrayComp.addSortCol(col, dir);
            }
        }
    }

    public static String prependOrderBy(String query, String sortCol, String sortOrder) {
        String select = OrderByParser.getSelect(query);
        String orderBy = OrderByParser.getOrderByClause(query);
        String orderByClause = "col" + sortCol + " " + sortOrder;
        orderBy = orderBy == null ? orderByClause : orderByClause + ", " + orderBy;
        return select + " order by " + orderBy;
    }

    private static String getSelect(String query) {
        return Utils.getREMatch("(select +.* +from +array).*", query, 1);
    }

    public static String getOrderByClause(String query) {
        return Utils.getREMatch(".* +order +by +(.*[^'\"])", query, 1);
    }

    public static void main(String[] args) {
        String[] header = new String[]{"fname", "lname"};
        OrderByParser p = new OrderByParser("col1, col2 desc, fname , lname", new ArrayComparator(header));
        p.addSortCols();
        System.out.println(p.getArrayComparator());
        System.out.println(OrderByParser.prependOrderBy("select * from array order by col1 des, col 2 asc, fname", "0", "asc"));
        System.out.println(OrderByParser.prependOrderBy("select * from array order by col1 des, col 2 asc, fname", "2", "desc"));
        System.out.println(OrderByParser.prependOrderBy("select * from array", "2", "desc"));
        System.out.println(OrderByParser.getSelect("select *,col1,rownum()  from     array order by col1 des, col 2 asc, fname"));
        System.out.println(OrderByParser.getSelect("select * from array order by col1 des, col 2 asc, fname"));
        System.out.println(OrderByParser.getSelect("SELECT     * from array"));
        System.out.println("1) order by clause=" + OrderByParser.getOrderByClause("select * from array where (string='select' or string='from' or string='where' or string=' order by ' or string='string' or string='col0' or string='jeff') order by string desc, col0 asc, col1"));
        System.out.println("2) order by clause=" + OrderByParser.getOrderByClause("select * from array    order    by col0 desc, col1 asc, string"));
        System.out.println("3) order by clause=" + OrderByParser.getOrderByClause("select * from array   where string=' order by '"));
        System.out.println("4) order by clause=" + OrderByParser.getOrderByClause("select rowNum(), * from array order by col0 desc"));
        System.out.println("5) order by clause=" + OrderByParser.getOrderByClause("select * from array where string='select * from array where string=\"string\" order by string'"));
        System.out.println("6) order by clause=" + OrderByParser.getOrderByClause("select * from array where string='select * from array where string=\"string\" order by string' order by string, col0"));
    }
}

