/*
 * Decompiled with CFR 0.152.
 */
package com.fdsapi.arrays;

import com.fdsapi.Utils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;

public class DataTypeParser {
    public boolean isNull(Object dataType) {
        return dataType == null;
    }

    public boolean isDate(Object dataType) {
        return dataType instanceof Date;
    }

    public boolean isString(Object dataType) {
        return dataType instanceof String;
    }

    public boolean isInteger(Object dataType) {
        return dataType instanceof Integer;
    }

    public boolean isBoolean(Object dataType) {
        return dataType instanceof Boolean;
    }

    public boolean isFloat(Object dataType) {
        return dataType instanceof Float;
    }

    public boolean isCharacter(Object dataType) {
        return dataType instanceof Character;
    }

    public boolean isDouble(Object dataType) {
        return dataType instanceof Double;
    }

    public boolean isBigDecimal(Object dataType) {
        return dataType instanceof BigDecimal;
    }

    public boolean isBigInteger(Object dataType) {
        return dataType instanceof BigInteger;
    }

    public boolean isLong(Object dataType) {
        return dataType instanceof Long;
    }

    public boolean isShort(Object dataType) {
        return dataType instanceof Short;
    }

    public boolean isDigit(char v) {
        return Character.isDigit(v);
    }

    public boolean isAlpha(char v) {
        return Character.isLetter(v);
    }

    public boolean isAlphaNumeric(char v) {
        return Character.isLetterOrDigit(v);
    }

    public boolean isFloatString(String str) {
        int decimalPointCount = 0;
        if (str == null) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            boolean flag;
            if (str.charAt(i) == '.') {
                ++decimalPointCount;
            }
            boolean bl = flag = this.isDigit(str.charAt(i)) && decimalPointCount <= 1;
            if (flag) continue;
            return false;
        }
        return true;
    }

    public boolean isIntegerString(String str) {
        if (str == null) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            boolean flag = this.isDigit(str.charAt(i));
            if (flag) continue;
            return false;
        }
        return true;
    }

    public boolean isAlpha(String str) {
        if (str == null) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            boolean flag = this.isAlpha(str.charAt(i));
            if (flag) continue;
            return false;
        }
        return true;
    }

    public boolean isAlphaNumeric(String str) {
        if (str == null) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            boolean flag = this.isAlphaNumeric(str.charAt(i));
            if (flag) continue;
            return false;
        }
        return false;
    }

    public boolean isDateString(String str) {
        if (str == null) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            boolean flag = this.isAlphaNumeric(str.charAt(i));
            if (flag) continue;
            return false;
        }
        return false;
    }

    public boolean isQuotedString(String str) {
        if (str == null || "".equals(str.trim())) {
            return false;
        }
        char first = str.charAt(0);
        char last = str.charAt(str.length() - 1);
        return (first == '\'' || first == '\"') && first == last;
    }

    public String stripQuotes(String str) {
        if (this.isQuotedString(str)) {
            str = str.substring(1, str.length() - 1);
        }
        return str;
    }

    private Object wrapperFactory(Object type, String valueToConvert) {
        if ("null".equalsIgnoreCase(valueToConvert)) {
            return this.wrapperFactory("null", null);
        }
        if (type == null) {
            return null;
        }
        if (this.isString(type)) {
            return this.wrapperFactory("String", this.stripQuotes(valueToConvert));
        }
        if (this.isInteger(type)) {
            return this.wrapperFactory("Integer", valueToConvert);
        }
        if (this.isFloat(type)) {
            return this.wrapperFactory("Float", valueToConvert);
        }
        if (this.isDate(type)) {
            return this.wrapperFactory("Date", this.stripQuotes(valueToConvert));
        }
        if (this.isBoolean(type)) {
            return this.wrapperFactory("Boolean", valueToConvert);
        }
        if (this.isCharacter(type)) {
            return this.wrapperFactory("Character", this.stripQuotes(valueToConvert));
        }
        if (this.isDouble(type)) {
            return this.wrapperFactory("Double", valueToConvert);
        }
        if (this.isLong(type)) {
            return this.wrapperFactory("Long", valueToConvert);
        }
        if (this.isShort(type)) {
            return this.wrapperFactory("Short", valueToConvert);
        }
        if (this.isBigDecimal(type)) {
            return this.wrapperFactory("BigDecimal", valueToConvert);
        }
        if (this.isBigInteger(type)) {
            return this.wrapperFactory("BigInteger", valueToConvert);
        }
        return null;
    }

    private Object wrapperFactory(String type, String valueToConvert) {
        if ("null".equalsIgnoreCase(valueToConvert)) {
            return null;
        }
        if (type == null) {
            return null;
        }
        if ("String".equalsIgnoreCase(type)) {
            return valueToConvert;
        }
        if ("Integer".equalsIgnoreCase(type)) {
            return new Integer(valueToConvert);
        }
        if ("Float".equalsIgnoreCase(type)) {
            return new Float(valueToConvert);
        }
        if ("Date".equalsIgnoreCase(type)) {
            return new Date(this.stripQuotes(valueToConvert));
        }
        if ("Boolean".equalsIgnoreCase(type)) {
            return new Boolean(valueToConvert);
        }
        if ("Character".equalsIgnoreCase(type)) {
            return new Character(valueToConvert.charAt(0));
        }
        if ("Double".equalsIgnoreCase(type)) {
            return new Double(valueToConvert);
        }
        if ("Long".equalsIgnoreCase(type)) {
            return new Long(valueToConvert);
        }
        if ("Short".equalsIgnoreCase(type)) {
            return new Short(valueToConvert);
        }
        if ("BigDecimal".equalsIgnoreCase(type)) {
            return new BigDecimal(valueToConvert);
        }
        if ("BigInteger".equalsIgnoreCase(type)) {
            return new BigInteger(valueToConvert);
        }
        return null;
    }

    public boolean isInFormat(String value) {
        if (value == null) {
            return false;
        }
        return (value = value.trim()).charAt(0) == '(' && value.charAt(value.length() - 1) == ')';
    }

    private Object[] inClauseWrapperFactory(Object dataType, String inClause) {
        String[] arr = Utils.split(",", inClause = inClause.substring(1, inClause.length() - 1));
        if (arr == null || arr.length == 0) {
            return null;
        }
        Object[] inObjects = new Object[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            inObjects[i] = this.wrapperFactory(dataType, arr[i].trim());
        }
        return inObjects;
    }

    public Object getComparisonValue(Object dataType, String compValue) {
        if (this.isInFormat(compValue)) {
            return this.inClauseWrapperFactory(dataType, compValue);
        }
        return this.wrapperFactory(dataType, compValue);
    }
}

