/*
 * Decompiled with CFR 0.152.
 */
package com.fdsapi.arrays;

import com.fdsapi.RegularExpression;
import com.fdsapi.arrays.ArrayFilter;
import com.fdsapi.arrays.DataTypeParser;
import com.fdsapi.arrays.FDSArraysRuntimeException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;

public class ConditionalParser {
    private String left = null;
    private String operator = null;
    private String right = null;
    private RegularExpression reCol = new RegularExpression("col([0-9]*)");
    private RegularExpression reConditional = new RegularExpression("([a-zA-Z_0-9]+) *(==|<=|>=|<>|=|<|>|!=| like | not like | !like | in| not in) *(.*)");
    private ArrayFilter arrayFilter;
    private Object[][] data;

    public ConditionalParser(Object[][] data, ArrayFilter arrayFilter) {
        this.data = data;
        this.arrayFilter = arrayFilter;
    }

    public void parse(String conditional) {
        this.reConditional.setSourceString(conditional);
        if (!this.reConditional.next()) {
            throw new FDSArraysRuntimeException("Invalid conditional syntax:  " + conditional);
        }
        this.setLeft(this.reConditional.getParen(1));
        this.setOperator(this.reConditional.getParen(2));
        this.setRight(this.reConditional.getParen(3));
        if (this.getLeft() == null || this.getOperator() == null || this.getRight() == null) {
            throw new FDSArraysRuntimeException("Invalid conditional syntax:  " + conditional);
        }
    }

    private String assignStr(String str) {
        return str == null ? null : str.trim();
    }

    private void setLeft(String left) {
        this.left = this.assignStr(left);
    }

    public String getLeft() {
        return this.left;
    }

    private void setOperator(String operator) {
        this.operator = this.assignStr(operator);
    }

    public String getOperator() {
        return this.operator;
    }

    private void setRight(String right) {
        this.right = this.assignStr(right);
    }

    public String getRight() {
        return this.right;
    }

    public void addConditional(String conditional) {
        this.parse(conditional);
        this.addConditional(this.getLeft(), this.getOperator(), this.getRight());
    }

    private void addConditional(String colName, String oper, String comparisonValue) {
        this.reCol.setSourceString(colName);
        if (this.reCol.next()) {
            String colNumStr = this.reCol.getParen(1);
            int colNum = Integer.parseInt(colNumStr);
            this.arrayFilter.addConditional(colNum, oper, this.getComparisonValue(colNum));
        } else {
            int colNum = this.arrayFilter.getColNumFromName(colName);
            this.arrayFilter.addConditional(colName, oper, this.getComparisonValue(colNum));
        }
    }

    private Object getComparisonValue(int colNum) {
        DataTypeParser dtp = new DataTypeParser();
        Object compObj = dtp.getComparisonValue(this.data[0][colNum], this.getRight());
        return compObj;
    }

    public String toString() {
        return this.getLeft() + " " + this.getOperator() + " " + this.getRight();
    }

    private static void printDebugInfo(String conditional) {
        String[] header = new String[]{"string", "date", "integer", "boolean", "float", "character", "double", "bigdecimal", "biginteger", "long", "short"};
        Object[][] data = new Object[][]{{"steve", new Date(), new Integer(100), new Boolean("true"), new Float("1.05"), new Character('c'), new Double("1.15"), new BigDecimal("100.9"), new BigInteger("222"), new Long("100"), new Short("50")}};
        ConditionalParser cp = new ConditionalParser(data, new ArrayFilter(header));
        cp.addConditional(conditional);
        System.out.println("\n***");
        System.out.println("after parsing: " + cp);
        System.out.println("left=" + cp.getLeft());
        System.out.println("operator=" + cp.getOperator());
        System.out.println("right=" + cp.getRight());
        System.out.println("ArrayFilter=" + cp.arrayFilter);
    }

    public static void main(String[] args) {
        ConditionalParser.printDebugInfo("string=='steve'");
        ConditionalParser.printDebugInfo("date<='12/22/2005 7:00 pm'");
        ConditionalParser.printDebugInfo("integer==1");
        ConditionalParser.printDebugInfo("boolean==true");
        ConditionalParser.printDebugInfo("float==2.5");
        ConditionalParser.printDebugInfo("character=='c'");
        ConditionalParser.printDebugInfo("double==3.75");
        ConditionalParser.printDebugInfo("bigdecimal==4");
        ConditionalParser.printDebugInfo("biginteger==5");
        ConditionalParser.printDebugInfo("long==6");
        ConditionalParser.printDebugInfo("short==7");
        ConditionalParser.printDebugInfo("string=null");
        ConditionalParser.printDebugInfo("d biginteger=500");
    }
}

