/*
 * Decompiled with CFR 0.152.
 */
package com.fdsapi.arrays;

import com.fdsapi.arrays.Conditional;
import com.fdsapi.arrays.ConditionalEquals;

public class ConditionalIn
implements Conditional {
    private int col = 0;
    private Object[] compArray;
    private boolean isNegated = false;

    public ConditionalIn(int col, Object[] compArray, boolean negate) {
        this(col, compArray);
        this.isNegated = negate;
    }

    public ConditionalIn(int col, Object[] compArray) {
        if (compArray == null) {
            throw new IllegalArgumentException("The array to compare against may not be null");
        }
        if (col < 0) {
            throw new IllegalArgumentException("The column to compare against must be greater than 0.  It was " + col);
        }
        this.col = col;
        this.compArray = compArray;
    }

    public String getType() {
        return this.isNegated ? "not in" : "in";
    }

    public boolean isTrue(Object[] row) {
        Object cell = row[this.col];
        boolean match = false;
        for (int i = 0; i < this.compArray.length; ++i) {
            if (!ConditionalEquals.isEqual(cell, this.compArray[i])) continue;
            match = true;
            break;
        }
        return this.negate(match);
    }

    private boolean negate(boolean bool) {
        return this.isNegated ? !bool : bool;
    }

    public String toString() {
        String str = "col" + this.col + " " + this.getType() + " (";
        int lastIndex = this.compArray.length - 1;
        for (int i = 0; i <= lastIndex; ++i) {
            str = i == lastIndex ? str + this.compArray[i] : str + this.compArray[i] + ",";
        }
        return str + ")";
    }
}

