/*
 * Decompiled with CFR 0.152.
 */
package com.fdsapi.arrays;

import com.fdsapi.arrays.Conditional;
import com.fdsapi.arrays.ConditionalEquals;
import com.fdsapi.arrays.ConditionalGreaterThan;
import com.fdsapi.arrays.ConditionalIn;
import com.fdsapi.arrays.ConditionalLessThan;
import com.fdsapi.arrays.ConditionalRE;
import com.fdsapi.arrays.NegateConditional;

public class ConditionalFactory {
    public static Conditional createInstance(int col, String type, Object comparisonValue) {
        Conditional cond = null;
        if (("<".equals(type) || "<=".equals(type) || ">".equals(type) || ">=".equals(type)) && comparisonValue != null && !(comparisonValue instanceof Comparable)) {
            throw new IllegalArgumentException("The passed comparisonValue (" + comparisonValue.getClass().getName() + ") must implement the Comparator interface if the following type argument is used: '" + type + "'");
        }
        if (("in".equalsIgnoreCase(type) || "not in".equalsIgnoreCase(type)) && !(comparisonValue instanceof Object[])) {
            throw new IllegalArgumentException("An Object[] array is required for 'in' or 'not in' (" + comparisonValue.getClass().getName() + ")");
        }
        if ("=".equals(type)) {
            cond = new ConditionalEquals(col, comparisonValue);
        } else if ("==".equals(type)) {
            cond = new ConditionalEquals(col, comparisonValue);
        } else if ("<".equals(type)) {
            cond = new ConditionalLessThan(col, (Comparable)comparisonValue);
        } else if (">".equals(type)) {
            cond = new ConditionalGreaterThan(col, (Comparable)comparisonValue);
        } else if ("<=".equals(type)) {
            cond = new ConditionalLessThan(col, (Comparable)comparisonValue, new ConditionalEquals(col, comparisonValue));
        } else if (">=".equals(type)) {
            cond = new ConditionalGreaterThan(col, (Comparable)comparisonValue, new ConditionalEquals(col, comparisonValue));
        } else if ("<>".equals(type)) {
            cond = new NegateConditional(new ConditionalEquals(col, comparisonValue));
        } else if ("!=".equals(type)) {
            cond = new NegateConditional(new ConditionalEquals(col, comparisonValue));
        } else if ("like".equalsIgnoreCase(type)) {
            cond = new ConditionalRE(col, comparisonValue);
        } else if ("not like".equalsIgnoreCase(type)) {
            cond = new NegateConditional(new ConditionalRE(col, comparisonValue));
        } else if ("!like".equalsIgnoreCase(type)) {
            cond = new NegateConditional(new ConditionalRE(col, comparisonValue));
        } else if ("in".equalsIgnoreCase(type)) {
            cond = new ConditionalIn(col, (Object[])comparisonValue, false);
        } else if ("not in".equalsIgnoreCase(type)) {
            cond = new ConditionalIn(col, (Object[])comparisonValue, true);
        } else {
            throw new IllegalArgumentException("The following Conditional type does not exist: " + type);
        }
        return cond;
    }
}

