/*
 * Decompiled with CFR 0.152.
 */
package com.fdsapi.arrays;

import com.fdsapi.FDSStack;
import com.fdsapi.arrays.Conditional;
import com.fdsapi.arrays.ConditionalComposite;
import com.fdsapi.arrays.ConditionalCompositeImp;
import com.fdsapi.arrays.WhereClauseToken;
import com.fdsapi.arrays.WhereClauseTokens;

public class ConditionalCompositeContainer
implements ConditionalComposite {
    private ConditionalComposite rootComposite = null;
    private FDSStack compositeStack = new FDSStack();
    private WhereClauseTokens whereClauseTokens = new WhereClauseTokens();
    private boolean shouldValidate = true;
    private boolean shouldBuild = true;

    public ConditionalCompositeContainer() {
        this(new ConditionalCompositeImp("or"));
    }

    public ConditionalCompositeContainer(ConditionalComposite rootComposite) {
        this.setRootComposite(rootComposite);
        this.setCurrentComposite(rootComposite);
    }

    public void build() {
        if (this.shouldBuild) {
            Object[][] createData = this.getCreateData();
            int rows = createData == null ? 0 : createData.length;
            ConditionalComposite prevComp = null;
            Conditional prevCond = null;
            for (int i = 0; i < rows; ++i) {
                BuildHelper helper = new BuildHelper(createData[i], prevComp, prevCond);
                helper.add();
                prevComp = helper.getPrevCondComposite();
                prevCond = helper.getConditional();
            }
            this.resetStack();
            this.shouldBuild = false;
        }
    }

    public boolean isTrue(Object[] row) {
        return this.getRootComposite().isTrue(row);
    }

    public void validate() {
        if (this.shouldValidate) {
            this.whereClauseTokens.validate();
            this.shouldValidate = false;
        }
    }

    private void resetBuildAndValidate() {
        this.shouldBuild = true;
        this.shouldValidate = true;
    }

    public void addConditional(Conditional conditional) {
        this.whereClauseTokens.addConditional(conditional);
        this.resetBuildAndValidate();
    }

    public void addConditionalComposite(ConditionalComposite comp) {
        this.whereClauseTokens.addConditional(comp);
        this.resetBuildAndValidate();
    }

    public void addLeftParen() {
        this.whereClauseTokens.addLeftParen();
        this.resetBuildAndValidate();
    }

    public void addRightParen() {
        this.whereClauseTokens.addRightParen();
        this.resetBuildAndValidate();
    }

    public void addNot() {
        this.whereClauseTokens.addNot();
        this.resetBuildAndValidate();
    }

    public void addAnd() {
        this.whereClauseTokens.addAnd();
        this.resetBuildAndValidate();
    }

    public void addOr() {
        this.whereClauseTokens.addOr();
        this.resetBuildAndValidate();
    }

    private void setCurrentComposite(ConditionalComposite comp) {
        this.push(comp);
    }

    private ConditionalComposite getCurrentComposite() {
        return (ConditionalComposite)this.compositeStack.getCurrent();
    }

    private void setRootComposite(ConditionalComposite comp) {
        this.rootComposite = comp;
    }

    private ConditionalComposite getRootComposite() {
        return this.rootComposite;
    }

    private void push(ConditionalComposite comp) {
        this.compositeStack.push(comp);
    }

    private ConditionalComposite pop() {
        return (ConditionalComposite)this.compositeStack.pop();
    }

    private Object[][] getCreateData() {
        return this.whereClauseTokens.getCreateData();
    }

    private void resetStack() {
        this.compositeStack.reset();
    }

    public String getType() {
        return "";
    }

    public String toString() {
        return this.whereClauseTokens.toString();
    }

    private class BuildHelper {
        private String create;
        private String conditionalToAdd;
        private String compositeToAdd;
        private String compositeStackAction;
        private String lastToken;
        private WhereClauseToken token;
        private ConditionalComposite prevComp;
        private Conditional prevCond;

        public BuildHelper(Object[] buildData, ConditionalComposite prevComp, Conditional prevCond) {
            this.token = (WhereClauseToken)buildData[0];
            this.create = (String)buildData[1];
            this.conditionalToAdd = (String)buildData[2];
            this.compositeToAdd = (String)buildData[3];
            this.compositeStackAction = (String)buildData[4];
            this.lastToken = (String)buildData[5];
            this.prevComp = prevComp;
            this.prevCond = prevCond;
        }

        private boolean isConditional() {
            return this.token.isConditional();
        }

        private boolean isRightParen() {
            return this.token.isRightParen();
        }

        private boolean isLastToken() {
            return "lastToken".equalsIgnoreCase(this.lastToken);
        }

        private boolean shouldCreateAndComposite() {
            return "createAndComposite".equalsIgnoreCase(this.create);
        }

        private boolean shouldCreateOrComposite() {
            return "createOrComposite".equalsIgnoreCase(this.create);
        }

        private boolean shouldAddConditional() {
            return "addConditional".equalsIgnoreCase(this.conditionalToAdd);
        }

        private boolean shouldAddComposite() {
            return "addComposite".equalsIgnoreCase(this.compositeToAdd);
        }

        private boolean shouldPop() {
            return this.compositeStackAction.startsWith("pop");
        }

        private void popNTimes() {
            int n = Integer.parseInt(this.compositeStackAction.substring(3));
            for (int i = 0; i < n; ++i) {
                if (this.token.isRightParen()) {
                    this.prevComp = ConditionalCompositeContainer.this.getCurrentComposite();
                }
                ConditionalCompositeContainer.this.pop();
            }
        }

        private void addConditional(Conditional conditional) {
            ConditionalCompositeContainer.this.getCurrentComposite().addConditional(conditional);
        }

        public Conditional getConditional() {
            return this.token.getConditional();
        }

        public ConditionalComposite getPrevCondComposite() {
            return this.prevComp;
        }

        private Conditional getConditionalToAdd() {
            return this.prevCond == null ? this.getConditional() : this.prevCond;
        }

        public void add() {
            ConditionalCompositeImp condComposite;
            if (this.shouldCreateAndComposite()) {
                condComposite = new ConditionalCompositeImp("and");
                this.addConditional(condComposite);
                ConditionalCompositeContainer.this.setCurrentComposite(condComposite);
            }
            if (this.shouldCreateOrComposite()) {
                condComposite = new ConditionalCompositeImp("or");
                ConditionalCompositeContainer.this.setCurrentComposite(condComposite);
            }
            if (this.shouldAddConditional()) {
                this.addConditional(this.getConditionalToAdd());
            }
            if (this.shouldAddComposite()) {
                this.addConditional(this.getPrevCondComposite());
            }
            if (this.shouldPop()) {
                this.popNTimes();
            }
            if (this.isLastToken() && this.isRightParen()) {
                this.addConditional(this.getPrevCondComposite());
            }
        }
    }
}

