/*
 * Decompiled with CFR 0.152.
 */
package com.fdsapi.arrays;

import com.fdsapi.Utils;
import com.fdsapi.arrays.Column;
import com.fdsapi.arrays.ColumnDate;
import com.fdsapi.arrays.ColumnRowNum;
import com.fdsapi.arrays.ColumnString;
import com.jamonapi.utils.AppMap;
import java.util.Map;

public class ColumnFunctionFactory {
    private Map factoryMap = AppMap.createInstance();

    public ColumnFunctionFactory() {
        this.putFunction("rowNum()", new ColumnRowNum());
        this.putFunction("date()", new ColumnDate());
    }

    public Column getFunction(String functionName) {
        if (this.factoryMap.containsKey(functionName)) {
            Column col = (Column)this.factoryMap.get(functionName);
            return col.createInstance();
        }
        String str = Utils.getREMatch("'(.*)'", functionName, 1);
        if (str == null) {
            str = Utils.getREMatch("\"(.*)\"", functionName, 1);
        }
        if (str == null) {
            throw new IllegalArgumentException("The passed function name is invalid.  It is not in the ColumnFunctionFactory.  The function is:  " + functionName);
        }
        return new ColumnString(str);
    }

    public void putFunction(String functionName, Column col) {
        this.factoryMap.put(functionName, col);
    }

    protected String getFunctionREString() {
        return "'.*'|\".*\"|rowNum[(][)]|date[(][)]";
    }
}

