/*
 * Decompiled with CFR 0.152.
 */
package com.fdsapi.arrays;

import com.fdsapi.AppConstants;
import com.fdsapi.FormattedDataSet;
import com.fdsapi.Utils;
import com.fdsapi.arrays.ArrayComparator;
import com.fdsapi.arrays.ArrayConverter;
import com.fdsapi.arrays.ArrayFilter;
import com.fdsapi.arrays.OrderByParser;
import com.fdsapi.arrays.SelectColsParser;
import com.fdsapi.arrays.WhereClauseParser;
import com.jamonapi.Monitor;
import com.jamonapi.MonitorFactory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;

public class ArraySQL {
    private ArrayFilter arrayFilter = null;
    private ArrayComparator arrayComparator = null;
    private String query;
    private boolean parseQuery = true;
    private boolean copyData = false;

    public ArraySQL(String query) {
        this.query = query;
        this.arrayFilter = new ArrayFilter();
        this.arrayComparator = new ArrayComparator();
    }

    public ArraySQL(String[] header, String query) {
        this.query = query;
        this.arrayFilter = new ArrayFilter(header);
        this.arrayComparator = new ArrayComparator(header);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildObject(Object[][] data) {
        Monitor mon = this.start("buildObject()");
        try {
            this.setSelectCols(data);
            this.setWhereClause(data);
            this.setOrderByClause();
        }
        finally {
            mon.stop();
        }
    }

    private String getSelectCols() {
        return SelectColsParser.getSelectCols(this.query);
    }

    private String getWhereClause() {
        return WhereClauseParser.getWhereClause(this.query);
    }

    private String getOrderByClause() {
        return OrderByParser.getOrderByClause(this.query);
    }

    private void setSelectCols(Object[][] data) {
        SelectColsParser p = new SelectColsParser(data, this.getSelectCols(), this.getArrayFilter());
        p.addSelectCols();
    }

    private void setWhereClause(Object[][] data) {
        WhereClauseParser p = new WhereClauseParser(data, this.getWhereClause(), this.getArrayFilter());
        p.addWhereClause();
    }

    private void setOrderByClause() {
        OrderByParser p = new OrderByParser(this.getOrderByClause(), this.getArrayComparator());
        p.addSortCols();
    }

    public static Object[][] copy(Object[][] data) {
        return ArrayComparator.copy(data);
    }

    private Monitor start(String label) {
        return AppConstants.start("arrays.ArraySQL." + label);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[][] execute(Object[][] data) {
        Monitor mon = this.start("execute(Object[][])");
        Object[][] retData = null;
        try {
            if (data == null) {
                Object[][] objectArray = null;
                return objectArray;
            }
            if (this.parseQuery) {
                this.buildObject(data);
                this.parseQuery = false;
            }
            if (this.getCopyData()) {
                data = ArraySQL.copy(data);
            }
            this.getArrayComparator().sort(data);
            retData = this.getArrayFilter().filter(data);
        }
        finally {
            mon.stop();
        }
        return retData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[][] convert(Object[][] data) {
        Monitor mon = this.start("convert(Object[][])");
        try {
            Object[][] objectArray = this.getArrayConverter().convert(this.execute(data));
            return objectArray;
        }
        finally {
            mon.stop();
        }
    }

    public String toString() {
        return this.query;
    }

    public ArrayFilter getArrayFilter() {
        return this.arrayFilter;
    }

    public ArrayComparator getArrayComparator() {
        return this.arrayComparator;
    }

    public ArrayConverter getArrayConverter() {
        return this.getArrayFilter().getArrayConverter();
    }

    public void setArrayConverter(ArrayConverter arrayConverter) {
        this.getArrayFilter().setArrayConverter(arrayConverter);
    }

    public String debugString() {
        return this.getArrayFilter() + " " + this.getArrayComparator() + " " + this.getArrayConverter();
    }

    public void setCopyData(boolean copyData) {
        this.copyData = copyData;
    }

    public boolean getCopyData() {
        return this.copyData;
    }

    public String[] getSelectColsList() {
        return this.getArrayFilter().getDisplayColList();
    }

    private static void printDebugInfo(int debugCounter, String query, String[] header, Object[][] data) {
        FormattedDataSet fds = FormattedDataSet.createInstance();
        ArraySQL asql = null;
        for (int i = 0; i < 50; ++i) {
            asql = header == null ? new ArraySQL(query) : new ArraySQL(header, query);
            asql.execute(data);
        }
        asql.log("\n\n\n**********************************************debugInfo for: " + debugCounter);
        asql.log("toString(): " + asql);
        asql.log("select: " + asql.getSelectCols());
        asql.log("where: " + asql.getWhereClause());
        asql.log("order by: " + asql.getOrderByClause());
        data = asql.convert(data);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("delimiter", " - ");
        asql.log("\nquery results:\n" + fds.getFormattedDataSet(null, (Object)data, map, "delimited"));
        asql.log("debugString() - arrayFilter + arrayComp: " + asql.debugString());
        int len = data == null ? 0 : data.length;
        asql.log("rows=" + len);
        String[] cols = asql.getSelectColsList();
        System.out.print("getSelectColsList()=");
        for (int i = 0; i < cols.length; ++i) {
            System.out.print(cols[i] + ",");
        }
    }

    private void log(String str) {
        Utils.log(str);
    }

    public static void main(String[] args) {
        Object[][] data = new Object[][]{{"jeff", new Date("12/22/2001"), new Integer(101), new Boolean(true), new Float("1.1"), new Character('a'), new Double("1.2"), new BigDecimal("1.3"), new BigInteger("102"), new Long("103"), new Short("104")}, {"mick", new Date("12/22/2002"), new Integer(201), new Boolean(false), new Float("2.1"), new Character('b'), new Double("2.2"), new BigDecimal("2.3"), new BigInteger("202"), new Long("203"), new Short("204")}, {"iggy", new Date("12/22/2003"), new Integer(301), new Boolean(true), new Float("3.1"), new Character('c'), new Double("3.2"), new BigDecimal("3.3"), new BigInteger("30200"), new Long("3030000"), new Short("30400")}, {"keith", new Date("12/22/2004"), new Integer(401), new Boolean(false), new Float("4.1"), new Character('d'), new Double("4.2"), new BigDecimal("4.3"), new BigInteger("402"), new Long("403"), new Short("404")}, {null, new Date("12/22/2005"), new Integer(501), new Boolean(true), new Float("5.1"), new Character('e'), new Double("5.2"), new BigDecimal("5.3"), new BigInteger("502"), new Long("503"), new Short("504")}, {"jim", new Date("12/22/2006"), new Integer(601), new Boolean(false), new Float("6.1"), new Character('f'), new Double("6.2"), new BigDecimal("6.3"), new BigInteger("602"), new Long("603"), new Short("604")}};
        String[] header = new String[]{"string", "date", "integer", "boolean", "float", "character", "double", "bigdecimal", "biginteger", "long", "short"};
        Monitor mon = MonitorFactory.start((String)"ArraySQL.main()");
        ArraySQL.printDebugInfo(1, "select * from array order by col0 asc, col1 desc", null, data);
        ArraySQL.printDebugInfo(2, "select * from array where string<='alan' || string='mick' order by date desc", header, data);
        ArraySQL.printDebugInfo(3, "select * from array where (date<='12/22/2000') || date='12/22/2004' order by date desc", header, data);
        ArraySQL.printDebugInfo(4, "select * from array where float<=-.35 || float=3.1 order by float desc", header, data);
        ArraySQL.printDebugInfo(5, "select string,boolean from array where boolean==true && string='iggy' order by string", header, data);
        ArraySQL.printDebugInfo(50, "select string,boolean from array where boolean==true or string='iggy' order by string", header, data);
        ArraySQL.printDebugInfo(6, "select string,boolean from array where string like 'j.*' ", header, data);
        ArraySQL.printDebugInfo(7, "select * from array where (string ='jeff') ", header, data);
        ArraySQL.printDebugInfo(8, "select * from array where character =='c' order by character ", header, data);
        ArraySQL.printDebugInfo(9, "select string,double from array where double>=3.2 order by double desc ", header, data);
        ArraySQL.printDebugInfo(10, "select string,bigdecimal from array where bigdecimal>=3.3 order by string", header, data);
        ArraySQL.printDebugInfo(11, "select string,biginteger from array where biginteger<=5000 order by biginteger desc", header, data);
        ArraySQL.printDebugInfo(12, "select string,long from array where long>=403 order by long desc", header, data);
        ArraySQL.printDebugInfo(13, "select string, short from array where short>=400 order by short desc", header, data);
        ArraySQL.printDebugInfo(14, "select string, short from array where  string='iggy'", header, data);
        ArraySQL.printDebugInfo(15, "select string, short from array where  string=='iggy' || string=null", header, data);
        ArraySQL.printDebugInfo(16, "select string, short from array where  date==null || string=   null  ", header, data);
        ArraySQL.printDebugInfo(17, "select string, short from array where  string in ('iggy','jeff',null) order by string ", header, data);
        ArraySQL.printDebugInfo(18, "select string, integer,date from array where  ((date in ('12/22/2003') || integer in ( 401 , 501 , 601    )) && integer not in (401)) order by integer ", header, data);
        ArraySQL.printDebugInfo(19, "select string, integer,date from array where  col0='jones'", header, null);
        ArraySQL.printDebugInfo(20, "select string, integer,date from array where  col0='jones'", header, data);
        ArraySQL.printDebugInfo(21, "select string, integer,date from array where  col0 like '12'", header, data);
        ArraySQL.printDebugInfo(22, "select rowNum(), rowNum(), 'steve', date(), col0 from array", header, data);
        ArraySQL.printDebugInfo(23, "select *,rowNum(), rowNum(), 'steve', string, *,col0 from array", header, data);
        ArraySQL.printDebugInfo(24, "select * from array where (short<=300 or long=503) and boolean=true", header, data);
        ArraySQL.printDebugInfo(25, "select * from array where string in ('jeff', 'iggy') && boolean=true && date='12/22/2001' ", header, data);
        ArraySQL.printDebugInfo(26, "select rowNum(),* from array where string in ('jeff', 'iggy') || boolean=false && date='12/22/2006' order by col0 asc", header, data);
        ArraySQL.printDebugInfo(27, "select * from array where col0='iggy' or col0='iggy' and col2=9999 order by col0 asc, col1 desc", header, data);
        ArraySQL.printDebugInfo(28, "select * from array where col0='iggy' or col0='iggy' and col2=9999 or col0='iggy' order by col0 asc, col1 desc", header, data);
        ArraySQL.printDebugInfo(29, "select * from array where ((string='mick' or string='jeff') and (integer=101 or integer=201)) order by col0 asc, col1 desc", header, data);
        ArraySQL.printDebugInfo(30, "select * from array where (((string='mick' or string='jeff' or string=null) or (integer=101 or integer=201 or integer=301))) order by integer", header, data);
        ArraySQL.printDebugInfo(31, "select * from array where (((string='mick' or string='jeff') and (integer=401 or integer=501))) order by integer", header, data);
        ArraySQL.printDebugInfo(32, "select * from array where (((string='mick' or string='jeff') or (integer=401 or integer=501))) order by integer", header, data);
        ArraySQL.printDebugInfo(34, "select * from array where string='select' or string='from' or string='where' or string='string' or string='col0' or string='jeff'", header, data);
        ArraySQL.printDebugInfo(35, "select rowNum(), * from array order by col0 desc", header, data);
        ArraySQL.printDebugInfo(36, "select col0, string as Name, string as Name, string as Name1, col0 as Name2, rowNum() as row, 'steve' as me, *, *, 'joel' as him from array order by col0, string desc", header, data);
        mon.stop();
        data = MonitorFactory.getRootMonitor().getData();
        ArraySQL.printDebugInfo(100, "select * from array", null, ArraySQL.copy(data));
    }
}

