/*
 * Decompiled with CFR 0.152.
 */
package com.fdsapi.arrays;

import com.jamonapi.utils.AppMap;
import java.util.Map;

public class ArrayHeaderLocator
implements Cloneable {
    private Map headerFromNum = null;
    private Map headerFromName = null;
    private int headerSize = 0;
    private boolean throwExceptions = false;
    public final int NOT_IN_HEADER = -3467651;

    public ArrayHeaderLocator() {
        this.initMaps();
    }

    public ArrayHeaderLocator(boolean throwExceptions) {
        this.initMaps();
        this.throwExceptions = throwExceptions;
    }

    public ArrayHeaderLocator(String[] header) {
        this.initMaps();
        for (int i = 0; i < header.length; ++i) {
            this.setColName(header[i], i);
        }
    }

    public ArrayHeaderLocator(String[] header, boolean throwExceptions) {
        this(header);
        this.throwExceptions = throwExceptions;
    }

    private void initMaps() {
        this.headerFromNum = AppMap.createInstance();
        this.headerFromName = AppMap.createInstance();
    }

    private ArrayHeaderLocator(Map headerFromNum, Map headerFromName, boolean throwExceptions) {
        this.headerFromNum = headerFromNum;
        this.headerFromName = headerFromName;
        this.throwExceptions = throwExceptions;
    }

    public int getColNum(String columnName) {
        int val;
        Integer col = (Integer)this.headerFromName.get(columnName);
        int indexValue = -3467651;
        if (col != null) {
            indexValue = col;
        } else if (columnName != null && columnName.toLowerCase().matches("col\\d+") && (val = Integer.parseInt(columnName.substring(3))) >= 0 && val < this.getHeaderSize()) {
            indexValue = val;
        }
        if (indexValue == -3467651 && this.throwExceptions) {
            throw new IllegalArgumentException("The following column name was not in the header: " + columnName);
        }
        return indexValue;
    }

    public void setThrowExceptions(boolean throwExceptions) {
        this.throwExceptions = throwExceptions;
    }

    public boolean getThrowExceptions() {
        return this.throwExceptions;
    }

    public String getColName(int index) {
        String col = (String)this.headerFromNum.get(new Integer(index));
        if (col != null) {
            return col;
        }
        if (index >= 0 && index < this.getHeaderSize()) {
            return "col" + index;
        }
        if (this.throwExceptions) {
            throw new IllegalArgumentException("The following column index was not in the header: " + index);
        }
        return null;
    }

    public String[] getHeader() {
        String[] header = null;
        int rows = this.getHeaderSize();
        if (rows > 0) {
            header = new String[rows];
            for (int i = 0; i < rows; ++i) {
                header[i] = this.getColName(i);
            }
        }
        return header;
    }

    public boolean containsColNum(int index) {
        return this.headerFromNum.containsKey(new Integer(index));
    }

    public boolean containsColName(String colName) {
        return this.headerFromName.containsKey(colName);
    }

    public void setColName(String columnName, int index) {
        Integer columnNum = new Integer(index);
        this.setHeaderSize(index);
        this.headerFromName.put(columnName, columnNum);
        this.headerFromNum.put(columnNum, columnName);
    }

    private void setHeaderSize(int value) {
        if (++value > this.headerSize) {
            this.headerSize = value;
        }
    }

    public int getHeaderSize() {
        return this.headerSize;
    }

    public Object clone() {
        Map num = (Map)((AppMap)this.headerFromNum).clone();
        Map name = (Map)((AppMap)this.headerFromName).clone();
        return new ArrayHeaderLocator(num, name, this.throwExceptions);
    }

    public ArrayHeaderLocator copy() {
        return (ArrayHeaderLocator)this.clone();
    }

    public String toString() {
        return this.headerFromNum.toString();
    }

    public static void main(String[] args) {
        String[] header = new String[]{"fname", "lname", "salary", "salary2", "salary"};
        ArrayHeaderLocator l = new ArrayHeaderLocator(header);
        System.out.println(l);
        l.setColName("ssn", 5);
        System.out.println(l);
        System.out.println(l.getColName(2) + "=" + l.getColNum("salary"));
        System.out.println("fname: name=" + l.getColName(0) + ", num=" + l.getColNum("fname"));
        System.out.println("salary2: name=" + l.getColName(3) + ", num=" + l.getColNum("salary2"));
        System.out.println("col10=" + l.getColNum("CoL10"));
        System.out.println("col5=" + l.getColNum("CoL5"));
        System.out.println("col4=" + l.getColNum("CoL4"));
        System.out.println("col-4=" + l.getColNum("CoL-4"));
        System.out.println("col5=" + l.getColName(5));
        System.out.println("col6 - error=" + l.getColName(6));
        System.out.println("col-1 - error=" + l.getColName(-1));
        l.setColName("test", 100);
        System.out.println("col99=" + l.getColNum("col99"));
        System.out.println("col100=" + l.getColNum("col100"));
        System.out.println("col101=" + l.getColNum("col101"));
        System.out.println("\nPrint header");
        header = l.getHeader();
        for (int i = 0; i < header.length; ++i) {
            System.out.println("index " + i + "=" + header[i]);
        }
    }
}

