/*
 * Decompiled with CFR 0.152.
 */
package com.fdsapi.arrays;

import com.fdsapi.AppConstants;
import com.fdsapi.FormattedDataSet;
import com.fdsapi.ResultSetUtils;
import com.fdsapi.Utils;
import com.fdsapi.arrays.ArrayComparator;
import com.fdsapi.arrays.ArrayConverter;
import com.fdsapi.arrays.ArrayHeaderLocator;
import com.fdsapi.arrays.Column;
import com.fdsapi.arrays.ColumnData;
import com.fdsapi.arrays.ColumnFunctionFactory;
import com.fdsapi.arrays.Conditional;
import com.fdsapi.arrays.ConditionalCompositeContainer;
import com.fdsapi.arrays.ConditionalFactory;
import com.jamonapi.Monitor;
import com.jamonapi.MonitorFactory;
import com.jamonapi.utils.AppMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ArrayFilter {
    private List displayCols = new ArrayList();
    private ArrayList displayColList = new ArrayList();
    private ResultSetUtils rsu = ResultSetUtils.createInstance();
    private ConditionalCompositeContainer rootComposite = new ConditionalCompositeContainer();
    private ArrayHeaderLocator headerLocator = new ArrayHeaderLocator(true);
    private static ColumnFunctionFactory colFunctionFactory = new ColumnFunctionFactory();
    private ArrayConverter arrayConverter = null;
    private Map aliasMap = AppMap.createInstance();
    private static final int COL_NAME = 0;
    private static final int ALIAS_NAME = 1;

    public ArrayFilter() {
        this.arrayConverter = new ArrayConverter();
    }

    public ArrayFilter(ArrayConverter arrayConverter) {
        this.arrayConverter = arrayConverter;
    }

    public ArrayFilter(String[] header) {
        this(header, new ArrayConverter(header));
    }

    public ArrayFilter(String[] header, ArrayConverter arrayConverter) {
        this.headerLocator = new ArrayHeaderLocator(header, true);
        this.arrayConverter = arrayConverter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[][] filter(Object[][] fullArray) {
        Monitor mon = AppConstants.start("arrays.ArrayFilter.filter(Object[][])");
        Object[][] filteredArray = null;
        try {
            if (fullArray == null) {
                Object[][] objectArray = fullArray;
                return objectArray;
            }
            this.validate();
            this.build();
            this.resetDisplayCols();
            ArrayList<Object[]> matchingArray = new ArrayList<Object[]>();
            int rows = fullArray.length;
            for (int i = 0; i < rows; ++i) {
                if (!this.keepRow(fullArray[i])) continue;
                Object[] row = this.filterCols(fullArray[i]);
                matchingArray.add(row);
            }
            filteredArray = this.rsu.listToObjectArray(matchingArray);
        }
        finally {
            mon.stop();
        }
        return filteredArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[][] convert(Object[][] data) {
        Monitor mon = AppConstants.start("arrays.ArrayFilter.convert(Object[][])");
        try {
            Object[][] objectArray = this.getArrayConverter().convert(this.filter(data));
            return objectArray;
        }
        finally {
            mon.stop();
        }
    }

    public ArrayConverter getArrayConverter() {
        return this.arrayConverter;
    }

    public void setArrayConverter(ArrayConverter arrayConverter) {
        this.arrayConverter = arrayConverter;
    }

    private void resetDisplayCols() {
        ArrayList<Column> list = new ArrayList<Column>();
        Iterator iter = this.displayCols.iterator();
        while (iter.hasNext()) {
            Column col = (Column)iter.next();
            list.add(col.createInstance());
        }
        this.displayCols = list;
    }

    private boolean keepRow(Object[] rowOfArray) {
        for (int col = 0; col < rowOfArray.length; ++col) {
            if (this.rootComposite.isTrue(rowOfArray)) continue;
            return false;
        }
        return true;
    }

    private void validate() {
        this.rootComposite.validate();
    }

    private void build() {
        this.rootComposite.build();
    }

    public void addConditional(int col, String type, Object comparisonValue) {
        Conditional conditional = ConditionalFactory.createInstance(col, type, comparisonValue);
        this.rootComposite.addConditional(conditional);
    }

    public void addConditional(String colName, String type, Object comparisonValue) {
        int col = this.getColNumFromName(colName);
        Conditional conditional = ConditionalFactory.createInstance(col, type, comparisonValue);
        this.rootComposite.addConditional(conditional);
    }

    public void addConditional(Conditional conditional) {
        this.rootComposite.addConditional(conditional);
    }

    public void addNot() {
        this.rootComposite.addNot();
    }

    public void addAnd() {
        this.rootComposite.addAnd();
    }

    public void addOr() {
        this.rootComposite.addOr();
    }

    public void addLeftParen() {
        this.rootComposite.addLeftParen();
    }

    public void addRightParen() {
        this.rootComposite.addRightParen();
    }

    private Object[] filterCols(Object[] originalRow) {
        Object[] filteredRow = null;
        filteredRow = this.getNumberOfDisplayCols() == 0 ? this.copyAllCols(originalRow) : this.copyFilteredCols(originalRow);
        return filteredRow;
    }

    private Object[] copyAllCols(Object[] originalRow) {
        return Utils.copy(originalRow);
    }

    private Object[] copyFilteredCols(Object[] originalRow) {
        int filteredColIndex = 0;
        Object[] filteredRow = new Object[this.getNumberOfDisplayCols()];
        Iterator iter = this.displayCols.iterator();
        while (iter.hasNext()) {
            Column col = (Column)iter.next();
            filteredRow[filteredColIndex++] = col.getObject(originalRow);
        }
        return filteredRow;
    }

    public void addDisplayCol(int columnNumber) {
        String colNumStr;
        if (columnNumber >= 0) {
            colNumStr = "col" + columnNumber;
            if (this.headerLocator.containsColNum(columnNumber)) {
                String displayCol = this.headerLocator.getColName(columnNumber);
                this.displayColList.add(displayCol);
            } else {
                this.displayColList.add(colNumStr);
            }
        } else {
            throw new IllegalArgumentException("The column number must be greater than 0.  It was " + columnNumber);
        }
        this.aliasMap.put(colNumStr, colNumStr);
        this.displayCols.add(new ColumnData(columnNumber));
    }

    public void addDisplayCol(String columnName) {
        this.addAlias(columnName);
        this.displayCols.add(new ColumnData(this.getColNumFromName(columnName)));
    }

    public String[] getDisplayColList() {
        return this.displayColList.toArray(new String[0]);
    }

    public void addDisplayFunction(String functionName) {
        this.addAlias(functionName);
        this.displayCols.add(colFunctionFactory.getFunction(this.getColFromAlias(functionName)));
    }

    private void addAlias(String columnName) {
        if (this.isAlias(columnName)) {
            String[] aliasInfo = columnName.split(" +[aA][sS] +");
            this.aliasMap.put(columnName, aliasInfo[0]);
            this.addAlias(aliasInfo[0], aliasInfo[1]);
        } else {
            this.addAlias(columnName, columnName);
        }
    }

    private String getColFromAlias(String alias) {
        return (String)this.aliasMap.get(alias);
    }

    private boolean isAlias(String col) {
        int NOT_AN_ALIAS = -1;
        col = col == null ? "" : col;
        return col.toLowerCase().indexOf(" as ") != NOT_AN_ALIAS;
    }

    private void addAlias(String col, String alias) {
        this.aliasMap.put(alias, col);
        this.displayColList.add(alias);
    }

    public int getColNumFromName(String columnName) {
        String col = this.getColFromAlias(columnName);
        if (col == null) {
            col = columnName;
        }
        return this.headerLocator.getColNum(col);
    }

    private int getNumberOfDisplayCols() {
        return this.displayCols.size();
    }

    public String toString() {
        String select = "select " + this.getDisplayColStr() + " from array";
        String whereCond = this.rootComposite.toString();
        return select + whereCond;
    }

    private String getDisplayColStr() {
        String cols = "";
        if (this.displayColList.size() == 0) {
            cols = "*";
        } else {
            Iterator iter = this.displayColList.iterator();
            while (iter.hasNext()) {
                cols = cols + iter.next();
                if (!iter.hasNext()) continue;
                cols = cols + ",";
            }
        }
        return cols;
    }

    ColumnFunctionFactory getColumnFunctionFactory() {
        return colFunctionFactory;
    }

    private static void printDebugInfo(ArrayFilter f, Object[][] data) {
        FormattedDataSet fds = FormattedDataSet.createInstance();
        String str = fds.getFormattedDataSet(null, data, "csv");
        Utils.log("***filter=" + f);
        Utils.log(str);
        String[][] colList = new String[][]{f.getDisplayColList()};
        Utils.log("***display cols=" + fds.getFormattedDataSet(null, colList, "csv"));
    }

    public static void main(String[] args) {
        Object[][] orig = new Object[][]{{"Row 1", "JAVA", new Boolean(true), new Integer(15)}, {"Row 2", "JAVA", new Boolean(true), new Integer(5)}, {"Row 3", "PERL", new Boolean(true), new Integer(111)}, {"Row 4", "JAVA", new Boolean(false), new Integer(26)}, {"Row 5", "JAVA", new Boolean(true), new Integer(51)}, {"Row 6", "C", new Boolean(true), new Integer(52)}, {"Row 7", "C", new Boolean(false), new Integer(51)}, {"Row 8", "C++", new Boolean(false), new Integer(52)}, {"Row 9", "C++", new Boolean(false), new Integer(55)}, {"Row 10", "C++", new Boolean(false), null}};
        String[] header = new String[]{"row", "Lang", "bool", "count"};
        Object[][] filtered = null;
        for (int i = 0; i < 25; ++i) {
            MonitorFactory.start((String)("page" + i + ".jsp")).stop();
        }
        MonitorFactory.start((String)"hello-mypage.jsp").stop();
        MonitorFactory.start((String)"zhello").stop();
        ArrayFilter f = new ArrayFilter();
        f.addDisplayCol(0);
        f.addDisplayCol(0);
        f.addDisplayCol(1);
        f.addDisplayCol(0);
        f.addDisplayCol(3);
        f.addDisplayCol(0);
        f.addDisplayCol(0);
        f.addDisplayCol(0);
        f.addDisplayCol(0);
        f.addDisplayCol(0);
        f.addDisplayCol(0);
        f.addDisplayCol(0);
        f.addDisplayCol(0);
        f.addDisplayCol(2);
        f.addDisplayCol(3);
        filtered = f.filter(orig);
        ArrayFilter.printDebugInfo(f, filtered);
        f = new ArrayFilter();
        filtered = f.filter(orig);
        ArrayFilter.printDebugInfo(f, filtered);
        f = new ArrayFilter();
        f.addConditional(1, "=", (Object)"JAVA");
        f.addAnd();
        f.addConditional(0, "<=", (Object)"Row 4");
        filtered = f.filter(orig);
        ArrayFilter.printDebugInfo(f, filtered);
        f = new ArrayFilter();
        f.addConditional(3, "<=", (Object)new Integer(26));
        filtered = f.filter(orig);
        ArrayFilter.printDebugInfo(f, filtered);
        f = new ArrayFilter();
        f.addConditional(3, ">", (Object)new Integer(26));
        filtered = f.filter(orig);
        ArrayFilter.printDebugInfo(f, filtered);
        f = new ArrayFilter();
        f.addConditional(3, "like", (Object)new Integer(52));
        filtered = f.filter(orig);
        ArrayFilter.printDebugInfo(f, filtered);
        f = new ArrayFilter();
        f.addNot();
        f.addConditional(3, "like", (Object)new Integer(52));
        filtered = f.filter(orig);
        System.out.println("**********");
        ArrayFilter.printDebugInfo(f, filtered);
        f = new ArrayFilter();
        f.addConditional(0, "like", (Object)".jsp");
        filtered = f.filter(MonitorFactory.getRootMonitor().getData());
        ArrayComparator.sort(filtered, 0, "desc");
        ArrayFilter.printDebugInfo(f, filtered);
        f = new ArrayFilter();
        f.addConditional(0, "not like", (Object)".jsp");
        filtered = f.filter(MonitorFactory.getRootMonitor().getData());
        ArrayFilter.printDebugInfo(f, filtered);
        f = new ArrayFilter();
        f.addConditional(0, "like", (Object)"com.fdsapi.arrays.");
        filtered = f.filter(MonitorFactory.getRootMonitor().getData());
        ArrayFilter.printDebugInfo(f, filtered);
        f = new ArrayFilter(header);
        f.addDisplayCol("row");
        f.addDisplayCol("lang");
        f.addDisplayCol("bool");
        f.addDisplayCol("count");
        f.addDisplayCol("LANG");
        f.addDisplayCol("row as rowAlias");
        f.addDisplayCol("col0 as rowAlias2");
        f.addDisplayCol("col1 as rowAlias3");
        f.addDisplayCol(0);
        f.addConditional("Lang", "=", (Object)"JAVA");
        f.addOr();
        f.addConditional("lang", "=", (Object)"C++");
        filtered = f.filter(orig);
        ArrayFilter.printDebugInfo(f, filtered);
        f = new ArrayFilter(header);
        f.addDisplayCol("row");
        f.addDisplayCol("lang");
        f.addConditional("lang", "in", (Object)new String[]{"JAVA", "C", "PERL"});
        f.addAnd();
        f.addConditional("lang", "not in", (Object)new String[]{"PERL"});
        filtered = f.filter(orig);
        ArrayFilter.printDebugInfo(f, filtered);
        f = new ArrayFilter(header);
        f.addDisplayFunction("rowNum()");
        f.addDisplayFunction("'steve'");
        f.addDisplayCol("row");
        f.addDisplayCol("lang");
        f.addDisplayFunction("'souza'");
        f.addDisplayFunction("\"jones\"");
        f.addDisplayFunction("date()");
        filtered = f.filter(orig);
        ArrayFilter.printDebugInfo(f, filtered);
        f = new ArrayFilter(header);
        f.addConditional("lang", "=", (Object)"JAVA");
        f.addAnd();
        f.addConditional("bool", "=", (Object)new Boolean("true"));
        f.addAnd();
        f.addConditional("count", "=", (Object)new Integer(15));
        filtered = f.filter(orig);
        ArrayFilter.printDebugInfo(f, filtered);
        f = new ArrayFilter(header);
        f.addConditional("lang", "=", (Object)"JAVA");
        f.addAnd();
        f.addConditional("bool", "=", (Object)new Boolean("true"));
        f.addOr();
        f.addConditional("count", "=", (Object)new Integer(4000));
        filtered = f.filter(orig);
        ArrayFilter.printDebugInfo(f, filtered);
        f = new ArrayFilter(header);
        f.addConditional("lang", "=", (Object)"JAVA");
        f.addOr();
        f.addConditional("count", "=", (Object)new Integer(4000));
        f.addAnd();
        f.addConditional("bool", "=", (Object)new Boolean("true"));
        filtered = f.filter(orig);
        ArrayFilter.printDebugInfo(f, filtered);
        f = new ArrayFilter(header);
        f.addConditional("lang", "=", (Object)"JAVA");
        f.addAnd();
        f.addConditional("count", "=", (Object)new Integer(4000));
        f.addOr();
        f.addConditional("bool", "=", (Object)new Boolean("true"));
        filtered = f.filter(orig);
        ArrayFilter.printDebugInfo(f, filtered);
        Object[][] test = new Object[][]{{new Integer(10000), new Date(), new Float(10001.13)}};
        f = new ArrayFilter();
        ArrayFilter.printDebugInfo(f, f.convert(test));
    }
}

