/*
 * Decompiled with CFR 0.152.
 */
package com.fdsapi.arrays;

import com.fdsapi.Converter;
import com.fdsapi.ConverterNumToString;
import com.fdsapi.NullConverter;
import com.fdsapi.arrays.ArrayHeaderLocator;
import com.jamonapi.utils.AppMap;
import java.util.Map;

public class ArrayConverterFactory
implements Cloneable {
    private Map converterMap = null;
    private Map sequenceMap = null;
    private int sequence;
    private final int NOTINMAP = -54321;
    private static final Converter NULL_CONVERTER = new NullConverter();
    private Converter defaultConverter = NULL_CONVERTER;

    public ArrayConverterFactory() {
        this.converterMap = AppMap.createInstance();
        this.sequenceMap = AppMap.createInstance();
    }

    private ArrayConverterFactory(Map converterMap, Map sequenceMap, Converter defaultConverter, int sequence) {
        this.converterMap = converterMap;
        this.sequenceMap = sequenceMap;
        this.defaultConverter = defaultConverter;
        this.sequence = sequence;
    }

    private Converter getConverter(Object key) {
        Converter converter = (Converter)this.converterMap.get(key);
        if (converter == null) {
            return null;
        }
        return converter.createInstance();
    }

    public void setDefaultConverter(Converter converter) {
        this.defaultConverter = converter;
    }

    private Converter getDefaultConverter() {
        return this.defaultConverter.createInstance();
    }

    public void setColConverter(int colNum, Converter converter) {
        this.setConverter(new Integer(colNum), converter);
    }

    public void removeColConverter(int colNum) {
        this.removeConverter(new Integer(colNum));
    }

    public void setColConverter(String colName, Converter converter) {
        this.setConverter(colName, converter);
    }

    public void removeColConverter(String colName) {
        this.removeConverter(colName);
    }

    public void setTypeConverter(Class type, Converter converter) {
        this.setConverter(type, converter);
    }

    public void removeTypeConverter(Class type) {
        this.removeConverter(type);
    }

    private void setConverter(Object key, Converter converter) {
        this.converterMap.put(key, converter);
        this.sequenceMap.put(key, new Integer(this.sequence++));
    }

    private void removeConverter(Object key) {
        this.converterMap.remove(key);
        this.sequenceMap.remove(key);
    }

    private int getSequence(Object key) {
        if (this.sequenceMap.containsKey(key)) {
            return (Integer)this.sequenceMap.get(key);
        }
        return -54321;
    }

    public Converter[] getConverters(ArrayHeaderLocator colNameLocator, Object[][] data) {
        int size = data == null || data.length == 0 ? 0 : data[0].length;
        Converter[] converters = new Converter[size];
        for (int j = 0; j < size; ++j) {
            Integer colKey = new Integer(j);
            String colName = colNameLocator.getColName(j);
            Converter converter = this.getConverter(j, colName);
            if (converter == null) {
                converter = this.getTypeConverter(data[0][j]);
            }
            if (converter == null) {
                converter = this.getDefaultConverter();
            }
            converters[j] = converter;
        }
        return converters;
    }

    private Converter getConverter(int colNum, String colName) {
        Integer colKey = new Integer(colNum);
        Converter converter = null;
        if (this.getSequence(colKey) > this.getSequence(colName)) {
            converter = this.getConverter(colKey);
        } else if (this.getSequence(colName) > this.getSequence(colKey)) {
            converter = this.getConverter(colName);
        }
        return converter;
    }

    private Converter getTypeConverter(Object obj) {
        Class<?> type;
        Class<?> clazz = type = obj == null ? null : obj.getClass();
        do {
            if (this.converterMap.containsKey(type)) {
                return ((Converter)this.converterMap.get(type)).createInstance();
            }
            if (type == null) continue;
            type = type.getSuperclass();
        } while (type != null);
        return null;
    }

    public static Class[] getTypes(Object obj) {
        return obj == null ? null : obj.getClass().getInterfaces();
    }

    public Object clone() {
        Map cm = (Map)((AppMap)this.converterMap).clone();
        Map sm = (Map)((AppMap)this.sequenceMap).clone();
        return new ArrayConverterFactory(cm, sm, this.defaultConverter, this.sequence);
    }

    public ArrayConverterFactory copy() {
        return (ArrayConverterFactory)this.clone();
    }

    public String toString() {
        return "converterMap=" + this.converterMap + "\ndefaultConverter= " + this.defaultConverter;
    }

    public static void main(String[] args) {
        ArrayConverterFactory f1 = new ArrayConverterFactory();
        f1.setColConverter(1, (Converter)new NullConverter());
        f1.setTypeConverter(Object.class, new NullConverter());
        f1.setDefaultConverter(new NullConverter());
        ArrayConverterFactory f2 = f1.copy();
        f2.setColConverter(25, (Converter)new ConverterNumToString());
        System.out.println(f1);
        System.out.println(f2);
    }
}

