/*
 * Decompiled with CFR 0.152.
 */
package com.fdsapi.arrays;

import com.fdsapi.AppConstants;
import com.fdsapi.Converter;
import com.fdsapi.ConverterDateToString;
import com.fdsapi.ConverterEscapeChars;
import com.fdsapi.ConverterMapValue;
import com.fdsapi.ConverterNumToString;
import com.fdsapi.FormattedDataSet;
import com.fdsapi.NullConverter;
import com.fdsapi.Utils;
import com.fdsapi.arrays.ArrayConverterFactory;
import com.fdsapi.arrays.ArrayHeaderLocator;
import com.jamonapi.Monitor;
import com.jamonapi.MonitorFactory;
import java.util.Date;
import java.util.HashMap;

public class ArrayConverter
implements Cloneable {
    private boolean overWriteExistingArray = false;
    private ArrayConverterFactory factory;
    private ArrayHeaderLocator headerLocator = new ArrayHeaderLocator();

    public ArrayConverter() {
        this.factory = new ArrayConverterFactory();
        this.setDefaultConverter();
    }

    public ArrayConverter(String[] header) {
        this();
        this.setArrayHeaderLocator(header);
    }

    public ArrayConverter(boolean overWriteExistingArray) {
        this();
        this.setOverWriteExistingArray(overWriteExistingArray);
    }

    public ArrayConverter(String[] header, boolean overWriteExistingArray) {
        this(header);
        this.setOverWriteExistingArray(overWriteExistingArray);
    }

    private ArrayConverter(ArrayConverterFactory factory, ArrayHeaderLocator headerLocator, boolean overWriteExistingArray) {
        this.factory = factory;
        this.headerLocator = headerLocator;
        this.overWriteExistingArray = overWriteExistingArray;
    }

    private void setDefaultConverter() {
        this.setDefaultConverter(new ConverterNumToString(new ConverterDateToString()));
    }

    public Object[][] convert(String[] header, Object[][] data) {
        return this.convert(new ArrayHeaderLocator(header), data);
    }

    public Object[][] convert(Object[][] data) {
        return this.convert(this.getArrayHeaderLocator(), data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[][] convert(ArrayHeaderLocator arrayHeaderLocator, Object[][] data) {
        Monitor mon = AppConstants.start("arrays.ArrayConverter.convert(Object[][])");
        Object[][] resultsArray = null;
        try {
            if (data == null) {
                Object[][] objectArray = null;
                return objectArray;
            }
            resultsArray = this.getData(data);
            Converter[] converters = this.factory.getConverters(arrayHeaderLocator, data);
            int rows = data.length;
            int cols = rows == 0 || data[0] == null ? 0 : data[0].length;
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < cols; ++j) {
                    resultsArray[i][j] = converters[j].convert(data[i][j]);
                }
            }
        }
        finally {
            mon.stop();
        }
        return resultsArray;
    }

    public void setOverWriteExistingArray(boolean overWriteExistingArray) {
        this.overWriteExistingArray = overWriteExistingArray;
    }

    public boolean overWriteExistingArray() {
        return this.overWriteExistingArray;
    }

    public void setDefaultConverter(Converter converter) {
        this.factory.setDefaultConverter(converter);
    }

    public void setColConverter(int colNum, Converter converter) {
        this.factory.setColConverter(colNum, converter);
    }

    public void removeColConverter(int colNum) {
        this.factory.removeColConverter(colNum);
    }

    public void setColConverter(String colName, Converter converter) {
        this.factory.setColConverter(colName, converter);
    }

    public void removeColConverter(String colName) {
        this.factory.removeColConverter(colName);
    }

    public void setTypeConverter(Class type, Converter converter) {
        this.factory.setTypeConverter(type, converter);
    }

    public void removeTypeConverter(Class type) {
        this.factory.removeTypeConverter(type);
    }

    public void setArrayConverterFactory(ArrayConverterFactory factory) {
        this.factory = factory;
    }

    public ArrayConverterFactory getArrayConverterFactory() {
        return this.factory;
    }

    public Object clone() {
        return new ArrayConverter(this.factory.copy(), this.headerLocator.copy(), this.overWriteExistingArray());
    }

    public ArrayConverter copy() {
        return (ArrayConverter)this.clone();
    }

    public void setArrayHeaderLocator(ArrayHeaderLocator headerLocator) {
        this.headerLocator = headerLocator;
    }

    public void setArrayHeaderLocator(String[] header) {
        this.setArrayHeaderLocator(new ArrayHeaderLocator(header));
    }

    private ArrayHeaderLocator getArrayHeaderLocator() {
        return this.headerLocator;
    }

    private Object[][] getData(Object[][] data) {
        if (this.overWriteExistingArray()) {
            return data;
        }
        return Utils.copy(data);
    }

    public String toString() {
        return "Factory=" + this.factory + "\nheaderLocator=" + this.headerLocator + "\noverWriteExistingArray=" + this.overWriteExistingArray();
    }

    public static void main(String[] args) throws Exception {
        FormattedDataSet fds = new FormattedDataSet();
        ArrayConverter ac = new ArrayConverter(new String[]{"fname", "lname"});
        Object[][] data = new Object[][]{{"jeff", "beck", new Integer(1000), new Long(999999L), new Float(123.756), new Date(), new Boolean(true), "beck"}, {"william", "reid", new Integer(1000000), new Long(99999999L), new Double(3456.789), new Date(), new Boolean(true), "reid"}, {"iggy", null, new Integer(1000000), new Long(99999999L), new Double(3456.789), new Date(), new Boolean(false), null}, {"special chars:<>'&\"\u00c8", null, new Integer(1000000), new Long(99999999L), new Double(3456.789), new Date(), new Boolean(false), null}};
        ac.convert(data);
        HashMap<Object, String> converterMap = new HashMap<Object, String>();
        converterMap.put("reid", "JIMMY");
        converterMap.put(null, "&nbsp;");
        converterMap.put(new Boolean(true), "yes");
        converterMap.put(new Boolean(false), "no");
        ac.setColConverter("lname", (Converter)new ConverterMapValue(converterMap));
        ac.setColConverter(6, (Converter)new ConverterMapValue(converterMap));
        ac.getArrayHeaderLocator().setColName("lnameagain", 7);
        ac.setColConverter(7, (Converter)new NullConverter());
        ac.setColConverter("lnameagain", (Converter)new ConverterMapValue(converterMap));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("delimiter", " - ");
        System.out.println("Data not formatted:");
        System.out.println(fds.getFormattedDataSet(null, (Object)data, map, "delimited"));
        System.out.println("Data formatted:");
        System.out.println(fds.getFormattedDataSet(null, (Object)ac.convert(data), map, "delimited"));
        ac.setOverWriteExistingArray(true);
        System.out.println("Data not formatted (overwrite existing array):");
        System.out.println(fds.getFormattedDataSet(null, (Object)data, map, "delimited"));
        System.out.println("Data formatted (overwrite existing array - original array displayed below):");
        ac.convert(data);
        System.out.println(fds.getFormattedDataSet(null, (Object)data, map, "delimited"));
        System.out.println(fds.getFormattedDataSet(null, (Object)MonitorFactory.getRootMonitor().getData(), map, "delimited"));
        ArrayConverter ac2 = ac.copy();
        ac2.setColConverter(25, (Converter)new NullConverter());
        ac2.setDefaultConverter(new NullConverter());
        ac2.setTypeConverter(String.class, new NullConverter());
        System.out.println(ac + "\n");
        System.out.println(ac.copy() + "\n");
        System.out.println(ac2 + "\n");
        ac = new ArrayConverter();
        ac.setDefaultConverter(new ConverterEscapeChars());
        System.out.println(fds.getFormattedDataSet(null, (Object)ac.convert(data), map, "delimited"));
    }
}

