/*
 * Decompiled with CFR 0.152.
 */
package com.fdsapi.arrays;

import com.fdsapi.AppConstants;
import com.fdsapi.FormattedDataSet;
import com.fdsapi.arrays.ArrayHeaderLocator;
import com.jamonapi.Monitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class ArrayComparator
implements Comparator {
    private List sortCols = new ArrayList();
    private ArrayHeaderLocator headerLocator = new ArrayHeaderLocator(true);
    private String sortStr = "";
    private boolean isFirstOrderBy = true;

    public ArrayComparator() {
    }

    public ArrayComparator(int sortCol, String direction) {
        this.addSortCol(sortCol, direction);
    }

    public ArrayComparator(String[] header) {
        this.headerLocator = new ArrayHeaderLocator(header, true);
    }

    public static void sort(Object[][] array, int sortIndex, String sortDir) {
        new ArrayComparator(sortIndex, sortDir).sort(array);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort(Object[][] array) {
        Monitor mon = AppConstants.start("arrays.ArrayComparator.sort(Object[][])");
        try {
            Arrays.sort(array, this);
        }
        finally {
            mon.stop();
        }
    }

    public void addSortCol(int sortCol, String direction) {
        this.addToString("col" + sortCol, direction);
        this.sortCols.add(new ElementComparator(sortCol, direction));
    }

    public void addSortCol(String sortColName, String direction) {
        this.addToString(sortColName, direction);
        this.sortCols.add(new ElementComparator(this.getColNumFromName(sortColName), direction));
    }

    private int getColNumFromName(String columnName) {
        return this.headerLocator.getColNum(columnName);
    }

    private void addToString(String sortColName, String direction) {
        String comma = this.isFirstOrderBy ? "order by " : ", ";
        this.sortStr = this.sortStr + comma + sortColName + " " + direction;
        this.isFirstOrderBy = false;
    }

    public String toString() {
        return this.sortStr;
    }

    public int compare(Object o1, Object o2) {
        Object element2;
        Object element1;
        ElementComparator elementComp;
        int compareVal = 0;
        Iterator iter = this.sortCols.iterator();
        while (iter.hasNext() && (compareVal = (elementComp = (ElementComparator)iter.next()).compare(element1 = ((Object[])o1)[elementComp.getSortCol()], element2 = ((Object[])o2)[elementComp.getSortCol()])) == 0) {
        }
        return compareVal;
    }

    public static Object[][] copy(Object[][] data) {
        if (data == null) {
            return null;
        }
        Object[][] copyData = new Object[data.length][];
        System.arraycopy(data, 0, copyData, 0, data.length);
        return copyData;
    }

    public static void main(String[] args) throws Exception {
        Object[][] array = new Object[][]{{"steve", null, "souza"}, {"steve", null, "adams"}, {"steve", null, "parker"}, {"zeus", new Long(1L), "johnson"}, {"al", new Long(100L), "adams"}, {null, new Long(10L), "johnson"}, {null, new Long(2L), "johnson"}, {null, new Long(1L), "johnson"}, {"al", new Long(20L), "smith"}, {"peter", new Long(20L), "smith"}, {"peter", new Long(20L), "parker"}, {"peter", new Long(20L), "adams"}};
        String[] header = new String[]{"fname", "age", "lname"};
        FormattedDataSet fds = FormattedDataSet.createInstance();
        ArrayComparator.sort(array, 1, "desc");
        System.out.println("1) col 1 descending" + fds.getFormattedDataSet(null, array, "csv"));
        Arrays.sort(array, new ArrayComparator(0, "asc"));
        System.out.println(fds.getFormattedDataSet(null, array, "csv"));
        ArrayComparator ac = new ArrayComparator();
        ac.addSortCol(0, "asc");
        ac.addSortCol(1, "desc");
        ac.addSortCol(2, "asc");
        ac.sort(array);
        System.out.println("\n\n3) " + ac + "\n" + fds.getFormattedDataSet(null, array, "csv"));
        ac = new ArrayComparator(header);
        ac.addSortCol("fname", "asc");
        ac.addSortCol("lname", "desc");
        ac.addSortCol("age", "asc");
        ac.sort(array);
        System.out.println("\n\n3) " + ac + "\n" + fds.getFormattedDataSet(null, array, "csv"));
    }

    private static class ElementComparator
    implements Comparator {
        private int sortCol;
        private static final int ASC = 0;
        private static final int DESC = 1;
        private int dir;

        public ElementComparator(int sortCol, String direction) {
            this.sortCol = sortCol;
            if ("asc".equalsIgnoreCase(direction) || "ascending".equalsIgnoreCase(direction)) {
                this.dir = 0;
            } else if ("desc".equalsIgnoreCase(direction) || "descending".equalsIgnoreCase(direction)) {
                this.dir = 1;
            } else {
                throw new IllegalArgumentException("'asc' or 'desc' must be passed to the constructor.  The argument passed was: " + direction);
            }
        }

        private boolean isAscending() {
            return this.dir == 0;
        }

        public int getSortCol() {
            return this.sortCol;
        }

        public int compare(Object o1, Object o2) {
            Comparable comparable = null;
            Object element1 = o1;
            Object element2 = o2;
            if (element1 == null && element2 == null) {
                return 0;
            }
            if (element1 == null) {
                return 1;
            }
            if (element2 == null) {
                return -1;
            }
            comparable = (Comparable)element1;
            if (this.isAscending()) {
                return comparable.compareTo(element2);
            }
            return -comparable.compareTo(element2);
        }
    }
}

