/*
 * Decompiled with CFR 0.152.
 */
package com.fdsapi;

import com.fdsapi.RegularExpression;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;

public class Utils {
    static boolean debug = false;

    public static boolean isEmpty(String str) {
        return str == null ? true : str.equals("");
    }

    public static String[][] getParameters(HttpServletRequest request) {
        int i;
        ArrayList<String[]> list = new ArrayList<String[]>();
        Enumeration enumer = request.getParameterNames();
        while (enumer.hasMoreElements()) {
            String name = enumer.nextElement().toString();
            String[] values = request.getParameterValues(name);
            if (values == null) continue;
            for (i = 0; i < values.length; ++i) {
                String[] row = new String[]{name, values[i]};
                list.add(row);
            }
        }
        String[][] arr = null;
        if (list.size() > 0) {
            arr = new String[list.size()][];
            Iterator iter = list.iterator();
            i = 0;
            while (iter.hasNext()) {
                arr[i] = (String[])iter.next();
                ++i;
            }
        }
        return arr;
    }

    public static Object[][] copy(Object[][] data) {
        if (data == null) {
            return null;
        }
        int size = data.length;
        Object[][] copyData = new Object[size][];
        System.arraycopy(data, 0, copyData, 0, size);
        for (int i = 0; i < size; ++i) {
            copyData[i] = Utils.copy(data[i]);
        }
        return copyData;
    }

    public static Object[] copy(Object[] originalRow) {
        if (originalRow == null) {
            return null;
        }
        int numCols = originalRow.length;
        Object[] rowCopy = new Object[numCols];
        System.arraycopy(originalRow, 0, rowCopy, 0, numCols);
        return rowCopy;
    }

    public static String[] convert(Object[] data) {
        if (data == null) {
            return null;
        }
        String[] strData = new String[data.length];
        for (int i = 0; i < data.length; ++i) {
            strData[i] = data[i] == null ? null : data[i].toString();
        }
        return strData;
    }

    public static String[] split(String reStr, String splitStr) {
        RegularExpression re = new RegularExpression(reStr);
        return re.split(splitStr);
    }

    public static String getREMatch(String reStr, String sourceStr, int matchNum) {
        RegularExpression re = new RegularExpression(reStr);
        re.setSourceString(sourceStr);
        String matchStr = null;
        while (re.next()) {
            matchStr = re.getParen(matchNum);
        }
        return matchStr;
    }

    private static void replaceSpecialChar(StringBuffer buf, char ch) {
        if (ch == '<') {
            buf.append("&lt;");
        } else if (ch == '>') {
            buf.append("&gt;");
        } else if (ch == '\"') {
            buf.append("&quot;");
        } else if (ch == '\'') {
            buf.append("&apos;");
        } else if (ch == '&') {
            buf.append("&amp;");
        } else if (ch >= '\u0080') {
            buf.append("&#" + ch + ";");
        } else {
            buf.append(ch);
        }
    }

    public static String escapeXML(String input) {
        if (input == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        int numChars = input.length();
        for (int i = 0; i < numChars; ++i) {
            Utils.replaceSpecialChar(buf, input.charAt(i));
        }
        return buf.toString();
    }

    public static void setDebug(boolean debugFlag) {
        debug = debugFlag;
    }

    public static boolean getDebug() {
        return debug;
    }

    public static void log(Object msg) {
        System.out.println(msg);
    }

    public static void logDebug(Object msg) {
        if (debug) {
            System.out.println(msg);
        }
    }

    public static String delimit(String delimeter, Object[] data) {
        int rows = data == null ? 0 : data.length;
        int lastElement = rows - 1;
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < rows; ++i) {
            buff.append(data[i]);
            if (i == lastElement) continue;
            buff.append(delimeter);
        }
        return buff.toString();
    }

    public static void main(String[] args) {
        System.out.println(Utils.escapeXML("The following special characters will be translated: <>'\"&\u00c8"));
        System.out.println(Utils.delimit(",", new String[]{"steve", "jeff", "william"}));
        System.out.println(Utils.delimit("-", new String[]{"steve", "jeff", "william"}));
        System.out.println(Utils.delimit(null, new String[]{"steve", "jeff", "william"}));
        System.out.println(Utils.delimit(",", new String[]{"steve"}));
        System.out.println(Utils.delimit(",", new Object[]{"steve", new Long(100L)}));
    }
}

