/*
 * Decompiled with CFR 0.152.
 */
package com.fdsapi;

import com.fdsapi.RuntimeExceptionBase;
import com.fdsapi.Template;
import com.fdsapi.Utils;
import com.jamonapi.Monitor;
import com.jamonapi.MonitorFactory;
import com.jamonapi.utils.AppMap;
import com.jamonapi.utils.FileUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Templates {
    private Map templatesMap = Collections.synchronizedMap(AppMap.createInstance());

    public Templates() {
        new DefaultTemplates().initialize();
    }

    public void put(String templateLogicalName, Template template) {
        this.templatesMap.put(templateLogicalName, template);
    }

    public Template get(String templateLogicalName) {
        return (Template)this.templatesMap.get(templateLogicalName);
    }

    public void remove(String templateLogicalName) {
        this.templatesMap.remove(templateLogicalName);
    }

    private void log(String logStr) {
        Utils.logDebug(logStr);
    }

    public void initialize(String[][] templateFiles) {
        try {
            this.log("**Start populating templates from files\n");
            int templateRows = templateFiles.length;
            Monitor mon = null;
            for (int i = 0; i < templateRows; ++i) {
                mon = MonitorFactory.start((String)"Templates.initialize()");
                String templateLogicalName = templateFiles[i][0];
                String templateFileName = templateFiles[i][1];
                this.log("**Start Initializing template templateName=" + templateLogicalName + ", templateFile=" + templateFileName);
                String fileContents = FileUtils.getFileContents((String)templateFileName);
                this.createFactoryTemplate(templateLogicalName, fileContents);
                this.log("**End Initializing template templateName=" + templateLogicalName + ", templateFile=" + templateFileName + ", Time=" + mon.stop());
            }
            this.log("**End populating templates from files.  Total time=" + mon + "\n");
        }
        catch (Exception e) {
            throw new RuntimeExceptionBase("error initializing template files" + e);
        }
    }

    private Template getTemplate(String templateLogicalName) {
        if (this.templatesMap.containsKey(templateLogicalName)) {
            return this.get(templateLogicalName);
        }
        return new Template();
    }

    private void createFactoryTemplate(String templateLogicalName, String templateContents) {
        Template template = this.getTemplate(templateLogicalName);
        template.initialize(templateContents);
        this.put(templateLogicalName, template);
    }

    public static void main(String[] args) throws Exception {
        Monitor mon = MonitorFactory.start();
        Utils.setDebug(true);
        Templates templates = new Templates();
        String[] header = new String[]{"stateCode", "stateName"};
        String[][] body = new String[][]{{"AL", "Alaska"}, {"CA", "California"}, {"VA", "Virginia"}, {"MD", "Maryland"}};
        Template template = templates.get("htmlTable");
        System.out.println("\n\n" + template.execute(header, body));
        template = templates.get("dropDownListBox");
        System.out.println("\n" + template.execute(header, body));
        template = templates.get("listBox");
        System.out.println("\n" + template.execute(header, body));
        header = new String[]{"stateCode", "stateName"};
        body = new String[][]{{"AL", "Alaska"}, {"CA", "California"}, {"VA", "Virginia"}, {"MD", "Maryland"}};
        template = templates.get("radioButton");
        System.out.println("\n" + template.execute(header, body));
        template = templates.get("basicHTMLTable");
        System.out.println("\n\n" + template.execute(header, body));
        template = templates.get("htmlTable");
        System.out.println("\n\n" + template.execute(header, body));
        template = templates.get("sortedHTMLTable");
        System.out.println("\n\n" + template.execute(header, body));
        template = templates.get("xml");
        System.out.println("\n\n" + template.execute(header, body));
        template = templates.get("xml1");
        HashMap<String, String> miscData = new HashMap<String, String>();
        miscData.put("rootElement", "statesRootElement");
        System.out.println("\n\n" + template.execute(header, body, miscData));
        template = templates.get("blank");
        System.out.println("\n\n" + template.execute(header, body));
        template = templates.get("csv");
        System.out.println("\n\n" + template.execute(header, body));
        template = templates.get("delimited");
        miscData.put("delimiter", "||");
        System.out.println("\n\n" + template.execute(header, body, miscData));
        Monitor mon2 = MonitorFactory.start();
        template = (Template)templates.get("htmlTable").clone();
        template.initialize("<!-- BODY_ROW_PREFIX -->Type==Alternating Odd==<tr class='odd'> Even==<tr class='even'><!-- BODY_ROW_PREFIX -->");
        template.initialize("<!-- body_cell_data 0,1 -->Type==Conditional if==VA ifValue==##this(conditional worked) elseValue==##this<!-- body_cell_data 0,1 -->");
        System.out.println("\n\n" + template.execute(header, body));
        System.out.println("Execution time for inheriting a template (cloning/overriding 2 tags) and executing: " + mon2.stop());
        System.out.println("\n\nTotal execution time: " + mon.stop());
    }

    private class DefaultTemplates {
        String basicTable = "<!-- COMPOSITE_PREFIX --><table border='1' rules='all'>\n<!-- COMPOSITE_PREFIX --><!-- COMPOSITE_SUFFIX --></table>\n<!-- COMPOSITE_SUFFIX --><!-- HEADER_ROW_SUFFIX -->\n<!-- HEADER_ROW_SUFFIX --><!-- HEADER_CELL_PREFIX --><th><!-- HEADER_CELL_PREFIX --><!-- HEADER_CELL_SUFFIX --></th><!-- HEADER_CELL_SUFFIX --><!-- BODY_ROW_PREFIX --><tr><!-- BODY_ROW_PREFIX --><!-- BODY_ROW_SUFFIX --></tr>\n<!-- BODY_ROW_SUFFIX --><!-- BODY_CELL_PREFIX --><td><!-- BODY_CELL_PREFIX --><!-- BODY_CELL_SUFFIX --></td><!-- BODY_CELL_SUFFIX -->";
        String htmlTable = "<!-- COMPOSITE_PREFIX -->\n<table class='layoutMain' border cellpadding='0' cellspacing='0' width='100%' align='center'>\n<tr bgcolor='#FFFFFF'>\n<td><table border='0' cellpadding='2' cellspacing='1' width='100%'>\n<!-- COMPOSITE_PREFIX --><!-- COMPOSITE_SUFFIX --></table></td>\n</tr>\n</table>\n<!-- COMPOSITE_SUFFIX --><!-- HEADER_ROW_PREFIX -->    <tr><!-- HEADER_ROW_PREFIX --><!-- HEADER_ROW_SUFFIX -->    </tr><!-- HEADER_ROW_SUFFIX --><!-- HEADER_ROW_PREFIX 1,0 -->   <tr class='sectHead'><!-- HEADER_ROW_PREFIX 1,0 --><!-- HEADER_ROW_SUFFIX 1,0 -->\n    </tr>\n<!-- HEADER_ROW_SUFFIX 1,0 --><!-- HEADER_CELL_PREFIX -->\n    <th><!-- HEADER_CELL_PREFIX --><!-- HEADER_CELL_SUFFIX --></th><!-- HEADER_CELL_SUFFIX --><!-- BODY_ROW_PREFIX -->Type==Alternating Odd==   <tr class='odd'>\n Even==   <tr class='even'>\n<!-- BODY_ROW_PREFIX --><!-- BODY_ROW_SUFFIX -->   </tr>\n<!-- BODY_ROW_SUFFIX --><!-- BODY_CELL_PREFIX -->    <td><!-- BODY_CELL_PREFIX --><!-- BODY_CELL_SUFFIX --></td>\n<!-- BODY_CELL_SUFFIX --><!-- body_cell_data -->Type==Conditional if==null ifValue==&nbsp; elseValue==##this<!-- body_cell_data -->";
        String sortedHTMLTable = this.htmlTable + "<!-- HEADER_CELL_DATA --><a style='color:white;' href=\"##sortPageName?sortCol=##colNum&sortOrder=##sortOrderThis##query\">##this</a><br>##sortOrderGifThis<!-- HEADER_CELL_DATA -->";
        String listBox = "<!-- HEADER_ROW_SUFFIX -->\n<!-- HEADER_ROW_SUFFIX --><!-- HEADER_CELL_PREFIX 0,1 --><select name='<!-- HEADER_CELL_PREFIX 0,1 --><!-- HEADER_CELL_SUFFIX 0,1 -->' size='1' id='##1_ID'><!-- HEADER_CELL_SUFFIX 0,1 --><!-- HEADER_CELL_DATA -->Type==EMPTY<!-- HEADER_CELL_DATA --><!-- HEADER_CELL_DATA 0,1 -->Type==DATA<!-- HEADER_CELL_DATA 0,1 --><!-- BODY_SUFFIX --></select>\n<!-- BODY_SUFFIX --><!-- BODY_ROW_PREFIX --><option value='<!-- BODY_ROW_PREFIX --><!-- BODY_ROW_SUFFIX -->\n<!-- BODY_ROW_SUFFIX --><!-- BODY_CELL_SUFFIX 0,1 -->'><!-- BODY_CELL_SUFFIX 0,1 -->";
        String multiSelectListBox = "<!-- HEADER_CELL_SUFFIX 0,1 -->' size='1' id='##1_ID' multiple='MULTIPLE'><!-- HEADER_CELL_SUFFIX 0,1 -->";
        String radioButton = "<!-- HEADER_DATA -->Type==EMPTY<!-- HEADER_DATA --><!-- BODY_PREFIX -->\n<!-- BODY_PREFIX --><!-- BODY_ROW_DATA --><input  name=##header1 value=##1 type=radio>##2\n<!-- BODY_ROW_DATA -->";
        String xml = "<!-- HEADER_DATA --><!-- HEADER_DATA --><!-- BODY_ROW_PREFIX --> <row rowID='##rowNum'>\n<!-- BODY_ROW_PREFIX --><!-- BODY_CELL_PREFIX -->  <##headerThis><!-- BODY_CELL_PREFIX --><!-- BODY_CELL_SUFFIX --></##headerThis>\n<!-- BODY_CELL_SUFFIX --><!-- BODY_ROW_SUFFIX --> </row>\n<!-- BODY_ROW_SUFFIX -->";
        String xml1 = "<!-- COMPOSITE_PREFIX --><##rootElement>\n<!-- COMPOSITE_PREFIX --><!-- COMPOSITE_SUFFIX --></##rootElement>\n<!-- COMPOSITE_SUFFIX -->" + this.xml;
        String blank = "<!-- HEADER_DATA -->Type==Empty<!-- HEADER_DATA -->";
        String csv = "<!-- HEADER_DATA -->Type==Empty<!-- HEADER_DATA --><!-- BODY_CELL_PREFIX -->,<!-- BODY_CELL_PREFIX --><!-- BODY_CELL_PREFIX 0,1 --><!-- BODY_CELL_PREFIX 0,1 --><!-- BODY_ROW_SUFFIX -->\n<!-- BODY_ROW_SUFFIX -->";
        String delimited = "<!-- HEADER_DATA -->Type==Empty<!-- HEADER_DATA --><!-- BODY_CELL_PREFIX -->##delimiter<!-- BODY_CELL_PREFIX --><!-- BODY_CELL_PREFIX 0,1 --><!-- BODY_CELL_PREFIX 0,1 --><!-- BODY_ROW_SUFFIX -->\n<!-- BODY_ROW_SUFFIX -->";

        private DefaultTemplates() {
        }

        void initialize() {
            Monitor mon = MonitorFactory.start();
            Templates.this.log("*Start Initializing default Templates.");
            Templates.this.log("\n*Start creating Default basic HTML table template");
            Templates.this.createFactoryTemplate("BASICHTMLTABLE", this.basicTable);
            Templates.this.log("*End creating Default basic HTML table template");
            Templates.this.log("\n*Start creating Default HTML table template");
            Templates.this.createFactoryTemplate("HTMLTABLE", this.htmlTable);
            Templates.this.log("*End creating Default HTML table template");
            Templates.this.log("\n*Start creating SortedHTMLTable template");
            Templates.this.createFactoryTemplate("sortedHTMLTable", this.sortedHTMLTable);
            Templates.this.log("*End creating SortedHTMLTable template");
            Templates.this.log("\n*Start creating Default dropDownListBox template");
            Templates.this.createFactoryTemplate("DROPDOWNLISTBOX", this.listBox);
            Templates.this.log("*End creating Default dropDownListBox template");
            Templates.this.log("\n*Start creating Default listBox template");
            Templates.this.createFactoryTemplate("LISTBOX", this.listBox);
            Templates.this.log("*End creating Default listBox template");
            Templates.this.log("\n*Start creating Default multi-select listBox template");
            Templates.this.createFactoryTemplate("MULTISELECTLISTBOX", this.listBox);
            Templates.this.get("MULTISELECTLISTBOX").initialize(this.multiSelectListBox);
            Templates.this.log("*End creating Default multi-select listBox template");
            Templates.this.log("\n*Start creating Default radioButton template");
            Templates.this.createFactoryTemplate("RADIOBUTTON", this.radioButton);
            Templates.this.log("*End creating Default radioButton template");
            Templates.this.log("\n*Start creating Default XML template");
            Templates.this.createFactoryTemplate("XML", this.xml);
            Templates.this.log("*End creating Default XML template");
            Templates.this.log("\n*Start creating Default XML1 template");
            Templates.this.createFactoryTemplate("XML1", this.xml1);
            Templates.this.log("*End creating Default XML1 template");
            Templates.this.log("\n*Start creating blank template");
            Templates.this.createFactoryTemplate("BLANK", this.blank);
            Templates.this.log("*End creating blank template");
            Templates.this.log("\n*Start creating CSV template");
            Templates.this.createFactoryTemplate("CSV", this.csv);
            Templates.this.log("*End creating CSV template");
            Templates.this.log("\n*Start creating delimited template");
            Templates.this.createFactoryTemplate("DELIMITED", this.delimited);
            Templates.this.log("*End creating delimited template");
            Templates.this.log("*End Initializing default Templates.  Total time=" + mon.stop());
        }
    }
}

