/*
 * Decompiled with CFR 0.152.
 */
package com.fdsapi;

import com.fdsapi.AppConstants;
import com.fdsapi.ColBoundary;
import com.fdsapi.DataSetParm;
import com.fdsapi.RuntimeExceptionBase;
import com.fdsapi.TabularData;
import com.fdsapi.TabularData2DimArray;
import com.fdsapi.TemplateColumnReader;
import com.fdsapi.TemplateVariableReader;
import com.fdsapi.Utils;
import com.jamonapi.utils.AppMap;
import java.util.Iterator;
import java.util.Map;

public class TemplateVariables {
    private Map variablesMap = AppMap.createInstance();

    public static TemplateVariables createInstance() {
        TemplateVariables variables = new TemplateVariables();
        variables.setVariable("TYPE", "CONSTANT");
        variables.setVariable("INCREMENTDATA", "DEFAULT");
        variables.setVariable("DATASOURCE", AppConstants.get(AppConstants.DATASOURCE));
        return variables;
    }

    public String getVariableValue(String variableName) {
        return this.getVariable(variableName).toString();
    }

    public String getVariableValue(String variableName, DataSetParm dataSetParm) {
        return this.getVariable(variableName).getVariableValue(dataSetParm);
    }

    public void setVariable(String variableName, String variableValue) {
        this.variablesMap.put(variableName, new VariableEntry(variableValue));
    }

    private VariableEntry getVariable(String variableName) {
        if (this.variablesMap.containsKey(variableName)) {
            return (VariableEntry)this.variablesMap.get(variableName);
        }
        throw new RuntimeExceptionBase("The specified variable did not exist: " + variableName);
    }

    public void populateVariables(String sourceString) {
        TemplateVariableReader variableReader = TemplateVariableReader.createInstance();
        variableReader.setSourceString(sourceString);
        this.setVariable("VALUE", sourceString);
        while (variableReader.next()) {
            this.setVariable(variableReader.getVariable(), variableReader.getVariableValue());
        }
    }

    public String getType() {
        return this.getVariableValue("TYPE").trim();
    }

    public String getValue() {
        return this.getVariableValue("VALUE");
    }

    public String getIncrementData(DataSetParm dataSetParm) {
        return this.getVariableValue("INCREMENTDATA", dataSetParm).trim();
    }

    public String getDataSource(DataSetParm dataSetParm) {
        return this.getVariableValue("DATASOURCE", dataSetParm).trim();
    }

    public String getValue(DataSetParm dataSetParm) {
        return this.getVariableValue("VALUE", dataSetParm);
    }

    public String getTemplate(DataSetParm dataSetParm) {
        return this.getVariableValue("TEMPLATE", dataSetParm).trim();
    }

    public String getSelected(DataSetParm dataSetParm) {
        return this.getVariableValue("SELECTED", dataSetParm);
    }

    public String getSize(DataSetParm dataSetParm) {
        return this.getVariableValue("SIZE", dataSetParm).trim();
    }

    public String getQuery(DataSetParm dataSetParm) {
        return this.getVariableValue("QUERY", dataSetParm);
    }

    public Iterator iterator() {
        return this.variablesMap.keySet().iterator();
    }

    public static void main(String[] args) throws Exception {
        String[][] data = new String[][]{{"(1,1)", "(1,2)"}, {"(2,1)", "(2,2)"}};
        int row = 1;
        TabularData td = new TabularData2DimArray().createInstance(data);
        DataSetParm dsp = new DataSetParm(td, new StringBuffer(), AppMap.createInstance());
        TemplateVariables test = TemplateVariables.createInstance();
        test.populateVariables("    before1stattribute query==exec  getJobTitlesHistory '##1' type==   listbox   selection==##2, ##1 request==exec request     template==   table     incrementData==  true    value==hello \nworld  dataSource==    myDataSource   size==  123   allTest== thiscell=##this cellincol1=##1, rowNum=##rowNum, colNum=##colNum testVariable==##rowNum, ##colNum ##headerThis ##header1");
        while (td.getRowIterator().next()) {
            while (td.getColIterator().next()) {
                Utils.log("\n\n****Row" + row++);
                Utils.log("Direct variable access: the following values are automatically trimmed");
                Utils.log("type==(" + test.getType() + ")");
                Utils.log("size==(" + test.getSize(dsp) + ")");
                Utils.log("dataSource==(" + test.getDataSource(dsp) + ")");
                Utils.log("template==(" + test.getTemplate(dsp) + ")");
                Utils.log("incrementData==(" + test.getIncrementData(dsp) + ")");
                Utils.log("\nAccess to all variables via an iterator (values are not trimmed)");
                Iterator iter = test.iterator();
                while (iter.hasNext()) {
                    String variableName = iter.next().toString();
                    Utils.log(variableName + "==(" + test.getVariableValue(variableName, dsp) + ")");
                }
            }
        }
    }

    static class VariableEntry {
        ColBoundary[] colBoundary;
        String variableValue;

        VariableEntry(String variableValue) {
            this.variableValue = variableValue;
            TemplateColumnReader colReader = TemplateColumnReader.createInstance();
            String[] boundarySplit = colReader.split(variableValue);
            this.colBoundary = new ColBoundary[boundarySplit.length];
            colReader.setSourceString(variableValue);
            for (int i = 0; i < boundarySplit.length; ++i) {
                this.colBoundary[i] = colReader.next() ? ColBoundary.createInstance(boundarySplit[i], colReader.getColumnValue()) : ColBoundary.createInstance(boundarySplit[i], null);
            }
        }

        String getVariableValue() {
            return this.variableValue;
        }

        public String toString() {
            return this.variableValue;
        }

        String getVariableValue(DataSetParm dataSetParm) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.colBoundary.length; ++i) {
                this.colBoundary[i].getVariableValue(stringBuffer, dataSetParm);
            }
            return stringBuffer.toString();
        }
    }
}

