/*
 * Decompiled with CFR 0.152.
 */
package com.fdsapi;

import com.fdsapi.TemplateConstants;
import com.fdsapi.TemplateReader;

public class TemplateTagReader
extends TemplateReader {
    private static final long XY = 0L;
    private static final long TAGVALUE = 1L;

    protected TemplateTagReader(String regularExpressionStr) {
        super(regularExpressionStr);
    }

    public static TemplateTagReader createInstance(String templateTagType) {
        return new TemplateTagReader(TemplateConstants.getTemplateTagTypeRegExp(templateTagType));
    }

    public int getX() {
        return this.getNumber(1);
    }

    public int getY() {
        return this.getNumber(3);
    }

    private int getNumber(int parenNumber) {
        return Integer.parseInt(this.getValue(0L, parenNumber));
    }

    public String getTemplateTagValue() {
        return this.getValue(1L, 4);
    }

    private String getValue(long type, int parenNumber) {
        String value = this.getParen(parenNumber);
        if (value == null && type == 0L) {
            return "0";
        }
        if (value == null && type == 1L) {
            return this.getParen(5);
        }
        return value;
    }

    public static void main(String[] args) throws Exception {
        TemplateTagReader test = TemplateTagReader.createInstance("BODY_ROW_PREFIX");
        test.setSourceString("abc<!-- BODY_ROW_PREFIX -->first valid 0,0<!-- BODY_ROW_PREFIX -->XXX<!-- BODY_ROW_PREFIX 2 -->invalid 2,0 <!-- BODY_ROW_PREFIX 2 -->XXX<!-- BODY_ROW_PREFIX 20,20  -->second valid\nsouza 20,20<!-- BODY_ROW_PREFIX 20,20 --><!-- BODY_CELL_PREFIX   -->invalid 0,0 not used cause it is cell not row<!-- BODY_CELL_PREFIX   --><!-- BODY_ROW_PREFIX 20,    0 -->third valid 20,0<!-- BODY_ROW_PREFIX 20,0 --><!-- BODY_ROW_PREFIX 0,    22 -->fourth valid O,22<!-- BODY_ROW_PREFIX 0,22 --><!-- BODY_ROW_PREFIX a,    22 -->invalid<!-- BODY_ROW_PREFIX a,22 --><!-- BODY_ROW_PREFIX Z,0 -->invalid Z,0<!-- BODY_ROW_PREFIX z,0 --><!-- BODY_ROW_PREFIX ,0 -->invalid ,0<!-- BODY_ROW_PREFIX ,0 --><!-- BODY_ROW_PREFIX 10,0 -->fifth valid 10,0<!-- BODY_ROW_PREFIX 10,0 --><!-- BODY_ROW_PREFIX 1,0 -->invalid 10,0<!-- zzzND_BODY_ROW_PREFIX 1,0 --><!-- BODY_ROW_PREFIX 2, -->invalid  2,<!-- BODY_ROW_PREFIX 2, -->more data at the end");
        while (test.next()) {
            System.out.println("x==" + test.getX() + ", y==" + test.getY() + ", template tag value==" + test.getTemplateTagValue());
        }
    }
}

