/*
 * Decompiled with CFR 0.152.
 */
package com.fdsapi;

public final class TemplateConstants {
    static final String TRUE = "TRUE";
    static final String FALSE = "FALSE";
    static final String DEFAULT = "DEFAULT";
    static final String CONTAINER = "CONTAINER";
    static final String TEMPLATE_TAG_TYPE_SEPARATOR = "_";
    static final String HEADER = "HEADER";
    static final String BODY = "BODY";
    static final String COMPOSITE = "COMPOSITE";
    static final String PREFIX = "PREFIX";
    static final String DATA = "DATA";
    static final String SUFFIX = "SUFFIX";
    static final String EMPTY_LEVEL2 = "";
    static final String CELL = "CELL";
    static final String ROW = "ROW";
    static final String TEMPLATE_VARIABLE_SEPARATOR = "==";
    static final int TEMPLATE_TAG_VALUE_PAREN1 = 4;
    static final int TEMPLATE_TAG_VALUE_PAREN2 = 5;
    static final int TEMPLATE_TAG_X_VALUE_PAREN = 1;
    static final int TEMPLATE_TAG_Y_VALUE_PAREN = 3;
    static final String TEMPLATE_VARIABLE_REGEXP = "(^(.*?)|\\s(.*?))==\\s*(\\w+)";
    static final int TEMPLATE_VARIABLE_PAREN = 4;
    static final int TEMPLATE_VARIABLE_VALUE1_PAREN = 2;
    static final int TEMPLATE_VARIABLE_VALUE2_PAREN = 3;
    static final String ROW_NUM = "rowNum";
    static final String COL_NUM = "colNum";
    static final String CURRENT_COL = "this";
    static final String CURRENT_COL_HEADER = "headerThis";
    static final String TEMPLATE_COLUMN_REGEXP = "##(\\d+|[0-9a-z_A-Z]+)";
    static final int TEMPLATE_COLUMN_VALUE_PAREN = 1;
    static final int DEFAULT_BUFFERSIZE = 25000;
    static final int LISTBOX_BUFFERSIZE = 2000;
    static final int TABLE_BUFFERSIZE = 25000;
    static final int RADIO_BUTTON_BUFFERSIZE = 2000;
    static final String TYPE = "TYPE";
    static final String DATASET_DEFAULT_TYPE = "TYPE==DEFAULT";
    static final String INCREMENT_DATA = "INCREMENTDATA";
    static final String VALUE = "VALUE";
    static final String TEMPLATE = "TEMPLATE";
    static final String DATASOURCE = "DATASOURCE";
    static final String SELECTED = "SELECTED";
    static final String SIZE = "SIZE";
    static final String DATASOURCE_DEFAULT = "DataSource";
    static final String CONSTANT = "CONSTANT";
    static final String NOAPPEND = "NOAPPEND";
    static final String EMPTY = "EMPTY";
    static final String COL = "COL";
    static final String DECORATOR = "DECORATOR";
    static final String NEXT = "NEXT";
    static final String LISTBOX = "LISTBOX";
    static final String DROPDOWNLISTBOX = "DROPDOWNLISTBOX";
    static final String MULTISELECTLISTBOX = "MULTISELECTLISTBOX";
    static final String RADIOBUTTON = "RADIOBUTTON";
    static final String BASICHTMLTABLE = "BASICHTMLTABLE";
    static final String HTMLTABLE = "HTMLTABLE";
    static final String SORTEDHTMLTABLE = "sortedHTMLTable";
    static final String XML = "XML";
    static final String XML1 = "XML1";
    static final String BLANK = "BLANK";
    static final String CSV = "CSV";
    static final String DELIMITED = "DELIMITED";
    static final String QUERY = "QUERY";
    static final String ALTERNATING = "ALTERNATING";
    static final String CONDITIONAL = "CONDITIONAL";
    static final String[] tagTypeLevel1 = new String[]{"HEADER", "BODY", "COMPOSITE"};
    static final String[] tagTypeLevel2 = new String[]{"CELL", "ROW", ""};
    static final String[] tagTypeLevel3 = new String[]{"PREFIX", "DATA", "SUFFIX"};

    public static final String getTemplateTagTypeRegExp(String templateTagType) {
        return "<!--\\s*" + templateTagType + "\\s*(\\d+)\\s*(,)\\s*(\\d+)\\s*-->" + "(.*)" + "<!--\\s*" + templateTagType + "\\s*\\1\\s*\\2*\\s*\\3*\\s*-->" + "|<!--\\s*" + templateTagType + "\\s*-->" + "(.*)" + "<!--\\s*" + templateTagType + "\\s*-->";
    }

    public static final String[] getTemplateTagTypes() {
        String[] templateTagTypes = new String[tagTypeLevel1.length * tagTypeLevel2.length * tagTypeLevel3.length];
        int l = 0;
        for (int i = 0; i < tagTypeLevel1.length; ++i) {
            for (int j = 0; j < tagTypeLevel2.length; ++j) {
                for (int k = 0; k < tagTypeLevel3.length; ++k) {
                    templateTagTypes[l++] = TemplateConstants.getTemplateKey(tagTypeLevel1[i], tagTypeLevel2[j], tagTypeLevel3[k]);
                }
            }
        }
        return templateTagTypes;
    }

    public static final String getTemplateKey(String templateTagTypeLevel1, String templateTagTypeLevel2, String templateTagTypeLevel3) {
        templateTagTypeLevel1 = templateTagTypeLevel1 == null ? EMPTY_LEVEL2 : templateTagTypeLevel1 + TEMPLATE_TAG_TYPE_SEPARATOR;
        templateTagTypeLevel2 = templateTagTypeLevel2 == null || EMPTY_LEVEL2.equals(templateTagTypeLevel2) ? EMPTY_LEVEL2 : templateTagTypeLevel2 + TEMPLATE_TAG_TYPE_SEPARATOR;
        templateTagTypeLevel3 = templateTagTypeLevel3 == null ? EMPTY_LEVEL2 : templateTagTypeLevel3;
        return templateTagTypeLevel1 + templateTagTypeLevel2 + templateTagTypeLevel3;
    }

    static final String[] getTagTypeLevel1() {
        return tagTypeLevel1;
    }

    static final String[] getTagTypeLevel2() {
        return tagTypeLevel2;
    }

    static final String[] getTagTypeLevel3() {
        return tagTypeLevel3;
    }
}

