/*
 * Decompiled with CFR 0.152.
 */
package com.fdsapi;

import com.fdsapi.DataSet;
import com.fdsapi.DataSetFactory;
import com.fdsapi.DataSetParm;
import com.fdsapi.TabularData;
import com.fdsapi.TabularDataFactory;
import com.fdsapi.TemplateConstants;
import com.fdsapi.Utils;
import com.jamonapi.Monitor;
import com.jamonapi.MonitorFactory;
import java.util.HashMap;
import java.util.Map;

public class Template
implements Cloneable {
    private TabularDataFactory tabularDataFactory = TabularDataFactory.createInstance();
    private DataSetFactory dataSetFactory = DataSetFactory.createInstance();
    private DataSet[] factoryDataSets = this.dataSetFactory.getDefaultDataSets();
    private int bufferSize = 25000;
    private String contents = "";
    private int initializeNum = 0;

    public Object execute(Object headerData, Object bodyData) {
        return this.execute(headerData, bodyData, new HashMap());
    }

    public Object execute(Object headerData, Object bodyData, Map miscDataMap) {
        boolean HEADER = false;
        DataSet[] ds = this.dataSetFactory.cloneDataSets(this.factoryDataSets);
        int rowsLevel1 = TemplateConstants.getTagTypeLevel1().length;
        DataSet[] compositeData = new DataSet[rowsLevel1 - 1];
        Object[] data = new Object[]{headerData, bodyData, compositeData};
        StringBuffer buffer = new StringBuffer(this.getBufferSize());
        TabularData headerTabData = null;
        for (int i = 0; i < rowsLevel1; ++i) {
            TabularData tabData = this.tabularDataFactory.getTabularData(data[i]);
            if (i == 0) {
                headerTabData = tabData;
            }
            tabData.setHeader(headerTabData);
            ds[i].setDataSetParm(new DataSetParm(tabData, buffer, miscDataMap));
            if (i >= rowsLevel1 - 1) continue;
            compositeData[i] = ds[i];
        }
        return ds[2].execute();
    }

    public Object clone() throws CloneNotSupportedException {
        Template template = (Template)super.clone();
        template.tabularDataFactory = TabularDataFactory.createInstance();
        template.dataSetFactory = DataSetFactory.createInstance();
        template.factoryDataSets = template.dataSetFactory.cloneDataSets(template.factoryDataSets);
        return template;
    }

    public Template copy() {
        Template t = null;
        try {
            t = (Template)this.clone();
        }
        catch (CloneNotSupportedException e) {
            this.log("This Exception should never happen!:" + e);
        }
        return t;
    }

    public void initialize(String templateTag, int row, int col, String value) {
        this.initialize("<!-- " + templateTag + " " + row + "," + col + " -->" + value + "<!-- " + templateTag + " " + row + "," + col + " -->");
    }

    public synchronized void initialize(String templateContents) {
        int rowsLevel1 = TemplateConstants.getTagTypeLevel1().length;
        this.contents = this.contents + "\n\nTemplate initialize call #" + ++this.initializeNum + "\n" + templateContents;
        for (int i = 0; i < rowsLevel1; ++i) {
            this.factoryDataSets[i].initialize(templateContents);
        }
    }

    public String getContents() {
        return this.contents;
    }

    private int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int size) {
        this.bufferSize = size;
    }

    private void log(String logStr) {
        Utils.log(logStr);
    }

    public static void main(String[] args) throws Exception {
        Monitor mon = MonitorFactory.start();
        Utils.setDebug(true);
        Template template1 = new Template();
        Template template2 = new Template();
        String[] header = new String[]{" col1  ", " col2  ", " col3 "};
        String[][] body = new String[][]{{" (1,1) ", " (1,2) ", " (1,3) "}, {" (2,1) ", " (2,2) ", " (2,3) "}, {" (3,1) ", " (3,2) ", " (3,3) "}};
        String templateContents = "********* Table Header info<!-- HEADER_PREFIX -->\nheader_prefix\n<!-- HEADER_PREFIX --><!-- HEADER_SUFFIX -->header_suffix\n<!-- HEADER_SUFFIX --><!-- HEADER_ROW_PREFIX -->header_row_prefix\n<!-- HEADER_ROW_PREFIX --><!-- HEADER_ROW_SUFFIX -->header_row_suffix\n<!-- HEADER_ROW_SUFFIX --><!-- HEADER_CELL_PREFIX -->header_cell_prefix this=##this, headerThis=##headerThis<!-- HEADER_CELL_PREFIX --><!-- HEADER_CELL_SUFFIX -->header_cell_suffix\n<!-- HEADER_CELL_SUFFIX -->********* Table body info<!-- BODY_PREFIX -->body_prefix\n<!-- BODY_PREFIX --><!-- BODY_SUFFIX -->body_suffix\n<!-- BODY_SUFFIX --><!-- BODY_ROW_PREFIX -->body_row_prefix\n<!-- BODY_ROW_PREFIX --><!-- BODY_ROW_PREFIX 0,2 -->body_2ndrow_prefix\n <!-- BODY_ROW_PREFIX 0,2 --><!-- BODY_ROW_SUFFIX -->body_row_suffix\n<!-- BODY_ROW_SUFFIX --><!-- BODY_CELL_PREFIX -->body_cell_prefix<!-- BODY_CELL_PREFIX --><!-- BODY_CELL_DATA 0,1 -->body_cell_DATA 0,1<!-- BODY_CELL_DATA 0,1 --><!-- BODY_CELL_DATA 0,2 -->body_cell_DATA 0,2 ## should not match ##myVariableA ##myVariableB ##arr1 ##arr2 ##arrThis ##intArr1 ##intArrThis(##1 ##2 ##3 ##this rowNum=##rowNum colNum=##colNum headerThis=##headerThis header1=##header1 header2=##header2)##header2<!-- BODY_CELL_DATA 0,2 --><!-- BODY_CELL_DATA 0,3 -->body_cell_DATA 0,3<!-- BODY_CELL_DATA 0,3 --><!-- BODY_CELL_DATA 0,4 -->body_cell_DATA 0,4<!-- BODY_CELL_DATA 0,4 --><!-- BODY_CELL_DATA 0,5 -->body_cell_DATA 0,5<!-- BODY_CELL_DATA 0,5 --><!-- BODY_CELL_SUFFIX -->body_cell_suffix\n<!-- BODY_CELL_SUFFIX --><!-- BODY_CELL_PREFIX 0,2 -->body_cell_prefix 0,2<!-- BODY_CELL_PREFIX 0,2 --><!-- BODY_CELL_SUFFIX 0,2 -->body_cell_suffix 0,2\n<!-- BODY_CELL_SUFFIX 0,2 --><!-- BODY_CELL_PREFIX 2,3 -->body_cell_prefix 2,3<!-- BODY_CELL_PREFIX 2,3 --><!-- BODY_CELL_SUFFIX 2,3 -->body_cell_suffix 2,3\n<!-- BODY_CELL_SUFFIX 2,3 --><!-- BODY_CELL_PREFIX 2,0 -->body_cell_prefix 2,0<!-- BODY_CELL_PREFIX 2,0 --><!-- BODY_CELL_SUFFIX 2,0 -->body_cell_suffix 2,0\n<!-- BODY_CELL_SUFFIX 2,0 -->********* Table composite info<!-- COMPOSITE_PREFIX -->composite_prefix\n<!-- COMPOSITE_PREFIX --><!-- COMPOSITE_SUFFIX -->composite_suffix\n<!-- COMPOSITE_SUFFIX --><!-- COMPOSITE_ROW_PREFIX -->composite_row_prefix\n<!-- COMPOSITE_ROW_PREFIX --><!-- COMPOSITE_ROW_SUFFIX -->composite_row_suffix\n<!-- COMPOSITE_ROW_SUFFIX --><!-- COMPOSITE_CELL_PREFIX -->composite_cell_prefix<!-- COMPOSITE_CELL_PREFIX --><!-- COMPOSITE_CELL_SUFFIX -->composite_cell_suffix\n<!-- COMPOSITE_CELL_SUFFIX -->";
        template1.initialize(templateContents);
        template2.initialize("<!-- BODY_ROW_SUFFIX -->type==constant value==\n<!-- BODY_ROW_SUFFIX --><!-- HEADER_ROW_SUFFIX -->type==constant value==\n<!-- HEADER_ROW_SUFFIX -->");
        Monitor mon2 = MonitorFactory.start();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("myVariableA", "ValueMyVariableA");
        map.put("arr", new String[]{"miscData1", "miscData2"});
        map.put("intArr", new int[]{100, 200});
        System.out.println(template1.execute(header, body, map));
        System.out.println(template2.execute(header, body));
        System.out.println(template2.execute(header, body));
        System.out.println(template2.copy().execute(header, body));
        System.out.println("Total time for displaying of data: " + mon2.stop());
        System.out.println("Total Execution time (parsing, and displaying): " + mon.stop());
        System.out.println("****Template contents=" + template2.getContents());
    }
}

