/*
 * Decompiled with CFR 0.152.
 */
package com.fdsapi;

import [Lcom.fdsapi.DataSet;;
import [Ljava.lang.Object;;
import com.fdsapi.RuntimeExceptionBase;
import com.fdsapi.TabularData;
import com.fdsapi.TabularData1DimArray;
import com.fdsapi.TabularData2DimArray;
import com.fdsapi.TabularDataDataSet;
import com.fdsapi.TabularDataEmpty;
import com.fdsapi.TabularDataRSMD;
import com.fdsapi.TabularDataResultSet;
import com.fdsapi.Utils;
import com.jamonapi.utils.Misc;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class TabularDataFactory {
    private Collection factories = new ArrayList();
    private static TabularDataFactory tabularDataFactory = new TabularDataFactory();

    public static TabularDataFactory createInstance() {
        return tabularDataFactory;
    }

    private void log(String logStr) {
        Utils.logDebug(logStr);
    }

    protected TabularDataFactory() {
        this.log("**** TabularDataFactory Constructor - start populating TabuldarDataFactory");
        this.addTabularDataFactory(null, new TabularDataEmpty());
        this.addTabularDataFactory(ResultSet.class, new TabularDataResultSet());
        this.addTabularDataFactory(ResultSetMetaData.class, new TabularDataRSMD());
        this.addTabularDataFactory(DataSet;.class, new TabularDataDataSet());
        this.addTabularDataFactory([[Ljava.lang.Object;.class, new TabularData2DimArray());
        this.addTabularDataFactory(Object;.class, new TabularData1DimArray());
        this.log("**** TabularDataFactory Constructor - end populating TabuldarDataFactory");
    }

    public void addTabularDataFactory(Class factoryKey, TabularData factory) {
        this.log("Initializing TabularDataFactory=" + factoryKey);
        this.factories.add(new TabularDataFactoryEntry(factoryKey, factory));
    }

    public TabularData getTabularData(Object data) {
        if (data instanceof TabularData) {
            return (TabularData)data;
        }
        Class<?> dataClass = data == null ? null : data.getClass();
        String dataClassName = data == null ? null : data.getClass().getName();
        TabularData factory = null;
        Iterator iterator = this.factories.iterator();
        while (iterator.hasNext()) {
            TabularDataFactoryEntry factoryEntry = (TabularDataFactoryEntry)iterator.next();
            if (factoryEntry.className == null) {
                if (dataClassName != null) continue;
                factory = factoryEntry.factory;
                break;
            }
            if (!factoryEntry.className.equals(dataClassName) && !factoryEntry.factoryKey.isAssignableFrom(dataClass)) continue;
            factory = factoryEntry.factory;
            break;
        }
        if (factory == null) {
            String errorMsg = Misc.getClassName((Object)this) + " error.  The following data type does not have a TabularData factory: " + data.getClass().getName();
            throw new RuntimeExceptionBase(errorMsg);
        }
        return factory.createInstance(data);
    }

    private static class TabularDataFactoryEntry {
        public Class factoryKey;
        public TabularData factory;
        public String className;

        protected TabularDataFactoryEntry(Class factoryKey, TabularData factory) {
            this.factoryKey = factoryKey;
            this.factory = factory;
            this.className = factoryKey == null ? null : factoryKey.getName();
        }
    }
}

