/*
 * Decompiled with CFR 0.152.
 */
package com.fdsapi;

import com.fdsapi.AppConstants;
import com.fdsapi.FDSDataAsRow;
import com.fdsapi.FormattedDataSet;
import com.fdsapi.RuntimeExceptionBase;
import com.jamonapi.Monitor;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ResultSetUtils {
    static ResultSetUtils resultSetUtils = new ResultSetUtils();

    protected ResultSetUtils() {
    }

    public static ResultSetUtils createInstance() {
        return resultSetUtils;
    }

    private Monitor start(String locator) {
        return AppConstants.start("ResultSetUtils." + locator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resultSetToList(List list, ResultSet resultSet) throws SQLException {
        Monitor mon = this.start("resultSetToList()");
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int columnCount = resultSetMetaData.getColumnCount();
            while (resultSet.next()) {
                list.add(this.getRowData(resultSet, columnCount));
            }
        }
        finally {
            mon.stop();
        }
    }

    public void resultSetMetaDataToList(List list, ResultSet resultSet) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int columnCount = resultSetMetaData.getColumnCount();
        list.add(this.getColumnNames(resultSetMetaData));
    }

    public void resultSetToMap(Map map, ResultSet resultSet) throws SQLException {
        int columnCount = resultSet.getMetaData().getColumnCount();
        if (columnCount < 2) {
            throw new SQLException("resultSetToMap: At least two columns needed for conversion.");
        }
        while (resultSet.next()) {
            Object[] rowData = this.getRowData(resultSet, columnCount);
            map.put(rowData[0], rowData[1]);
        }
    }

    public void objectArrayToMap(Map map, Object[][] data) {
        int columnCount;
        int rowCount = data == null ? 0 : data.length;
        int n = columnCount = data == null || data.length == 0 ? 0 : data[0].length;
        if (columnCount < 2) {
            throw new RuntimeExceptionBase("objectArrayToMap: At least two columns are needed for the conversion.");
        }
        for (int i = 0; i < rowCount; ++i) {
            map.put(data[i][0], data[i][1]);
        }
    }

    public void objectArrayToList(List list, Object[][] data) {
        int rowCount = data == null ? 0 : data.length;
        for (int i = 0; i < rowCount; ++i) {
            list.add(data[i]);
        }
    }

    public Object[][] toArray(Collection collection) {
        return this.toArray(collection, true);
    }

    public Object[][] listToObjectArray(Collection collection) {
        return this.toArray(collection, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[][] toArray(Collection collection, boolean getDataAsRows) {
        Monitor mon = this.start("collectionToObjectArray()");
        try {
            if (collection == null || collection.isEmpty()) {
                Object[][] objectArray = null;
                return objectArray;
            }
            Object[][] resultArr = new Object[collection.size()][];
            int i = 0;
            Iterator iter = collection.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (obj instanceof Collection) {
                    resultArr[i++] = ((Collection)obj).toArray();
                    continue;
                }
                if (obj instanceof Object[]) {
                    collection.toArray((T[])resultArr);
                    break;
                }
                if (getDataAsRows && obj instanceof FDSDataAsRow) {
                    resultArr[i++] = ((FDSDataAsRow)obj).getDataAsRow();
                    continue;
                }
                resultArr[i++] = new Object[]{obj};
            }
            Object[][] objectArray = resultArr;
            return objectArray;
        }
        finally {
            mon.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[][] resultSetToObjectArray(ResultSet resultSet) throws SQLException {
        Monitor mon = this.start("resultSetToObjectArray()");
        try {
            Object[][] arr;
            ArrayList list = new ArrayList();
            this.resultSetToList(list, resultSet);
            Object[][] objectArray = arr = this.listToObjectArray(list);
            return objectArray;
        }
        finally {
            mon.stop();
        }
    }

    public String[] getColumnNames(ResultSetMetaData resultSetMetaData) throws SQLException {
        int columnCount = resultSetMetaData.getColumnCount();
        String[] columnNames = new String[columnCount];
        for (int colIndex = 1; colIndex <= columnCount; ++colIndex) {
            columnNames[colIndex - 1] = resultSetMetaData.getColumnName(colIndex);
        }
        return columnNames;
    }

    public String[] getColumnNames(ResultSetMetaData resultSetMetaData, int[] returnCols) throws SQLException {
        int columnCount = returnCols.length;
        String[] columnNames = new String[returnCols.length];
        for (int colIndex = 0; colIndex < columnCount; ++colIndex) {
            columnNames[colIndex] = resultSetMetaData.getColumnName(returnCols[colIndex]);
        }
        return columnNames;
    }

    private Object[] getRowData(ResultSet resultSet, int columnCount) throws SQLException {
        Object[] rowData = new Object[columnCount];
        for (int colIndex = 1; colIndex <= columnCount; ++colIndex) {
            rowData[colIndex - 1] = resultSet.getObject(colIndex);
        }
        return rowData;
    }

    public String[][] convert(Object[][] arr) {
        if (arr == null) {
            return null;
        }
        int rows = arr.length;
        int cols = arr[0].length;
        String[][] strArr = new String[rows][cols];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                strArr[i][j] = arr[i][j] == null ? null : arr[i][j].toString();
            }
        }
        return strArr;
    }

    public String[] convert(Object[] arr) {
        if (arr == null) {
            return null;
        }
        int rows = arr.length;
        String[] strArr = new String[rows];
        for (int i = 0; i < rows; ++i) {
            strArr[i] = arr[i] == null ? null : arr[i].toString();
        }
        return strArr;
    }

    public static void main(String[] args) {
        Object[][] data = new Object[][]{{"key1", "value1", "ignored"}, {"key2", "value2", "ignored"}};
        Object[] header = new Object[]{"fname", "lname"};
        String[] headerStrArr = resultSetUtils.convert(header);
        HashMap map = new HashMap();
        ArrayList<Integer> list = new ArrayList<Integer>();
        resultSetUtils.objectArrayToMap(map, data);
        System.out.println(map);
        FormattedDataSet fds = FormattedDataSet.createInstance();
        resultSetUtils.objectArrayToList(list, data);
        resultSetUtils.objectArrayToList(list, data);
        data = resultSetUtils.listToObjectArray(list);
        resultSetUtils.objectArrayToList(list, data);
        data = resultSetUtils.listToObjectArray(list);
        System.out.println("4 copies of the array i.e. 8 rows - \n" + fds.getFormattedDataSet(null, data, "csv"));
        ArrayList<String> row1 = new ArrayList<String>();
        row1.add("steve");
        row1.add("souza");
        ArrayList<String> row2 = new ArrayList<String>();
        row2.add("jeff");
        row2.add("beck");
        ArrayList<ArrayList<String>> allRows = new ArrayList<ArrayList<String>>();
        allRows.add(row1);
        allRows.add(row2);
        data = resultSetUtils.listToObjectArray(allRows);
        System.out.println("2 rows of people from List - \n" + fds.getFormattedDataSet(null, data, "csv"));
        map = new HashMap();
        map.put("row1", row1);
        map.put("row2", row2);
        data = resultSetUtils.listToObjectArray(map.values());
        System.out.println("2 rows of people from Map - \n" + fds.getFormattedDataSet(null, data, "csv"));
        list = new ArrayList();
        list.add(new Integer(100));
        list.add(new Integer(200));
        data = resultSetUtils.listToObjectArray(list);
        System.out.println("2 rows of integers - \n" + fds.getFormattedDataSet(null, data, "csv"));
    }
}

