/*
 * Decompiled with CFR 0.152.
 */
package com.fdsapi;

import com.fdsapi.AppConstants;
import com.fdsapi.FDSDataAsRow;
import com.fdsapi.FormattedDataSet;
import com.fdsapi.ResultSetUtils;
import com.fdsapi.Utils;
import com.fdsapi.arrays.ArrayHeaderLocator;
import com.fdsapi.arrays.ArraySQL;
import com.jamonapi.Monitor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class ResultSetConverter
implements Iterator {
    private String[] metaData;
    private ArrayHeaderLocator locator;
    private List resultSetAsList = new ArrayList();
    private ResultSetUtils rsu = ResultSetUtils.createInstance();
    private Iterator iter;
    private boolean hasNext = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSetConverter(ResultSet rs) throws SQLException {
        Monitor mon = AppConstants.start("ResultSetConverter(ResultSet)");
        try {
            this.setMetaData(this.rsu.getColumnNames(rs.getMetaData()));
            this.setResultSet(this.rsu.resultSetToObjectArray(rs));
        }
        finally {
            mon.stop();
        }
    }

    public ResultSetConverter(String[] metaData, Object[][] resultSet) {
        this.setMetaData(metaData);
        this.setResultSet(resultSet);
    }

    public ResultSetConverter(String[] metaData) {
        this.setMetaData(metaData);
    }

    public void setMetaData(String[] metaData) {
        this.metaData = metaData;
        this.locator = new ArrayHeaderLocator(metaData, true);
    }

    public String[] getMetaData() {
        return this.metaData;
    }

    public void setResultSet(Object[][] resultSet) {
        this.rsu.objectArrayToList(this.resultSetAsList, resultSet);
    }

    public Object[][] getResultSet() {
        return this.rsu.listToObjectArray(this.resultSetAsList);
    }

    public void addRow(Object[] row) {
        this.resultSetAsList.add(row);
    }

    public void add(ResultSetConverter rsc) {
        this.add(rsc.getResultSet());
    }

    public void add(Object[][] data) {
        this.rsu.objectArrayToList(this.resultSetAsList, data);
    }

    public boolean isEmpty() {
        return this.getRowCount() == 0;
    }

    public boolean hasData() {
        return !this.isEmpty();
    }

    public int getRowCount() {
        return this.resultSetAsList == null ? 0 : this.resultSetAsList.size();
    }

    public int getColumnCount() {
        return this.metaData == null ? 0 : this.metaData.length;
    }

    public Object getCellData(int row, int col) {
        return this.getRowArray(row)[col];
    }

    private Object[] getRowArray(int row) {
        return (Object[])this.resultSetAsList.get(row);
    }

    public Row getRow(int row) {
        return new Row(this.getRowArray(row));
    }

    public Object getCellData(int row, String colName) {
        return this.getRowArray(row)[this.locator.getColNum(colName)];
    }

    public ResultSetConverter copy() {
        String[] header = Utils.convert(this.metaData);
        Object[][] data = Utils.copy(this.getResultSet());
        return new ResultSetConverter(header, data);
    }

    public String toString() {
        return this.getRowCount() + " rows, " + this.getColumnCount() + " columns";
    }

    public boolean hasNext() {
        if (this.iter == null) {
            this.iter = this.resultSetAsList.iterator();
        }
        this.hasNext = this.iter.hasNext();
        if (!this.hasNext) {
            this.iter = null;
        }
        return this.hasNext;
    }

    public Object next() {
        if (this.hasNext) {
            return new Row((Object[])this.iter.next());
        }
        return null;
    }

    public Row getCurrentRow() {
        return (Row)this.next();
    }

    public void remove() {
        if (this.iter != null) {
            this.iter.remove();
        }
    }

    public ResultSetConverter execute(String arraySQLQuery) {
        ArraySQL asql = new ArraySQL(this.getMetaData(), arraySQLQuery);
        Object[][] data = asql.execute(this.getResultSet());
        return new ResultSetConverter(asql.getSelectColsList(), data);
    }

    public static ResultSetConverter getSQLExceptions(SQLException e) {
        ResultSetConverter rsc = new ResultSetConverter(new String[]{"SQLException"});
        while (e != null) {
            rsc.addRow(new Object[]{e});
            e = e.getNextException();
        }
        return rsc;
    }

    public static void main(String[] args) {
        String[] header = new String[]{"fname", "lname"};
        Object[][] data = new Object[][]{{"steve", "souza"}, {"jeff", "beck"}, {"mindy", "bobish"}};
        ResultSetConverter rsc = new ResultSetConverter(header, data);
        FormattedDataSet fds = FormattedDataSet.createInstance();
        System.out.println(fds.getFormattedDataSet(rsc, "xml"));
        while (rsc.hasNext()) {
            Row r = rsc.getCurrentRow();
            System.out.println("Row=" + r + ", lname=" + r.getCellData("lname"));
        }
        rsc = new ResultSetConverter(header);
        for (int i = 0; i < data.length; ++i) {
            rsc.addRow(data[i]);
        }
        System.out.println(fds.getFormattedDataSet(rsc, "xml"));
    }

    public class Row
    implements FDSDataAsRow {
        private Object[] rowData;

        public Row(Object[] rowData) {
            this.rowData = rowData;
        }

        public Object getCellData(String colName) {
            return this.rowData[ResultSetConverter.this.locator.getColNum(colName)];
        }

        public String getCellDataAsString(String colName) {
            Object obj = this.getCellData(colName);
            return obj == null ? null : obj.toString();
        }

        public Object getCellData(int index) {
            return this.rowData[index];
        }

        public String getCellDataAsString(int index) {
            Object obj = this.getCellData(index);
            return obj == null ? null : obj.toString();
        }

        public Object[] toArray() {
            return this.rowData;
        }

        public Object[] getDataAsRow() {
            return this.rowData;
        }

        public String toString() {
            StringBuffer buff = new StringBuffer();
            for (int i = 0; i < this.getNumRows(); ++i) {
                buff.append(this.rowData[i]).append(", ");
            }
            return buff.toString();
        }

        private int getNumRows() {
            return this.rowData == null ? 0 : this.rowData.length;
        }

        public boolean equals(Object compareKey) {
            if (compareKey instanceof Row) {
                Row row = (Row)compareKey;
                Object[] compareRow = row.getDataAsRow();
                return Arrays.equals(this.rowData, compareRow);
            }
            return false;
        }

        public int hashCode() {
            int hashCode = 0;
            for (int i = 0; i < this.getNumRows(); ++i) {
                hashCode += this.rowData[i].hashCode();
            }
            return hashCode;
        }
    }
}

