/*
 * Decompiled with CFR 0.152.
 */
package com.fdsapi;

import com.fdsapi.RuntimeExceptionBase;
import com.jamonapi.utils.Misc;
import java.util.ArrayList;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Util;

public class RegularExpression {
    private PatternCompiler compiler = new Perl5Compiler();
    private Pattern pattern;
    private PatternMatcher matcher = new Perl5Matcher();
    private PatternMatcherInput input;

    public RegularExpression(String regularExpressionStr) {
        try {
            this.pattern = this.compiler.compile(regularExpressionStr, 17);
        }
        catch (Exception e) {
            String err = Misc.getClassName((Object)this) + " contructor error: " + e;
            throw new RuntimeExceptionBase(err, e);
        }
    }

    public static RegularExpression createInstance(String regularExpressionStr) {
        return new RegularExpression(regularExpressionStr);
    }

    public String getParen(int parenNumber) {
        return this.matcher.getMatch().group(parenNumber);
    }

    public void setSourceString(String sourceString) {
        this.input = new PatternMatcherInput(sourceString);
    }

    public boolean next() {
        return this.matcher.contains(this.input, this.pattern);
    }

    public String[] split(String stringToSplit) {
        ArrayList results = new ArrayList();
        Util.split(results, (PatternMatcher)this.matcher, (Pattern)this.pattern, (String)stringToSplit);
        String[] string = new String[results.size()];
        results.toArray(string);
        return string;
    }

    public static void main(String[] args) throws Exception {
        String RE = "##(hello|world)";
        RegularExpression re = new RegularExpression("##(hello|world)");
        re.setSourceString("##hello ##miscData1 ##steve ##souza ##world ##this ##rownum ##headerthis ##3");
        while (re.next()) {
            System.out.println(re.getParen(0));
            System.out.println(re.getParen(1));
        }
    }
}

