/*
 * Decompiled with CFR 0.152.
 */
package com.fdsapi;

import com.fdsapi.AppConstants;
import com.fdsapi.ColBoundary;
import com.fdsapi.DataAccess;
import com.fdsapi.DataAccessJ2EE;
import com.fdsapi.ResultSetConverter;
import com.fdsapi.ResultSetUtils;
import com.fdsapi.TabularDataRSMD;
import com.fdsapi.TabularDataResultSet;
import com.fdsapi.Template;
import com.fdsapi.Templates;
import com.fdsapi.Utils;
import com.fdsapi.arrays.ArrayComparator;
import com.fdsapi.arrays.ArrayConverter;
import com.jamonapi.Monitor;
import com.jamonapi.MonitorFactory;
import java.io.Serializable;
import java.net.URLEncoder;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class FormattedDataSet
implements Serializable {
    private final Map NULLMAP = new HashMap();
    private ArrayConverter arrayConverter = null;
    private static FormattedDataSet formattedDataSet = new FormattedDataSet();
    private static Templates defaultTemplates = null;
    private Templates templates = defaultTemplates;
    private DataAccess dataAccessFactory = null;

    public static FormattedDataSet createInstance() {
        return formattedDataSet;
    }

    public void initialize(Object[][] templateFiles) {
        String[][] templates = ResultSetUtils.createInstance().convert(templateFiles);
        this.getTemplates().initialize(templates);
    }

    public Templates getTemplates() {
        if (defaultTemplates == null) {
            this.templates = defaultTemplates = new Templates();
            return this.templates;
        }
        return this.templates;
    }

    public Template getTemplate(String templateName) {
        return this.getTemplates().get(templateName);
    }

    public void putTemplate(String templateName, Template template) {
        this.getTemplates().put(templateName, template);
    }

    private void setTemplates(Templates templates) {
        this.templates = templates;
    }

    public void setDataAccessFactory(DataAccess dataAccessFactory) {
        this.dataAccessFactory = dataAccessFactory;
    }

    private DataAccess getDataAccessFactory() throws SQLException {
        if (this.dataAccessFactory == null) {
            this.dataAccessFactory = new DataAccessJ2EE();
            return this.dataAccessFactory;
        }
        return this.dataAccessFactory;
    }

    public DataAccess getDataAccess() throws SQLException {
        return this.getDataAccessFactory().createInstance();
    }

    public String getFormattedDataSet(String query, String templateName) throws SQLException {
        return this.getFormattedDataSet(AppConstants.DATASOURCE, query, templateName);
    }

    public String getFormattedDataSet(String query, Template template) throws SQLException {
        return this.getFormattedDataSet(AppConstants.DATASOURCE, query, this.NULLMAP, template);
    }

    public String getFormattedDataSet(String query, Map miscData, String templateName) throws SQLException {
        return this.getFormattedDataSet(AppConstants.DATASOURCE, query, miscData, templateName);
    }

    public String getFormattedDataSet(String dataSource, String query, String templateName) throws SQLException {
        return this.getFormattedDataSet(dataSource, query, this.NULLMAP, templateName);
    }

    public String getFormattedDataSet(String dataSource, String query, Map miscData, String templateName) throws SQLException {
        return this.getFormattedDataSet(dataSource, query, miscData, this.getTemplate(templateName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFormattedDataSet(String dataSource, String query, Map miscData, Template template) throws SQLException {
        Monitor mon = this.start("getFormattedDataSet(sql)");
        DataAccess dataAccess = null;
        try {
            dataAccess = this.getDataAccessFactory().createInstance();
            dataAccess.setDataSourceName(dataSource);
            ResultSet rs = dataAccess.getResultSet(query);
            String string = this.getFormattedDataSet((Object)new TabularDataRSMD(rs.getMetaData()), (Object)new TabularDataResultSet(rs), miscData, template);
            return string;
        }
        finally {
            try {
                if (dataAccess != null) {
                    dataAccess.close();
                }
            }
            finally {
                mon.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSetConverter getResultSetConverter(String dataSource, String query) throws SQLException {
        Monitor mon = this.start("getResultSetConverter(dataSource, query)");
        try {
            DataAccess dataAccess = this.getDataAccessFactory().createInstance();
            dataAccess.setDataSourceName(dataSource);
            ResultSetConverter resultSetConverter = dataAccess.getResultSetConverter(query);
            return resultSetConverter;
        }
        finally {
            mon.stop();
        }
    }

    public ResultSetConverter getResultSetConverter(String query) throws SQLException {
        return this.getResultSetConverter(AppConstants.DATASOURCE, query);
    }

    public ArrayConverter getArrayConverter() {
        return this.arrayConverter;
    }

    public void setArrayConverter(ArrayConverter arrayConverter) {
        this.arrayConverter = arrayConverter;
    }

    public String getFormattedDataSet(Object header, Object body, String templateName) {
        return this.getFormattedDataSet(header, body, this.NULLMAP, templateName);
    }

    public String getFormattedDataSet(Object header, Object body, Map miscData, String templateName) {
        return this.getFormattedDataSet(header, body, miscData, this.getTemplate(templateName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFormattedDataSet(Object header, Object body, Map miscData, Template template) {
        Monitor mon = this.start("getFormattedDataSet(all)");
        try {
            if (header == null && body == null) {
                String string = null;
                return string;
            }
            String string = template.execute(header, body, miscData).toString();
            return string;
        }
        finally {
            mon.stop();
        }
    }

    public String getFormattedDataSet(ResultSetConverter rsConverter, String templateName) {
        if (rsConverter == null) {
            return null;
        }
        return this.getFormattedDataSet(rsConverter.getMetaData(), rsConverter.getResultSet(), templateName);
    }

    public String getFormattedDataSet(ResultSetConverter rsConverter, Map miscData, String templateName) {
        if (rsConverter == null) {
            return null;
        }
        return this.getFormattedDataSet(rsConverter, miscData, this.getTemplate(templateName));
    }

    public String getFormattedDataSet(ResultSetConverter rsConverter, Map miscData, Template template) {
        if (rsConverter == null) {
            return null;
        }
        return this.getFormattedDataSet((Object)rsConverter.getMetaData(), (Object)rsConverter.getResultSet(), miscData, template);
    }

    public String getSortedText(Object[] header, Object[][] body, Map miscData, int sortCol, String sortOrder, Template template) {
        int cols = header.length;
        int sortColIndex = sortCol - 1;
        String[] sortOrderArr = new String[cols];
        String[] sortOrderGifArr = new String[cols];
        for (int i = 0; i < cols; ++i) {
            sortOrderArr[i] = "desc";
            sortOrderGifArr[i] = "";
        }
        Object imagesDirEntry = miscData.get("imagesDir");
        String imagesDir = "";
        if (imagesDirEntry != null) {
            imagesDir = imagesDirEntry.toString();
        }
        sortOrderArr[sortColIndex] = this.toggleSortOrder(sortOrder);
        sortOrderGifArr[sortColIndex] = "<img src='" + imagesDir + sortOrder + ".gif'>";
        if (miscData.get("query") == null) {
            miscData.put("query", "");
        }
        miscData.put("sortOrder", sortOrderArr);
        miscData.put("sortOrderGif", sortOrderGifArr);
        ArrayComparator.sort(body, sortColIndex, sortOrder);
        if (this.getArrayConverter() != null) {
            body = this.getArrayConverter().convert(body);
        }
        return this.getFormattedDataSet((Object)header, (Object)body, miscData, template);
    }

    public String getSortedText(Object[] header, Object[][] body, Map miscData, int sortCol, String sortOrder, String templateName) {
        return this.getSortedText(header, body, miscData, sortCol, sortOrder, this.getTemplate(templateName));
    }

    public String getSortedText(ResultSetConverter rsConverter, Map miscData, int sortCol, String sortOrder, String templateName) {
        return this.getSortedText((Object[])rsConverter.getMetaData(), rsConverter.getResultSet(), miscData, sortCol, sortOrder, templateName);
    }

    public String getSortedText(String query, Map miscData, int sortCol, String sortOrder, String templateName) throws SQLException {
        return this.getSortedText(AppConstants.DATASOURCE, query, miscData, sortCol, sortOrder, templateName);
    }

    public String getSortedText(String dataSource, String query, Map miscData, int sortCol, String sortOrder, String templateName) throws SQLException {
        miscData.put("query", "&query=" + URLEncoder.encode(query));
        return this.getSortedText(this.getResultSetConverter(dataSource, query), miscData, sortCol, sortOrder, templateName);
    }

    private String toggleSortOrder(String sortOrder) {
        return sortOrder == null || "asc".equalsIgnoreCase(sortOrder) ? "desc" : "asc";
    }

    public String getDropDownListBox(String dataSource, String query, String selectedItem) throws SQLException {
        return this.getDropDownListBox(dataSource, query, this.NULLMAP, selectedItem);
    }

    public String getDropDownListBox(String dataSource, String query, Map miscData, String selectedItem) throws SQLException {
        String listBox = this.getFormattedDataSet(dataSource, query, miscData, "DROPDOWNLISTBOX");
        listBox = this.sizeList(listBox, 1);
        return this.formatList(listBox, selectedItem);
    }

    public String getDropDownListBox(String query, String selectedItem) throws SQLException {
        return this.getDropDownListBox(AppConstants.DATASOURCE, query, selectedItem);
    }

    public String getDropDownListBox(String query, Map miscData, String selectedItem) throws SQLException {
        return this.getDropDownListBox(AppConstants.DATASOURCE, query, miscData, selectedItem);
    }

    public String getDropDownListBox(Object header, Object body, String selectedItem) {
        return this.getDropDownListBox(header, body, this.NULLMAP, selectedItem);
    }

    public String getDropDownListBox(Object header, Object body, Map miscData, String selectedItem) {
        String listBox = this.getFormattedDataSet(header, body, miscData, "DROPDOWNLISTBOX");
        listBox = this.sizeList(listBox, 1);
        return this.formatList(listBox, selectedItem);
    }

    public String getDropDownListBox(ResultSetConverter rsc, String selectedItem) {
        return this.getDropDownListBox(rsc.getMetaData(), rsc.getResultSet(), selectedItem);
    }

    public String getDropDownListBox(ResultSetConverter rsc, Map miscData, String selectedItem) {
        return this.getDropDownListBox(rsc.getMetaData(), rsc.getResultSet(), miscData, selectedItem);
    }

    public String getListBox(String dataSource, String query, String selectedItem, int size) throws SQLException {
        return this.getListBox(dataSource, query, this.NULLMAP, selectedItem, size);
    }

    public String getListBox(String dataSource, String query, Map miscData, String selectedItem, int size) throws SQLException {
        String listBox = this.getFormattedDataSet(dataSource, query, miscData, "LISTBOX");
        listBox = this.sizeList(listBox, size);
        return this.formatList(listBox, selectedItem);
    }

    public String getListBox(String query, String selectedItem, int size) throws SQLException {
        return this.getListBox(AppConstants.DATASOURCE, query, selectedItem, size);
    }

    public String getListBox(String query, Map miscData, String selectedItem, int size) throws SQLException {
        return this.getListBox(AppConstants.DATASOURCE, query, miscData, selectedItem, size);
    }

    public String getListBox(Object header, Object body, String selectedItem, int size) {
        return this.getListBox(header, body, this.NULLMAP, selectedItem, size);
    }

    public String getListBox(Object header, Object body, Map miscData, String selectedItem, int size) {
        String listBox = this.getFormattedDataSet(header, body, miscData, "LISTBOX");
        listBox = this.sizeList(listBox, size);
        return this.formatList(listBox, selectedItem);
    }

    public String getListBox(ResultSetConverter rsc, String selectedItem, int size) {
        return this.getListBox(rsc.getMetaData(), rsc.getResultSet(), selectedItem, size);
    }

    public String getListBox(ResultSetConverter rsc, Map miscData, String selectedItem, int size) {
        return this.getListBox(rsc.getMetaData(), rsc.getResultSet(), miscData, selectedItem, size);
    }

    public String getMultiSelectListBox(String dataSource, String query, String[] selectedItems, int size) throws SQLException {
        return this.getMultiSelectListBox(dataSource, query, this.NULLMAP, selectedItems, size);
    }

    public String getMultiSelectListBox(String dataSource, String query, Map miscData, String[] selectedItems, int size) throws SQLException {
        String listBox = this.getFormattedDataSet(dataSource, query, miscData, "MULTISELECTLISTBOX");
        listBox = this.sizeList(listBox, size);
        listBox = this.highLightMultiSelect(listBox, selectedItems);
        return listBox;
    }

    public String getMultiSelectListBox(String query, String[] selectedItems, int size) throws SQLException {
        return this.getMultiSelectListBox(AppConstants.DATASOURCE, query, selectedItems, size);
    }

    public String getMultiSelectListBox(String query, Map miscData, String[] selectedItems, int size) throws SQLException {
        return this.getMultiSelectListBox(AppConstants.DATASOURCE, query, miscData, selectedItems, size);
    }

    public String getMultiSelectListBox(Object header, Object body, String[] selectedItems, int size) {
        return this.getMultiSelectListBox(header, body, this.NULLMAP, selectedItems, size);
    }

    public String getMultiSelectListBox(Object header, Object body, Map miscData, String[] selectedItems, int size) {
        String listBox = this.getFormattedDataSet(header, body, miscData, "MULTISELECTLISTBOX");
        listBox = this.sizeList(listBox, size);
        listBox = this.highLightMultiSelect(listBox, selectedItems);
        return listBox;
    }

    public String getMultiSelectListBox(ResultSetConverter rsc, String[] selectedItems, int size) {
        return this.getMultiSelectListBox(rsc.getMetaData(), rsc.getResultSet(), selectedItems, size);
    }

    public String getMultiSelectListBox(ResultSetConverter rsc, Map miscData, String[] selectedItems, int size) {
        return this.getMultiSelectListBox(rsc.getMetaData(), rsc.getResultSet(), miscData, selectedItems, size);
    }

    protected String highLightMultiSelect(String listBox, String[] selectedItems) {
        if (selectedItems != null) {
            for (int i = 0; i < selectedItems.length; ++i) {
                listBox = this.formatList(listBox, selectedItems[i]);
            }
        }
        return listBox;
    }

    public String getRadioButton(String dataSource, String query, String selectedItem) throws SQLException {
        return this.getRadioButton(dataSource, query, this.NULLMAP, selectedItem);
    }

    public String getRadioButton(String dataSource, String query, Map miscData, String selectedItem) throws SQLException {
        String radioButton = this.getFormattedDataSet(dataSource, query, miscData, "RADIOBUTTON");
        return this.formatRadioButton(radioButton, selectedItem);
    }

    public String getRadioButton(String query, String selectedItem) throws SQLException {
        return this.getRadioButton(AppConstants.DATASOURCE, query, selectedItem);
    }

    public String getRadioButton(Object header, Object body, String selectedItem) {
        return this.getRadioButton(header, body, this.NULLMAP, selectedItem);
    }

    public String getRadioButton(Object header, Object body, Map miscData, String selectedItem) {
        String radioButton = this.getFormattedDataSet(header, body, miscData, "RADIOBUTTON");
        return this.formatRadioButton(radioButton, selectedItem);
    }

    public String getRadioButton(ResultSetConverter rsc, String selectedItem) {
        return this.getRadioButton(rsc.getMetaData(), rsc.getResultSet(), this.NULLMAP, selectedItem);
    }

    public String getRadioButton(ResultSetConverter rsc, Map miscData, String selectedItem) {
        return this.getRadioButton(rsc.getMetaData(), rsc.getResultSet(), miscData, selectedItem);
    }

    private boolean isEmpty(String string) {
        return string == null || "".equals(string.trim());
    }

    private Monitor start(String locator) {
        return AppConstants.start("FormattedDataSet." + locator);
    }

    private void log(String logStr) {
        Utils.logDebug(logStr);
    }

    public void setDebug(boolean debug) {
        Utils.setDebug(debug);
    }

    public boolean getDebug() {
        return Utils.getDebug();
    }

    protected String sizeList(String listBox, int size) {
        return AppConstants.replaceString(listBox, "1", String.valueOf(size));
    }

    protected String formatList(String listBox, String selectedItem) {
        if (this.isEmpty(selectedItem)) {
            return listBox;
        }
        selectedItem = "'" + selectedItem + "'";
        listBox = AppConstants.replaceString(listBox, selectedItem, selectedItem + " selected");
        return listBox;
    }

    protected String formatRadioButton(String radioButton, String selectedItem) {
        if (this.isEmpty(selectedItem)) {
            return radioButton;
        }
        radioButton = AppConstants.replaceString(radioButton, selectedItem + " ", selectedItem + " checked ");
        return radioButton;
    }

    public static void main(String[] args) throws Exception {
        String[] header = new String[]{"FirstName", "LastName"};
        Object[][] body = new String[][]{{"SouzaValue", "1SouzaDisplay"}, {"BeckValue", "2BeckDisplay"}, {"ReidValue", "3ReidDisplay"}, {"OsterbergValue", "4OsterbergDisplay"}};
        String[] selectedItems = new String[]{"SouzaValue", "ReidValue"};
        Monitor mon1 = MonitorFactory.start();
        FormattedDataSet fds = new FormattedDataSet();
        fds.setDebug(true);
        ColBoundary.setDebug(true);
        Utils.log("\n\n" + fds.getListBox(header, body, "BeckValue", 2));
        Monitor mon2 = MonitorFactory.start();
        Utils.log("\n\n" + fds.getDropDownListBox(header, body, "SouzaValue"));
        Utils.log("\n\n" + fds.getMultiSelectListBox(header, body, selectedItems, 10));
        Utils.log("\n\n" + fds.getRadioButton(header, body, "BeckValue"));
        Utils.log("\n\n<names>\n" + fds.getFormattedDataSet(header, body, "xml") + "</names>");
        HashMap<String, String> miscData = new HashMap<String, String>();
        miscData.put("rootElement", "mynames");
        miscData.put("sortPageName", "MySortPage.jsp");
        Utils.log("\n\n" + fds.getFormattedDataSet((Object)header, (Object)body, miscData, "xml1"));
        Utils.log("\n\n" + fds.getFormattedDataSet((Object)header, (Object)body, miscData, fds.getTemplate("xml1")));
        Utils.log("\n\ncol 1 desc\n" + fds.getSortedText(new ResultSetConverter(header, body), miscData, 1, "desc", "sortedHTMLTable"));
        Utils.log("\n\nnull data - display header\n" + fds.getFormattedDataSet(header, null, "basicHtmlTable"));
        Utils.log("\n\nnull header - display data\n" + fds.getFormattedDataSet(null, body, "basicHtmlTable"));
        Utils.log("\n\nnull header and data - return null\n" + fds.getFormattedDataSet((Object)null, null, "basicHtmlTable"));
        miscData.put("query", "&query=select * from tablename");
        miscData.put("imagesDir", "images/");
        Utils.log("\n\ncol 2 asc\n" + fds.getSortedText(new ResultSetConverter(header, body), miscData, 2, "asc", "sortedHTMLTable"));
        Utils.log("\nTime executing 7 calls to getFormattedDataSet() (excludes initialization): " + mon2.stop());
        Utils.log("\nTime executing all 8 calls to getFormattedDataSet() (mostly initialization time): " + mon1.stop());
    }
}

