/*
 * Decompiled with CFR 0.152.
 */
package com.fdsapi;

import com.fdsapi.Coordinate;
import com.fdsapi.DataSet;
import com.fdsapi.DataSetFactory;
import com.fdsapi.DataSetFactoryParm;
import com.fdsapi.DataSetParm;
import com.fdsapi.RuntimeExceptionBase;
import com.fdsapi.TemplateTagReader;
import com.fdsapi.TemplateVariables;
import com.fdsapi.Utils;
import com.jamonapi.utils.AppMap;
import com.jamonapi.utils.Command;
import com.jamonapi.utils.CommandIterator;
import com.jamonapi.utils.Misc;
import java.util.Map;

public class DataSetMap
implements Cloneable {
    private Map map = AppMap.createInstance();
    private Coordinate key = new Coordinate(0, 0);
    private DataSetFactoryParm parm;
    private int maxX;
    private int maxY;

    protected DataSetMap(int maxX, int maxY) {
        this.maxX = maxX;
        this.maxY = maxY;
    }

    private DataSetMap(DataSetFactoryParm parm) {
        this.parm = parm;
        this.setDataSet(0, 0, DataSetFactory.createInstance().getDataSetFactoryMaster("EMPTY"));
    }

    static DataSetMap createFactoryInstance(DataSetFactoryParm p) {
        DataSetMap dataSetMap = new DataSetMap(p);
        dataSetMap.initialize(p.getTemplateContents());
        return dataSetMap;
    }

    public Object clone() throws CloneNotSupportedException {
        DataSetMap dsMap = (DataSetMap)super.clone();
        dsMap.key = new Coordinate(0, 0);
        dsMap.map = (Map)((AppMap)this.map).clone();
        dsMap.map = this.deepCopyMap(dsMap.map);
        dsMap.parm = (DataSetFactoryParm)this.parm.clone();
        return dsMap;
    }

    private static void iterate(Map m, Command c) {
        try {
            CommandIterator.iterate((Map)m, (Command)c);
        }
        catch (Exception e) {
            throw new RuntimeExceptionBase("error executing Map Command object", e);
        }
    }

    private Map deepCopyMap(Map dataSets) {
        class CloneMapCommand
        implements Command {
            private final /* synthetic */ Map val$dataSets;

            CloneMapCommand(Map map) {
                this.val$dataSets = map;
            }

            public void execute(Object object) throws Exception {
                Map.Entry mapEntry = (Map.Entry)object;
                DataSet ds = (DataSet)mapEntry.getValue();
                this.val$dataSets.put(mapEntry.getKey(), ds.clone());
            }
        }
        CloneMapCommand command = new CloneMapCommand(dataSets);
        DataSetMap.iterate(dataSets, command);
        return dataSets;
    }

    public void setDataSetParm(DataSetParm dsp) {
        class DataSetParmCommand
        implements Command {
            private final /* synthetic */ DataSetParm val$dsp;

            DataSetParmCommand(DataSetParm dataSetParm) {
                this.val$dsp = dataSetParm;
            }

            public void execute(Object object) throws Exception {
                Map.Entry mapEntry = (Map.Entry)object;
                DataSet ds = (DataSet)mapEntry.getValue();
                ds.setDataSetParm(this.val$dsp);
            }
        }
        DataSetParmCommand command = new DataSetParmCommand(dsp);
        DataSetMap.iterate(this.map, command);
    }

    public void setDataSet(int x, int y, DataSet dataSet) {
        this.setMaxX(x);
        this.setMaxY(y);
        this.map.put(new Coordinate(x, y), dataSet);
    }

    public void setMaxX(int x) {
        if (this.maxX < x) {
            this.maxX = x;
        }
    }

    public void setMaxY(int y) {
        if (this.maxY < y) {
            this.maxY = y;
        }
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public DataSet getDataSet(int x, int y) {
        if (this.map.containsKey(this.key.setValues(x, y))) {
            return (DataSet)this.map.get(this.key);
        }
        if (this.map.containsKey(this.key.setValues(x, 0))) {
            return (DataSet)this.map.get(this.key);
        }
        if (this.map.containsKey(this.key.setValues(0, y))) {
            return (DataSet)this.map.get(this.key);
        }
        return (DataSet)this.map.get(this.key.setValues(0, 0));
    }

    void initialize(String templateContents) {
        this.parm.setTemplateContents(templateContents);
        new DataSetMapParser().parse();
        this.parm.setTemplateContents(null);
    }

    private void log(String logStr) {
        Utils.logDebug(logStr);
    }

    private class DataSetMapParser {
        private DataSetMapParser() {
        }

        private void parse() {
            this.populateDefaultFactoryDataSets();
            this.populateFactoryDataSets();
        }

        private void populateDefaultFactoryDataSets() {
            DataSetMap.this.getDataSet(0, 0).initialize(DataSetMap.this.parm.getTemplateContents());
        }

        private void populateFactoryDataSets() {
            TemplateTagReader templateTagReader = TemplateTagReader.createInstance(DataSetMap.this.parm.getTemplateTagType());
            templateTagReader.setSourceString(DataSetMap.this.parm.getTemplateContents());
            while (templateTagReader.next()) {
                DataSet ds = this.createFactoryDataSet(templateTagReader.getTemplateTagValue());
                DataSetMap.this.setDataSet(templateTagReader.getX(), templateTagReader.getY(), ds);
                DataSetMap.this.log("Initialize template specified DataSet: Template Info=" + DataSetMap.this.parm.getTemplateTagType() + "    DataSet=" + Misc.getClassName((Object)ds) + "     x=" + templateTagReader.getX() + "     y=" + templateTagReader.getY() + "    value=(" + templateTagReader.getTemplateTagValue() + ")");
            }
        }

        private DataSet createFactoryDataSet(String templateTagValue) {
            TemplateVariables variables = TemplateVariables.createInstance();
            variables.populateVariables(templateTagValue);
            String type = variables.getType();
            DataSetMap.this.parm.setVariables(variables);
            DataSet dataSet = DataSetFactory.createInstance().getDataSetFactoryMaster(type).createFactoryInstance(DataSetMap.this.parm);
            return dataSet;
        }
    }
}

