/*
 * Decompiled with CFR 0.152.
 */
package com.fdsapi;

import com.fdsapi.DataSet;
import com.fdsapi.DataSetCell;
import com.fdsapi.DataSetCellAlternating;
import com.fdsapi.DataSetCellConstant;
import com.fdsapi.DataSetCellDropDownListBox;
import com.fdsapi.DataSetCellEmpty;
import com.fdsapi.DataSetCellFormattedDataSet;
import com.fdsapi.DataSetCellListBox;
import com.fdsapi.DataSetCellNoAppend;
import com.fdsapi.DataSetCellRadioButton;
import com.fdsapi.DataSetCol;
import com.fdsapi.DataSetConditional;
import com.fdsapi.DataSetDecorator;
import com.fdsapi.DataSetFactoryParm;
import com.fdsapi.DataSetNext;
import com.fdsapi.DataSetRow;
import com.fdsapi.RuntimeExceptionBase;
import com.fdsapi.TemplateConstants;
import com.fdsapi.Utils;
import com.jamonapi.utils.AppMap;
import com.jamonapi.utils.Misc;
import java.util.Map;

public class DataSetFactory {
    private static DataSetFactory dataSetFactory = new DataSetFactory();
    private Map dataSetFactoryMasterList = AppMap.createInstance();
    private boolean createDefaultTemplate = true;
    private DataSet[] defaultDataSets;
    private String defaultTemplate = "<!-- HEADER_PREFIX -->type==empty<!-- HEADER_PREFIX --><!-- HEADER_DATA -->type==next<!-- HEADER_DATA --><!-- HEADER_SUFFIX -->type==empty<!-- HEADER_SUFFIX --><!-- HEADER_ROW_PREFIX -->type==empty<!-- HEADER_ROW_PREFIX --><!-- HEADER_ROW_DATA -->type==next<!-- HEADER_ROW_DATA --><!-- HEADER_ROW_SUFFIX -->type==empty<!-- HEADER_ROW_SUFFIX --><!-- HEADER_CELL_PREFIX -->type==empty<!-- HEADER_CELL_PREFIX --><!-- HEADER_CELL_DATA -->type==data<!-- HEADER_CELL_DATA --><!-- HEADER_CELL_SUFFIX -->type==empty<!-- HEADER_CELL_SUFFIX --><!-- BODY_PREFIX -->type==empty<!-- BODY_PREFIX --><!-- BODY_DATA -->type==next<!-- BODY_DATA --><!-- BODY_SUFFIX -->type==empty<!-- BODY_SUFFIX --><!-- BODY_ROW_PREFIX -->type==empty<!-- BODY_ROW_PREFIX --><!-- BODY_ROW_DATA -->type==next<!-- BODY_ROW_DATA --><!-- BODY_ROW_SUFFIX -->type==empty<!-- BODY_ROW_SUFFIX --><!-- BODY_CELL_PREFIX -->type==empty<!-- BODY_CELL_PREFIX --><!-- BODY_CELL_DATA -->type==data<!-- BODY_CELL_DATA --><!-- BODY_CELL_SUFFIX -->type==empty<!-- BODY_CELL_SUFFIX --><!-- COMPOSITE_PREFIX -->type==empty<!-- COMPOSITE_PREFIX --><!-- COMPOSITE_DATA -->type==next<!-- COMPOSITE_DATA --><!-- COMPOSITE_SUFFIX -->type==empty<!-- COMPOSITE_SUFFIX --><!-- COMPOSITE_ROW_PREFIX -->type==empty<!-- COMPOSITE_ROW_PREFIX --><!-- COMPOSITE_ROW_DATA -->type==next<!-- COMPOSITE_ROW_DATA --><!-- COMPOSITE_ROW_SUFFIX -->type==empty<!-- COMPOSITE_ROW_SUFFIX --><!-- COMPOSITE_CELL_PREFIX -->type==empty<!-- COMPOSITE_CELL_PREFIX --><!-- COMPOSITE_CELL_DATA -->type==noappend<!-- COMPOSITE_CELL_DATA --><!-- COMPOSITE_CELL_SUFFIX -->type==empty<!-- COMPOSITE_CELL_SUFFIX -->";

    public static DataSetFactory createInstance() {
        return dataSetFactory;
    }

    private void log(String logStr) {
        Utils.logDebug(logStr);
    }

    protected DataSetFactory() {
        this.log("\n*DataSetFactory Contructor - start populating DataSetFactory");
        DataSetCellEmpty dataSetCellEmpty = new DataSetCellEmpty();
        DataSetCellNoAppend dataSetCellNoAppend = new DataSetCellNoAppend();
        DataSetCellConstant dataSetCellConstant = new DataSetCellConstant();
        DataSetCell dataSetCell = new DataSetCell();
        DataSetRow dataSetRow = new DataSetRow();
        DataSetCol dataSetCol = new DataSetCol();
        DataSetDecorator dataSetDecorator = new DataSetDecorator();
        DataSetNext dataSetNext = new DataSetNext();
        DataSetCellFormattedDataSet dataSetCellFormattedDataSet = new DataSetCellFormattedDataSet();
        DataSetCellListBox dataSetCellListBox = new DataSetCellListBox();
        DataSetCellDropDownListBox dataSetCellDropDownListBox = new DataSetCellDropDownListBox();
        DataSetCellRadioButton dataSetCellRadioButton = new DataSetCellRadioButton();
        DataSetConditional dataSetConditional = new DataSetConditional();
        DataSetCellAlternating dataSetCellAlternating = new DataSetCellAlternating();
        this.setDataSetFactoryMaster("EMPTY", dataSetCellEmpty);
        this.setDataSetFactoryMaster("NOAPPEND", dataSetCellNoAppend);
        this.setDataSetFactoryMaster("CONSTANT", dataSetCellConstant);
        this.setDataSetFactoryMaster("DATA", dataSetCell);
        this.setDataSetFactoryMaster("ROW", dataSetRow);
        this.setDataSetFactoryMaster("COL", dataSetCol);
        this.setDataSetFactoryMaster("DECORATOR", dataSetDecorator);
        this.setDataSetFactoryMaster("NEXT", dataSetNext);
        this.setDataSetFactoryMaster("QUERY", dataSetCellFormattedDataSet);
        this.setDataSetFactoryMaster("LISTBOX", dataSetCellListBox);
        this.setDataSetFactoryMaster("DROPDOWNLISTBOX", dataSetCellDropDownListBox);
        this.setDataSetFactoryMaster("RADIOBUTTON", dataSetCellRadioButton);
        this.setDataSetFactoryMaster("CONDITIONAL", dataSetConditional);
        this.setDataSetFactoryMaster("ALTERNATING", dataSetCellAlternating);
        this.setDataSetFactoryMaster("HEADER_CONTAINER", dataSetDecorator);
        this.setDataSetFactoryMaster("HEADER_ROW_CONTAINER", dataSetRow);
        this.setDataSetFactoryMaster("HEADER_CELL_CONTAINER", dataSetCol);
        this.setDataSetFactoryMaster("BODY_CONTAINER", dataSetDecorator);
        this.setDataSetFactoryMaster("BODY_ROW_CONTAINER", dataSetRow);
        this.setDataSetFactoryMaster("BODY_CELL_CONTAINER", dataSetCol);
        this.setDataSetFactoryMaster("COMPOSITE_CONTAINER", dataSetDecorator);
        this.setDataSetFactoryMaster("COMPOSITE_ROW_CONTAINER", dataSetRow);
        this.setDataSetFactoryMaster("COMPOSITE_CELL_CONTAINER", dataSetCol);
        this.log("\n*DataSetFactory Contructor - end populating DataSetFactory");
    }

    DataSet getDataSetFactoryMaster(String name) {
        try {
            return (DataSet)AppMap.get((Map)this.dataSetFactoryMasterList, (Object)name);
        }
        catch (Exception e) {
            String err = Misc.getClassName((Object)this) + ".getDataSetFactoryMaster() error: " + e;
            throw new RuntimeExceptionBase(err);
        }
    }

    public void setDataSetFactoryMaster(String type, DataSet dataSet) {
        this.log("Initializing DataSet Factory Master, name=" + type + ", class=" + Misc.getClassName((Object)dataSet));
        this.dataSetFactoryMasterList.put(type, dataSet);
    }

    public void setDefaultTemplate(String defaultTemplate) {
        this.defaultTemplate = defaultTemplate;
    }

    DataSet[] getDefaultDataSets() {
        if (this.createDefaultTemplate) {
            this.log("\n\n** Start Building Default DataSets - DataSetFactory.getDefaultDataSets()");
            this.defaultDataSets = new DataSetFactoryBuilder(this.defaultTemplate).getLevel1DataSets();
            this.createDefaultTemplate = false;
            this.log("** End Building Default DataSets - DataSetFactory.getDefaultDataSets()\n\n");
        }
        return this.cloneDataSets(this.defaultDataSets);
    }

    DataSet[] cloneDataSets(DataSet[] dsFrom) {
        try {
            DataSet[] dsTo = new DataSet[dsFrom.length];
            for (int i = 0; i < this.defaultDataSets.length; ++i) {
                dsTo[i] = (DataSet)dsFrom[i].clone();
            }
            return dsTo;
        }
        catch (Exception e) {
            String err = Misc.getClassName((Object)this) + ".cloneDataSets() error: " + e;
            throw new RuntimeExceptionBase(err, e);
        }
    }

    private class DataSetFactoryBuilder {
        private String templateContents;

        private DataSetFactoryBuilder(String templateContents) {
            this.templateContents = templateContents;
        }

        private DataSet[] getLevel1DataSets() {
            String[] templateTagTypeLevel1 = TemplateConstants.getTagTypeLevel1();
            int rowsLevel1 = templateTagTypeLevel1.length;
            DataSet[] dataSets = new DataSet[rowsLevel1];
            for (int i = 0; i < rowsLevel1; ++i) {
                DataSetFactory.this.log("\n* Start DataSetFactoryBuilder.getLevel1DataSets(): templateTagTypeLevel1=" + templateTagTypeLevel1[i] + ", dataSets[" + i + "]");
                dataSets[i] = this.createTagLevel1DataSet(templateTagTypeLevel1[i]);
                DataSetFactory.this.log("* End DataSetFactoryBuilder.getLevel1DataSets(): templateTagTypeLevel1=" + templateTagTypeLevel1[i] + ", dataSets[" + i + "]=" + Misc.getClassName((Object)dataSets[i]) + "\n");
            }
            return dataSets;
        }

        private DataSet createTagLevel1DataSet(String templateTagTypeLevel1) {
            DataSet nextDataSet = null;
            String[] templateTagTypeLevel2 = TemplateConstants.getTagTypeLevel2();
            int rowsLevel2 = templateTagTypeLevel2.length;
            for (int i = 0; i < rowsLevel2; ++i) {
                String key = TemplateConstants.getTemplateKey(templateTagTypeLevel1, templateTagTypeLevel2[i], null);
                String containerKey = TemplateConstants.getTemplateKey(templateTagTypeLevel1, templateTagTypeLevel2[i], "CONTAINER");
                DataSetFactory.this.log("\nStart DataSetFactory.DataSetFactoryBuilder: create DataSet factory instances: containerKey=" + containerKey);
                DataSetFactoryParm dataSetFactoryParm = new DataSetFactoryParm(key, this.templateContents, nextDataSet);
                nextDataSet = DataSetFactory.this.getDataSetFactoryMaster(containerKey).createFactoryInstance(dataSetFactoryParm);
                DataSetFactory.this.log("End DataSetFactory.DataSetFactoryBuilder: create DataSet factory instances: containerKey=" + containerKey);
            }
            return nextDataSet;
        }
    }
}

