/*
 * Decompiled with CFR 0.152.
 */
package com.fdsapi;

import com.fdsapi.DataIterator;
import com.fdsapi.DataIteratorBase;
import com.fdsapi.DataSetFactoryParm;
import com.fdsapi.DataSetParm;
import com.fdsapi.RuntimeExceptionBase;
import com.fdsapi.TabularData;
import com.fdsapi.TemplateVariables;
import com.fdsapi.Utils;
import java.util.Map;

public abstract class DataSet
implements Cloneable {
    protected TemplateVariables variables;
    protected DataSetParm dataSetParm;
    protected String templateTagType;

    public boolean next() {
        return this.dataSetParm.getDataIterator().next();
    }

    public DataSet createFactoryInstance(DataSetFactoryParm parm) {
        DataSet dataSet = this.createFactoryInstance();
        dataSet.variables = parm.getVariables();
        dataSet.templateTagType = parm.getTemplateTagType();
        return dataSet;
    }

    public abstract DataSet createFactoryInstance();

    public void setDataSetParm(DataSetParm dsp) {
        try {
            this.dataSetParm = (DataSetParm)dsp.clone();
            this.dataSetParm.setDataIterator(this.createDataIterator());
        }
        catch (Exception e) {
            throw new RuntimeExceptionBase("Failure in setting DataSetParms: ", e);
        }
    }

    protected void log(String logStr) {
        Utils.logDebug(logStr);
    }

    public DataIterator createDataIterator() {
        return new DataIteratorBase();
    }

    public Object clone() throws CloneNotSupportedException {
        DataSet dataSet = (DataSet)super.clone();
        return dataSet;
    }

    public abstract void execute(int var1);

    public Object execute() {
        return this;
    }

    protected void initialize(String templateContents) {
    }

    protected String getVariableValue(String variableName) {
        return this.variables.getVariableValue(variableName, this.dataSetParm);
    }

    protected TemplateVariables getTemplateVariables() {
        return this.variables;
    }

    protected DataSetParm getDataSetParm() {
        return this.dataSetParm;
    }

    protected TabularData getTabularData() {
        return this.dataSetParm.getTabularData();
    }

    protected Object getCellData() {
        return this.getTabularData().getCellData();
    }

    protected Map getMiscDataMap() {
        return this.dataSetParm.getMiscDataMap();
    }

    protected StringBuffer getStringBuffer() {
        return this.dataSetParm.getStringBuffer();
    }

    public String toString() {
        return this.dataSetParm.getStringBuffer().toString();
    }
}

