/*
 * Decompiled with CFR 0.152.
 */
package com.fdsapi;

import com.fdsapi.AppConstants;
import com.fdsapi.DataAccess;
import com.fdsapi.DataAccessBase;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class DataAccessJ2EE
extends DataAccessBase {
    private DataSource dataSource;
    private InitialContext initialContext;

    public DataAccessJ2EE(InitialContext initialContext, String dataSourceName) {
        this.setDataSourceName(dataSourceName);
        this.initialContext = initialContext;
    }

    public DataAccessJ2EE(String dataSourceName) throws SQLException {
        this(DataAccessJ2EE.createInitialContext(), dataSourceName);
    }

    public DataAccessJ2EE() throws SQLException {
        this(DataAccessJ2EE.createInitialContext(), AppConstants.DATASOURCE);
    }

    private static InitialContext createInitialContext() throws SQLException {
        try {
            return new InitialContext();
        }
        catch (NamingException e) {
            throw new SQLException("DataAccessJ2EE NamingException message=" + e.getMessage());
        }
    }

    public DataAccess createInstance() throws SQLException {
        return new DataAccessJ2EE(this.initialContext, this.getDataSourceName());
    }

    private DataSource getDataSource() throws SQLException {
        try {
            if (this.dataSource == null) {
                this.dataSource = (DataSource)this.initialContext.lookup("java:comp/env/jdbc/" + this.getDataSourceName());
            }
        }
        catch (NamingException e) {
            throw new SQLException("DataAccessJ2EE NamingException dataSourceName=" + this.getDataSourceName() + ", message=" + e.getMessage());
        }
        return this.dataSource;
    }

    public void setDataSourceName(String dataSourceName) {
        super.setDataSourceName(dataSourceName);
        this.dataSource = null;
    }

    public Connection getConnection() throws SQLException {
        return this.getDataSource().getConnection();
    }
}

