/*
 * Decompiled with CFR 0.152.
 */
package com.fdsapi;

import com.fdsapi.DataAccess;
import com.fdsapi.DataAccessBase;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class DataAccessClient
extends DataAccessBase {
    private String dbDriver;
    private String dbUrl;
    private String userName;
    private String passWord;
    private Properties info;
    private boolean cacheConnection = true;
    private boolean fromUserName = false;
    private boolean fromUrl = false;
    private boolean fromProperties = false;

    public DataAccessClient(String dbDriver, String dbUrl, String userName, String passWord, boolean cacheConnection) throws SQLException {
        this(dbDriver, dbUrl, userName, passWord, null, cacheConnection);
    }

    public DataAccessClient(String dbDriver, String dbUrl, boolean cacheConnection) throws SQLException {
        this(dbDriver, dbUrl, null, null, null, cacheConnection);
    }

    public DataAccessClient(String dbDriver, String dbUrl, Properties info, boolean cacheConnection) throws SQLException {
        this(dbDriver, dbUrl, null, null, info, cacheConnection);
    }

    private DataAccessClient(String dbDriver, String dbUrl, String userName, String passWord, Properties info, boolean cacheConnection) throws SQLException {
        try {
            this.dbDriver = dbDriver;
            this.dbUrl = dbUrl;
            this.userName = userName;
            this.passWord = passWord;
            this.info = info;
            this.cacheConnection = cacheConnection;
            if (userName != null && passWord != null) {
                this.fromUserName = true;
            } else if (info == null) {
                this.fromProperties = true;
            } else {
                this.fromUrl = true;
            }
            Class.forName(dbDriver);
        }
        catch (ClassNotFoundException e) {
            throw new SQLException("DataAccessClient message=" + e.getMessage());
        }
    }

    public DataAccess createInstance() throws SQLException {
        if (this.cacheConnection) {
            return this;
        }
        return new DataAccessClient(this.dbDriver, this.dbUrl, this.userName, this.passWord, this.info, this.cacheConnection);
    }

    public Connection getConnection() throws SQLException {
        if (this.connectionIsClosed()) {
            if (this.fromUserName) {
                this.connection = DriverManager.getConnection(this.dbUrl, this.userName, this.passWord);
            } else if (this.fromUrl) {
                this.connection = DriverManager.getConnection(this.dbUrl);
            } else if (this.fromProperties) {
                this.connection = DriverManager.getConnection(this.dbUrl, this.info);
            } else {
                throw new SQLException("DataAccessClient message=Invalid connection parm");
            }
        }
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        try {
            this.closeResultSet();
            this.closeStatement();
        }
        finally {
            if (!this.cacheConnection) {
                this.closeConnection();
            }
        }
    }
}

