/*
 * Decompiled with CFR 0.152.
 */
package com.fdsapi;

import com.fdsapi.AppConstants;
import com.fdsapi.DataAccess;
import com.fdsapi.ResultSetConverter;
import com.jamonapi.Monitor;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public abstract class DataAccessBase
implements DataAccess {
    protected Connection connection;
    protected Statement statement;
    protected ResultSet resultSet;
    private String dataSourceName;

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    protected Statement createStatement() throws SQLException {
        return this.connection.createStatement();
    }

    protected Monitor start(String locator) {
        return AppConstants.start("DataAccess." + locator);
    }

    protected ResultSet executeQuery(String query) throws SQLException {
        return this.statement.executeQuery(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        try {
            this.closeResultSet();
            this.closeStatement();
        }
        finally {
            this.closeConnection();
        }
    }

    public void closeConnection() throws SQLException {
        if (!this.connectionIsClosed()) {
            this.connection.close();
            this.connection = null;
        }
    }

    public boolean connectionIsClosed() throws SQLException {
        return this.connection == null || this.connection.isClosed();
    }

    public void closeResultSet() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
        }
    }

    public void closeStatement() throws SQLException {
        if (this.statement != null) {
            this.statement.close();
            this.statement = null;
        }
    }

    public ResultSet getResultSet(String queryCommand) throws SQLException {
        this.connection = this.getConnection();
        this.statement = this.createStatement();
        this.resultSet = this.executeQuery(queryCommand);
        return this.resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSetConverter getResultSetConverter(String query) throws SQLException {
        try {
            ResultSet rs = this.getResultSet(query);
            ResultSetConverter resultSetConverter = new ResultSetConverter(rs);
            return resultSetConverter;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSetConverter[] getResultSetConverters(String queryCommand) throws SQLException {
        try {
            ArrayList<ResultSetConverter> list = new ArrayList<ResultSetConverter>();
            this.connection = this.getConnection();
            this.statement = this.createStatement();
            this.statement.execute(queryCommand);
            do {
                this.resultSet = this.statement.getResultSet();
                if (this.resultSet == null) continue;
                list.add(new ResultSetConverter(this.resultSet));
            } while (this.statement.getMoreResults() || this.statement.getUpdateCount() != -1);
            ResultSetConverter[] resultSetConverterArray = list.size() == 0 ? null : list.toArray(new ResultSetConverter[0]);
            return resultSetConverterArray;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String sql) throws SQLException {
        try {
            int rowCount;
            this.connection = this.getConnection();
            this.statement = this.createStatement();
            int n = rowCount = this.statement.executeUpdate(sql);
            return n;
        }
        finally {
            this.close();
        }
    }
}

