/*
 * Decompiled with CFR 0.152.
 */
package com.fdsapi;

import com.fdsapi.Converter;
import com.fdsapi.ConverterBase;

public class ConverterRegExp
extends ConverterBase {
    private String regExp;
    private String replaceStr;

    public ConverterRegExp(String regExp, String replaceStr) {
        this.setVars(regExp, replaceStr);
    }

    public ConverterRegExp(String regExp, String replaceStr, Converter nextConverter) {
        super(nextConverter);
        this.setVars(regExp, replaceStr);
    }

    private void setVars(String regExp, String replaceStr) {
        this.regExp = this.noNulls(regExp);
        this.replaceStr = this.noNulls(replaceStr);
    }

    private String noNulls(String str) {
        return str == null ? "" : str;
    }

    protected Converter createInstance(Converter nextConverter) {
        return new ConverterRegExp(this.regExp, this.replaceStr, nextConverter);
    }

    public Object convert(Object inputObj) {
        if ((inputObj = this.decoratorConvert(inputObj)) == null) {
            return null;
        }
        if (inputObj instanceof String) {
            return ((String)inputObj).replaceAll(this.regExp, this.replaceStr);
        }
        return inputObj;
    }

    public static void main(String[] args) {
        ConverterRegExp converter = new ConverterRegExp("'", "''");
        System.out.println(converter.convert("steve's"));
        System.out.println(converter.convert("steve"));
        System.out.println(converter.convert("steve's souza's"));
        System.out.println(converter.convert(new Long(100L)));
        converter = new ConverterRegExp("t", "thomas");
        System.out.println(converter.convert("t"));
        converter = new ConverterRegExp(null, null);
        System.out.println(converter.convert("steve"));
        converter = new ConverterRegExp("[ ]+", " ");
        System.out.println(converter.convert("   steven      thomas     souza    "));
    }
}

