/*
 * Decompiled with CFR 0.152.
 */
package com.fdsapi;

import com.fdsapi.Converter;
import com.fdsapi.ConverterBase;
import com.fdsapi.Utils;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

public class ConverterChecksum
extends ConverterBase {
    private Checksum checksumEngine;

    public ConverterChecksum() {
        this(ConverterChecksum.getChecksumEngine("default"));
    }

    public ConverterChecksum(Checksum checksumEngine) {
        this.checksumEngine = checksumEngine;
    }

    public ConverterChecksum(Converter nextConverter) {
        super(nextConverter);
        this.checksumEngine = ConverterChecksum.getChecksumEngine("default");
    }

    public ConverterChecksum(Checksum checksumEngine, Converter nextConverter) {
        super(nextConverter);
        this.checksumEngine = checksumEngine;
    }

    public Object convert(Object inputObj) {
        if ((inputObj = this.decoratorConvert(inputObj)) == null) {
            return null;
        }
        if (inputObj instanceof String) {
            return new Long(this.checksum(((String)inputObj).getBytes()));
        }
        if (inputObj instanceof byte[]) {
            return new Long(this.checksum((byte[])inputObj));
        }
        return inputObj;
    }

    protected Converter createInstance(Converter nextConverter) {
        return new ConverterChecksum(this.cloneChecksum(), nextConverter);
    }

    private Checksum cloneChecksum() {
        Checksum returnValue = null;
        try {
            returnValue = (Checksum)this.checksumEngine.getClass().newInstance();
        }
        catch (Exception e) {
            Utils.log(e);
        }
        return returnValue;
    }

    private long checksum(byte[] bytes) {
        this.checksumEngine.update(bytes, 0, bytes.length);
        long checksum = this.checksumEngine.getValue();
        this.checksumEngine.reset();
        return checksum;
    }

    public static Checksum getChecksumEngine(String checkSumType) {
        if ("crc32".equalsIgnoreCase(checkSumType)) {
            return new CRC32();
        }
        if ("adler32".equalsIgnoreCase(checkSumType)) {
            return new Adler32();
        }
        return new Adler32();
    }

    public static void main(String[] args) throws Exception {
        ConverterChecksum check = new ConverterChecksum();
        System.out.println("checksum = " + check.convert("steven souza"));
        System.out.println("checksum = " + check.convert("steven  souza"));
        System.out.println("checksum = " + check.convert("mindy bobish"));
        System.out.println("checksum = " + check.convert("steven souza"));
        System.out.println("checksum = " + check.convert(new Long(-10000L)));
    }
}

