/*
 * Decompiled with CFR 0.152.
 */
package com.fdsapi;

import com.fdsapi.DataSetParm;
import com.fdsapi.RuntimeExceptionBase;
import com.fdsapi.Utils;

public abstract class ColBoundary {
    String string;
    boolean strictSyntax = false;
    private static boolean debug = false;

    ColBoundary(String string, String dynamicVariableType) {
        this.string = string;
    }

    void getVariableValue(StringBuffer stringBuffer, DataSetParm dataSetParm) {
        stringBuffer.append(this.string);
        this.getVariableValueThis(stringBuffer, dataSetParm);
    }

    void getVariableValueThis(StringBuffer stringBuffer, DataSetParm dataSetParm) {
    }

    static int parseInt(String integerStr) {
        return Integer.parseInt(integerStr);
    }

    static int firstIntPosition(String str) {
        char[] arr = str.toCharArray();
        int startPosition = -1;
        int i = str.length() - 1;
        while (i >= 0 && Character.isDigit(arr[i])) {
            startPosition = i--;
        }
        return startPosition;
    }

    static int extractInt(String str) {
        int startPosition = ColBoundary.firstIntPosition(str);
        if (startPosition == -1) {
            return -1;
        }
        return ColBoundary.parseInt(str.substring(startPosition));
    }

    static ColBoundary createInstance(String string, String dynamicVariableType) {
        ColBoundary colBoundary = null;
        if (Null.isType(dynamicVariableType)) {
            colBoundary = new Null(string, dynamicVariableType);
        } else if (CellData.isType(dynamicVariableType)) {
            colBoundary = new CellData(string, dynamicVariableType);
        } else if (CurrentCol.isType(dynamicVariableType)) {
            colBoundary = new CurrentCol(string, dynamicVariableType);
        } else if (RowNum.isType(dynamicVariableType)) {
            colBoundary = new RowNum(string, dynamicVariableType);
        } else if (ColNum.isType(dynamicVariableType)) {
            colBoundary = new ColNum(string, dynamicVariableType);
        } else if (CurrentColHeader.isType(dynamicVariableType)) {
            colBoundary = new CurrentColHeader(string, dynamicVariableType);
        } else if (CellDataHeader.isType(dynamicVariableType)) {
            colBoundary = new CellDataHeader(string, dynamicVariableType);
        } else if (MiscDataArray.isType(dynamicVariableType)) {
            colBoundary = new MiscDataArray(string, dynamicVariableType);
        } else if (MiscDataCurrentCol.isType(dynamicVariableType)) {
            colBoundary = new MiscDataCurrentCol(string, dynamicVariableType);
        } else if (MiscData.isType(dynamicVariableType)) {
            colBoundary = new MiscData(string, dynamicVariableType);
        } else {
            throw new RuntimeExceptionBase("Error creating ColBoundary object of type (This code should never be reached): " + dynamicVariableType + " (" + string + ")");
        }
        ColBoundary.log(colBoundary + ": string=" + string + ", dynamicVariableType=" + dynamicVariableType);
        return colBoundary;
    }

    static void setDebug(boolean debugFlag) {
        debug = debugFlag;
    }

    private static void log(String logStr) {
        if (debug) {
            Utils.logDebug(logStr);
        }
    }

    private static class MiscData
    extends ColBoundary {
        private String miscVariableName;

        MiscData(String string, String miscVariableName) {
            super(string, miscVariableName);
            this.miscVariableName = miscVariableName;
        }

        void getVariableValueThis(StringBuffer stringBuffer, DataSetParm dataSetParm) {
            Object value = dataSetParm.getMiscDataMap().get(this.miscVariableName);
            if (value != null) {
                stringBuffer.append(value);
            } else if (this.strictSyntax) {
                throw new RuntimeExceptionBase("A value was not in miscDataMap: variableName=" + this.miscVariableName);
            }
        }

        static boolean isType(String dynamicVariableType) {
            return true;
        }
    }

    private static class MiscDataCurrentCol
    extends ColBoundary {
        private String miscVariableName;

        MiscDataCurrentCol(String string, String miscVariableName) {
            super(string, miscVariableName);
            int endIndex = miscVariableName.length() - "this".length();
            this.miscVariableName = miscVariableName.substring(0, endIndex);
        }

        void getVariableValueThis(StringBuffer stringBuffer, DataSetParm dataSetParm) {
            Object obj = dataSetParm.getMiscDataMap().get(this.miscVariableName);
            int index = dataSetParm.getTabularData().getColIterator().getCurrentItemNumber() - 1;
            if (obj instanceof Object[]) {
                Object[] objArr = (Object[])obj;
                stringBuffer.append(objArr[index]);
            } else if (obj instanceof int[]) {
                int[] intArr = (int[])obj;
                stringBuffer.append(intArr[index]);
            } else if (this.strictSyntax) {
                throw new RuntimeExceptionBase("Invalid object type in miscDataMap.  Valid values are Object[] and int[]: variableName=" + this.miscVariableName + ", index=" + index + ", Object type=" + obj);
            }
        }

        static boolean isType(String dynamicVariableType) {
            String var = dynamicVariableType.toLowerCase();
            String thisStr = "this".toLowerCase();
            return var.endsWith(thisStr);
        }
    }

    private static class MiscDataArray
    extends ColBoundary {
        private int col;
        private String miscVariableName;

        MiscDataArray(String string, String miscVariableName) {
            super(string, miscVariableName);
            int intPos = MiscDataArray.firstIntPosition(miscVariableName);
            this.col = MiscDataArray.extractInt(miscVariableName) - 1;
            this.miscVariableName = miscVariableName.substring(0, intPos);
        }

        void getVariableValueThis(StringBuffer stringBuffer, DataSetParm dataSetParm) {
            Object obj = dataSetParm.getMiscDataMap().get(this.miscVariableName);
            if (obj instanceof Object[]) {
                Object[] objArr = (Object[])obj;
                stringBuffer.append(objArr[this.col]);
            } else if (obj instanceof int[]) {
                int[] intArr = (int[])obj;
                stringBuffer.append(intArr[this.col]);
            } else if (this.strictSyntax) {
                throw new RuntimeExceptionBase("Invalid object type in miscDataMap.  Valid values are Object[] and int[]: " + this.miscVariableName + this.col);
            }
        }

        static boolean isType(String dynamicVariableType) {
            char lastChar = dynamicVariableType.charAt(dynamicVariableType.length() - 1);
            return Character.isDigit(lastChar);
        }
    }

    private static class CurrentColHeader
    extends ColBoundary {
        CurrentColHeader(String string, String dynamicVariableType) {
            super(string, dynamicVariableType);
        }

        void getVariableValueThis(StringBuffer stringBuffer, DataSetParm dataSetParm) {
            int currentCol = dataSetParm.getTabularData().getColIterator().getCurrentItemNumber();
            stringBuffer.append(dataSetParm.getTabularData().getHeader().getCellData(currentCol));
        }

        static boolean isType(String dynamicVariableType) {
            return "headerThis".equalsIgnoreCase(dynamicVariableType);
        }
    }

    private static class CellDataHeader
    extends ColBoundary {
        int col;
        private static final String HEADER = "HEADER".toLowerCase();

        CellDataHeader(String string, String dynamicVariableType) {
            super(string, dynamicVariableType);
            this.col = CellDataHeader.extractInt(dynamicVariableType);
        }

        void getVariableValueThis(StringBuffer stringBuffer, DataSetParm dataSetParm) {
            stringBuffer.append(dataSetParm.getTabularData().getHeader().getCellData(this.col));
        }

        static boolean isType(String dynamicVariableType) {
            return dynamicVariableType.toLowerCase().startsWith(HEADER) && Character.isDigit(dynamicVariableType.charAt(HEADER.length()));
        }
    }

    private static class ColNum
    extends ColBoundary {
        ColNum(String string, String dynamicVariableType) {
            super(string, dynamicVariableType);
        }

        void getVariableValueThis(StringBuffer stringBuffer, DataSetParm dataSetParm) {
            stringBuffer.append(dataSetParm.getTabularData().getColIterator().getCurrentItemNumber());
        }

        static boolean isType(String dynamicVariableType) {
            return "colNum".equalsIgnoreCase(dynamicVariableType);
        }
    }

    private static class RowNum
    extends ColBoundary {
        RowNum(String string, String dynamicVariableType) {
            super(string, dynamicVariableType);
        }

        void getVariableValueThis(StringBuffer stringBuffer, DataSetParm dataSetParm) {
            stringBuffer.append(dataSetParm.getTabularData().getRowIterator().getCurrentItemNumber());
        }

        static boolean isType(String dynamicVariableType) {
            return "rowNum".equalsIgnoreCase(dynamicVariableType);
        }
    }

    private static class CurrentCol
    extends ColBoundary {
        CurrentCol(String string, String dynamicVariableType) {
            super(string, dynamicVariableType);
        }

        void getVariableValueThis(StringBuffer stringBuffer, DataSetParm dataSetParm) {
            stringBuffer.append(dataSetParm.getTabularData().getCellData());
        }

        static boolean isType(String dynamicVariableType) {
            return "this".equalsIgnoreCase(dynamicVariableType);
        }
    }

    private static class Null
    extends ColBoundary {
        Null(String string, String dynamicVariableType) {
            super(string, dynamicVariableType);
        }

        static boolean isType(String dynamicVariableType) {
            return dynamicVariableType == null;
        }
    }

    private static class CellData
    extends ColBoundary {
        int col;

        CellData(String string, String integerStr) {
            super(string, integerStr);
            this.col = CellData.parseInt(integerStr);
        }

        void getVariableValueThis(StringBuffer stringBuffer, DataSetParm dataSetParm) {
            stringBuffer.append(dataSetParm.getTabularData().getCellData(this.col));
        }

        static boolean isType(String dynamicVariableType) {
            return Character.isDigit(dynamicVariableType.charAt(0));
        }
    }
}

