/*
 * Decompiled with CFR 0.152.
 */
package com.fdsapi;

import com.fdsapi.Utils;
import com.jamonapi.Monitor;
import com.jamonapi.MonitorFactory;
import com.jamonapi.utils.AppMap;
import java.util.Map;

public class AppConstants {
    public static String DATASOURCE = "DataSource";
    public static final int MONITOR_PRIORITY_LEVEL = 11;
    public static final String MONITOR_PREFIX = "com.fdsapi.";
    private static Map appConstants = AppMap.createInstance();

    public static void setAppConstants(Map newAppConstants) {
        appConstants = newAppConstants;
    }

    public static Map getAppConstants() {
        return appConstants;
    }

    public static String get(String key) {
        String value = "The requested AppConstant was not found.  Please contact a developer.  key=" + key;
        if (appConstants.containsKey(key)) {
            value = appConstants.get(key).toString();
        } else {
            Utils.log(value);
        }
        return value;
    }

    public static Monitor start(String locator) {
        return MonitorFactory.getDebugFactory().start(MONITOR_PREFIX + locator);
    }

    public static String replaceString(String sourceStr, String replaceStr, String replaceWithStr) {
        int NOMATCH = -1;
        int start = sourceStr.indexOf(replaceStr);
        if (start == -1) {
            return sourceStr;
        }
        StringBuffer sourceBuffer = new StringBuffer(sourceStr);
        int end = start + replaceStr.length();
        sourceBuffer.replace(start, end, replaceWithStr);
        return sourceBuffer.toString();
    }

    protected AppConstants() {
    }

    static {
        appConstants.put(DATASOURCE, DATASOURCE);
        appConstants.put("formMethod", "post");
        appConstants.put("debug", "0");
        appConstants.put("dateFormat", "M/d/yy");
        appConstants.put("errorIndicator", "** ");
        appConstants.put("requiredField", "This is a required field.<br>");
        appConstants.put("invalidDate", " is an invalid date.<br>");
        appConstants.put("conversion", " was not converted properly.<br>");
        appConstants.put("fieldNoExists", " Field object must be defined.<br>");
    }
}

