/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.update.type;

public class DownloadItem {
    private String internalRepresentation;
    private String version;
    private String fileName;
    private String location;
    private long size;
    private String os;
    private String description;

    public DownloadItem(String version, String fileName, String location, long size, String os, String description) {
        if (!location.equals("") && !location.endsWith("/")) {
            location = location + "/";
        }
        this.version = version;
        this.fileName = fileName;
        this.location = location;
        this.size = size;
        this.os = os;
        this.description = description;
        if (fileName == null || location == null || fileName.trim().equals("") && location.trim().equals("")) {
            throw new IllegalArgumentException("Please specify correct fileName and location");
        }
        this.internalRepresentation = location + fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getLocation() {
        return this.location;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public String getOs() {
        return this.os;
    }

    public long getSize() {
        return this.size;
    }

    public int hashCode() {
        return this.internalRepresentation.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DownloadItem) {
            DownloadItem item = (DownloadItem)obj;
            if (this.internalRepresentation.equals(item.internalRepresentation)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.internalRepresentation + " (" + this.version + ")";
    }
}

