/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.update;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Launcher {
    private static final String CLIENT_VERSION_FILE = "version.txt";
    private static final String MAP_KEY_WINDOWS = "windows";
    private static final String MAP_KEY_LINUX = "linux";
    private static final String MAP_KEY_MAC = "mac";
    static /* synthetic */ Class array$Ljava$lang$String;

    private Launcher() {
    }

    public static void main(String[] args) {
        try {
            File updateDir = new File("version_update_complete");
            if (updateDir.exists()) {
                Launcher.copyDirectory(updateDir, new File("."));
            }
            Launcher.deleteDirectory(updateDir);
            Map versionFiles = Launcher.getVersionFiles();
            if (versionFiles.size() > 0) {
                File osVersionFile = null;
                String os = System.getProperty("os.name");
                if (os.startsWith("Windows")) {
                    osVersionFile = (File)versionFiles.get(MAP_KEY_WINDOWS);
                } else if (os.startsWith("Linux")) {
                    osVersionFile = (File)versionFiles.get(MAP_KEY_LINUX);
                } else if (os.startsWith("Mac OS X")) {
                    osVersionFile = (File)versionFiles.get(MAP_KEY_MAC);
                }
                if (osVersionFile != null) {
                    File oldVersionTxt = new File(CLIENT_VERSION_FILE);
                    if (oldVersionTxt != null) {
                        oldVersionTxt.delete();
                    }
                    osVersionFile.renameTo(new File(CLIENT_VERSION_FILE));
                }
                Launcher.removeVersionFiles();
            }
            URLClassLoader loader = new URLClassLoader(Launcher.getJARs());
            Class<?> c = loader.loadClass(Launcher.getMainClass());
            Method m = c.getMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = Launcher.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
            m.invoke(null, new Object[]{args});
        }
        catch (ClassNotFoundException e) {
            System.err.println("Couldn't find a class or library, there may be some problems with the classpath.");
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            System.err.println("Couldn't find the main method to start the application.");
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Map getVersionFiles() {
        HashMap<String, File> versionFiles = new HashMap<String, File>();
        File root = new File(".");
        File[] files = root.listFiles(new VersionFileFilter());
        for (int i = 0; i < files.length; ++i) {
            if (files[i].getName().toLowerCase().startsWith("version_w")) {
                versionFiles.put(MAP_KEY_WINDOWS, files[i]);
                continue;
            }
            if (files[i].getName().toLowerCase().startsWith("version_l")) {
                versionFiles.put(MAP_KEY_LINUX, files[i]);
                continue;
            }
            if (!files[i].getName().toLowerCase().startsWith("version_m")) continue;
            versionFiles.put(MAP_KEY_MAC, files[i]);
        }
        return versionFiles;
    }

    private static void removeVersionFiles() {
        File root = new File(".");
        File[] files = root.listFiles(new VersionFileFilter());
        for (int i = 0; i < files.length; ++i) {
            files[i].delete();
        }
    }

    private static void copyDirectory(File srcDir, File destDir) {
        if (srcDir.isDirectory()) {
            if (!destDir.exists()) {
                destDir.mkdir();
            }
            String[] children = srcDir.list();
            for (int i = 0; i < children.length; ++i) {
                Launcher.copyDirectory(new File(srcDir, children[i]), new File(destDir, children[i]));
            }
        } else {
            Launcher.copyFile(srcDir, destDir);
        }
    }

    private static boolean copyFile(File src, File dest) {
        try {
            int len;
            FileInputStream in = new FileInputStream(src);
            FileOutputStream out = new FileOutputStream(dest);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static void deleteDirectory(File directory) {
        File[] files = directory.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    Launcher.deleteDirectory(files[i]);
                }
                files[i].delete();
            }
            directory.delete();
        }
    }

    private static String getMainClass() {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(CLIENT_VERSION_FILE));
            String line = null;
            while ((line = reader.readLine()) != null) {
                String searchString = "mainclass=";
                if (!line.trim().toLowerCase().startsWith(searchString)) continue;
                return line.substring(searchString.length());
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static URL[] getJARs() {
        ArrayList<URL> jarList = new ArrayList<URL>();
        URL[] urls = null;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(CLIENT_VERSION_FILE));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line.trim().toLowerCase().startsWith("version") || line.trim().toLowerCase().startsWith("mainclass")) continue;
                URL url = new File(line).toURI().toURL();
                jarList.add(url);
            }
            urls = new URL[jarList.size()];
            for (int i = 0; i < jarList.size(); ++i) {
                urls[i] = (URL)jarList.get(i);
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return urls;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class VersionFileFilter
    implements FileFilter {
        private VersionFileFilter() {
        }

        public boolean accept(File pathname) {
            String fileName;
            return pathname.isFile() && (fileName = pathname.getName().toLowerCase()).startsWith("version_") && fileName.endsWith(".txt");
        }
    }
}

