/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.de;

import java.io.IOException;
import java.util.Hashtable;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.de.GermanStemmer;

public final class GermanStemFilter
extends TokenFilter {
    private Token token = null;
    private GermanStemmer stemmer = new GermanStemmer();
    private Hashtable exclusions = null;

    public GermanStemFilter(TokenStream tokenStream) {
        this.input = tokenStream;
    }

    public GermanStemFilter(TokenStream tokenStream, Hashtable hashtable) {
        this(tokenStream);
        this.exclusions = hashtable;
    }

    public final Token next() throws IOException {
        this.token = this.input.next();
        if (this.token == null) {
            return null;
        }
        if (this.exclusions != null && this.exclusions.contains(this.token.termText())) {
            return this.token;
        }
        String string = this.stemmer.stem(this.token.termText());
        if (!string.equals(this.token.termText())) {
            return new Token(string, this.token.startOffset(), this.token.endOffset(), this.token.type());
        }
        return this.token;
    }

    public void setStemmer(GermanStemmer germanStemmer) {
        if (germanStemmer != null) {
            this.stemmer = germanStemmer;
        }
    }

    public void setExclusionTable(Hashtable hashtable) {
        this.exclusions = hashtable;
    }
}

