/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.schema;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xerces.framework.XMLContentSpec;
import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.utils.NamespacesScope;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.validators.common.Grammar;
import org.apache.xerces.validators.common.GrammarResolver;
import org.apache.xerces.validators.common.XMLAttributeDecl;
import org.apache.xerces.validators.common.XMLElementDecl;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.DatatypeValidatorFactoryImpl;
import org.apache.xerces.validators.datatype.IDDatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;
import org.apache.xerces.validators.datatype.ListDatatypeValidator;
import org.apache.xerces.validators.datatype.NOTATIONDatatypeValidator;
import org.apache.xerces.validators.datatype.StringDatatypeValidator;
import org.apache.xerces.validators.datatype.UnionDatatypeValidator;
import org.apache.xerces.validators.schema.GeneralAttrCheck;
import org.apache.xerces.validators.schema.SchemaGrammar;
import org.apache.xerces.validators.schema.SchemaMessageProvider;
import org.apache.xerces.validators.schema.SubstitutionGroupComparator;
import org.apache.xerces.validators.schema.XUtil;
import org.apache.xerces.validators.schema.identity.Field;
import org.apache.xerces.validators.schema.identity.IdentityConstraint;
import org.apache.xerces.validators.schema.identity.Key;
import org.apache.xerces.validators.schema.identity.KeyRef;
import org.apache.xerces.validators.schema.identity.Selector;
import org.apache.xerces.validators.schema.identity.Unique;
import org.apache.xerces.validators.schema.identity.XPathException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class TraverseSchema
implements NamespacesScope.NamespacesHandler {
    private static final int TOP_LEVEL_SCOPE = -1;
    private static final String[][] IDENTITY_CONSTRAINTS = new String[][]{{"http://www.w3.org/2001/XMLSchema", "unique"}, {"http://www.w3.org/2001/XMLSchema", "key"}, {"http://www.w3.org/2001/XMLSchema", "keyref"}};
    private static final String redefIdentifier = "_fn3dktizrknc9pi";
    private static final int NOT_ALL_CONTEXT = 0;
    private static final int PROCESSING_ALL_EL = 1;
    private static final int GROUP_REF_WITH_ALL = 2;
    private static final int CHILD_OF_GROUP = 4;
    private static final int PROCESSING_ALL_GP = 8;
    private static final boolean DEBUGGING = false;
    private static final boolean DEBUG_IDENTITY_CONSTRAINTS = false;
    private static final boolean DEBUG_NEW_GROUP = true;
    private static final boolean DEBUG_IC_DATATYPES = false;
    private boolean fFullConstraintChecking = false;
    private XMLErrorReporter fErrorReporter = null;
    private StringPool fStringPool = null;
    private GrammarResolver fGrammarResolver = null;
    private SchemaGrammar fSchemaGrammar = null;
    private Element fSchemaRootElement;
    private SchemaInfo fSchemaInfoListRoot = null;
    private SchemaInfo fCurrentSchemaInfo = null;
    private boolean fRedefineSucceeded;
    private DatatypeValidatorFactoryImpl fDatatypeRegistry = null;
    private Hashtable fComplexTypeRegistry = new Hashtable();
    private Hashtable fAttributeDeclRegistry = new Hashtable();
    private Hashtable fGroupNameRegistry = new Hashtable();
    private Hashtable fRestrictedRedefinedGroupRegistry = new Hashtable();
    private Hashtable fSimpleTypeFinalRegistry = new Hashtable();
    private Hashtable fNotationRegistry = new Hashtable();
    private Vector fIncludeLocations = new Vector();
    private Vector fImportLocations = new Vector();
    private Hashtable fRedefineLocations = new Hashtable();
    private Vector fTraversedRedefineElements = new Vector();
    private Hashtable fRedefineAttributeGroupMap = null;
    private Hashtable fFacetData = new Hashtable(10);
    private Stack fSimpleTypeNameStack = new Stack();
    private String fListName = "";
    private int fAnonTypeCount = 0;
    private int fScopeCount = 0;
    private int fCurrentScope = -1;
    private int fSimpleTypeAnonCount = 0;
    private Stack fCurrentTypeNameStack = new Stack();
    private Stack fBaseTypeNameStack = new Stack();
    private Stack fCurrentGroupNameStack = new Stack();
    private Vector fElementRecurseComplex = new Vector();
    private Vector fTopLevelElementsRefdFromGroup = new Vector();
    private Vector fSubstitutionGroupRecursionRegistry = new Vector();
    private boolean fElementDefaultQualified = false;
    private boolean fAttributeDefaultQualified = false;
    private int fBlockDefault = 0;
    private int fFinalDefault = 0;
    private int fTargetNSURI;
    private String fTargetNSURIString = "";
    private NamespacesScope fNamespacesScope = null;
    private String fCurrentSchemaURL = "";
    private XMLAttributeDecl fTempAttributeDecl = new XMLAttributeDecl();
    private XMLAttributeDecl fTemp2AttributeDecl = new XMLAttributeDecl();
    private XMLElementDecl fTempElementDecl = new XMLElementDecl();
    private XMLElementDecl fTempElementDecl2 = new XMLElementDecl();
    private XMLContentSpec tempContentSpec1 = new XMLContentSpec();
    private XMLContentSpec tempContentSpec2 = new XMLContentSpec();
    private EntityResolver fEntityResolver = null;
    private SubstitutionGroupComparator fSComp = null;
    private Hashtable fIdentityConstraints = new Hashtable();
    private Hashtable fIdentityConstraintNames = new Hashtable();
    private GeneralAttrCheck fGeneralAttrCheck = null;
    private int fXsiURI;
    private static final int CT_IS_ABSTRACT = 1;
    private static final int CT_CONTAINS_ATTR_TYPE_ID = 2;
    private static final int CT_DECL_SEEN = 4;
    public static final String SchemaForSchemaURI = "http://www.w3.org/TR-1/Schema";

    private TraverseSchema() {
    }

    public void setFullConstraintCheckingEnabled() {
        this.fFullConstraintChecking = true;
    }

    public void setGrammarResolver(GrammarResolver grammarResolver) {
        this.fGrammarResolver = grammarResolver;
    }

    public void startNamespaceDeclScope(int n, int n2) {
    }

    public void endNamespaceDeclScope(int n) {
    }

    public boolean particleEmptiable(int n) {
        if (!this.fFullConstraintChecking) {
            return true;
        }
        return this.minEffectiveTotalRange(n) == 0;
    }

    public int minEffectiveTotalRange(int n) {
        this.fSchemaGrammar.getContentSpec(n, this.tempContentSpec1);
        int n2 = this.tempContentSpec1.type;
        if (n2 == 5 || n2 == 9) {
            return this.minEffectiveTotalRangeSeq(n);
        }
        if (n2 == 4) {
            return this.minEffectiveTotalRangeChoice(n);
        }
        return this.fSchemaGrammar.getContentSpecMinOccurs(n);
    }

    private int minEffectiveTotalRangeSeq(int n) {
        this.fSchemaGrammar.getContentSpec(n, this.tempContentSpec1);
        int n2 = this.tempContentSpec1.type;
        int n3 = this.tempContentSpec1.value;
        int n4 = this.tempContentSpec1.otherValue;
        int n5 = this.fSchemaGrammar.getContentSpecMinOccurs(n);
        int n6 = n4 == -2 ? n5 * this.minEffectiveTotalRange(n3) : n5 * (this.minEffectiveTotalRange(n3) + this.minEffectiveTotalRange(n4));
        return n6;
    }

    private int minEffectiveTotalRangeChoice(int n) {
        int n2;
        int n3;
        this.fSchemaGrammar.getContentSpec(n, this.tempContentSpec1);
        int n4 = this.tempContentSpec1.type;
        int n5 = this.tempContentSpec1.value;
        int n6 = this.tempContentSpec1.otherValue;
        int n7 = this.fSchemaGrammar.getContentSpecMinOccurs(n);
        int n8 = n6 == -2 ? n7 * this.minEffectiveTotalRange(n5) : n7 * ((n3 = this.minEffectiveTotalRange(n5)) < (n2 = this.minEffectiveTotalRange(n6)) ? n3 : n2);
        return n8;
    }

    public int maxEffectiveTotalRange(int n) {
        this.fSchemaGrammar.getContentSpec(n, this.tempContentSpec1);
        int n2 = this.tempContentSpec1.type;
        if (n2 == 5 || n2 == 9) {
            return this.maxEffectiveTotalRangeSeq(n);
        }
        if (n2 == 4) {
            return this.maxEffectiveTotalRangeChoice(n);
        }
        return this.fSchemaGrammar.getContentSpecMaxOccurs(n);
    }

    private int maxEffectiveTotalRangeSeq(int n) {
        this.fSchemaGrammar.getContentSpec(n, this.tempContentSpec1);
        int n2 = this.tempContentSpec1.type;
        int n3 = this.tempContentSpec1.value;
        int n4 = this.tempContentSpec1.otherValue;
        int n5 = this.fSchemaGrammar.getContentSpecMaxOccurs(n);
        if (n5 == -2) {
            return -2;
        }
        int n6 = this.maxEffectiveTotalRange(n3);
        if (n4 == -2) {
            if (n6 == -2) {
                return -2;
            }
            return n5 * n6;
        }
        int n7 = this.maxEffectiveTotalRange(n4);
        if (n6 == -2 || n7 == -2) {
            return -2;
        }
        return n5 * (n6 + n7);
    }

    private int maxEffectiveTotalRangeChoice(int n) {
        this.fSchemaGrammar.getContentSpec(n, this.tempContentSpec1);
        int n2 = this.tempContentSpec1.type;
        int n3 = this.tempContentSpec1.value;
        int n4 = this.tempContentSpec1.otherValue;
        int n5 = this.fSchemaGrammar.getContentSpecMaxOccurs(n);
        if (n5 == -2) {
            return -2;
        }
        int n6 = this.maxEffectiveTotalRange(n3);
        if (n4 == -2) {
            if (n6 == -2) {
                return -2;
            }
            return n5 * n6;
        }
        int n7 = this.maxEffectiveTotalRange(n4);
        if (n6 == -2 || n7 == -2) {
            return -2;
        }
        return n5 * (n6 > n7 ? n6 : n7);
    }

    private String resolvePrefixToURI(String string) throws Exception {
        String string2 = this.fStringPool.toString(this.fNamespacesScope.getNamespaceForPrefix(this.fStringPool.addSymbol(string)));
        if (string2.length() == 0 && string.length() > 0) {
            this.reportGenericSchemaError("prefix : [" + string + "] cannot be resolved to a URI");
            return "";
        }
        return string2;
    }

    public TraverseSchema(Element element, StringPool stringPool, SchemaGrammar schemaGrammar, GrammarResolver grammarResolver, XMLErrorReporter xMLErrorReporter, String string, EntityResolver entityResolver, boolean bl, GeneralAttrCheck generalAttrCheck) throws Exception {
        this.fErrorReporter = xMLErrorReporter;
        this.fCurrentSchemaURL = string;
        this.fFullConstraintChecking = bl;
        this.fEntityResolver = entityResolver;
        this.fGeneralAttrCheck = generalAttrCheck;
        this.doTraverseSchema(element, stringPool, schemaGrammar, grammarResolver);
    }

    public TraverseSchema(Element element, StringPool stringPool, SchemaGrammar schemaGrammar, GrammarResolver grammarResolver, XMLErrorReporter xMLErrorReporter, String string, boolean bl, GeneralAttrCheck generalAttrCheck) throws Exception {
        this.fErrorReporter = xMLErrorReporter;
        this.fCurrentSchemaURL = string;
        this.fFullConstraintChecking = bl;
        this.fGeneralAttrCheck = generalAttrCheck;
        this.doTraverseSchema(element, stringPool, schemaGrammar, grammarResolver);
    }

    public TraverseSchema(Element element, StringPool stringPool, SchemaGrammar schemaGrammar, GrammarResolver grammarResolver, boolean bl, GeneralAttrCheck generalAttrCheck) throws Exception {
        this.fFullConstraintChecking = bl;
        this.fGeneralAttrCheck = generalAttrCheck;
        this.doTraverseSchema(element, stringPool, schemaGrammar, grammarResolver);
    }

    public void doTraverseSchema(Element element, StringPool stringPool, SchemaGrammar schemaGrammar, GrammarResolver grammarResolver) throws Exception {
        int n;
        Object object;
        Integer n2;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        this.fNamespacesScope = new NamespacesScope(this);
        this.fSchemaRootElement = element;
        this.fStringPool = stringPool;
        this.fSchemaGrammar = schemaGrammar;
        if (this.fFullConstraintChecking) {
            this.fSchemaGrammar.setDeferContentSpecExpansion();
            this.fSchemaGrammar.setCheckUniqueParticleAttribution();
        }
        this.fGrammarResolver = grammarResolver;
        this.fDatatypeRegistry = (DatatypeValidatorFactoryImpl)this.fGrammarResolver.getDatatypeRegistry();
        this.fDatatypeRegistry.expandRegistryToFullSchemaSet();
        this.fXsiURI = this.fStringPool.addSymbol("http://www.w3.org/2001/XMLSchema-instance");
        if (element == null) {
            return;
        }
        int n3 = GeneralAttrCheck.ELE_CONTEXT_GLOBAL;
        Hashtable hashtable = this.generalCheck(element, n3);
        String string = element.getPrefix();
        if ((string == null || string.length() == 0) && ((String)(object6 = element.getAttribute("xmlns"))).length() == 0) {
            element.setAttribute("xmlns", "http://www.w3.org/2001/XMLSchema");
        }
        this.fTargetNSURIString = this.getTargetNamespaceString(element);
        this.fTargetNSURI = this.fStringPool.addSymbol(this.fTargetNSURIString);
        if (this.fGrammarResolver == null) {
            this.reportGenericSchemaError("Internal error: don't have a GrammarResolver for TraverseSchema");
        } else {
            if (this.fSchemaGrammar.getComplexTypeRegistry() == null) {
                this.fSchemaGrammar.setComplexTypeRegistry(this.fComplexTypeRegistry);
            } else {
                this.fComplexTypeRegistry = this.fSchemaGrammar.getComplexTypeRegistry();
            }
            if (this.fSchemaGrammar.getAttributeDeclRegistry() == null) {
                this.fSchemaGrammar.setAttributeDeclRegistry(this.fAttributeDeclRegistry);
            } else {
                this.fAttributeDeclRegistry = this.fSchemaGrammar.getAttributeDeclRegistry();
            }
            if (this.fSchemaGrammar.getNamespacesScope() == null) {
                this.fSchemaGrammar.setNamespacesScope(this.fNamespacesScope);
            } else {
                this.fNamespacesScope = this.fSchemaGrammar.getNamespacesScope();
            }
            this.fSchemaGrammar.setDatatypeRegistry(this.fDatatypeRegistry);
            this.fSchemaGrammar.setTargetNamespaceURI(this.fTargetNSURIString);
            this.fGrammarResolver.putGrammar(this.fTargetNSURIString, this.fSchemaGrammar);
        }
        object6 = element.getAttributes();
        int n4 = 0;
        Attr attr = null;
        boolean bl = false;
        while ((attr = (Attr)object6.item(n4++)) != null) {
            object5 = attr.getName();
            if (((String)object5).startsWith("xmlns:")) {
                object4 = attr.getValue();
                object3 = ((String)object5).substring(((String)object5).indexOf(":") + 1);
                this.fNamespacesScope.setNamespaceForPrefix(this.fStringPool.addSymbol((String)object3), this.fStringPool.addSymbol((String)object4));
            }
            if (!((String)object5).equals("xmlns")) continue;
            object4 = attr.getValue();
            this.fNamespacesScope.setNamespaceForPrefix(0, this.fStringPool.addSymbol((String)object4));
            bl = true;
        }
        if (!bl && this.fTargetNSURIString.length() == 0) {
            this.fNamespacesScope.setNamespaceForPrefix(0, 0);
        }
        this.fElementDefaultQualified = element.getAttribute("elementFormDefault").equals("qualified");
        this.fAttributeDefaultQualified = element.getAttribute("attributeFormDefault").equals("qualified");
        object5 = element.getAttributeNode("blockDefault");
        this.fBlockDefault = object5 == null ? 0 : this.parseBlockSet(object5.getValue());
        object4 = element.getAttributeNode("finalDefault");
        this.fFinalDefault = object4 == null ? 0 : this.parseFinalSet(object4.getValue());
        if (this.fTargetNSURI == 0) {
            // empty if block
        }
        this.extractTopLevel3Components(element);
        object3 = XUtil.getFirstChildElement(element);
        while (object3 != null) {
            object2 = object3.getLocalName();
            if (((String)object2).equals("annotation")) {
                this.traverseAnnotationDecl((Element)object3);
            } else if (((String)object2).equals("include")) {
                this.fNamespacesScope.increaseDepth();
                this.traverseInclude((Element)object3);
                this.fNamespacesScope.decreaseDepth();
            } else if (((String)object2).equals("import")) {
                this.traverseImport((Element)object3);
            } else {
                if (!((String)object2).equals("redefine")) break;
                this.fRedefineSucceeded = true;
                this.traverseRedefine((Element)object3);
            }
            object3 = XUtil.getNextSiblingElement((Node)object3);
        }
        while (object3 != null) {
            object2 = object3.getLocalName();
            if (((String)object2).equals("annotation")) {
                this.traverseAnnotationDecl((Element)object3);
            } else if (((String)object2).equals("simpleType")) {
                this.traverseSimpleTypeDecl((Element)object3);
            } else if (((String)object2).equals("complexType")) {
                this.traverseComplexTypeDecl((Element)object3);
            } else if (((String)object2).equals("element")) {
                this.traverseElementDecl((Element)object3);
            } else if (((String)object2).equals("attributeGroup")) {
                this.traverseAttributeGroupDecl((Element)object3, null, null);
            } else if (((String)object2).equals("attribute")) {
                this.traverseAttributeDecl((Element)object3, null, false);
            } else if (((String)object2).equals("group")) {
                this.traverseGroupDecl((Element)object3);
            } else if (((String)object2).equals("notation")) {
                this.traverseNotationDecl((Element)object3);
            } else {
                this.reportGenericSchemaError("error in content of <schema> element information item");
            }
            object3 = XUtil.getNextSiblingElement((Node)object3);
        }
        object2 = this.fIdentityConstraints.keys();
        while (object2.hasMoreElements()) {
            n2 = (Integer)object2.nextElement();
            object = (Vector)this.fIdentityConstraints.get(n2);
            if (object == null) continue;
            n = n2;
            this.traverseIdentityNameConstraintsFor(n, (Vector)object);
        }
        object2 = this.fIdentityConstraints.keys();
        while (object2.hasMoreElements()) {
            n2 = (Integer)object2.nextElement();
            object = (Vector)this.fIdentityConstraints.get(n2);
            if (object == null) continue;
            n = n2;
            this.traverseIdentityRefConstraintsFor(n, (Vector)object);
        }
        if (this.fFullConstraintChecking) {
            int n5 = 0;
            while (n5 < this.fTopLevelElementsRefdFromGroup.size()) {
                object = (QName)this.fTopLevelElementsRefdFromGroup.elementAt(n5);
                n = (Integer)this.fTopLevelElementsRefdFromGroup.elementAt(n5 + 1);
                this.checkConsistentElements((QName)object, n);
                n5 += 2;
            }
            int n6 = this.fComplexTypeRegistry.size();
            Enumeration enumeration = this.fComplexTypeRegistry.elements();
            while (enumeration.hasMoreElements()) {
                ComplexTypeInfo complexTypeInfo = (ComplexTypeInfo)enumeration.nextElement();
                ComplexTypeInfo complexTypeInfo2 = complexTypeInfo.baseComplexTypeInfo;
                if (complexTypeInfo.derivedBy != 2 || complexTypeInfo2 == null || complexTypeInfo.contentSpecHandle <= -1) continue;
                try {
                    this.checkParticleDerivationOK(complexTypeInfo.contentSpecHandle, complexTypeInfo.scopeDefined, complexTypeInfo2.contentSpecHandle, complexTypeInfo2.scopeDefined, complexTypeInfo2);
                }
                catch (ParticleRecoverableError particleRecoverableError) {
                    String string2 = particleRecoverableError.getMessage();
                    this.reportGenericSchemaError("ComplexType '" + complexTypeInfo.typeName + "': " + string2);
                }
            }
        }
    }

    private void extractTopLevel3Components(Element element) throws Exception {
        Element element2 = XUtil.getFirstChildElement(element);
        while (element2 != null) {
            String string = element2.getLocalName();
            String string2 = element2.getAttribute("name");
            if (string.equals("element")) {
                if (this.fSchemaGrammar.topLevelElemDecls.get(string2) != null) {
                    this.reportGenericSchemaError("sch-props-correct: Duplicate declaration for an element " + string2);
                } else {
                    this.fSchemaGrammar.topLevelElemDecls.put(string2, element2);
                }
            } else if (string.equals("simpleType") || string.equals("complexType")) {
                if (this.fSchemaGrammar.topLevelTypeDecls.get(string2) != null) {
                    this.reportGenericSchemaError("sch-props-correct: Duplicate declaration for a type " + string2);
                } else {
                    this.fSchemaGrammar.topLevelTypeDecls.put(string2, element2);
                }
            } else if (string.equals("attributeGroup")) {
                if (this.fSchemaGrammar.topLevelAttrGrpDecls.get(string2) != null) {
                    this.reportGenericSchemaError("sch-props-correct: Duplicate declaration for an attribute group " + string2);
                } else {
                    this.fSchemaGrammar.topLevelAttrGrpDecls.put(string2, element2);
                }
            } else if (string.equals("attribute")) {
                if (this.fSchemaGrammar.topLevelAttrGrpDecls.get(string2) != null) {
                    this.reportGenericSchemaError("sch-props-correct: Duplicate declaration for an attribute " + string2);
                } else {
                    this.fSchemaGrammar.topLevelAttrGrpDecls.put(string2, element2);
                }
            } else if (string.equals("group")) {
                if (this.fSchemaGrammar.topLevelGroupDecls.get(string2) != null) {
                    this.reportGenericSchemaError("sch-props-correct: Duplicate declaration for a group " + string2);
                } else {
                    this.fSchemaGrammar.topLevelGroupDecls.put(string2, element2);
                }
            } else if (string.equals("notation")) {
                if (this.fSchemaGrammar.topLevelNotationDecls.get(string2) != null) {
                    this.reportGenericSchemaError("sch-props-correct: Duplicate declaration for a notation " + string2);
                } else {
                    this.fSchemaGrammar.topLevelNotationDecls.put(string2, element2);
                }
            }
            element2 = XUtil.getNextSiblingElement(element2);
        }
    }

    private void checkConsistentElements(QName qName, int n) throws Exception {
        this.fTempElementDecl.clear();
        int n2 = this.fSchemaGrammar.getElementDeclIndex(qName, -1);
        if (n2 < 0) {
            return;
        }
        this.fSchemaGrammar.getElementDecl(n2, this.fTempElementDecl);
        DatatypeValidator datatypeValidator = this.fTempElementDecl.datatypeValidator;
        ComplexTypeInfo complexTypeInfo = this.fSchemaGrammar.getElementComplexTypeInfo(n2);
        int n3 = this.fSchemaGrammar.getElementDeclIndex(qName.uri, qName.localpart, n);
        if (n3 > -1 && !this.checkDuplicateElementTypes(n3, complexTypeInfo, datatypeValidator)) {
            this.reportGenericSchemaError("duplicate element decl in the same scope with different types : " + this.fStringPool.toString(qName.localpart));
        }
        Vector vector = this.fSchemaGrammar.getElementDeclAllSubstitutionGroupQNames(n2, this.fGrammarResolver, this.fStringPool);
        int n4 = 0;
        while (n4 < vector.size()) {
            SchemaGrammar.OneSubGroup oneSubGroup = (SchemaGrammar.OneSubGroup)vector.elementAt(n4);
            QName qName2 = oneSubGroup.name;
            int n5 = oneSubGroup.eleIndex;
            int n6 = this.fSchemaGrammar.getElementDeclIndex(qName2, n);
            if (n6 > -1) {
                this.fSchemaGrammar.getElementDecl(n6, this.fTempElementDecl);
                datatypeValidator = this.fTempElementDecl.datatypeValidator;
                complexTypeInfo = this.fSchemaGrammar.getElementComplexTypeInfo(n6);
                if (!this.checkDuplicateElementTypes(n5, complexTypeInfo, datatypeValidator)) {
                    this.reportGenericSchemaError("duplicate element decl in the same scope with different types : " + this.fStringPool.toString(qName2.localpart));
                }
            }
            ++n4;
        }
    }

    private String expandSystemId(String string, String string2) throws Exception {
        URL uRL;
        String string3 = string;
        if (string3 == null || string3.length() == 0) {
            return string;
        }
        try {
            uRL = new URL(string3);
            if (uRL != null) {
                return string;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        string3 = TraverseSchema.fixURI(string3);
        uRL = null;
        URL uRL2 = null;
        try {
            if (string2 == null) {
                String string4;
                try {
                    string4 = TraverseSchema.fixURI(System.getProperty("user.dir"));
                }
                catch (SecurityException securityException) {
                    string4 = "";
                }
                if (!string4.endsWith("/")) {
                    string4 = string4 + "/";
                }
                uRL = new URL("file", "", string4);
            } else {
                uRL = new URL(string2);
            }
            uRL2 = new URL(uRL, string3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (uRL2 == null) {
            return string;
        }
        return uRL2.toString();
    }

    private static String fixURI(String string) {
        char c;
        char c2;
        if ((string = string.replace(File.separatorChar, '/')).length() >= 2 && (c2 = string.charAt(1)) == ':' && (c = Character.toUpperCase(string.charAt(0))) >= 'A' && c <= 'Z') {
            string = "/" + string;
        }
        return string;
    }

    private void traverseInclude(Element element) throws Exception {
        int n = GeneralAttrCheck.ELE_CONTEXT_GLOBAL;
        Hashtable hashtable = this.generalCheck(element, n);
        this.checkContent(element, XUtil.getFirstChildElement(element), true);
        Attr attr = element.getAttributeNode("schemaLocation");
        if (attr == null) {
            this.reportGenericSchemaError("a schemaLocation attribute must be specified on an <include> element");
            return;
        }
        String string = attr.getValue();
        InputSource inputSource = null;
        if (this.fEntityResolver != null) {
            inputSource = this.fEntityResolver.resolveEntity("", string);
        }
        if (inputSource == null) {
            string = this.expandSystemId(string, this.fCurrentSchemaURL);
            inputSource = new InputSource(string);
        } else {
            if (inputSource.getPublicId() != null) {
                string = inputSource.getPublicId();
            }
            string = string + ',' + inputSource.getSystemId();
        }
        if (this.fIncludeLocations.contains(string)) {
            return;
        }
        this.fIncludeLocations.addElement(string);
        IgnoreWhitespaceParser ignoreWhitespaceParser = new IgnoreWhitespaceParser();
        ignoreWhitespaceParser.setEntityResolver(new Resolver());
        ignoreWhitespaceParser.setErrorHandler(new ErrorHandler(){

            public void fatalError(SAXParseException sAXParseException) throws SAXException {
                StringBuffer stringBuffer = new StringBuffer();
                String string = sAXParseException.getSystemId();
                if (string != null) {
                    int n = string.lastIndexOf(47);
                    if (n != -1) {
                        string = string.substring(n + 1);
                    }
                    stringBuffer.append(string);
                }
                stringBuffer.append(':').append(sAXParseException.getLineNumber()).append(':').append(sAXParseException.getColumnNumber());
                String string2 = sAXParseException.getMessage();
                if (!string2.toLowerCase().trim().endsWith("not found.")) {
                    System.err.println("[Fatal Error] " + stringBuffer.toString() + ":" + string2);
                    throw sAXParseException;
                }
                System.err.println("[Warning] " + stringBuffer.toString() + ": " + string2);
            }
        });
        try {
            ignoreWhitespaceParser.setFeature("http://xml.org/sax/features/validation", false);
            ignoreWhitespaceParser.setFeature("http://xml.org/sax/features/namespaces", true);
            ignoreWhitespaceParser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            sAXNotRecognizedException.printStackTrace();
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            sAXNotSupportedException.printStackTrace();
        }
        try {
            ignoreWhitespaceParser.parse(inputSource);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        Document document = ignoreWhitespaceParser.getDocument();
        Element element2 = null;
        if (document != null) {
            element2 = document.getDocumentElement();
        }
        if (element2 != null) {
            String string2 = this.getTargetNamespaceString(element2);
            if (string2.length() > 0 && !string2.equals(this.fTargetNSURIString)) {
                this.reportGenericSchemaError("included schema '" + string + "' has a different targetNameSpace '" + string2 + "'");
            } else {
                if (this.fSchemaInfoListRoot == null) {
                    this.fCurrentSchemaInfo = this.fSchemaInfoListRoot = new SchemaInfo(this.fElementDefaultQualified, this.fAttributeDefaultQualified, this.fBlockDefault, this.fFinalDefault, this.fCurrentSchemaURL, this.fSchemaRootElement, this.fNamespacesScope, null, null);
                }
                this.fSchemaRootElement = element2;
                this.fCurrentSchemaURL = string;
                this.traverseIncludedSchemaHeader(element2);
                this.fCurrentSchemaInfo = new SchemaInfo(this.fElementDefaultQualified, this.fAttributeDefaultQualified, this.fBlockDefault, this.fFinalDefault, this.fCurrentSchemaURL, this.fSchemaRootElement, this.fNamespacesScope, this.fCurrentSchemaInfo.getNext(), this.fCurrentSchemaInfo);
                this.fCurrentSchemaInfo.getPrev().setNext(this.fCurrentSchemaInfo);
                this.traverseIncludedSchema(element2);
                this.fCurrentSchemaInfo = this.fCurrentSchemaInfo.getPrev();
                this.fCurrentSchemaInfo.restore();
            }
        }
    }

    private void traverseIncludedSchemaHeader(Element element) throws Exception {
        Object object;
        Object object2;
        int n = GeneralAttrCheck.ELE_CONTEXT_GLOBAL;
        Hashtable hashtable = this.generalCheck(element, n);
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n2 = 0;
        Attr attr = null;
        boolean bl = false;
        while ((attr = (Attr)namedNodeMap.item(n2++)) != null) {
            object2 = attr.getName();
            if (((String)object2).startsWith("xmlns:")) {
                object = attr.getValue();
                String string = ((String)object2).substring(((String)object2).indexOf(":") + 1);
                this.fNamespacesScope.setNamespaceForPrefix(this.fStringPool.addSymbol(string), this.fStringPool.addSymbol((String)object));
            }
            if (!((String)object2).equals("xmlns")) continue;
            object = attr.getValue();
            this.fNamespacesScope.setNamespaceForPrefix(0, this.fStringPool.addSymbol((String)object));
            bl = true;
        }
        if (!bl && this.fTargetNSURIString.length() == 0) {
            this.fNamespacesScope.setNamespaceForPrefix(0, 0);
        }
        this.fElementDefaultQualified = element.getAttribute("elementFormDefault").equals("qualified");
        this.fAttributeDefaultQualified = element.getAttribute("attributeFormDefault").equals("qualified");
        object2 = element.getAttributeNode("blockDefault");
        this.fBlockDefault = object2 == null ? 0 : this.parseBlockSet(object2.getValue());
        object = element.getAttributeNode("finalDefault");
        this.fFinalDefault = object == null ? 0 : this.parseFinalSet(object.getValue());
        if (this.fTargetNSURI == 0) {
            this.fElementDefaultQualified = true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void traverseIncludedSchema(Element element) throws Exception {
        String string;
        int n = GeneralAttrCheck.ELE_CONTEXT_GLOBAL;
        Hashtable hashtable = this.generalCheck(element, n);
        this.extractTopLevel3Components(element);
        Element element2 = XUtil.getFirstChildElement(element);
        while (element2 != null) {
            string = element2.getLocalName();
            if (string.equals("annotation")) {
                this.traverseAnnotationDecl(element2);
            } else if (string.equals("include")) {
                this.fNamespacesScope.increaseDepth();
                this.traverseInclude(element2);
                this.fNamespacesScope.decreaseDepth();
            } else if (string.equals("import")) {
                this.traverseImport(element2);
            } else {
                if (!string.equals("redefine")) break;
                this.fRedefineSucceeded = true;
                this.traverseRedefine(element2);
            }
            element2 = XUtil.getNextSiblingElement(element2);
        }
        while (element2 != null) {
            block18: {
                block25: {
                    Object object;
                    String string2;
                    Object object2;
                    block24: {
                        block23: {
                            block22: {
                                block21: {
                                    block20: {
                                        block19: {
                                            string = element2.getLocalName();
                                            if (!string.equals("annotation")) break block19;
                                            this.traverseAnnotationDecl(element2);
                                            break block18;
                                        }
                                        if (!string.equals("simpleType")) break block20;
                                        this.traverseSimpleTypeDecl(element2);
                                        break block18;
                                    }
                                    if (!string.equals("complexType")) break block21;
                                    this.traverseComplexTypeDecl(element2);
                                    break block18;
                                }
                                if (!string.equals("element")) break block22;
                                this.traverseElementDecl(element2);
                                break block18;
                            }
                            if (!string.equals("attributeGroup")) break block23;
                            if (this.fRedefineAttributeGroupMap != null && (object2 = (String)this.fRedefineAttributeGroupMap.get(string2 = element2.getAttribute("name"))) != null) {
                                element2.setAttribute("name", (String)object2);
                                this.fSchemaGrammar.topLevelAttrGrpDecls.remove(string2);
                                object = new ComplexTypeInfo();
                                int n2 = this.fStringPool.addSymbol("$" + (String)object2);
                                int n3 = this.fStringPool.addSymbol("%" + (String)object2);
                                ((ComplexTypeInfo)object).scopeDefined = -2;
                                ((ComplexTypeInfo)object).contentSpecHandle = -1;
                                ((ComplexTypeInfo)object).contentType = 5;
                                ((ComplexTypeInfo)object).datatypeValidator = null;
                                ((ComplexTypeInfo)object).templateElementIndex = this.fSchemaGrammar.addElementDecl(new QName(-1, n2, n3, this.fTargetNSURI), this.fTargetNSURI == 0 ? 0 : -2, ((ComplexTypeInfo)object).scopeDefined, ((ComplexTypeInfo)object).contentType, ((ComplexTypeInfo)object).contentSpecHandle, -1, ((ComplexTypeInfo)object).datatypeValidator);
                                Vector vector = new Vector();
                                this.traverseAttributeGroupDecl(element2, (ComplexTypeInfo)object, vector);
                                ((ComplexTypeInfo)object).attlistHead = this.fSchemaGrammar.getFirstAttributeDeclIndex(((ComplexTypeInfo)object).templateElementIndex);
                                this.fRedefineAttributeGroupMap.put(string2, new Object[]{object, this.fSchemaGrammar, vector});
                                break block18;
                            } else {
                                this.traverseAttributeGroupDecl(element2, null, null);
                            }
                            break block18;
                        }
                        if (!string.equals("attribute")) break block24;
                        this.traverseAttributeDecl(element2, null, false);
                        break block18;
                    }
                    if (!string.equals("group")) break block25;
                    string2 = element2.getAttribute("name");
                    if (this.fGroupNameRegistry.get(this.fTargetNSURIString + "," + string2) == null) {
                        this.traverseGroupDecl(element2);
                        break block18;
                    } else {
                        try {
                            object2 = (GroupInfo)this.fGroupNameRegistry.get(this.fTargetNSURIString + "," + string2);
                        }
                        catch (ClassCastException classCastException) {
                            object = (String)this.fGroupNameRegistry.get(this.fTargetNSURIString + "," + string2);
                            if (object != null) {
                                object2 = (String)this.fGroupNameRegistry.get(this.fTargetNSURIString + "," + string2);
                                if (object2 != null) {
                                    element2.setAttribute("name", (String)object2);
                                }
                                this.traverseGroupDecl(element2);
                            }
                            break block18;
                        }
                    }
                }
                if (string.equals("notation")) {
                    this.traverseNotationDecl(element2);
                } else {
                    this.reportGenericSchemaError("error in content of included <schema> element information item");
                }
            }
            element2 = XUtil.getNextSiblingElement(element2);
        }
    }

    private void openRedefinedSchema(Element element, SchemaInfo schemaInfo) throws Exception {
        Attr attr = element.getAttributeNode("schemaLocation");
        if (attr == null) {
            this.fRedefineSucceeded = false;
            this.reportGenericSchemaError("a schemaLocation attribute must be specified on a <redefine> element");
            return;
        }
        String string = attr.getValue();
        InputSource inputSource = null;
        if (this.fEntityResolver != null) {
            inputSource = this.fEntityResolver.resolveEntity("", string);
        }
        if (inputSource == null) {
            string = this.expandSystemId(string, this.fCurrentSchemaURL);
            inputSource = new InputSource(string);
        } else {
            if (inputSource.getPublicId() != null) {
                string = inputSource.getPublicId();
            }
            if (inputSource.getSystemId().equals(this.fCurrentSchemaURL)) {
                this.reportGenericSchemaError("src-redefine.2:  a schema cannot redefine itself");
                this.fRedefineSucceeded = false;
                return;
            }
            string = string + ',' + inputSource.getSystemId();
        }
        if (this.fRedefineLocations.get(string) != null) {
            this.fCurrentSchemaInfo = (SchemaInfo)this.fRedefineLocations.get(string);
            this.fCurrentSchemaInfo.restore();
            return;
        }
        IgnoreWhitespaceParser ignoreWhitespaceParser = new IgnoreWhitespaceParser();
        ignoreWhitespaceParser.setEntityResolver(new Resolver());
        ignoreWhitespaceParser.setErrorHandler(new ErrorHandler());
        try {
            ignoreWhitespaceParser.setFeature("http://xml.org/sax/features/validation", false);
            ignoreWhitespaceParser.setFeature("http://xml.org/sax/features/namespaces", true);
            ignoreWhitespaceParser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            sAXNotRecognizedException.printStackTrace();
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            sAXNotSupportedException.printStackTrace();
        }
        try {
            ignoreWhitespaceParser.parse(inputSource);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        Document document = ignoreWhitespaceParser.getDocument();
        Element element2 = null;
        if (document != null) {
            element2 = document.getDocumentElement();
        }
        if (element2 == null) {
            this.fRedefineSucceeded = false;
            return;
        }
        String string2 = this.getTargetNamespaceString(element2);
        if (string2.length() > 0 && !string2.equals(this.fTargetNSURIString)) {
            this.fRedefineSucceeded = false;
            this.reportGenericSchemaError("redefined schema '" + string + "' has a different targetNameSpace '" + string2 + "' from the original schema");
        } else {
            this.fSchemaRootElement = element2;
            this.fCurrentSchemaURL = string;
            this.fNamespacesScope = new NamespacesScope(this);
            if (string2.length() == 0 && element2.getAttributeNode("xmlns") == null) {
                this.fNamespacesScope.setNamespaceForPrefix(0, this.fTargetNSURI);
            }
            this.traverseIncludedSchemaHeader(element2);
            schemaInfo.setNext(new SchemaInfo(this.fElementDefaultQualified, this.fAttributeDefaultQualified, this.fBlockDefault, this.fFinalDefault, this.fCurrentSchemaURL, this.fSchemaRootElement, this.fNamespacesScope, null, schemaInfo));
            schemaInfo.getNext().setPrev(schemaInfo);
            this.fCurrentSchemaInfo = schemaInfo.getNext();
            this.fRedefineLocations.put(string, schemaInfo.getNext());
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void traverseRedefine(Element var1_1) throws Exception {
        var2_2 = GeneralAttrCheck.ELE_CONTEXT_GLOBAL;
        var3_3 = this.generalCheck(var1_1, var2_2);
        this.fRedefineAttributeGroupMap = new Hashtable<K, V>();
        var4_4 = (NamespacesScope)this.fNamespacesScope.clone();
        if (this.fSchemaInfoListRoot == null) {
            this.fSchemaInfoListRoot = new SchemaInfo(this.fElementDefaultQualified, this.fAttributeDefaultQualified, this.fBlockDefault, this.fFinalDefault, this.fCurrentSchemaURL, this.fSchemaRootElement, this.fNamespacesScope, null, null);
            this.openRedefinedSchema(var1_1, this.fSchemaInfoListRoot);
            if (!this.fRedefineSucceeded) {
                return;
            }
            this.fCurrentSchemaInfo = this.fSchemaInfoListRoot.getNext();
            this.fNamespacesScope = (NamespacesScope)var4_4.clone();
            this.renameRedefinedComponents(var1_1, this.fSchemaInfoListRoot.getNext().getRoot(), this.fSchemaInfoListRoot.getNext());
        } else {
            var5_5 = this.fSchemaInfoListRoot;
            while (var5_5.getNext() != null) {
                var5_5 = var5_5.getNext();
            }
            this.fCurrentSchemaInfo = var5_5;
            this.fCurrentSchemaInfo.restore();
            this.openRedefinedSchema(var1_1, this.fCurrentSchemaInfo);
            if (!this.fRedefineSucceeded) {
                return;
            }
            this.fNamespacesScope = (NamespacesScope)var4_4.clone();
            this.renameRedefinedComponents(var1_1, this.fCurrentSchemaInfo.getRoot(), this.fCurrentSchemaInfo);
        }
        this.fCurrentSchemaInfo.restore();
        this.traverseIncludedSchema(this.fSchemaRootElement);
        this.fNamespacesScope = (NamespacesScope)var4_4.clone();
        var5_5 = XUtil.getFirstChildElement(var1_1);
        while (var5_5 != null) {
            block23: {
                block27: {
                    block26: {
                        block25: {
                            block24: {
                                var6_6 = var5_5.getLocalName();
                                if (!var6_6.equals("annotation")) break block24;
                                this.traverseAnnotationDecl((Element)var5_5);
                                break block23;
                            }
                            if (!var6_6.equals("simpleType")) break block25;
                            this.traverseSimpleTypeDecl((Element)var5_5);
                            break block23;
                        }
                        if (!var6_6.equals("complexType")) break block26;
                        this.traverseComplexTypeDecl((Element)var5_5);
                        break block23;
                    }
                    if (!var6_6.equals("group")) break block27;
                    var7_7 = var5_5.getAttribute("name");
                    if (this.fGroupNameRegistry.get(this.fTargetNSURIString + "," + var7_7) == null || this.fRestrictedRedefinedGroupRegistry.get(this.fTargetNSURIString + "," + var7_7) != null && !((Boolean)this.fRestrictedRedefinedGroupRegistry.get(this.fTargetNSURIString + "," + var7_7)).booleanValue()) {
                        this.traverseGroupDecl((Element)var5_5);
                    } else {
                        this.traverseGroupDecl((Element)var5_5);
                        var8_8 /* !! */  = null;
                        try {
                            var8_8 /* !! */  = (GroupInfo)this.fGroupNameRegistry.get(this.fTargetNSURIString + "," + var7_7 + "_fn3dktizrknc9pi");
                        }
                        catch (ClassCastException var9_9) {
                            this.reportGenericSchemaError("src-redefine.6.2:  a <group> within a <redefine> must either have a ref to a <group> with the same name or must restrict such an <group>");
                            break block23;
                        }
                        if (var8_8 /* !! */  != null) {
                            var9_10 = var8_8 /* !! */ .contentSpecIndex;
                            try {
                                var10_13 = (GroupInfo)this.fGroupNameRegistry.get(this.fTargetNSURIString + "," + var7_7);
                            }
                            catch (ClassCastException var11_14) {
                                break block23;
                            }
                            if (var10_13 != null) {
                                var11_15 = var10_13.contentSpecIndex;
                                try {
                                    this.checkParticleDerivationOK(var11_15, -1, var9_10, -1, null);
                                }
                                catch (ParticleRecoverableError var12_18) {
                                    this.reportGenericSchemaError(var12_18.getMessage());
                                }
                            }
                        } else {
                            this.reportGenericSchemaError("src-redefine.6.2:  a <group> within a <redefine> must either have a ref to a <group> with the same name or must restrict such an <group>");
                        }
                    }
                    break block23;
                }
                if (!var6_6.equals("attributeGroup")) break block23;
                if (this.fRedefineAttributeGroupMap == null) ** GOTO lbl-1000
                var7_7 = var5_5.getAttribute("name");
                var8_8 /* !! */  = null;
                try {
                    var8_8 /* !! */  = (Object[])this.fRedefineAttributeGroupMap.get(var7_7);
                }
                catch (ClassCastException var9_11) {
                    this.reportGenericSchemaError("src-redefine.7.2:  an <attributeGroup> within a <redefine> must either have a ref to an <attributeGroup> with the same name or must restrict such an <attributeGroup>");
                    break block23;
                }
                if (var8_8 /* !! */  != null) {
                    var9_12 = (ComplexTypeInfo)var8_8 /* !! */ [0];
                    var10_13 = (SchemaGrammar)var8_8 /* !! */ [1];
                    var11_16 = (Vector)var8_8 /* !! */ [2];
                    var12_17 = var11_16.size() > 0 ? (XMLAttributeDecl)var11_16.elementAt(0) : null;
                    var13_19 = new ComplexTypeInfo();
                    var14_20 = this.fStringPool.addSymbol("$" + var7_7);
                    var15_21 = this.fStringPool.addSymbol("%" + var7_7);
                    var13_19.scopeDefined = -2;
                    var13_19.contentSpecHandle = -1;
                    var13_19.contentType = 5;
                    var13_19.datatypeValidator = null;
                    var13_19.templateElementIndex = this.fSchemaGrammar.addElementDecl(new QName(-1, var14_20, var15_21, this.fTargetNSURI), this.fTargetNSURI == 0 ? 0 : -2, var13_19.scopeDefined, var13_19.contentType, var13_19.contentSpecHandle, -1, var13_19.datatypeValidator);
                    var16_22 = new Vector<E>();
                    var17_23 = var16_22.size() > 0 ? (XMLAttributeDecl)var16_22.elementAt(0) : null;
                    this.traverseAttributeGroupDecl((Element)var5_5, var13_19, var16_22);
                    var13_19.attlistHead = this.fSchemaGrammar.getFirstAttributeDeclIndex(var13_19.templateElementIndex);
                    try {
                        this.checkAttributesDerivationOKRestriction(var13_19.attlistHead, this.fSchemaGrammar, var17_23, var9_12.attlistHead, (SchemaGrammar)var10_13, var12_17);
                    }
                    catch (ComplexTypeRecoverableError var18_24) {
                        var19_25 = var18_24.getMessage();
                        this.reportGenericSchemaError("src-redefine.7.2:  redefinition failed because of " + var19_25);
                    }
                } else lbl-1000:
                // 2 sources

                {
                    this.traverseAttributeGroupDecl((Element)var5_5, null, null);
                }
            }
            var5_5 = XUtil.getNextSiblingElement((Node)var5_5);
        }
        this.fCurrentSchemaInfo = this.fCurrentSchemaInfo.getPrev();
        this.fCurrentSchemaInfo.restore();
    }

    private void renameRedefinedComponents(Element element, Element element2, SchemaInfo schemaInfo) throws Exception {
        Element element3 = XUtil.getFirstChildElement(element);
        while (element3 != null) {
            String string = element3.getLocalName();
            if (!string.equals("annotation")) {
                String string2;
                if (string.equals("simpleType")) {
                    string2 = element3.getAttribute("name");
                    if (!this.fTraversedRedefineElements.contains(string2) && this.validateRedefineNameChange("simpleType", string2, string2 + redefIdentifier, element3)) {
                        this.fixRedefinedSchema("simpleType", string2, string2 + redefIdentifier, element2, schemaInfo);
                    }
                } else if (string.equals("complexType")) {
                    string2 = element3.getAttribute("name");
                    if (!this.fTraversedRedefineElements.contains(string2) && this.validateRedefineNameChange("complexType", string2, string2 + redefIdentifier, element3)) {
                        this.fixRedefinedSchema("complexType", string2, string2 + redefIdentifier, element2, schemaInfo);
                    }
                } else if (string.equals("attributeGroup")) {
                    string2 = element3.getAttribute("name");
                    if (!this.fTraversedRedefineElements.contains(string2) && this.validateRedefineNameChange("attributeGroup", string2, string2 + redefIdentifier, element3)) {
                        this.fixRedefinedSchema("attributeGroup", string2, string2 + redefIdentifier, element2, schemaInfo);
                    }
                } else if (string.equals("group")) {
                    string2 = element3.getAttribute("name");
                    if (!this.fTraversedRedefineElements.contains(string2) && this.validateRedefineNameChange("group", string2, string2 + redefIdentifier, element3)) {
                        this.fixRedefinedSchema("group", string2, string2 + redefIdentifier, element2, schemaInfo);
                    }
                } else {
                    this.fRedefineSucceeded = false;
                    this.reportGenericSchemaError("invalid top-level content for <redefine>");
                    return;
                }
            }
            element3 = XUtil.getNextSiblingElement(element3);
        }
    }

    private int changeRedefineGroup(QName qName, String string, String string2, Element element) throws Exception {
        int n = 0;
        Element element2 = XUtil.getFirstChildElement(element);
        while (element2 != null) {
            String string3 = element2.getLocalName();
            if (!string3.equals(string)) {
                n += this.changeRedefineGroup(qName, string, string2, element2);
            } else {
                String string4 = element2.getAttribute("ref");
                if (string4.length() != 0) {
                    String string5 = "";
                    String string6 = string4;
                    int n2 = string4.indexOf(":");
                    if (n2 > 0) {
                        string5 = string4.substring(0, n2);
                        string6 = string4.substring(n2 + 1);
                    }
                    String string7 = this.resolvePrefixToURI(string5);
                    if (qName.equals(new QName(-1, this.fStringPool.addSymbol(string6), this.fStringPool.addSymbol(string6), this.fStringPool.addSymbol(string7)))) {
                        if (string5.length() == 0) {
                            element2.setAttribute("ref", string2);
                        } else {
                            element2.setAttribute("ref", string5 + ":" + string2);
                        }
                        ++n;
                        if (string.equals("group")) {
                            String string8 = element2.getAttribute("minOccurs");
                            String string9 = element2.getAttribute("maxOccurs");
                            if (string9.length() != 0 && !string9.equals("1") || string8.length() != 0 && !string8.equals("1")) {
                                this.reportGenericSchemaError("src-redefine.6.1.2:  the group " + string4 + " which contains a reference to a group being redefined must have minOccurs = maxOccurs = 1");
                            }
                        }
                    }
                }
            }
            element2 = XUtil.getNextSiblingElement(element2);
        }
        return n;
    }

    private void fixRedefinedSchema(String string, String string2, String string3, Element element, SchemaInfo schemaInfo) throws Exception {
        boolean bl = false;
        Element element2 = XUtil.getFirstChildElement(element);
        while (element2 != null) {
            Object object;
            String string4 = element2.getLocalName();
            if (string4.equals("redefine")) {
                object = XUtil.getFirstChildElement(element2);
                while (object != null) {
                    String string5;
                    String string6 = object.getLocalName();
                    if (string6.equals(string) && (string5 = object.getAttribute("name")).equals(string2)) {
                        bl = true;
                        this.openRedefinedSchema(element2, schemaInfo);
                        if (!this.fRedefineSucceeded) {
                            return;
                        }
                        NamespacesScope namespacesScope = (NamespacesScope)this.fNamespacesScope.clone();
                        schemaInfo.restore();
                        if (this.validateRedefineNameChange(string, string2, string3 + redefIdentifier, (Element)object) && schemaInfo.getNext() != null) {
                            schemaInfo.getNext().restore();
                            this.fixRedefinedSchema(string, string2, string3 + redefIdentifier, this.fSchemaRootElement, schemaInfo.getNext());
                        }
                        this.fNamespacesScope = namespacesScope;
                        object.setAttribute("name", string3);
                        this.fTraversedRedefineElements.addElement(string3);
                        schemaInfo.restore();
                        this.fCurrentSchemaInfo = schemaInfo;
                        break;
                    }
                    object = XUtil.getNextSiblingElement((Node)object);
                }
                if (bl) {
                    break;
                }
            } else if (string4.equals(string) && ((String)(object = element2.getAttribute("name"))).equals(string2)) {
                bl = true;
                element2.setAttribute("name", string3);
                break;
            }
            element2 = XUtil.getNextSiblingElement(element2);
        }
        if (!bl) {
            this.fRedefineSucceeded = false;
            this.reportGenericSchemaError("could not find a declaration in the schema to be redefined corresponding to " + string2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean validateRedefineNameChange(String string, String string2, String string3, Element element) throws Exception {
        if (string.equals("simpleType")) {
            QName qName = new QName(-1, this.fStringPool.addSymbol(string2), this.fStringPool.addSymbol(string2), this.fTargetNSURI);
            Element element2 = XUtil.getFirstChildElement(element);
            if (element2 == null) {
                this.fRedefineSucceeded = false;
                this.reportGenericSchemaError("a simpleType child of a <redefine> must have a restriction element as a child");
                return false;
            }
            String string4 = element2.getLocalName();
            if (string4.equals("annotation")) {
                element2 = XUtil.getNextSiblingElement(element2);
                string4 = element2.getLocalName();
            }
            if (element2 == null) {
                this.fRedefineSucceeded = false;
                this.reportGenericSchemaError("a simpleType child of a <redefine> must have a restriction element as a child");
                return false;
            }
            if (!string4.equals("restriction")) {
                this.fRedefineSucceeded = false;
                this.reportGenericSchemaError("a simpleType child of a <redefine> must have a restriction element as a child");
                return false;
            }
            String string5 = element2.getAttribute("base");
            QName qName2 = this.parseBase(string5);
            if (!qName.equals(qName2)) {
                this.fRedefineSucceeded = false;
                this.reportGenericSchemaError("the base attribute of the restriction child of a simpleType child of a redefine must have the same value as the simpleType's type attribute");
                return false;
            }
            String string6 = "";
            int n = string5.indexOf(":");
            if (n > 0) {
                string6 = string5.substring(0, n) + ":";
            }
            element2.setAttribute("base", string6 + string3);
            return true;
        }
        if (string.equals("complexType")) {
            QName qName = new QName(-1, this.fStringPool.addSymbol(string2), this.fStringPool.addSymbol(string2), this.fTargetNSURI);
            Element element3 = XUtil.getFirstChildElement(element);
            if (element3 == null) {
                this.fRedefineSucceeded = false;
                this.reportGenericSchemaError("a complexType child of a <redefine> must have a restriction or extension element as a grandchild");
                return false;
            }
            if (element3.getLocalName().equals("annotation")) {
                element3 = XUtil.getNextSiblingElement(element3);
            }
            if (element3 == null) {
                this.fRedefineSucceeded = false;
                this.reportGenericSchemaError("a complexType child of a <redefine> must have a restriction or extension element as a grandchild");
                return false;
            }
            Element element4 = XUtil.getFirstChildElement(element3);
            if (element4 == null) {
                this.fRedefineSucceeded = false;
                this.reportGenericSchemaError("a complexType child of a <redefine> must have a restriction or extension element as a grandchild");
                return false;
            }
            String string7 = element4.getLocalName();
            if (string7.equals("annotation")) {
                element4 = XUtil.getNextSiblingElement(element4);
                string7 = element4.getLocalName();
            }
            if (element4 == null) {
                this.fRedefineSucceeded = false;
                this.reportGenericSchemaError("a complexType child of a <redefine> must have a restriction or extension element as a grandchild");
                return false;
            }
            if (!string7.equals("restriction") && !string7.equals("extension")) {
                this.fRedefineSucceeded = false;
                this.reportGenericSchemaError("a complexType child of a <redefine> must have a restriction or extension element as a grandchild");
                return false;
            }
            String string8 = element4.getAttribute("base");
            QName qName3 = this.parseBase(string8);
            if (!qName.equals(qName3)) {
                this.fRedefineSucceeded = false;
                this.reportGenericSchemaError("the base attribute of the restriction or extension grandchild of a complexType child of a redefine must have the same value as the complexType's type attribute");
                return false;
            }
            String string9 = "";
            int n = string8.indexOf(":");
            if (n > 0) {
                string9 = string8.substring(0, n) + ":";
            }
            element4.setAttribute("base", string9 + string3);
            return true;
        }
        if (string.equals("attributeGroup")) {
            QName qName = new QName(-1, this.fStringPool.addSymbol(string2), this.fStringPool.addSymbol(string2), this.fTargetNSURI);
            int n = this.changeRedefineGroup(qName, string, string3, element);
            if (n > 1) {
                this.fRedefineSucceeded = false;
                this.reportGenericSchemaError("if an attributeGroup child of a <redefine> element contains an attributeGroup ref'ing itself, it must have exactly 1; this one has " + n);
                return false;
            }
            if (n == 1) {
                return true;
            }
            this.fRedefineAttributeGroupMap.put(string2, string3);
            return false;
        }
        if (!string.equals("group")) {
            this.fRedefineSucceeded = false;
            this.reportGenericSchemaError("internal Xerces error; please submit a bug with schema as testcase");
            return false;
        }
        QName qName = new QName(-1, this.fStringPool.addSymbol(string2), this.fStringPool.addSymbol(string2), this.fTargetNSURI);
        int n = this.changeRedefineGroup(qName, string, string3, element);
        String string10 = string3.substring(0, string3.length() - redefIdentifier.length());
        if (!this.fRedefineSucceeded) {
            this.fRestrictedRedefinedGroupRegistry.put(this.fTargetNSURIString + "," + string10, new Boolean(false));
        }
        if (n > 1) {
            this.fRedefineSucceeded = false;
            this.fRestrictedRedefinedGroupRegistry.put(this.fTargetNSURIString + "," + string10, new Boolean(false));
            this.reportGenericSchemaError("if a group child of a <redefine> element contains a group ref'ing itself, it must have exactly 1; this one has " + n);
            return false;
        }
        if (n == 1) {
            this.fRestrictedRedefinedGroupRegistry.put(this.fTargetNSURIString + "," + string10, new Boolean(false));
            return true;
        }
        this.fGroupNameRegistry.put(this.fTargetNSURIString + "," + string2, string3);
        this.fRestrictedRedefinedGroupRegistry.put(this.fTargetNSURIString + "," + string10, new Boolean(true));
        return false;
    }

    private void traverseImport(Element element) throws Exception {
        SchemaGrammar schemaGrammar;
        int n = GeneralAttrCheck.ELE_CONTEXT_GLOBAL;
        Hashtable hashtable = this.generalCheck(element, n);
        this.checkContent(element, XUtil.getFirstChildElement(element), true);
        String string = element.getAttribute("schemaLocation");
        InputSource inputSource = null;
        if (this.fEntityResolver != null) {
            inputSource = this.fEntityResolver.resolveEntity("", string);
        }
        if (inputSource == null) {
            string = this.expandSystemId(string, this.fCurrentSchemaURL);
            inputSource = new InputSource(string);
        } else {
            if (inputSource.getPublicId() != null) {
                string = inputSource.getPublicId();
            }
            string = string + ',' + inputSource.getSystemId();
        }
        if (this.fImportLocations.contains(string)) {
            return;
        }
        this.fImportLocations.addElement(string);
        if (inputSource.getSystemId().equals(this.fCurrentSchemaURL)) {
            return;
        }
        String string2 = element.getAttribute("namespace");
        if (string2.length() == 0) {
            if (this.fTargetNSURI == 0) {
                this.reportGenericSchemaError("src-import.1.2:  if the namespace attribute on an <import> element is not present, the <import>ing schema must have a targetNamespace");
            }
        } else if (this.fTargetNSURIString.equals(string2.trim())) {
            this.reportGenericSchemaError("src-import.1.1:  the namespace attribute of an <import> element must not be the same as the targetNamespace of the <import>ing schema");
        }
        if ((schemaGrammar = (SchemaGrammar)this.fGrammarResolver.getGrammar(string2)) != null) {
            return;
        }
        schemaGrammar = new SchemaGrammar();
        IgnoreWhitespaceParser ignoreWhitespaceParser = new IgnoreWhitespaceParser();
        ignoreWhitespaceParser.setEntityResolver(new Resolver());
        ignoreWhitespaceParser.setErrorHandler(new ErrorHandler(){

            public void fatalError(SAXParseException sAXParseException) throws SAXException {
                StringBuffer stringBuffer = new StringBuffer();
                String string = sAXParseException.getSystemId();
                if (string != null) {
                    int n = string.lastIndexOf(47);
                    if (n != -1) {
                        string = string.substring(n + 1);
                    }
                    stringBuffer.append(string);
                }
                stringBuffer.append(':').append(sAXParseException.getLineNumber()).append(':').append(sAXParseException.getColumnNumber());
                String string2 = sAXParseException.getMessage();
                if (!string2.toLowerCase().trim().endsWith("not found.")) {
                    System.err.println("[Fatal Error] " + stringBuffer.toString() + ":" + string2);
                    throw sAXParseException;
                }
                System.err.println("[Warning] " + stringBuffer.toString() + ": " + string2);
            }
        });
        try {
            ignoreWhitespaceParser.setFeature("http://xml.org/sax/features/validation", false);
            ignoreWhitespaceParser.setFeature("http://xml.org/sax/features/namespaces", true);
            ignoreWhitespaceParser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            sAXNotRecognizedException.printStackTrace();
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            sAXNotSupportedException.printStackTrace();
        }
        try {
            ignoreWhitespaceParser.parse(inputSource);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        Document document = ignoreWhitespaceParser.getDocument();
        Element element2 = null;
        if (document != null) {
            element2 = document.getDocumentElement();
        }
        if (element2 != null) {
            String string3 = this.getTargetNamespaceString(element2);
            if (!string3.equals(string2)) {
                this.reportGenericSchemaError("imported schema '" + string + "' has a different targetNameSpace '" + string3 + "' from what is declared '" + string2 + "'.");
            } else {
                Object object;
                TraverseSchema traverseSchema = new TraverseSchema(element2, this.fStringPool, schemaGrammar, this.fGrammarResolver, this.fErrorReporter, string, this.fEntityResolver, this.fFullConstraintChecking, this.fGeneralAttrCheck);
                Enumeration enumeration = traverseSchema.fIdentityConstraints.keys();
                while (enumeration.hasMoreElements()) {
                    object = enumeration.nextElement();
                    this.fIdentityConstraints.put(object, traverseSchema.fIdentityConstraints.get(object));
                }
                object = traverseSchema.fIdentityConstraintNames.keys();
                while (object.hasMoreElements()) {
                    String string4 = (String)object.nextElement();
                    this.fIdentityConstraintNames.put(string4, traverseSchema.fIdentityConstraintNames.get(string4));
                }
            }
        } else {
            this.reportGenericSchemaError("Could not get the doc root for imported Schema file: " + string);
        }
    }

    private String getTargetNamespaceString(Element element) throws Exception {
        String string = "";
        Attr attr = element.getAttributeNode("targetNamespace");
        if (attr != null && (string = attr.getValue()).length() == 0) {
            this.reportGenericSchemaError("sch-prop-correct.1:  \"\" is not a legal value for the targetNamespace attribute; the attribute must either be absent or contain a nonempty value");
        }
        return string;
    }

    private void traverseAnnotationDecl(Element element) throws Exception {
        int n = GeneralAttrCheck.ELE_CONTEXT_LOCAL;
        Hashtable hashtable = this.generalCheck(element, n);
        Element element2 = XUtil.getFirstChildElement(element);
        while (element2 != null) {
            String string = element2.getLocalName();
            if (!string.equals("appinfo") && !string.equals("documentation")) {
                this.reportGenericSchemaError("an <annotation> can only contain <appinfo> and <documentation> elements");
            }
            hashtable = this.generalCheck(element2, n);
            element2 = XUtil.getNextSiblingElement(element2);
        }
    }

    private Element checkContent(Element element, Element element2, boolean bl) throws Exception {
        if (element2 == null) {
            if (!bl) {
                this.reportSchemaError(25, new Object[]{element.getAttribute("name")});
            }
            return null;
        }
        if (element2.getLocalName().equals("annotation")) {
            this.traverseAnnotationDecl(element2);
            element2 = XUtil.getNextSiblingElement(element2);
            if (element2 == null) {
                if (!bl) {
                    this.reportSchemaError(25, new Object[]{element.getAttribute("name")});
                }
                return null;
            }
            if (element2.getLocalName().equals("annotation")) {
                this.reportSchemaError(26, new Object[]{element.getAttribute("name")});
                return null;
            }
        }
        return element2;
    }

    private DatatypeValidator findDTValidator(Element element, String string, int n) throws Exception {
        Object object;
        String string2;
        int n2 = this.fStringPool.addSymbol(string);
        String string3 = "";
        DatatypeValidator datatypeValidator = null;
        String string4 = string;
        int n3 = string.indexOf(":");
        if (n3 > 0) {
            string3 = string.substring(0, n3);
            string4 = string.substring(n3 + 1);
        }
        if ((datatypeValidator = this.getDatatypeValidator(string2 = this.resolvePrefixToURI(string3), string4)) == null && (object = this.getTopLevelComponentByName("simpleType", string4)) != null) {
            this.traverseSimpleTypeDecl((Element)object);
            datatypeValidator = this.getDatatypeValidator(string2, string4);
        }
        if (datatypeValidator == null) {
            this.reportSchemaError(15, new Object[]{element.getAttribute("base"), element.getAttribute("name")});
        } else {
            object = (Integer)this.fSimpleTypeFinalRegistry.get(string2 + "," + string4);
            if (object != null && ((Integer)object & n) != 0) {
                this.reportGenericSchemaError("the base type " + string + " does not allow itself to be used as the base for a restriction and/or as a type in a list and/or union");
                return datatypeValidator;
            }
        }
        return datatypeValidator;
    }

    private void checkEnumerationRequiredNotation(String string, String string2) throws Exception {
        String string3 = string2;
        int n = string2.indexOf(":");
        if (n > 0) {
            string3 = string2.substring(n + 1);
        }
        if (string3.equals("NOTATION")) {
            this.reportGenericSchemaError("[enumeration-required-notation] It is an error for NOTATION to be used directly in a schema in element/attribute '" + string + "'");
        }
    }

    private int resetSimpleTypeNameStack(int n) {
        if (!this.fSimpleTypeNameStack.empty()) {
            this.fSimpleTypeNameStack.pop();
        }
        return n;
    }

    private void reportCosListOfAtomic() throws Exception {
        this.reportGenericSchemaError("cos-list-of-atomic: The itemType must have a {variety} of atomic or union (in which case all the {member type definitions} must be atomic)");
        this.fListName = "";
    }

    private boolean isListDatatype(DatatypeValidator datatypeValidator) {
        if (datatypeValidator instanceof UnionDatatypeValidator) {
            Vector vector = ((UnionDatatypeValidator)datatypeValidator).getBaseValidators();
            int n = 0;
            while (n < vector.size()) {
                if (vector.elementAt(n) instanceof ListDatatypeValidator) {
                    return true;
                }
                if (vector.elementAt(n) instanceof UnionDatatypeValidator && this.isListDatatype((DatatypeValidator)vector.elementAt(n))) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private int traverseSimpleTypeDecl(Element var1_1) throws Exception {
        var2_2 = this.isTopLevel(var1_1) != false ? GeneralAttrCheck.ELE_CONTEXT_GLOBAL : GeneralAttrCheck.ELE_CONTEXT_LOCAL;
        var3_3 = this.generalCheck(var1_1, var2_2);
        var5_5 = var4_4 = var1_1.getAttribute("name");
        if (var4_4.length() == 0) {
            var5_5 = this.fTargetNSURIString + "," + "#S#" + this.fSimpleTypeAnonCount++;
            this.fStringPool.addSymbol(var5_5);
        } else {
            var5_5 = this.fTargetNSURIString + "," + var5_5;
            this.fStringPool.addSymbol(var4_4);
        }
        if (this.fDatatypeRegistry.getDatatypeValidator(var5_5) != null) {
            return this.resetSimpleTypeNameStack(this.fStringPool.addSymbol(var5_5));
        }
        if (this.fSimpleTypeNameStack.search(var5_5) != -1) {
            this.reportGenericSchemaError("cos-no-circular-unions: no circular definitions are allowed for an element '" + var4_4 + "'");
            return this.resetSimpleTypeNameStack(-1);
        }
        var6_6 = var1_1.getAttributeNode("final");
        var7_7 = 0;
        var7_7 = var6_6 != null ? this.parseFinalSet(var6_6.getValue()) : this.parseFinalSet(null);
        if (var7_7 != 0) {
            this.fSimpleTypeFinalRegistry.put(var5_5, new Integer(var7_7));
        }
        this.fSimpleTypeNameStack.push(var5_5);
        var8_8 = XUtil.getFirstChildElement(var1_1);
        var8_8 = this.checkContent(var1_1, var8_8, false);
        if (var8_8 == null) {
            return this.resetSimpleTypeNameStack(-1);
        }
        var2_2 = GeneralAttrCheck.ELE_CONTEXT_LOCAL;
        var9_9 = this.generalCheck(var8_8, var2_2);
        var10_10 = var8_8.getLocalName();
        var11_11 = null;
        var12_12 = null;
        var13_13 = 0;
        var14_14 = null;
        var15_15 = false;
        var16_16 = false;
        var17_17 = false;
        var18_18 = 0;
        if (var10_10.equals("list")) {
            var11_11 = var8_8.getAttribute("itemType");
            var15_15 = true;
            if (this.fListName.length() != 0) {
                this.reportCosListOfAtomic();
                return this.resetSimpleTypeNameStack(-1);
            }
            this.fListName = var5_5;
        } else if (var10_10.equals("restriction")) {
            var11_11 = var8_8.getAttribute("base");
            var17_17 = true;
        } else if (var10_10.equals("union")) {
            var16_16 = true;
            var11_11 = var8_8.getAttribute("memberTypes");
            if (var11_11.length() != 0) {
                var14_14 = new StringTokenizer(var11_11);
                var13_13 = var14_14.countTokens();
            } else {
                var13_13 = 1;
            }
            var12_12 = new Vector<DatatypeValidator>(var13_13, 2);
        } else {
            this.reportSchemaError(7, new Object[]{var10_10});
            return -1;
        }
        if (XUtil.getNextSiblingElement(var8_8) != null) {
            this.reportGenericSchemaError("error in content of simpleType");
        }
        var20_19 = null;
        if (var11_11.length() != 0) ** GOTO lbl81
        var8_8 = XUtil.getFirstChildElement(var8_8);
        if ((var8_8 = this.checkContent(var1_1, var8_8, false)) == null) {
            return this.resetSimpleTypeNameStack(-1);
        }
        if (var8_8.getLocalName().equals("simpleType")) {
            var19_20 = this.traverseSimpleTypeDecl(var8_8);
            if (var19_20 != -1 && (var20_19 = this.fDatatypeRegistry.getDatatypeValidator(this.fStringPool.toString(var19_20))) != null && var16_16) {
                var12_12.addElement(var20_19);
            }
            if (var19_20 == -1 || var20_19 == null) {
                this.reportSchemaError(15, new Object[]{var8_8.getAttribute("base"), var8_8.getAttribute("name")});
                return this.resetSimpleTypeNameStack(-1);
            }
        } else {
            this.reportSchemaError(27, new Object[]{var1_1.getAttribute("name")});
            return this.resetSimpleTypeNameStack(-1);
lbl81:
            // 1 sources

            var18_18 = 1;
            if (var16_16) {
                var18_18 = var13_13;
            }
            var21_21 = var17_17 != false ? 2 : 0;
            var21_21 |= var16_16 != false ? 4 : 0;
            var21_21 |= var15_15 != false ? 8 : 0;
            var22_22 = 0;
            while (var22_22 < var18_18) {
                if (var16_16) {
                    var11_11 = var14_14.nextToken();
                }
                if ((var20_19 = this.findDTValidator(var1_1, var11_11, var21_21)) == null) {
                    return this.resetSimpleTypeNameStack(-1);
                }
                if (this.fListName.length() != 0) {
                    if (var20_19 instanceof ListDatatypeValidator) {
                        this.reportCosListOfAtomic();
                        return this.resetSimpleTypeNameStack(-1);
                    }
                    if (this.isListDatatype(var20_19)) {
                        this.reportCosListOfAtomic();
                        return this.resetSimpleTypeNameStack(-1);
                    }
                }
                if (var16_16) {
                    var12_12.addElement(var20_19);
                }
                if (var15_15 && var20_19 instanceof UnionDatatypeValidator) {
                    this.reportSchemaError(15, new Object[]{var1_1.getAttribute("base"), var1_1.getAttribute("name")});
                    return -1;
                }
                ++var22_22;
            }
        }
        var8_8 = var11_11.length() == 0 ? XUtil.getNextSiblingElement(var8_8) : XUtil.getFirstChildElement(var8_8);
        if (var16_16) {
            var21_21 = var13_13;
            if (var11_11.length() != 0) {
                var8_8 = this.checkContent(var1_1, var8_8, true);
            }
            while (var8_8 != null) {
                var19_20 = this.traverseSimpleTypeDecl(var8_8);
                if (var19_20 != -1 && (var20_19 = this.fDatatypeRegistry.getDatatypeValidator(this.fStringPool.toString(var19_20))) != null) {
                    if (this.fListName.length() != 0 && var20_19 instanceof ListDatatypeValidator) {
                        this.reportCosListOfAtomic();
                        return this.resetSimpleTypeNameStack(-1);
                    }
                    var12_12.addElement(var20_19);
                }
                if (var20_19 == null || var19_20 == -1) {
                    this.reportSchemaError(15, new Object[]{var1_1.getAttribute("base"), var1_1.getAttribute("name")});
                    return -1;
                }
                var8_8 = XUtil.getNextSiblingElement(var8_8);
            }
        }
        if (this.fListName.length() != 0 && this.fListName.equals(var5_5)) {
            this.fListName = "";
        }
        var21_21 = 0;
        this.fFacetData.clear();
        if (var17_17 && var8_8 != null) {
            var22_22 = 0;
            var23_25 = 0;
            var24_26 = new Vector<String>();
            var8_8 = this.checkContent(var1_1, var8_8, true);
            var25_27 = null;
            while (var8_8 != null) {
                if (var8_8.getNodeType() == 1) {
                    var9_9 = this.generalCheck(var8_8, var2_2);
                    ++var21_21;
                    var26_28 = var8_8.getLocalName();
                    if (var26_28.equals("enumeration")) {
                        ++var23_25;
                        var27_29 = var8_8.getAttribute("value");
                        if (var20_19 instanceof NOTATIONDatatypeValidator) {
                            var29_31 = "";
                            var30_32 = var27_29;
                            var31_33 = var27_29.indexOf(":");
                            if (var31_33 > 0) {
                                var29_31 = var27_29.substring(0, var31_33);
                                var30_32 = var27_29.substring(var31_33 + 1);
                            }
                            var32_34 = var29_31.length() != 0 ? this.resolvePrefixToURI(var29_31) : this.fTargetNSURIString;
                            var4_4 = var32_34 + ":" + var30_32;
                            var28_30 = (String)this.fNotationRegistry.get(var4_4);
                            if (var28_30 == null && (var28_30 = this.traverseNotationFromAnotherSchema(var30_32, var32_34)) == null) {
                                this.reportGenericSchemaError("Notation '" + var30_32 + "' not found in the grammar " + var32_34);
                            }
                            var27_29 = var4_4;
                        }
                        var24_26.addElement(var27_29);
                        this.checkContent(var1_1, XUtil.getFirstChildElement(var8_8), true);
                    } else if (var26_28.equals("annotation") || var26_28.equals("simpleType")) {
                        this.reportSchemaError(27, new Object[]{var1_1.getAttribute("name")});
                    } else if (var26_28.equals("pattern")) {
                        if (var25_27 == null) {
                            var25_27 = new StringBuffer(var8_8.getAttribute("value"));
                        } else {
                            var25_27.append("|");
                            var25_27.append(var8_8.getAttribute("value"));
                            this.checkContent(var1_1, XUtil.getFirstChildElement(var8_8), true);
                        }
                    } else {
                        if (this.fFacetData.containsKey(var26_28)) {
                            this.reportSchemaError(21, new Object[]{"The facet '" + var26_28 + "' is defined more than once."});
                        }
                        this.fFacetData.put(var26_28, var8_8.getAttribute("value"));
                        if (var8_8.getAttribute("fixed").equals("true") || var8_8.getAttribute("fixed").equals("1")) {
                            if (var26_28.equals("minLength")) {
                                var22_22 = (short)(var22_22 | 2);
                            } else if (var26_28.equals("maxLength")) {
                                var22_22 = (short)(var22_22 | 4);
                            } else if (var26_28.equals("maxExclusive")) {
                                var22_22 = (short)(var22_22 | 64);
                            } else if (var26_28.equals("maxInclusive")) {
                                var22_22 = (short)(var22_22 | 32);
                            } else if (var26_28.equals("minExclusive")) {
                                var22_22 = (short)(var22_22 | 256);
                            } else if (var26_28.equals("minInclusive")) {
                                var22_22 = (short)(var22_22 | 128);
                            } else if (var26_28.equals("totalDigits")) {
                                var22_22 = (short)(var22_22 | 512);
                            } else if (var26_28.equals("fractionDigits")) {
                                var22_22 = (short)(var22_22 | 1024);
                            } else if (var26_28.equals("whiteSpace") && var20_19 instanceof StringDatatypeValidator) {
                                var22_22 = (short)(var22_22 | 16384);
                            }
                        }
                        this.checkContent(var1_1, XUtil.getFirstChildElement(var8_8), true);
                    }
                }
                var8_8 = XUtil.getNextSiblingElement(var8_8);
            }
            if (var23_25 > 0) {
                this.fFacetData.put("enumeration", var24_26);
            }
            if (var25_27 != null) {
                this.fFacetData.put("pattern", var25_27.toString());
            }
            if (var22_22 != 0) {
                this.fFacetData.put("fixed", new Short(var22_22));
            }
        } else if (var15_15 && var8_8 != null) {
            if (var11_11.length() != 0) {
                if ((var8_8 = this.checkContent(var1_1, var8_8, true)) != null) {
                    this.reportSchemaError(27, new Object[]{var1_1.getAttribute("name")});
                }
            } else {
                this.reportSchemaError(27, new Object[]{var1_1.getAttribute("name")});
            }
        } else if (var16_16 && var8_8 != null) {
            if (var11_11.length() != 0) {
                if ((var8_8 = this.checkContent(var1_1, var8_8, true)) != null) {
                    this.reportSchemaError(27, new Object[]{var1_1.getAttribute("name")});
                }
            } else {
                this.reportSchemaError(27, new Object[]{var1_1.getAttribute("name")});
            }
        }
        try {
            var22_23 = this.fDatatypeRegistry.getDatatypeValidator(var5_5);
            if (var22_23 == null) {
                if (var15_15) {
                    this.fDatatypeRegistry.createDatatypeValidator(var5_5, var20_19, this.fFacetData, true);
                } else if (var17_17) {
                    this.fDatatypeRegistry.createDatatypeValidator(var5_5, var20_19, this.fFacetData, false);
                } else {
                    this.fDatatypeRegistry.createDatatypeValidator(var5_5, var12_12);
                }
            }
        }
        catch (Exception var22_24) {
            this.reportSchemaError(21, new Object[]{var22_24.getMessage()});
        }
        return this.resetSimpleTypeNameStack(this.fStringPool.addSymbol(var5_5));
    }

    private int traverseAny(Element element) throws Exception {
        int n = GeneralAttrCheck.ELE_CONTEXT_LOCAL;
        Hashtable hashtable = this.generalCheck(element, n);
        Element element2 = this.checkContent(element, XUtil.getFirstChildElement(element), true);
        if (element2 != null) {
            this.reportGenericSchemaError("<any> elements can contain at most one <annotation> element in their children");
        }
        int n2 = -1;
        String string = element.getAttribute("namespace").trim();
        String string2 = element.getAttribute("processContents").trim();
        int n3 = 6;
        int n4 = 7;
        int n5 = 8;
        if (string2.length() > 0 && !string2.equals("strict")) {
            if (string2.equals("lax")) {
                n3 = 22;
                n4 = 23;
                n5 = 24;
            } else if (string2.equals("skip")) {
                n3 = 38;
                n4 = 39;
                n5 = 40;
            }
        }
        if (string.length() == 0 || string.equals("##any")) {
            n2 = this.fSchemaGrammar.addContentSpecNode(n3, -1, 0, false);
        } else if (string.equals("##other")) {
            String string3 = this.fTargetNSURIString;
            int n6 = this.fStringPool.addSymbol(string3);
            n2 = this.fSchemaGrammar.addContentSpecNode(n4, -1, n6, false);
        } else if (string.length() > 0) {
            int n7;
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            String string4 = stringTokenizer.nextToken();
            if (string4.equals("##local")) {
                n7 = 0;
            } else {
                if (string4.equals("##targetNamespace")) {
                    string4 = this.fTargetNSURIString;
                }
                n7 = this.fStringPool.addSymbol(string4);
            }
            int n8 = this.fSchemaGrammar.addContentSpecNode(n5, -1, n7, false);
            int[] nArray = new int[8];
            nArray[0] = n7;
            int n9 = 1;
            while (stringTokenizer.hasMoreElements()) {
                string4 = stringTokenizer.nextToken();
                if (string4.equals("##local")) {
                    n7 = 0;
                } else {
                    if (string4.equals("##targetNamespace")) {
                        string4 = this.fTargetNSURIString;
                    }
                    n7 = this.fStringPool.addSymbol(string4);
                }
                int n10 = 0;
                while (n10 < n9) {
                    if (nArray[n10] == n7) {
                        // empty if block
                    }
                    ++n10;
                }
                if (nArray.length == n9) {
                    int[] nArray2 = new int[n9 * 2];
                    System.arraycopy(nArray, 0, nArray2, 0, n9);
                    nArray = nArray2;
                }
                nArray[n9++] = n7;
                int n11 = this.fSchemaGrammar.addContentSpecNode(n5, -1, n7, false);
                n8 = this.fSchemaGrammar.addContentSpecNode(4, n8, n11, false);
            }
            n2 = n8;
        } else {
            this.reportGenericSchemaError("Empty namespace attribute for any element");
        }
        return n2;
    }

    public DatatypeValidator getDatatypeValidator(String string, String string2) {
        DatatypeValidator datatypeValidator = null;
        datatypeValidator = string.equals("http://www.w3.org/2001/XMLSchema") ? this.fDatatypeRegistry.getDatatypeValidator(string2) : this.fDatatypeRegistry.getDatatypeValidator(string + "," + string2);
        return datatypeValidator;
    }

    private XMLAttributeDecl traverseAnyAttribute(Element element) throws Exception {
        int n = GeneralAttrCheck.ELE_CONTEXT_LOCAL;
        Hashtable hashtable = this.generalCheck(element, n);
        Element element2 = this.checkContent(element, XUtil.getFirstChildElement(element), true);
        if (element2 != null) {
            this.reportGenericSchemaError("<anyAttribute> elements can contain at most one <annotation> element in their children");
        }
        XMLAttributeDecl xMLAttributeDecl = new XMLAttributeDecl();
        String string = element.getAttribute("processContents").trim();
        String string2 = element.getAttribute("namespace").trim();
        String string3 = this.fTargetNSURIString;
        if (string2.length() == 0 || string2.equals("##any")) {
            xMLAttributeDecl.type = 8;
        } else if (string2.equals("##other")) {
            xMLAttributeDecl.type = 9;
            xMLAttributeDecl.name.uri = this.fStringPool.addSymbol(string3);
        } else if (string2.length() > 0) {
            xMLAttributeDecl.type = 11;
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            int n2 = this.fStringPool.startStringList();
            Vector vector = new Vector();
            while (stringTokenizer.hasMoreElements()) {
                int n3;
                String string4 = stringTokenizer.nextToken();
                if (string4.equals("##local")) {
                    n3 = 0;
                } else {
                    if (string4.equals("##targetNamespace")) {
                        string4 = string3;
                    }
                    n3 = this.fStringPool.addSymbol(string4);
                }
                if (this.fStringPool.addStringToList(n2, n3)) continue;
                this.reportGenericSchemaError("Internal StringPool error when reading the namespace attribute for anyattribute declaration");
            }
            this.fStringPool.finishStringList(n2);
            xMLAttributeDecl.enumeration = n2;
        } else {
            this.reportGenericSchemaError("Empty namespace attribute for anyattribute declaration");
        }
        xMLAttributeDecl.defaultType = string.equals("skip") ? (xMLAttributeDecl.defaultType |= 0x1000) : (string.equals("lax") ? (xMLAttributeDecl.defaultType |= 0x800) : (xMLAttributeDecl.defaultType |= 0x400));
        return xMLAttributeDecl;
    }

    private XMLAttributeDecl AWildCardIntersection(XMLAttributeDecl xMLAttributeDecl, XMLAttributeDecl xMLAttributeDecl2) {
        if (xMLAttributeDecl.type == -1) {
            return xMLAttributeDecl;
        }
        if (xMLAttributeDecl2.type == -1) {
            return xMLAttributeDecl2;
        }
        if (xMLAttributeDecl.type == 8) {
            return xMLAttributeDecl2;
        }
        if (xMLAttributeDecl2.type == 8) {
            return xMLAttributeDecl;
        }
        if (xMLAttributeDecl.type == 9 && xMLAttributeDecl2.type == 11 || xMLAttributeDecl.type == 11 && xMLAttributeDecl2.type == 9) {
            XMLAttributeDecl xMLAttributeDecl3;
            XMLAttributeDecl xMLAttributeDecl4;
            if (xMLAttributeDecl.type == 11) {
                xMLAttributeDecl4 = xMLAttributeDecl;
                xMLAttributeDecl3 = xMLAttributeDecl2;
            } else {
                xMLAttributeDecl4 = xMLAttributeDecl2;
                xMLAttributeDecl3 = xMLAttributeDecl;
            }
            int[] nArray = this.fStringPool.stringListAsIntArray(xMLAttributeDecl4.enumeration);
            if (this.elementInSet(xMLAttributeDecl3.name.uri, nArray)) {
                int n = this.fStringPool.startStringList();
                int n2 = 0;
                while (n2 < nArray.length) {
                    if (nArray[n2] != xMLAttributeDecl3.name.uri) {
                        this.fStringPool.addStringToList(n, nArray[n2]);
                    }
                    ++n2;
                }
                this.fStringPool.finishStringList(n);
                xMLAttributeDecl4.enumeration = n;
            }
            return xMLAttributeDecl4;
        }
        if (xMLAttributeDecl.type == 11 && xMLAttributeDecl2.type == 11) {
            int[] nArray = this.intersect2sets(this.fStringPool.stringListAsIntArray(xMLAttributeDecl.enumeration), this.fStringPool.stringListAsIntArray(xMLAttributeDecl2.enumeration));
            int n = this.fStringPool.startStringList();
            int n3 = 0;
            while (n3 < nArray.length) {
                this.fStringPool.addStringToList(n, nArray[n3]);
                ++n3;
            }
            this.fStringPool.finishStringList(n);
            xMLAttributeDecl.enumeration = n;
            return xMLAttributeDecl;
        }
        if (xMLAttributeDecl.type == 9 && xMLAttributeDecl2.type == 9) {
            if (xMLAttributeDecl.name.uri == xMLAttributeDecl2.name.uri) {
                return xMLAttributeDecl;
            }
            xMLAttributeDecl.type = -1;
            return xMLAttributeDecl;
        }
        return xMLAttributeDecl;
    }

    private XMLAttributeDecl AWildCardUnion(XMLAttributeDecl xMLAttributeDecl, XMLAttributeDecl xMLAttributeDecl2) {
        if (xMLAttributeDecl.type == -1) {
            return xMLAttributeDecl;
        }
        if (xMLAttributeDecl2.type == -1) {
            return xMLAttributeDecl2;
        }
        if (xMLAttributeDecl.type == 8) {
            return xMLAttributeDecl;
        }
        if (xMLAttributeDecl2.type == 8) {
            return xMLAttributeDecl2;
        }
        if (xMLAttributeDecl.type == 11 && xMLAttributeDecl2.type == 11) {
            int[] nArray = this.union2sets(this.fStringPool.stringListAsIntArray(xMLAttributeDecl.enumeration), this.fStringPool.stringListAsIntArray(xMLAttributeDecl2.enumeration));
            int n = this.fStringPool.startStringList();
            int n2 = 0;
            while (n2 < nArray.length) {
                this.fStringPool.addStringToList(n, nArray[n2]);
                ++n2;
            }
            this.fStringPool.finishStringList(n);
            xMLAttributeDecl.enumeration = n;
            return xMLAttributeDecl;
        }
        if (xMLAttributeDecl.type == 9 && xMLAttributeDecl2.type == 9) {
            if (xMLAttributeDecl.name.uri == xMLAttributeDecl2.name.uri) {
                return xMLAttributeDecl;
            }
            xMLAttributeDecl.type = 8;
            return xMLAttributeDecl;
        }
        if (xMLAttributeDecl.type == 9 && xMLAttributeDecl2.type == 11 || xMLAttributeDecl.type == 11 && xMLAttributeDecl2.type == 9) {
            XMLAttributeDecl xMLAttributeDecl3;
            XMLAttributeDecl xMLAttributeDecl4;
            if (xMLAttributeDecl.type == 11) {
                xMLAttributeDecl4 = xMLAttributeDecl;
                xMLAttributeDecl3 = xMLAttributeDecl2;
            } else {
                xMLAttributeDecl4 = xMLAttributeDecl2;
                xMLAttributeDecl3 = xMLAttributeDecl;
            }
            if (this.elementInSet(xMLAttributeDecl3.name.uri, this.fStringPool.stringListAsIntArray(xMLAttributeDecl4.enumeration))) {
                xMLAttributeDecl3.type = 8;
            }
            return xMLAttributeDecl3;
        }
        return xMLAttributeDecl;
    }

    private boolean AWildCardSubset(XMLAttributeDecl xMLAttributeDecl, XMLAttributeDecl xMLAttributeDecl2) {
        if (xMLAttributeDecl.type == -1 || xMLAttributeDecl2.type == -1) {
            return false;
        }
        if (xMLAttributeDecl2.type == 8) {
            return true;
        }
        if (xMLAttributeDecl.type == 9 && xMLAttributeDecl2.type == 9 && xMLAttributeDecl.name.uri == xMLAttributeDecl2.name.uri) {
            return true;
        }
        if (xMLAttributeDecl.type == 11) {
            if (xMLAttributeDecl2.type == 11 && this.subset2sets(this.fStringPool.stringListAsIntArray(xMLAttributeDecl.enumeration), this.fStringPool.stringListAsIntArray(xMLAttributeDecl2.enumeration))) {
                return true;
            }
            if (xMLAttributeDecl2.type == 9 && !this.elementInSet(xMLAttributeDecl2.name.uri, this.fStringPool.stringListAsIntArray(xMLAttributeDecl2.enumeration))) {
                return true;
            }
        }
        return false;
    }

    private boolean AWildCardAllowsNameSpace(XMLAttributeDecl xMLAttributeDecl, String string) {
        if (xMLAttributeDecl.type == -1) {
            return false;
        }
        if (xMLAttributeDecl.type == 8) {
            return true;
        }
        int n = this.fStringPool.addString(string);
        if (xMLAttributeDecl.type == 9 && n != xMLAttributeDecl.name.uri && n != 0) {
            return true;
        }
        return xMLAttributeDecl.type == 11 && this.elementInSet(n, this.fStringPool.stringListAsIntArray(xMLAttributeDecl.enumeration));
    }

    private boolean isAWildCard(XMLAttributeDecl xMLAttributeDecl) {
        return xMLAttributeDecl.type == 8 || xMLAttributeDecl.type == 11 || xMLAttributeDecl.type == 9;
    }

    int[] intersect2sets(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[nArray.length > nArray2.length ? nArray.length : nArray2.length];
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            if (this.elementInSet(nArray[n2], nArray2)) {
                nArray3[n++] = nArray[n2];
            }
            ++n2;
        }
        int[] nArray4 = new int[n];
        System.arraycopy(nArray3, 0, nArray4, 0, n);
        return nArray4;
    }

    int[] union2sets(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[nArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            if (!this.elementInSet(nArray[n2], nArray2)) {
                nArray3[n++] = nArray[n2];
            }
            ++n2;
        }
        int[] nArray4 = new int[n + nArray2.length];
        System.arraycopy(nArray3, 0, nArray4, 0, n);
        System.arraycopy(nArray2, 0, nArray4, n, nArray2.length);
        return nArray4;
    }

    boolean subset2sets(int[] nArray, int[] nArray2) {
        int n = 0;
        while (n < nArray.length) {
            if (!this.elementInSet(nArray[n], nArray2)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    boolean elementInSet(int n, int[] nArray) {
        boolean bl = false;
        int n2 = 0;
        while (n2 < nArray.length && !bl) {
            if (n == nArray[n2]) {
                bl = true;
            }
            ++n2;
        }
        return bl;
    }

    private int traverseComplexTypeDecl(Element element) throws Exception {
        return this.traverseComplexTypeDecl(element, false);
    }

    private int traverseComplexTypeDecl(Element element, boolean bl) throws Exception {
        int n = this.isTopLevel(element) ? GeneralAttrCheck.ELE_CONTEXT_GLOBAL : GeneralAttrCheck.ELE_CONTEXT_LOCAL;
        Hashtable hashtable = this.generalCheck(element, n);
        String string = element.getAttribute("abstract");
        String string2 = null;
        Attr attr = element.getAttributeNode("block");
        if (attr != null) {
            string2 = attr.getValue();
        }
        String string3 = null;
        Attr attr2 = element.getAttributeNode("final");
        if (attr2 != null) {
            string3 = attr2.getValue();
        }
        String string4 = element.getAttribute("ID");
        String string5 = element.getAttribute("name");
        String string6 = element.getAttribute("mixed");
        boolean bl2 = false;
        Stack stack = null;
        if (string5.length() == 0) {
            string5 = this.genAnonTypeName(element);
        }
        this.fCurrentTypeNameStack.push(string5);
        int n2 = this.fStringPool.addSymbol(string5);
        if (this.isTopLevel(element)) {
            String string7 = this.fTargetNSURIString + "," + string5;
            ComplexTypeInfo complexTypeInfo = (ComplexTypeInfo)this.fComplexTypeRegistry.get(string7);
            if (complexTypeInfo != null) {
                if (!bl) {
                    if (complexTypeInfo.declSeen()) {
                        this.reportGenericSchemaError("sch-props-correct: Duplicate declaration for complexType " + string5);
                    } else {
                        complexTypeInfo.setDeclSeen();
                    }
                }
                return this.fStringPool.addSymbol(string7);
            }
            if (this.getDatatypeValidator(this.fTargetNSURIString, string5) != null) {
                this.reportGenericSchemaError("sch-props-correct: Duplicate type declaration - type is " + string5);
            }
        }
        int n3 = this.fScopeCount++;
        int n4 = this.fCurrentScope;
        this.fCurrentScope = n3;
        if (!this.fCurrentGroupNameStack.isEmpty()) {
            stack = this.fCurrentGroupNameStack;
            this.fCurrentGroupNameStack = new Stack();
        }
        Element element2 = null;
        ComplexTypeInfo complexTypeInfo = new ComplexTypeInfo();
        try {
            element2 = this.checkContent(element, XUtil.getFirstChildElement(element), true);
            if (element2 == null) {
                this.processComplexContent(n2, element2, complexTypeInfo, null, false);
            } else {
                String string8 = element2.getLocalName();
                int n5 = -2;
                if (string8.equals("simpleContent")) {
                    this.traverseSimpleContentDecl(n2, element2, complexTypeInfo);
                    if (XUtil.getNextSiblingElement(element2) != null) {
                        throw new ComplexTypeRecoverableError("Invalid child following the simpleContent child in the complexType");
                    }
                } else if (string8.equals("complexContent")) {
                    this.traverseComplexContentDecl(n2, element2, complexTypeInfo, string6.equals("true"));
                    if (XUtil.getNextSiblingElement(element2) != null) {
                        throw new ComplexTypeRecoverableError("Invalid child following the complexContent child in the complexType");
                    }
                } else {
                    this.processComplexContent(n2, element2, complexTypeInfo, null, string6.equals("true"));
                }
            }
            complexTypeInfo.blockSet = this.parseBlockSet(string2);
            if (string2 != null && string2.length() != 0 && !string2.equals("#all") && (complexTypeInfo.blockSet & 2) == 0 && (complexTypeInfo.blockSet & 1) == 0) {
                throw new ComplexTypeRecoverableError("The values of the 'block' attribute of a complexType must be either #all or a list of 'restriction' and 'extension'; " + string2 + " was found");
            }
            complexTypeInfo.finalSet = this.parseFinalSet(string3);
            if (string3 != null && string3.length() != 0 && !string3.equals("#all") && (complexTypeInfo.finalSet & 2) == 0 && (complexTypeInfo.finalSet & 1) == 0) {
                throw new ComplexTypeRecoverableError("The values of the 'final' attribute of a complexType must be either #all or a list of 'restriction' and 'extension'; " + string3 + " was found");
            }
        }
        catch (ComplexTypeRecoverableError complexTypeRecoverableError) {
            String string9 = complexTypeRecoverableError.getMessage();
            this.handleComplexTypeError(string9, n2, complexTypeInfo);
        }
        complexTypeInfo.scopeDefined = n3;
        if (string.equals("true")) {
            complexTypeInfo.setIsAbstractType();
        }
        if (!bl) {
            complexTypeInfo.setDeclSeen();
        }
        string5 = this.fTargetNSURIString + "," + string5;
        complexTypeInfo.typeName = new String(string5);
        this.fComplexTypeRegistry.put(string5, complexTypeInfo);
        this.fCurrentScope = n4;
        if (stack != null) {
            this.fCurrentGroupNameStack = stack;
        }
        this.fCurrentTypeNameStack.pop();
        this.checkRecursingComplexType();
        this.fSchemaGrammar.setElementComplexTypeInfo(complexTypeInfo.templateElementIndex, complexTypeInfo);
        n2 = this.fStringPool.addSymbol(string5);
        return n2;
    }

    private void traverseSimpleContentDecl(int n, Element element, ComplexTypeInfo complexTypeInfo) throws Exception {
        int n2;
        int n3 = GeneralAttrCheck.ELE_CONTEXT_LOCAL;
        Hashtable hashtable = this.generalCheck(element, n3);
        String string = this.fStringPool.toString(n);
        String string2 = element.getAttribute("ID");
        complexTypeInfo.contentType = 5;
        complexTypeInfo.contentSpecHandle = -1;
        Element element2 = this.checkContent(element, XUtil.getFirstChildElement(element), false);
        if (element2 == null) {
            throw new ComplexTypeRecoverableError();
        }
        hashtable = this.generalCheck(element2, n3);
        String string3 = element2.getLocalName();
        if (string3.equals("restriction")) {
            complexTypeInfo.derivedBy = 2;
        } else if (string3.equals("extension")) {
            complexTypeInfo.derivedBy = 1;
        } else {
            throw new ComplexTypeRecoverableError("The content of the simpleContent element is invalid.  The content must be RESTRICTION or EXTENSION");
        }
        String string4 = element2.getAttribute("base");
        String string5 = element2.getAttribute("ID");
        Element element3 = this.checkContent(element2, XUtil.getFirstChildElement(element2), true);
        if (string4.length() == 0) {
            throw new ComplexTypeRecoverableError("The BASE attribute must be specified for the RESTRICTION or EXTENSION element");
        }
        QName qName = this.parseBase(string4);
        Integer n4 = (Integer)this.fSimpleTypeFinalRegistry.get(this.fStringPool.toString(qName.uri) + "," + this.fStringPool.toString(qName.localpart));
        if (n4 != null && n4 == complexTypeInfo.derivedBy) {
            throw new ComplexTypeRecoverableError("The simpleType " + string4 + " that " + string + " uses has a value of \"final\" which does not permit extension");
        }
        this.processBaseTypeInfo(qName, complexTypeInfo);
        if (complexTypeInfo.baseComplexTypeInfo != null && complexTypeInfo.baseComplexTypeInfo.contentType != 5) {
            throw new ComplexTypeRecoverableError("The type '" + string4 + "' specified as the " + "base in the simpleContent element must not have complexContent");
        }
        Element element4 = null;
        if (complexTypeInfo.derivedBy == 2) {
            if (complexTypeInfo.baseDataTypeValidator != null) {
                throw new ComplexTypeRecoverableError("ct-props-correct.2: The type '" + string4 + "' is a simple type.  It cannot be used in a " + "derivation by RESTRICTION for a complexType");
            }
            complexTypeInfo.baseDataTypeValidator = complexTypeInfo.baseComplexTypeInfo.datatypeValidator;
            if ((complexTypeInfo.baseComplexTypeInfo.finalSet & 2) != 0) {
                throw new ComplexTypeRecoverableError("Derivation by restriction is forbidden by either the base type " + string4 + " or the schema");
            }
            if (element3.getLocalName().equals("simpleType")) {
                n2 = this.traverseSimpleTypeDecl(element3);
                if (n2 != -1) {
                    DatatypeValidator datatypeValidator = this.fDatatypeRegistry.getDatatypeValidator(this.fStringPool.toString(n2));
                    if (!this.checkSimpleTypeDerivationOK(datatypeValidator, complexTypeInfo.baseDataTypeValidator)) {
                        throw new ComplexTypeRecoverableError("derivation-ok-restriction.5.1.1:  The content type is not a valid restriction of the content type of the base");
                    }
                    complexTypeInfo.baseDataTypeValidator = datatypeValidator;
                    element3 = XUtil.getNextSiblingElement(element3);
                } else {
                    throw new ComplexTypeRecoverableError();
                }
            }
            n2 = 0;
            int n5 = 0;
            Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
            Vector<String> vector = new Vector<String>();
            n3 = GeneralAttrCheck.ELE_CONTEXT_LOCAL;
            Element element5 = element3;
            while (element5 != null && (element5.getLocalName().equals("minExclusive") || element5.getLocalName().equals("minInclusive") || element5.getLocalName().equals("maxExclusive") || element5.getLocalName().equals("maxInclusive") || element5.getLocalName().equals("totalDigits") || element5.getLocalName().equals("fractionDigits") || element5.getLocalName().equals("length") || element5.getLocalName().equals("minLength") || element5.getLocalName().equals("maxLength") || element5.getLocalName().equals("period") || element5.getLocalName().equals("duration") || element5.getLocalName().equals("enumeration") || element5.getLocalName().equals("pattern") || element5.getLocalName().equals("annotation"))) {
                if (element5.getNodeType() == 1) {
                    Element element6 = element5;
                    Hashtable hashtable3 = this.generalCheck(element6, n3);
                    ++n5;
                    if (element6.getLocalName().equals("enumeration")) {
                        ++n2;
                        vector.addElement(element6.getAttribute("value"));
                        Element element7 = XUtil.getFirstChildElement(element6);
                        if (element7 != null && element7.getLocalName().equals("annotation")) {
                            this.traverseAnnotationDecl(element5);
                        }
                    } else {
                        hashtable2.put(element6.getLocalName(), element6.getAttribute("value"));
                    }
                }
                element5 = XUtil.getNextSiblingElement(element5);
            }
            if (n2 > 0) {
                hashtable2.put("enumeration", vector);
            }
            if (n5 > 0) {
                try {
                    complexTypeInfo.datatypeValidator = this.fDatatypeRegistry.createDatatypeValidator(string, complexTypeInfo.baseDataTypeValidator, hashtable2, false);
                }
                catch (Exception exception) {
                    throw new ComplexTypeRecoverableError(exception.getMessage());
                }
            } else {
                complexTypeInfo.datatypeValidator = complexTypeInfo.baseDataTypeValidator;
            }
            if (element5 != null) {
                if (!this.isAttrOrAttrGroup(element5)) {
                    throw new ComplexTypeRecoverableError("Invalid child in the RESTRICTION element of simpleContent");
                }
                element4 = element5;
            }
        } else {
            if (complexTypeInfo.baseComplexTypeInfo != null) {
                complexTypeInfo.baseDataTypeValidator = complexTypeInfo.baseComplexTypeInfo.datatypeValidator;
                if ((complexTypeInfo.baseComplexTypeInfo.finalSet & 1) != 0) {
                    throw new ComplexTypeRecoverableError("Derivation by extension is forbidden by either the base type " + string4 + " or the schema");
                }
            }
            complexTypeInfo.datatypeValidator = complexTypeInfo.baseDataTypeValidator;
            if (element3 != null) {
                if (!this.isAttrOrAttrGroup(element3)) {
                    throw new ComplexTypeRecoverableError("Only annotations and attributes are allowed in the content of an EXTENSION element for a complexType with simpleContent");
                }
                element4 = element3;
            }
        }
        n2 = this.fStringPool.addSymbol("$" + string);
        complexTypeInfo.templateElementIndex = this.fSchemaGrammar.addElementDecl(new QName(-1, n2, n, this.fTargetNSURI), this.fTargetNSURI == 0 ? 0 : this.fCurrentScope, complexTypeInfo.scopeDefined, complexTypeInfo.contentType, complexTypeInfo.contentSpecHandle, -1, complexTypeInfo.datatypeValidator);
        complexTypeInfo.attlistHead = this.fSchemaGrammar.getFirstAttributeDeclIndex(complexTypeInfo.templateElementIndex);
        this.processAttributes(element4, qName, complexTypeInfo);
        if (XUtil.getNextSiblingElement(element2) != null) {
            throw new ComplexTypeRecoverableError("Invalid child following the RESTRICTION or EXTENSION element in the complex type definition");
        }
    }

    private void traverseComplexContentDecl(int n, Element element, ComplexTypeInfo complexTypeInfo, boolean bl) throws Exception {
        int n2 = GeneralAttrCheck.ELE_CONTEXT_LOCAL;
        Hashtable hashtable = this.generalCheck(element, n2);
        String string = this.fStringPool.toString(n);
        String string2 = element.getAttribute("ID");
        String string3 = element.getAttribute("mixed");
        boolean bl2 = bl;
        if (string3.equals("true")) {
            bl2 = true;
        } else if (string3.equals("false")) {
            bl2 = false;
        }
        complexTypeInfo.datatypeValidator = null;
        complexTypeInfo.baseDataTypeValidator = null;
        Element element2 = this.checkContent(element, XUtil.getFirstChildElement(element), false);
        if (element2 == null) {
            throw new ComplexTypeRecoverableError();
        }
        String string4 = element2.getLocalName();
        if (string4.equals("restriction")) {
            complexTypeInfo.derivedBy = 2;
        } else if (string4.equals("extension")) {
            complexTypeInfo.derivedBy = 1;
        } else {
            throw new ComplexTypeRecoverableError("The content of the complexContent element is invalid. The content must be RESTRICTION or EXTENSION");
        }
        String string5 = element2.getAttribute("base");
        String string6 = element2.getAttribute("ID");
        Element element3 = this.checkContent(element2, XUtil.getFirstChildElement(element2), true);
        if (string5.length() == 0) {
            throw new ComplexTypeRecoverableError("The BASE attribute must be specified for the RESTRICTION or EXTENSION element");
        }
        QName qName = this.parseBase(string5);
        String string7 = this.fStringPool.toString(qName.uri);
        String string8 = this.fStringPool.toString(qName.localpart);
        if (!string7.equals("http://www.w3.org/2001/XMLSchema") || !string8.equals("anyType")) {
            this.processBaseTypeInfo(qName, complexTypeInfo);
            if (complexTypeInfo.baseComplexTypeInfo == null) {
                throw new ComplexTypeRecoverableError("The base type specified in the complexContent element must be a complexType");
            }
        }
        this.processComplexContent(n, element3, complexTypeInfo, qName, bl2);
        if (XUtil.getNextSiblingElement(element2) != null) {
            throw new ComplexTypeRecoverableError("Invalid child following the RESTRICTION or EXTENSION element in the complex type definition");
        }
    }

    private void handleComplexTypeError(String string, int n, ComplexTypeInfo complexTypeInfo) throws Exception {
        String string2 = this.fStringPool.toString(n);
        if (string != null) {
            if (string2.startsWith("#")) {
                this.reportGenericSchemaError("Anonymous complexType: " + string);
            } else {
                this.reportGenericSchemaError("ComplexType '" + string2 + "': " + string);
            }
        }
        complexTypeInfo.contentType = 1;
        complexTypeInfo.contentSpecHandle = -1;
        complexTypeInfo.derivedBy = 0;
        complexTypeInfo.datatypeValidator = null;
        complexTypeInfo.attlistHead = -1;
        int n2 = this.fStringPool.addSymbol("$" + string2);
        complexTypeInfo.templateElementIndex = this.fSchemaGrammar.addElementDecl(new QName(-1, n2, n, this.fTargetNSURI), this.fTargetNSURI == 0 ? 0 : this.fCurrentScope, complexTypeInfo.scopeDefined, complexTypeInfo.contentType, complexTypeInfo.contentSpecHandle, -1, complexTypeInfo.datatypeValidator);
    }

    private String genAnonTypeName(Element element) throws Exception {
        Element element2 = element;
        String string = "#AnonType_";
        while (!this.isTopLevel(element2)) {
            element2 = (Element)element2.getParentNode();
            string = string + element2.getAttribute("name");
        }
        return string;
    }

    private QName parseBase(String string) throws Exception {
        String string2 = "";
        String string3 = string;
        int n = string.indexOf(":");
        if (n > 0) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        int n2 = this.fStringPool.addSymbol(string);
        int n3 = this.fStringPool.addSymbol(string2);
        int n4 = this.fStringPool.addSymbol(string3);
        int n5 = this.fStringPool.addSymbol(this.resolvePrefixToURI(string2));
        return new QName(n3, n4, n2, n5);
    }

    private boolean baseFromAnotherSchema(QName qName) throws Exception {
        String string = this.fStringPool.toString(qName.uri);
        return !string.equals(this.fTargetNSURIString) && !string.equals("http://www.w3.org/2001/XMLSchema") && string.length() != 0;
    }

    private void processBaseTypeInfo(QName qName, ComplexTypeInfo complexTypeInfo) throws Exception {
        ComplexTypeInfo complexTypeInfo2 = null;
        DatatypeValidator datatypeValidator = null;
        String string = this.fStringPool.toString(qName.uri);
        String string2 = this.fStringPool.toString(qName.localpart);
        String string3 = this.fStringPool.toString(qName.rawname);
        if (this.baseFromAnotherSchema(qName)) {
            complexTypeInfo2 = this.getTypeInfoFromNS(string, string2);
            if (complexTypeInfo2 == null && (datatypeValidator = this.getTypeValidatorFromNS(string, string2)) == null) {
                throw new ComplexTypeRecoverableError("Could not find base type " + string2 + " in schema " + string);
            }
        } else {
            String string4 = string + "," + string2;
            complexTypeInfo2 = (ComplexTypeInfo)this.fComplexTypeRegistry.get(string4);
            if (complexTypeInfo2 == null && (datatypeValidator = this.getDatatypeValidator(string, string2)) == null) {
                Element element = this.getTopLevelComponentByName("complexType", string2);
                if (element != null) {
                    if (this.fBaseTypeNameStack.search(string4) > -1) {
                        throw new ComplexTypeRecoverableError("ct-props-correct.3:  Recursive type definition");
                    }
                    this.fBaseTypeNameStack.push(string4);
                    int n = this.traverseComplexTypeDecl(element, true);
                    this.fBaseTypeNameStack.pop();
                    complexTypeInfo2 = (ComplexTypeInfo)this.fComplexTypeRegistry.get(this.fStringPool.toString(n));
                } else {
                    element = this.getTopLevelComponentByName("simpleType", string2);
                    if (element != null) {
                        int n = this.traverseSimpleTypeDecl(element);
                        datatypeValidator = this.getDatatypeValidator(string, string2);
                        if (datatypeValidator == null) {
                            // empty if block
                        }
                    } else {
                        throw new ComplexTypeRecoverableError("Base type could not be found : " + string3);
                    }
                }
            }
        }
        complexTypeInfo.baseComplexTypeInfo = complexTypeInfo2;
        complexTypeInfo.baseDataTypeValidator = datatypeValidator;
    }

    private void processComplexContent(int n, Element element, ComplexTypeInfo complexTypeInfo, QName qName, boolean bl) throws Exception {
        Object object;
        Element element2 = null;
        int n2 = -2;
        String string = this.fStringPool.toString(n);
        if (element != null) {
            String string2 = element.getLocalName();
            if (string2.equals("group")) {
                object = this.traverseGroupDecl(element);
                int n3 = object != null ? ((GroupInfo)object).contentSpecIndex : -2;
                n2 = this.handleOccurrences(n3, element, this.hasAllContent(n3) ? 2 : 0);
                element2 = XUtil.getNextSiblingElement(element);
            } else if (string2.equals("sequence")) {
                n2 = this.handleOccurrences(this.traverseSequence(element), element);
                element2 = XUtil.getNextSiblingElement(element);
            } else if (string2.equals("choice")) {
                n2 = this.handleOccurrences(this.traverseChoice(element), element);
                element2 = XUtil.getNextSiblingElement(element);
            } else if (string2.equals("all")) {
                n2 = this.handleOccurrences(this.traverseAll(element), element, 8);
                element2 = XUtil.getNextSiblingElement(element);
            } else if (this.isAttrOrAttrGroup(element)) {
                complexTypeInfo.contentType = 1;
                element2 = element;
            } else {
                throw new ComplexTypeRecoverableError("Invalid child '" + string2 + "' in the complex type");
            }
        }
        complexTypeInfo.contentSpecHandle = n2;
        if (complexTypeInfo.baseComplexTypeInfo != null) {
            int n4 = complexTypeInfo.baseComplexTypeInfo.contentSpecHandle;
            if (complexTypeInfo.derivedBy == 2) {
                if ((complexTypeInfo.baseComplexTypeInfo.finalSet & 2) != 0) {
                    throw new ComplexTypeRecoverableError("Derivation by restriction is forbidden by either the base type " + this.fStringPool.toString(qName.localpart) + " or the schema");
                }
                if (complexTypeInfo.contentSpecHandle == -2 && complexTypeInfo.baseComplexTypeInfo.contentType != 0 && !this.particleEmptiable(n4)) {
                    throw new ComplexTypeRecoverableError("derivation-ok-restrictoin.5.2 Content type of complexType is EMPTY but base is not EMPTY or does not have a particle which is emptiable");
                }
            } else {
                if ((complexTypeInfo.baseComplexTypeInfo.finalSet & 1) != 0) {
                    throw new ComplexTypeRecoverableError("cos-ct-extends.1.1: Derivation by extension is forbidden by either the base type " + this.fStringPool.toString(qName.localpart) + " or the schema");
                }
                if (complexTypeInfo.baseComplexTypeInfo.contentType != 0 && (complexTypeInfo.baseComplexTypeInfo.contentType == 4 && bl || complexTypeInfo.baseComplexTypeInfo.contentType == 3 && !bl)) {
                    throw new ComplexTypeRecoverableError("cos-ct-extends.1.4.2.2.2.1: The content type of the base type " + this.fStringPool.toString(qName.localpart) + " and derived type " + string + " must both be mixed or element-only");
                }
                if (this.baseFromAnotherSchema(qName)) {
                    object = this.fStringPool.toString(qName.uri);
                    SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarResolver.getGrammar((String)object);
                    n4 = this.importContentSpec(schemaGrammar, n4);
                }
                if (complexTypeInfo.contentSpecHandle == -2) {
                    complexTypeInfo.contentSpecHandle = n4;
                } else if (n4 > -1) {
                    if (complexTypeInfo.contentSpecHandle > -1 && (this.hasAllContent(complexTypeInfo.contentSpecHandle) || this.hasAllContent(n4))) {
                        throw new ComplexTypeRecoverableError("cos-all-limited.1.2:  An \"all\" model group that is part of a complex type definition must constitute the entire {content type} of the definition.");
                    }
                    complexTypeInfo.contentSpecHandle = this.fSchemaGrammar.addContentSpecNode(5, n4, complexTypeInfo.contentSpecHandle, false);
                }
            }
        } else {
            complexTypeInfo.derivedBy = 0;
        }
        complexTypeInfo.contentType = bl ? (complexTypeInfo.contentSpecHandle == -2 ? 2 : 3) : (complexTypeInfo.contentSpecHandle == -2 ? 0 : 4);
        int n5 = this.fStringPool.addSymbol("$" + string);
        complexTypeInfo.templateElementIndex = this.fSchemaGrammar.addElementDecl(new QName(-1, n5, n, this.fTargetNSURI), this.fTargetNSURI == 0 ? 0 : this.fCurrentScope, complexTypeInfo.scopeDefined, complexTypeInfo.contentType, complexTypeInfo.contentSpecHandle, -1, complexTypeInfo.datatypeValidator);
        complexTypeInfo.attlistHead = this.fSchemaGrammar.getFirstAttributeDeclIndex(complexTypeInfo.templateElementIndex);
        if (element2 != null) {
            if (!this.isAttrOrAttrGroup(element2)) {
                throw new ComplexTypeRecoverableError("Invalid child " + element2.getLocalName() + " in the complexType or complexContent");
            }
            this.processAttributes(element2, qName, complexTypeInfo);
        } else if (complexTypeInfo.baseComplexTypeInfo != null) {
            this.processAttributes(null, qName, complexTypeInfo);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processAttributes(Element var1_1, QName var2_2, ComplexTypeInfo var3_3) throws Exception {
        block26: {
            var4_4 = null;
            var5_5 = new Vector<E>();
            var6_6 = var1_1;
            while (var6_6 != null) {
                var7_7 = var6_6.getLocalName();
                if (var7_7.equals("attribute")) {
                    this.traverseAttributeDecl(var6_6, var3_3, false);
                } else if (var7_7.equals("attributeGroup")) {
                    this.traverseAttributeGroupDecl(var6_6, var3_3, var5_5);
                } else if (var7_7.equals("anyAttribute")) {
                    var4_4 = this.traverseAnyAttribute(var6_6);
                } else {
                    throw new ComplexTypeRecoverableError("Invalid child among the children of the complexType definition");
                }
                var6_6 = XUtil.getNextSiblingElement(var6_6);
            }
            if (var4_4 != null) {
                var7_7 = null;
                var8_8 = var5_5.size();
                if (var8_8 > 0) {
                    var7_7 = (XMLAttributeDecl)var5_5.elementAt(0);
                    var9_10 = 1;
                    while (var9_10 < var8_8) {
                        var7_7 = this.AWildCardIntersection((XMLAttributeDecl)var7_7, (XMLAttributeDecl)var5_5.elementAt(var9_10));
                        ++var9_10;
                    }
                }
                if (var7_7 != null) {
                    var9_10 = var4_4.defaultType;
                    var4_4 = this.AWildCardIntersection(var4_4, (XMLAttributeDecl)var7_7);
                    var4_4.defaultType = var9_10;
                }
            } else if (var5_5.size() > 0) {
                var4_4 = (XMLAttributeDecl)var5_5.elementAt(0);
            }
            var7_7 = null;
            var8_9 = var3_3.baseComplexTypeInfo;
            var9_11 = null;
            if (var8_9 == null || var8_9.attlistHead <= -1) break block26;
            var10_12 = var8_9.attlistHead;
            var9_11 = this.fSchemaGrammar;
            v0 = var11_13 = this.baseFromAnotherSchema(var2_2) != false ? this.fStringPool.toString(var2_2.uri) : null;
            if (var11_13 != null) {
                var9_11 = (SchemaGrammar)this.fGrammarResolver.getGrammar(var11_13);
            }
            if (var9_11 != null) ** GOTO lbl65
            break block26;
lbl-1000:
            // 1 sources

            {
                this.fTempAttributeDecl.clear();
                var9_11.getAttributeDecl(var10_12, this.fTempAttributeDecl);
                if (this.fTempAttributeDecl.type == 8 || this.fTempAttributeDecl.type == 11 || this.fTempAttributeDecl.type == 9) {
                    if (var4_4 == null) {
                        var7_7 = this.fTempAttributeDecl;
                    }
                    var10_12 = var9_11.getNextAttributeDeclIndex(var10_12);
                    continue;
                }
                var12_14 = this.fSchemaGrammar.getAttributeDeclIndex(var3_3.templateElementIndex, this.fTempAttributeDecl.name);
                if (var12_14 > -1) {
                    if (var3_3.derivedBy == 1) {
                        this.reportGenericSchemaError("Attribute that appeared in the base should nnot appear in a derivation by extension");
                    } else {
                        var10_12 = this.fSchemaGrammar.getNextAttributeDeclIndex(var10_12);
                        continue;
                    }
                }
                this.fSchemaGrammar.addAttDef(var3_3.templateElementIndex, this.fTempAttributeDecl.name, this.fTempAttributeDecl.type, this.fTempAttributeDecl.enumeration, this.fTempAttributeDecl.defaultType, this.fTempAttributeDecl.defaultValue, this.fTempAttributeDecl.datatypeValidator, this.fTempAttributeDecl.list);
                var10_12 = var9_11.getNextAttributeDeclIndex(var10_12);
lbl65:
                // 4 sources

                ** while (var10_12 > -1)
            }
        }
        if (var4_4 != null) {
            if (var4_4.type != -1) {
                this.fSchemaGrammar.addAttDef(var3_3.templateElementIndex, var4_4.name, var4_4.type, var4_4.enumeration, var4_4.defaultType, var4_4.defaultValue, var4_4.datatypeValidator, var4_4.list);
            } else {
                this.reportGenericSchemaError("The intensional intersection for {attribute wildcard}s must be expressible");
            }
        } else if (var7_7 != null) {
            this.fSchemaGrammar.addAttDef(var3_3.templateElementIndex, var7_7.name, var7_7.type, var7_7.enumeration, var7_7.defaultType, var7_7.defaultValue, var7_7.datatypeValidator, var7_7.list);
        }
        var3_3.attlistHead = this.fSchemaGrammar.getFirstAttributeDeclIndex(var3_3.templateElementIndex);
        if (var3_3.derivedBy == 2 && var3_3.attlistHead > -1 && var8_9 != null) {
            this.checkAttributesDerivationOKRestriction(var3_3.attlistHead, this.fSchemaGrammar, var4_4, var8_9.attlistHead, var9_11, (XMLAttributeDecl)var7_7);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void checkAttributesDerivationOKRestriction(int var1_1, SchemaGrammar var2_2, XMLAttributeDecl var3_3, int var4_4, SchemaGrammar var5_5, XMLAttributeDecl var6_6) throws ComplexTypeRecoverableError {
        var7_7 = var1_1;
        if (var4_4 >= 0) ** GOTO lbl25
        throw new ComplexTypeRecoverableError("derivation-ok-restriction.2:  Base type definition does not have any attributes");
lbl-1000:
        // 1 sources

        {
            this.fTempAttributeDecl.clear();
            var2_2.getAttributeDecl(var7_7, this.fTempAttributeDecl);
            if (this.isAWildCard(this.fTempAttributeDecl)) {
                var7_7 = var2_2.getNextAttributeDeclIndex(var7_7);
                continue;
            }
            var8_8 = var5_5.findAttributeDecl(var4_4, this.fTempAttributeDecl.name);
            if (var8_8 > -1) {
                this.fTemp2AttributeDecl.clear();
                var5_5.getAttributeDecl(var8_8, this.fTemp2AttributeDecl);
                if ((this.fTemp2AttributeDecl.defaultType & 2) > 0 && (this.fTempAttributeDecl.defaultType & 2) <= 0) {
                    throw new ComplexTypeRecoverableError("derivation-ok-restriction.2.1.1:  Attribute '" + this.fStringPool.toString(this.fTempAttributeDecl.name.localpart) + "' in derivation has an inconsistent REQUIRED setting to that of attribute in base");
                }
                if (!this.checkSimpleTypeDerivationOK(this.fTempAttributeDecl.datatypeValidator, this.fTemp2AttributeDecl.datatypeValidator)) {
                    throw new ComplexTypeRecoverableError("derivation-ok-restriction.2.1.2:  Type of attribute '" + this.fStringPool.toString(this.fTempAttributeDecl.name.localpart) + "' in derivation must be a restriction of type of attribute in base");
                }
                if (!((this.fTemp2AttributeDecl.defaultType & 16) <= 0 || (this.fTempAttributeDecl.defaultType & 16) > 0 && this.fTempAttributeDecl.defaultValue.equals(this.fTemp2AttributeDecl.defaultValue))) {
                    throw new ComplexTypeRecoverableError("derivation-ok-restriction.2.1.3:  Attribute '" + this.fStringPool.toString(this.fTempAttributeDecl.name.localpart) + "' is either not fixed, or is not fixed with the same value as the attribute in the base");
                }
            } else if (var6_6 == null || !this.AWildCardAllowsNameSpace(var6_6, var2_2.getTargetNamespaceURI())) {
                throw new ComplexTypeRecoverableError("derivation-ok-restriction.2.2:  Attribute '" + this.fStringPool.toString(this.fTempAttributeDecl.name.localpart) + "' has a target namespace which is not valid with respect to a base type definition's wildcard or, the base does not contain a wildcard");
            }
            var7_7 = var2_2.getNextAttributeDeclIndex(var7_7);
lbl25:
            // 3 sources

            ** while (var7_7 > -1)
        }
lbl26:
        // 1 sources

        if (var3_3 != null) {
            if (var6_6 == null) {
                throw new ComplexTypeRecoverableError("derivation-ok-restriction.4.1: An attribute wildcard is present in the derived type, but not the base");
            }
            if (!this.AWildCardSubset(var3_3, var6_6)) {
                throw new ComplexTypeRecoverableError("derivation-ok-restriction.4.2: The attribute wildcard in the derived type is not a valid subset of that in the base");
            }
        }
    }

    private boolean isAttrOrAttrGroup(Element element) {
        String string = element.getLocalName();
        return string.equals("attribute") || string.equals("attributeGroup") || string.equals("anyAttribute");
    }

    private void checkRecursingComplexType() throws Exception {
        if (this.fCurrentTypeNameStack.empty() && !this.fElementRecurseComplex.isEmpty()) {
            int n = this.fElementRecurseComplex.size();
            int n2 = 0;
            while (n2 < n) {
                ElementInfo elementInfo = (ElementInfo)this.fElementRecurseComplex.elementAt(n2);
                int n3 = elementInfo.elementIndex;
                String string = elementInfo.typeName;
                ComplexTypeInfo complexTypeInfo = (ComplexTypeInfo)this.fComplexTypeRegistry.get(this.fTargetNSURIString + "," + string);
                if (complexTypeInfo == null) {
                    throw new Exception("Internal Error in void checkRecursingComplexType(). ");
                }
                this.fSchemaGrammar.getElementDecl(n3, this.fTempElementDecl);
                this.fTempElementDecl.type = complexTypeInfo.contentType;
                this.fTempElementDecl.contentSpecIndex = complexTypeInfo.contentSpecHandle;
                this.fTempElementDecl.datatypeValidator = complexTypeInfo.datatypeValidator;
                this.fSchemaGrammar.setElementDecl(n3, this.fTempElementDecl);
                this.fSchemaGrammar.setFirstAttributeDeclIndex(n3, complexTypeInfo.attlistHead);
                this.fSchemaGrammar.setElementComplexTypeInfo(n3, complexTypeInfo);
                ++n2;
            }
            this.fElementRecurseComplex.removeAllElements();
        }
    }

    private void checkParticleDerivationOK(int n, int n2, int n3, int n4, ComplexTypeInfo complexTypeInfo) throws Exception {
        if (!this.fFullConstraintChecking) {
            return;
        }
        int n5 = n;
        this.fSchemaGrammar.getContentSpec(n5, this.tempContentSpec1);
        int n6 = n3;
        this.fSchemaGrammar.getContentSpec(n6, this.tempContentSpec2);
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        if (this.tempContentSpec1.type == 5 || this.tempContentSpec1.type == 4 || this.tempContentSpec1.type == 9) {
            n5 = this.checkForPointlessOccurrences(n5, vector);
        }
        if (this.tempContentSpec2.type == 5 || this.tempContentSpec2.type == 4 || this.tempContentSpec2.type == 9) {
            n6 = this.checkForPointlessOccurrences(n6, vector2);
        }
        this.fSchemaGrammar.getContentSpec(n5, this.tempContentSpec1);
        this.fSchemaGrammar.getContentSpec(n6, this.tempContentSpec2);
        switch (this.tempContentSpec1.type & 0xF) {
            case 0: {
                switch (this.tempContentSpec2.type & 0xF) {
                    case 0: {
                        this.checkNameAndTypeOK(n5, n2, n6, n4, complexTypeInfo);
                        return;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        this.checkNSCompat(n5, n2, n6);
                        return;
                    }
                    case 4: 
                    case 5: 
                    case 9: {
                        this.checkRecurseAsIfGroup(n5, n2, n6, vector2, n4, complexTypeInfo);
                        return;
                    }
                }
                throw new ParticleRecoverableError("internal Xerces error");
            }
            case 6: 
            case 7: 
            case 8: {
                switch (this.tempContentSpec2.type & 0xF) {
                    case 6: 
                    case 7: 
                    case 8: {
                        this.checkNSSubset(n5, n6);
                        return;
                    }
                    case 0: 
                    case 4: 
                    case 5: 
                    case 9: {
                        throw new ParticleRecoverableError("cos-particle-restrict: Forbidden restriction: Any: Choice,Seq,All,Elt");
                    }
                }
                throw new ParticleRecoverableError("internal Xerces error");
            }
            case 9: {
                switch (this.tempContentSpec2.type & 0xF) {
                    case 6: 
                    case 7: 
                    case 8: {
                        this.checkNSRecurseCheckCardinality(n5, vector, n2, n6);
                        return;
                    }
                    case 9: {
                        this.checkRecurse(n5, vector, n2, n6, vector2, n4, complexTypeInfo);
                        return;
                    }
                    case 0: 
                    case 4: 
                    case 5: {
                        throw new ParticleRecoverableError("cos-particle-restrict: Forbidden restriction: All:Choice,Seq,Elt");
                    }
                }
                throw new ParticleRecoverableError("internal Xerces error");
            }
            case 4: {
                switch (this.tempContentSpec2.type & 0xF) {
                    case 6: 
                    case 7: 
                    case 8: {
                        this.checkNSRecurseCheckCardinality(n5, vector, n2, n6);
                        return;
                    }
                    case 4: {
                        this.checkRecurseLax(n5, vector, n2, n6, vector2, n4, complexTypeInfo);
                        return;
                    }
                    case 0: 
                    case 5: 
                    case 9: {
                        throw new ParticleRecoverableError("cos-particle-restrict: Forbidden restriction: Choice:All,Seq,Leaf");
                    }
                }
                throw new ParticleRecoverableError("internal Xerces error");
            }
            case 5: {
                switch (this.tempContentSpec2.type & 0xF) {
                    case 6: 
                    case 7: 
                    case 8: {
                        this.checkNSRecurseCheckCardinality(n5, vector, n2, n6);
                        return;
                    }
                    case 9: {
                        this.checkRecurseUnordered(n5, vector, n2, n6, vector2, n4, complexTypeInfo);
                        return;
                    }
                    case 5: {
                        this.checkRecurse(n5, vector, n2, n6, vector2, n4, complexTypeInfo);
                        return;
                    }
                    case 4: {
                        this.checkMapAndSum(n5, vector, n2, n6, vector2, n4, complexTypeInfo);
                        return;
                    }
                    case 0: {
                        throw new ParticleRecoverableError("cos-particle-restrict: Forbidden restriction: Seq:Elt");
                    }
                }
                throw new ParticleRecoverableError("internal Xerces error");
            }
        }
    }

    private int checkForPointlessOccurrences(int n, Vector vector) {
        this.fSchemaGrammar.getContentSpec(n, this.tempContentSpec1);
        if (this.tempContentSpec1.otherValue == -2) {
            this.gatherChildren(this.tempContentSpec1.type, this.tempContentSpec1.value, vector);
            if (vector.size() == 1) {
                Integer n2 = (Integer)vector.elementAt(0);
                return n2;
            }
        }
        int n3 = this.tempContentSpec1.type;
        int n4 = this.tempContentSpec1.value;
        int n5 = this.tempContentSpec1.otherValue;
        this.gatherChildren(n3, n4, vector);
        this.gatherChildren(n3, n5, vector);
        return n;
    }

    private void gatherChildren(int n, int n2, Vector vector) {
        this.fSchemaGrammar.getContentSpec(n2, this.tempContentSpec1);
        int n3 = this.fSchemaGrammar.getContentSpecMinOccurs(n2);
        int n4 = this.fSchemaGrammar.getContentSpecMaxOccurs(n2);
        int n5 = this.tempContentSpec1.value;
        int n6 = this.tempContentSpec1.otherValue;
        int n7 = this.tempContentSpec1.type;
        if (n7 == 0 || (n7 & 0xF) == 6 || (n7 & 0xF) == 8 || (n7 & 0xF) == 7) {
            vector.addElement(new Integer(n2));
        } else if (n3 != 1 || n4 != 1) {
            vector.addElement(new Integer(n2));
        } else if (n6 == -2) {
            this.gatherChildren(n7, n5, vector);
        } else if (n == n7) {
            this.gatherChildren(n7, n5, vector);
            this.gatherChildren(n7, n6, vector);
        } else {
            vector.addElement(new Integer(n2));
        }
    }

    private void checkNameAndTypeOK(int n, int n2, int n3, int n4, ComplexTypeInfo complexTypeInfo) throws Exception {
        int n5;
        int n6;
        this.fSchemaGrammar.getContentSpec(n, this.tempContentSpec1);
        this.fSchemaGrammar.getContentSpec(n3, this.tempContentSpec2);
        int n7 = this.tempContentSpec1.value;
        int n8 = this.tempContentSpec1.otherValue;
        int n9 = this.tempContentSpec2.value;
        int n10 = this.tempContentSpec2.otherValue;
        int n11 = this.fSchemaGrammar.getContentSpecMinOccurs(n);
        int n12 = this.fSchemaGrammar.getContentSpecMaxOccurs(n);
        int n13 = this.fSchemaGrammar.getContentSpecMinOccurs(n3);
        int n14 = this.fSchemaGrammar.getContentSpecMaxOccurs(n3);
        if (n7 != n9 || n8 != n10) {
            if (this.fSComp == null) {
                this.fSComp = new SubstitutionGroupComparator(this.fGrammarResolver, this.fStringPool, this.fErrorReporter);
            }
            if (!this.checkSubstitutionGroups(n7, n8, n9, n10)) {
                throw new ParticleRecoverableError("rcase-nameAndTypeOK.1:  Element name/uri in restriction does not match that of corresponding base element");
            }
        }
        if (!this.checkOccurrenceRange(n11, n12, n13, n14)) {
            throw new ParticleRecoverableError("rcase-nameAndTypeOK.3:  Element occurrence range not a restriction of base element's range: element is " + this.fStringPool.toString(n7));
        }
        SchemaGrammar schemaGrammar = this.fSchemaGrammar;
        String string = this.fStringPool.toString(n8);
        if (!string.equals(this.fTargetNSURIString) && string.length() != 0) {
            schemaGrammar = (SchemaGrammar)this.fGrammarResolver.getGrammar(string);
        }
        if ((n6 = this.findElement(n2, n7, schemaGrammar, null)) < 0) {
            return;
        }
        int n15 = this.findElement(n4, n9, schemaGrammar, complexTypeInfo);
        if (n15 < 0) {
            return;
        }
        int n16 = schemaGrammar.getElementDeclMiscFlags(n6);
        int n17 = schemaGrammar.getElementDeclMiscFlags(n15);
        boolean bl = (n16 & 1) != 0;
        boolean bl2 = (n17 & 1) != 0;
        boolean bl3 = (n17 & 4) != 0;
        boolean bl4 = (n16 & 4) != 0;
        String string2 = schemaGrammar.getElementDefaultValue(n6);
        String string3 = schemaGrammar.getElementDefaultValue(n15);
        if (!bl2 && bl) {
            throw new ParticleRecoverableError("rcase-nameAndTypeOK.2:  Element " + this.fStringPool.toString(n7) + " is nillable in the restriction but not the base");
        }
        if (!(string3 == null || !bl3 || bl4 && string2.equals(string3))) {
            throw new ParticleRecoverableError("rcase-nameAndTypeOK.4:  Element " + this.fStringPool.toString(n7) + " is either not fixed, or is not fixed with the same value as in the base");
        }
        int n18 = schemaGrammar.getElementDeclBlockSet(n6);
        if ((n18 & (n5 = schemaGrammar.getElementDeclBlockSet(n15))) != n5 || n18 == 0 && n5 != 0) {
            throw new ParticleRecoverableError("rcase-nameAndTypeOK.6:  Element " + this.fStringPool.toString(n7) + "'s disallowed subsitutions are not a superset of those of the base element's");
        }
        schemaGrammar.getElementDecl(n6, this.fTempElementDecl);
        schemaGrammar.getElementDecl(n15, this.fTempElementDecl2);
        this.checkIDConstraintRestriction(this.fTempElementDecl, this.fTempElementDecl2, schemaGrammar, n7, n9);
        this.checkTypesOK(this.fTempElementDecl, this.fTempElementDecl2, n6, n15, schemaGrammar, this.fStringPool.toString(n7));
    }

    private void checkTypesOK(XMLElementDecl xMLElementDecl, XMLElementDecl xMLElementDecl2, int n, int n2, SchemaGrammar schemaGrammar, String string) throws Exception {
        ComplexTypeInfo complexTypeInfo = schemaGrammar.getElementComplexTypeInfo(n);
        if (xMLElementDecl.type == 5) {
            if (xMLElementDecl2.type != 5) {
                throw new ParticleRecoverableError("rcase-nameAndTypeOK.6:  Derived element " + string + " has a type that does not derive from that of the base");
            }
            if (complexTypeInfo == null) {
                if (!this.checkSimpleTypeDerivationOK(xMLElementDecl.datatypeValidator, xMLElementDecl2.datatypeValidator)) {
                    throw new ParticleRecoverableError("rcase-nameAndTypeOK.6:  Derived element " + string + " has a type that does not derive from that of the base");
                }
                return;
            }
        }
        ComplexTypeInfo complexTypeInfo2 = schemaGrammar.getElementComplexTypeInfo(n2);
        while (complexTypeInfo != null) {
            if (complexTypeInfo.derivedBy != 2) {
                throw new ParticleRecoverableError("rcase-nameAndTypeOK.6:  Derived element " + string + " has a type that does not derives from that of the base");
            }
            if (complexTypeInfo.typeName.equals(complexTypeInfo2.typeName)) break;
            complexTypeInfo = complexTypeInfo.baseComplexTypeInfo;
        }
        if (complexTypeInfo == null) {
            throw new ParticleRecoverableError("rcase-nameAndTypeOK.6:  Derived element " + string + " has a type that does not derives from that of the base");
        }
    }

    private void checkIDConstraintRestriction(XMLElementDecl xMLElementDecl, XMLElementDecl xMLElementDecl2, SchemaGrammar schemaGrammar, int n, int n2) throws Exception {
        int n3;
        int n4;
        Vector vector = xMLElementDecl.unique;
        Vector vector2 = xMLElementDecl2.unique;
        if (vector.size() > vector2.size()) {
            throw new ParticleRecoverableError("rcase-nameAndTypeOK.5:  derived element " + this.fStringPool.toString(n) + " has fewer <unique> Identity Constraints than the base element" + this.fStringPool.toString(n2));
        }
        boolean bl = true;
        int n5 = 0;
        while (n5 < vector.size() && bl) {
            Unique unique = (Unique)vector.elementAt(n5);
            bl = false;
            n4 = 0;
            while (n4 < vector2.size()) {
                if (unique.equals((Unique)vector2.elementAt(n4))) {
                    bl = true;
                    break;
                }
                ++n4;
            }
            ++n5;
        }
        if (!bl) {
            throw new ParticleRecoverableError("rcase-nameAndTypeOK.5:  derived element " + this.fStringPool.toString(n) + " has a <unique> Identity Constraint that does not appear on the base element" + this.fStringPool.toString(n2));
        }
        Vector vector3 = xMLElementDecl.key;
        Vector vector4 = xMLElementDecl2.key;
        if (vector3.size() > vector4.size()) {
            throw new ParticleRecoverableError("rcase-nameAndTypeOK.5:  derived element " + this.fStringPool.toString(n) + " has fewer <key> Identity Constraints than the base element" + this.fStringPool.toString(n2));
        }
        boolean bl2 = true;
        n4 = 0;
        while (n4 < vector3.size() && bl2) {
            Key key = (Key)vector3.elementAt(n4);
            bl2 = false;
            n3 = 0;
            while (n3 < vector4.size()) {
                if (key.equals((Key)vector4.elementAt(n3))) {
                    bl2 = true;
                    break;
                }
                ++n3;
            }
            ++n4;
        }
        if (!bl2) {
            throw new ParticleRecoverableError("rcase-nameAndTypeOK.5:  derived element " + this.fStringPool.toString(n) + " has a <key> Identity Constraint that does not appear on the base element" + this.fStringPool.toString(n2));
        }
        Vector vector5 = xMLElementDecl.keyRef;
        Vector vector6 = xMLElementDecl2.keyRef;
        if (vector5.size() > vector6.size()) {
            throw new ParticleRecoverableError("rcase-nameAndTypeOK.5:  derived element " + this.fStringPool.toString(n) + " has fewer <keyref> Identity Constraints than the base element" + this.fStringPool.toString(n2));
        }
        boolean bl3 = true;
        n3 = 0;
        while (n3 < vector5.size() && bl3) {
            KeyRef keyRef = (KeyRef)vector5.elementAt(n3);
            bl3 = false;
            int n6 = 0;
            while (n6 < vector6.size()) {
                if (keyRef.equals((KeyRef)vector6.elementAt(n6))) {
                    bl3 = true;
                    break;
                }
                ++n6;
            }
            ++n3;
        }
        if (!bl3) {
            throw new ParticleRecoverableError("rcase-nameAndTypeOK.5:  derived element " + this.fStringPool.toString(n) + " has a <keyref> Identity Constraint that does not appear on the base element" + this.fStringPool.toString(n2));
        }
    }

    private boolean checkSubstitutionGroups(int n, int n2, int n3, int n4) throws Exception {
        QName qName = new QName(-1, n, n, n2);
        QName qName2 = new QName(-1, n3, n3, n4);
        return this.fSComp.isEquivalentTo(qName, qName2) || this.fSComp.isEquivalentTo(qName2, qName);
    }

    private boolean checkOccurrenceRange(int n, int n2, int n3, int n4) {
        return n >= n3 && (n4 == -2 || n2 != -2 && n2 <= n4);
    }

    private int findElement(int n, int n2, SchemaGrammar schemaGrammar, ComplexTypeInfo complexTypeInfo) {
        int n3 = schemaGrammar.getElementDeclIndex(n2, n);
        if (n3 == -1 && (n3 = schemaGrammar.getElementDeclIndex(n2, -1)) == -1 && complexTypeInfo != null) {
            ComplexTypeInfo complexTypeInfo2 = complexTypeInfo;
            while (complexTypeInfo2 != null) {
                n3 = schemaGrammar.getElementDeclIndex(n2, complexTypeInfo2.scopeDefined);
                if (n3 > -1) break;
                complexTypeInfo2 = complexTypeInfo2.baseComplexTypeInfo;
            }
        }
        return n3;
    }

    private void checkNSCompat(int n, int n2, int n3) throws Exception {
        int n4;
        int n5;
        int n6;
        int n7 = this.fSchemaGrammar.getContentSpecMinOccurs(n);
        if (!this.checkOccurrenceRange(n7, n6 = this.fSchemaGrammar.getContentSpecMaxOccurs(n), n5 = this.fSchemaGrammar.getContentSpecMinOccurs(n3), n4 = this.fSchemaGrammar.getContentSpecMaxOccurs(n3))) {
            throw new ParticleRecoverableError("rcase-NSCompat.2:  Element occurrence range not a restriction of base any element's range");
        }
        this.fSchemaGrammar.getContentSpec(n, this.tempContentSpec1);
        int n8 = this.tempContentSpec1.otherValue;
        if (!this.wildcardEltAllowsNamespace(n3, n8)) {
            throw new ParticleRecoverableError("rcase-NSCompat.1:  Element's namespace not allowed by wildcard in base");
        }
    }

    private boolean wildcardEltAllowsNamespace(int n, int n2) {
        this.fSchemaGrammar.getContentSpec(n, this.tempContentSpec1);
        if ((this.tempContentSpec1.type & 0xF) == 6) {
            return true;
        }
        return (this.tempContentSpec1.type & 0xF) == 8 ? n2 == this.tempContentSpec1.otherValue : n2 != this.tempContentSpec1.otherValue && n2 != 0;
    }

    private void checkNSSubset(int n, int n2) throws Exception {
        int n3;
        int n4;
        int n5;
        int n6 = this.fSchemaGrammar.getContentSpecMinOccurs(n);
        if (!this.checkOccurrenceRange(n6, n5 = this.fSchemaGrammar.getContentSpecMaxOccurs(n), n4 = this.fSchemaGrammar.getContentSpecMinOccurs(n2), n3 = this.fSchemaGrammar.getContentSpecMaxOccurs(n2))) {
            throw new ParticleRecoverableError("rcase-NSSubset.2:  Wildcard's occurrence range not a restriction of base wildcard's range");
        }
        if (!this.wildcardEltSubset(n, n2)) {
            throw new ParticleRecoverableError("rcase-NSSubset.1:  Wildcard is not a subset of corresponding wildcard in base");
        }
    }

    private boolean wildcardEltSubset(int n, int n2) {
        this.fSchemaGrammar.getContentSpec(n, this.tempContentSpec1);
        this.fSchemaGrammar.getContentSpec(n2, this.tempContentSpec2);
        if ((this.tempContentSpec2.type & 0xF) == 6) {
            return true;
        }
        if ((this.tempContentSpec1.type & 0xF) == 7 && (this.tempContentSpec2.type & 0xF) == 7 && this.tempContentSpec1.otherValue == this.tempContentSpec2.otherValue) {
            return true;
        }
        if ((this.tempContentSpec1.type & 0xF) == 8) {
            if ((this.tempContentSpec2.type & 0xF) == 8 && this.tempContentSpec1.otherValue == this.tempContentSpec2.otherValue) {
                return true;
            }
            if ((this.tempContentSpec2.type & 0xF) == 7 && this.tempContentSpec1.otherValue != this.tempContentSpec2.otherValue) {
                return true;
            }
        }
        return false;
    }

    private void checkRecurseAsIfGroup(int n, int n2, int n3, Vector vector, int n4, ComplexTypeInfo complexTypeInfo) throws Exception {
        this.fSchemaGrammar.getContentSpec(n3, this.tempContentSpec2);
        int n5 = this.fSchemaGrammar.addContentSpecNode(this.tempContentSpec2.type, n, -2, false);
        Vector<Integer> vector2 = new Vector<Integer>();
        vector2.addElement(new Integer(n));
        if (this.tempContentSpec2.type == 9 || this.tempContentSpec2.type == 5) {
            this.checkRecurse(n5, vector2, n2, n3, vector, n4, complexTypeInfo);
        } else {
            this.checkRecurseLax(n5, vector2, n2, n3, vector, n4, complexTypeInfo);
        }
        vector2 = null;
    }

    private void checkNSRecurseCheckCardinality(int n, Vector vector, int n2, int n3) throws Exception {
        int n4;
        int n5;
        int n6;
        int n7 = this.minEffectiveTotalRange(n);
        if (!this.checkOccurrenceRange(n7, n6 = this.maxEffectiveTotalRange(n), n5 = this.fSchemaGrammar.getContentSpecMinOccurs(n3), n4 = this.fSchemaGrammar.getContentSpecMaxOccurs(n3))) {
            throw new ParticleRecoverableError("rcase-NSSubset.2:  Wildcard's occurrence range not a restriction of base wildcard's range");
        }
        if (!this.wildcardEltSubset(n, n3)) {
            throw new ParticleRecoverableError("rcase-NSSubset.1:  Wildcard is not a subset of corresponding wildcard in base");
        }
        int n8 = vector.size();
        int n9 = 0;
        while (n9 < n8) {
            Integer n10 = (Integer)vector.elementAt(n9);
            this.checkParticleDerivationOK(n10, n2, n3, -1, null);
            ++n9;
        }
    }

    private void checkRecurse(int n, Vector vector, int n2, int n3, Vector vector2, int n4, ComplexTypeInfo complexTypeInfo) throws Exception {
        int n5;
        int n6;
        int n7;
        int n8 = this.fSchemaGrammar.getContentSpecMinOccurs(n);
        if (!this.checkOccurrenceRange(n8, n7 = this.fSchemaGrammar.getContentSpecMaxOccurs(n), n6 = this.fSchemaGrammar.getContentSpecMinOccurs(n3), n5 = this.fSchemaGrammar.getContentSpecMaxOccurs(n3))) {
            throw new ParticleRecoverableError("rcase-Recurse.1:  Occurrence range of group is not a valid restriction of occurence range of base group");
        }
        int n9 = vector.size();
        int n10 = vector2.size();
        int n11 = 0;
        int n12 = 0;
        while (n12 < n9) {
            block8: {
                Integer n13 = (Integer)vector.elementAt(n12);
                int n14 = n11;
                while (n14 < n10) {
                    Integer n15 = (Integer)vector2.elementAt(n14);
                    ++n11;
                    try {
                        this.checkParticleDerivationOK(n13, n2, n15, n4, complexTypeInfo);
                        break block8;
                    }
                    catch (ParticleRecoverableError particleRecoverableError) {
                        if (!this.particleEmptiable(n15)) {
                            throw new ParticleRecoverableError("rcase-Recurse.2:  There is not a complete functional mapping between the particles");
                        }
                        ++n14;
                    }
                }
                throw new ParticleRecoverableError("rcase-Recurse.2:  There is not a complete functional mapping between the particles");
            }
            ++n12;
        }
        int n16 = n11;
        while (n16 < n10) {
            Integer n17 = (Integer)vector2.elementAt(n16);
            if (!this.particleEmptiable(n17)) {
                throw new ParticleRecoverableError("rcase-Recurse.2:  There is not a complete functional mapping between the particles");
            }
            ++n16;
        }
    }

    private void checkRecurseUnordered(int n, Vector vector, int n2, int n3, Vector vector2, int n4, ComplexTypeInfo complexTypeInfo) throws Exception {
        int n5;
        int n6;
        int n7;
        int n8 = this.fSchemaGrammar.getContentSpecMinOccurs(n);
        if (!this.checkOccurrenceRange(n8, n7 = this.fSchemaGrammar.getContentSpecMaxOccurs(n), n6 = this.fSchemaGrammar.getContentSpecMinOccurs(n3), n5 = this.fSchemaGrammar.getContentSpecMaxOccurs(n3))) {
            throw new ParticleRecoverableError("rcase-RecurseUnordered.1:  Occurrence range of group is not a valid restriction of occurence range of base group");
        }
        int n9 = vector.size();
        int n10 = vector2.size();
        boolean[] blArray = new boolean[n10];
        int n11 = 0;
        while (n11 < n9) {
            block6: {
                Integer n12 = (Integer)vector.elementAt(n11);
                int n13 = 0;
                while (n13 < n10) {
                    Integer n14 = (Integer)vector2.elementAt(n13);
                    try {
                        this.checkParticleDerivationOK(n12, n2, n14, n4, complexTypeInfo);
                        if (blArray[n13]) {
                            throw new ParticleRecoverableError("rcase-RecurseUnordered.2:  There is not a complete functional mapping between the particles");
                        }
                        blArray[n13] = true;
                        break block6;
                    }
                    catch (ParticleRecoverableError particleRecoverableError) {
                        ++n13;
                    }
                }
                throw new ParticleRecoverableError("rcase-RecurseUnordered.2:  There is not a complete functional mapping between the particles");
            }
            ++n11;
        }
    }

    private void checkRecurseLax(int n, Vector vector, int n2, int n3, Vector vector2, int n4, ComplexTypeInfo complexTypeInfo) throws Exception {
        int n5;
        int n6;
        int n7;
        int n8 = this.fSchemaGrammar.getContentSpecMinOccurs(n);
        if (!this.checkOccurrenceRange(n8, n7 = this.fSchemaGrammar.getContentSpecMaxOccurs(n), n6 = this.fSchemaGrammar.getContentSpecMinOccurs(n3), n5 = this.fSchemaGrammar.getContentSpecMaxOccurs(n3))) {
            throw new ParticleRecoverableError("rcase-RecurseLax.1:  Occurrence range of group is not a valid restriction of occurence range of base group");
        }
        int n9 = vector.size();
        int n10 = vector2.size();
        int n11 = 0;
        int n12 = 0;
        while (n12 < n9) {
            block5: {
                Integer n13 = (Integer)vector.elementAt(n12);
                int n14 = n11;
                while (n14 < n10) {
                    Integer n15 = (Integer)vector2.elementAt(n14);
                    ++n11;
                    try {
                        this.checkParticleDerivationOK(n13, n2, n15, n4, complexTypeInfo);
                        break block5;
                    }
                    catch (ParticleRecoverableError particleRecoverableError) {
                        ++n14;
                    }
                }
                throw new ParticleRecoverableError("rcase-Recurse.2:  There is not a complete functional mapping between the particles");
            }
            ++n12;
        }
    }

    private void checkMapAndSum(int n, Vector vector, int n2, int n3, Vector vector2, int n4, ComplexTypeInfo complexTypeInfo) throws Exception {
        int n5;
        int n6;
        int n7 = vector.size();
        int n8 = vector2.size();
        int n9 = this.fSchemaGrammar.getContentSpecMinOccurs(n) * n7;
        int n10 = this.fSchemaGrammar.getContentSpecMaxOccurs(n);
        if (n10 != -2) {
            n10 *= n7;
        }
        if (!this.checkOccurrenceRange(n9, n10, n6 = this.fSchemaGrammar.getContentSpecMinOccurs(n3), n5 = this.fSchemaGrammar.getContentSpecMaxOccurs(n3))) {
            throw new ParticleRecoverableError("rcase-MapAndSum.2:  Occurrence range of group is not a valid restriction of occurence range of base group");
        }
        int n11 = 0;
        while (n11 < n7) {
            block6: {
                Integer n12 = (Integer)vector.elementAt(n11);
                int n13 = 0;
                while (n13 < n8) {
                    Integer n14 = (Integer)vector2.elementAt(n13);
                    try {
                        this.checkParticleDerivationOK(n12, n2, n14, n4, complexTypeInfo);
                        break block6;
                    }
                    catch (ParticleRecoverableError particleRecoverableError) {
                        ++n13;
                    }
                }
                throw new ParticleRecoverableError("rcase-MapAndSum.1:  There is not a complete functional mapping between the particles");
            }
            ++n11;
        }
    }

    private int importContentSpec(SchemaGrammar schemaGrammar, int n) throws Exception {
        XMLContentSpec xMLContentSpec = new XMLContentSpec();
        schemaGrammar.getContentSpec(n, xMLContentSpec);
        int n2 = -1;
        int n3 = -1;
        if (xMLContentSpec.type == 0 || (xMLContentSpec.type & 0xF) == 6 || (xMLContentSpec.type & 0xF) == 8 || (xMLContentSpec.type & 0xF) == 7) {
            return this.fSchemaGrammar.addContentSpecNode(xMLContentSpec.type, xMLContentSpec.value, xMLContentSpec.otherValue, false);
        }
        if (xMLContentSpec.type == -1) {
            return -2;
        }
        n2 = xMLContentSpec.value == -1 ? -1 : this.importContentSpec(schemaGrammar, xMLContentSpec.value);
        n3 = xMLContentSpec.otherValue == -1 ? -1 : this.importContentSpec(schemaGrammar, xMLContentSpec.otherValue);
        return this.fSchemaGrammar.addContentSpecNode(xMLContentSpec.type, n2, n3, false);
    }

    private int handleOccurrences(int n, Element element) throws Exception {
        return this.handleOccurrences(n, element, 0);
    }

    private int handleOccurrences(int n, Element element, int n2) throws Exception {
        boolean bl;
        if (n < 0) {
            return n;
        }
        String string = element.getAttribute("minOccurs").trim();
        String string2 = element.getAttribute("maxOccurs").trim();
        boolean bl2 = (n2 & 1) != 0;
        boolean bl3 = (n2 & 8) != 0;
        boolean bl4 = (n2 & 2) != 0;
        boolean bl5 = bl = (n2 & 4) != 0;
        if (bl && (string.length() != 0 || string2.length() != 0)) {
            this.reportSchemaError(49, null);
            string2 = "1";
            string = "1";
        }
        if (string.equals("0") && string2.equals("0")) {
            return -2;
        }
        int n3 = 1;
        int n4 = 1;
        if (string.length() == 0) {
            string = "1";
        }
        if (string2.length() == 0) {
            string2 = "1";
        }
        if (bl2 || bl4 || bl3) {
            int n5;
            if ((bl3 || bl4 || !string.equals("0")) && !string.equals("1")) {
                n5 = bl2 ? 44 : (bl3 ? 50 : 45);
                this.reportSchemaError(n5, new Object[]{"minOccurs", string});
                string = "1";
            }
            if (!string2.equals("1")) {
                n5 = bl2 ? 44 : (bl3 ? 50 : 45);
                this.reportSchemaError(n5, new Object[]{"maxOccurs", string2});
                string2 = "1";
            }
        }
        try {
            n3 = Integer.parseInt(string);
        }
        catch (Exception exception) {
            this.reportSchemaError(23, new Object[]{"illegal value for minOccurs or maxOccurs : '" + exception.getMessage() + "' "});
        }
        if (string2.equals("unbounded")) {
            n4 = -2;
        } else {
            try {
                n4 = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                this.reportSchemaError(23, new Object[]{"illegal value for minOccurs or maxOccurs : '" + exception.getMessage() + "' "});
            }
            if (n3 > n4) {
                this.reportGenericSchemaError("p-props-correct:2.1 Value of minOccurs '" + string + "' must not be greater than value of maxOccurs '" + string2 + "'");
            }
            if (n4 < 1) {
                this.reportGenericSchemaError("p-props-correct:2.2 Value of maxOccurs " + string2 + " is invalid.  It must be greater than or equal to 1");
            }
        }
        if (this.fSchemaGrammar.getDeferContentSpecExpansion()) {
            this.fSchemaGrammar.setContentSpecMinOccurs(n, n3);
            this.fSchemaGrammar.setContentSpecMaxOccurs(n, n4);
            return n;
        }
        return this.fSchemaGrammar.expandContentModel(n, n3, n4);
    }

    private int traverseAttributeDecl(Element element, ComplexTypeInfo complexTypeInfo, boolean bl) throws Exception {
        DatatypeValidator datatypeValidator;
        int n;
        QName qName;
        StringBuffer stringBuffer;
        boolean bl2;
        int n2;
        int n3;
        boolean bl3;
        int n4;
        boolean bl4;
        String string;
        block84: {
            int n5;
            int n6 = this.isTopLevel(element) ? GeneralAttrCheck.ELE_CONTEXT_GLOBAL : GeneralAttrCheck.ELE_CONTEXT_LOCAL;
            Hashtable hashtable = this.generalCheck(element, n6);
            String string2 = element.getAttribute("default");
            String string3 = element.getAttribute("fixed");
            String string4 = element.getAttribute("form");
            string = element.getAttribute("name");
            String string5 = element.getAttribute("ref");
            String string6 = element.getAttribute("type");
            String string7 = element.getAttribute("use");
            Element element2 = this.findAttributeSimpleType(element);
            Attr attr = element.getAttributeNode("default");
            Attr attr2 = element.getAttributeNode("fixed");
            Attr attr3 = element.getAttributeNode("form");
            Attr attr4 = element.getAttributeNode("name");
            Attr attr5 = element.getAttributeNode("ref");
            Attr attr6 = element.getAttributeNode("type");
            Attr attr7 = element.getAttributeNode("use");
            this.checkEnumerationRequiredNotation(string, string6);
            bl4 = false;
            n4 = -1;
            String string8 = null;
            bl3 = false;
            n3 = 0;
            n2 = -1;
            bl2 = this.isTopLevel(element);
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            stringBuffer = new StringBuffer(30);
            stringBuffer.append(" -- ");
            if (complexTypeInfo == null) {
                stringBuffer.append("(global attribute) ");
            } else if (complexTypeInfo.typeName == null) {
                stringBuffer.append("(local attribute) ");
            } else {
                stringBuffer.append("(attribute) ").append(complexTypeInfo.typeName).append("/");
            }
            stringBuffer.append(string).append(' ').append(string5);
            if (string7.length() == 0 || string7.equals("optional")) {
                n3 |= 1;
                bl5 = true;
            } else if (string7.equals("prohibited")) {
                n3 |= 4;
                bl6 = true;
            } else if (string7.equals("required")) {
                n3 |= 2;
                bl7 = true;
            } else {
                this.reportGenericSchemaError("An attribute cannot declare \"use\" as \"" + string7 + "\"" + stringBuffer);
            }
            if (attr != null && attr2 != null) {
                this.reportGenericSchemaError("src-attribute.1: \"default\" and \"fixed\" cannot be both present" + stringBuffer);
            } else if (attr != null && !bl5) {
                this.reportGenericSchemaError("src-attribute.2: If both \"default\" and \"use\" are present for an attribute declaration, \"use\" can only be \"optional\", not \"" + string7 + "\"." + stringBuffer);
            }
            if (!bl2) {
                if (attr5 == null == (attr4 == null)) {
                    this.reportGenericSchemaError("src-attribute.3.1: When the attribute's parent is not <schema> , one of \"ref\" and \"name\" should be declared, but not both." + stringBuffer);
                    return -1;
                }
                if (attr5 != null && (element2 != null || attr3 != null || attr6 != null)) {
                    this.reportGenericSchemaError("src-attribute.3.2: When the attribute's parent is not <schema> and \"ref\" is present, all of <simpleType>, form and type must be absent." + stringBuffer);
                }
            }
            if (attr6 != null && element2 != null) {
                this.reportGenericSchemaError("src-attribute.4: \"type\" and <simpleType> cannot both be present" + stringBuffer);
            }
            if (bl2) {
                int n7 = this.fStringPool.addSymbol(string);
                n5 = this.fTargetNSURIString.length() == 0 ? 0 : this.fTargetNSURI;
                qName = new QName();
                qName.setValues(-1, n7, n7, n5);
            } else if (attr5 == null) {
                int n8 = this.fStringPool.addSymbol(string);
                n5 = string4.length() > 0 && string4.equals("qualified") || string4.length() == 0 && this.fAttributeDefaultQualified ? this.fTargetNSURI : 0;
                qName = new QName();
                qName.setValues(-1, n8, n8, n5);
            } else {
                String string9;
                int n9 = string5.indexOf(":");
                if (n9 > 0) {
                    string9 = string5.substring(0, n9);
                    string8 = string5.substring(n9 + 1);
                } else {
                    string9 = "";
                    string8 = string5;
                }
                String string10 = this.resolvePrefixToURI(string9);
                if (!string10.equals(this.fTargetNSURIString)) {
                    this.addAttributeDeclFromAnotherSchema(string8, string10, complexTypeInfo);
                    return 0;
                }
                Element element3 = this.getTopLevelComponentByName("attribute", string8);
                if (element3 != null) {
                    String string11;
                    this.traverseAttributeDecl(element3, complexTypeInfo, true);
                    Attr attr8 = element3.getAttributeNode("fixed");
                    String string12 = string11 = attr8 == null ? null : attr8.getValue();
                    if (string11 != null && (attr != null || attr2 != null && !string11.equals(string3))) {
                        this.reportGenericSchemaError("au-props-correct.2: If the {attribute declaration} has a fixed {value constraint}, then if the attribute use itself has a {value constraint}, it must also be fixed and its value must match that of the {attribute declaration}'s {value constraint}" + stringBuffer);
                    }
                    if (!(complexTypeInfo == null || bl5 && string3.length() <= 0)) {
                        int n10 = this.fStringPool.addSymbol(element3.getAttribute("name"));
                        int n11 = 0;
                        if (this.fTargetNSURIString.length() > 0) {
                            n11 = this.fTargetNSURI;
                        }
                        QName qName2 = new QName(-1, n10, n10, n11);
                        int n12 = this.fSchemaGrammar.getAttributeDeclIndex(complexTypeInfo.templateElementIndex, qName2);
                        XMLAttributeDecl xMLAttributeDecl = new XMLAttributeDecl();
                        this.fSchemaGrammar.getAttributeDecl(n12, xMLAttributeDecl);
                        boolean bl8 = false;
                        int n13 = 7;
                        int n14 = 24;
                        if (!bl5 && (xMLAttributeDecl.defaultType & n13) != (n3 & n13) && xMLAttributeDecl.defaultType != 4) {
                            xMLAttributeDecl.defaultType |= n13;
                            xMLAttributeDecl.defaultType ^= n13;
                            xMLAttributeDecl.defaultType |= n3 & n13;
                            bl8 = true;
                        }
                        if (string3.length() > 0 && (xMLAttributeDecl.defaultType & 0x10) == 0) {
                            xMLAttributeDecl.defaultType |= n14;
                            xMLAttributeDecl.defaultType ^= n14;
                            xMLAttributeDecl.defaultType |= 0x10;
                            xMLAttributeDecl.defaultValue = string3;
                            bl8 = true;
                        }
                        if (bl8) {
                            this.fSchemaGrammar.setAttributeDecl(complexTypeInfo.templateElementIndex, n12, xMLAttributeDecl);
                        }
                    }
                } else if (this.fAttributeDeclRegistry.get(string8) != null) {
                    this.addAttributeDeclFromAnotherSchema(string8, string10, complexTypeInfo);
                } else {
                    this.reportGenericSchemaError("Couldn't find top level attribute " + string5 + stringBuffer);
                }
                return 0;
            }
            if (n5 == this.fXsiURI) {
                this.reportGenericSchemaError("no-xsi: The {target namespace} of an attribute declaration must not match http://www.w3.org/2001/XMLSchema-instance" + stringBuffer);
            }
            if (element2 != null) {
                n = 7;
                n4 = this.traverseSimpleTypeDecl(element2);
                string8 = this.fStringPool.toString(n4);
                datatypeValidator = this.fDatatypeRegistry.getDatatypeValidator(string8);
            } else if (string6.length() != 0) {
                String string13;
                n4 = this.fStringPool.addSymbol(string6);
                int n15 = string6.indexOf(":");
                if (n15 > 0) {
                    string13 = string6.substring(0, n15);
                    string8 = string6.substring(n15 + 1);
                } else {
                    string13 = "";
                    string8 = string6;
                }
                String string14 = this.resolvePrefixToURI(string13);
                if (string14.equals("http://www.w3.org/2001/XMLSchema")) {
                    datatypeValidator = this.getDatatypeValidator("http://www.w3.org/2001/XMLSchema", string8);
                    if (string8.equals("ID")) {
                        n = 3;
                    } else if (string8.equals("IDREF")) {
                        n = 4;
                    } else if (string8.equals("IDREFS")) {
                        n = 4;
                        bl4 = true;
                    } else if (string8.equals("ENTITY")) {
                        n = 1;
                    } else if (string8.equals("ENTITIES")) {
                        n = 1;
                        bl4 = true;
                    } else if (string8.equals("NMTOKEN")) {
                        n = 5;
                    } else if (string8.equals("NMTOKENS")) {
                        n = 5;
                        bl4 = true;
                    } else if (string8.equals("notation")) {
                        n = 6;
                    } else {
                        n = 7;
                        if (datatypeValidator == null && !bl) {
                            this.reportGenericSchemaError("attribute " + string + " has a type (" + string6 + ") which is not recognized as one of the predefined schema datatypes");
                        }
                    }
                } else {
                    n = 7;
                    datatypeValidator = this.getDatatypeValidator(string14, string8);
                    if (datatypeValidator == null && string14.equals(this.fTargetNSURIString)) {
                        Element element4 = this.getTopLevelComponentByName("simpleType", string8);
                        if (element4 != null) {
                            this.traverseSimpleTypeDecl(element4);
                            datatypeValidator = this.getDatatypeValidator(string14, string8);
                        } else if (!bl) {
                            this.reportGenericSchemaError("simpleType not found : (" + string14 + ":" + string8 + ")" + stringBuffer);
                        }
                    }
                    if (datatypeValidator == null && !bl) {
                        this.reportGenericSchemaError("attribute " + string + " has an unrecognized type " + string6);
                    }
                }
            } else {
                n = 7;
                string8 = "string";
                n4 = this.fStringPool.addSymbol(string8);
                datatypeValidator = this.fDatatypeRegistry.getDatatypeValidator(string8);
            }
            if (string2.length() > 0) {
                n3 |= 8;
                n2 = this.fStringPool.addString(string2);
            } else if (string3.length() > 0) {
                n3 |= 0x10;
                n2 = this.fStringPool.addString(string3);
            }
            if (n == 7 && n2 != -1) {
                try {
                    if (datatypeValidator != null) {
                        if (string2.length() > 0) {
                            datatypeValidator.validate(string2, null);
                        } else {
                            datatypeValidator.validate(string3, null);
                        }
                    } else if (!bl) {
                        this.reportSchemaError(2, new Object[]{string6});
                    }
                }
                catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                    if (bl) break block84;
                    this.reportSchemaError(18, new Object[]{element.getAttribute("name"), invalidDatatypeValueException.getMessage()});
                }
            }
        }
        boolean bl9 = bl3 = datatypeValidator != null && datatypeValidator instanceof IDDatatypeValidator;
        if (bl3 && n2 != -1) {
            this.reportGenericSchemaError("a-props-correct.3: If type definition is or is derived from ID ,there must not be a value constraint" + stringBuffer);
        }
        if (string.equals("xmlns")) {
            this.reportGenericSchemaError("no-xmlns: The {name} of an attribute declaration must not match 'xmlns'" + stringBuffer);
        }
        if (bl2) {
            this.fTempAttributeDecl.datatypeValidator = datatypeValidator;
            this.fTempAttributeDecl.name.setValues(qName);
            this.fTempAttributeDecl.type = n;
            this.fTempAttributeDecl.defaultType = n3;
            this.fTempAttributeDecl.list = bl4;
            if (n2 != -1) {
                this.fTempAttributeDecl.defaultValue = this.fStringPool.toString(n2);
            }
            this.fAttributeDeclRegistry.put(string, new XMLAttributeDecl(this.fTempAttributeDecl));
        }
        if (complexTypeInfo != null) {
            int n16 = this.fSchemaGrammar.getAttributeDeclIndex(complexTypeInfo.templateElementIndex, qName);
            if (n16 > -1) {
                this.reportGenericSchemaError("ct-props-correct.4:  Duplicate attribute " + this.fStringPool.toString(qName.rawname) + " in type definition");
            }
            if (bl3) {
                if (complexTypeInfo.containsAttrTypeID()) {
                    this.reportGenericSchemaError("ct-props-correct.5: More than one attribute derived from type ID cannot appear in the same complex type definition.");
                }
                complexTypeInfo.setContainsAttrTypeID();
            }
            this.fSchemaGrammar.addAttDef(complexTypeInfo.templateElementIndex, qName, n, n4, n3, this.fStringPool.toString(n2), datatypeValidator, bl4);
        }
        return 0;
    }

    private int addAttributeDeclFromAnotherSchema(String string, String string2, ComplexTypeInfo complexTypeInfo) throws Exception {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarResolver.getGrammar(string2);
        if (string2 == null || !(schemaGrammar instanceof SchemaGrammar)) {
            this.reportGenericSchemaError("no attribute named \"" + string + "\" was defined in schema : " + string2);
            return -1;
        }
        Hashtable hashtable = schemaGrammar.getAttributeDeclRegistry();
        if (hashtable == null) {
            this.reportGenericSchemaError("no attribute named \"" + string + "\" was defined in schema : " + string2);
            return -1;
        }
        XMLAttributeDecl xMLAttributeDecl = (XMLAttributeDecl)hashtable.get(string);
        if (xMLAttributeDecl == null) {
            this.reportGenericSchemaError("no attribute named \"" + string + "\" was defined in schema : " + string2);
            return -1;
        }
        if (complexTypeInfo != null) {
            int n = this.fSchemaGrammar.getAttributeDeclIndex(complexTypeInfo.templateElementIndex, xMLAttributeDecl.name);
            if (n > -1) {
                this.reportGenericSchemaError("ct-props-correct.4:  Duplicate attribute " + this.fStringPool.toString(xMLAttributeDecl.name.rawname) + " in type definition");
            }
            if (xMLAttributeDecl.datatypeValidator != null && xMLAttributeDecl.datatypeValidator instanceof IDDatatypeValidator) {
                if (complexTypeInfo.containsAttrTypeID()) {
                    this.reportGenericSchemaError("ct-props-correct.5: More than one attribute derived from type ID cannot appear in the same complex type definition");
                }
                complexTypeInfo.setContainsAttrTypeID();
            }
            this.fSchemaGrammar.addAttDef(complexTypeInfo.templateElementIndex, xMLAttributeDecl.name, xMLAttributeDecl.type, -1, xMLAttributeDecl.defaultType, xMLAttributeDecl.defaultValue, xMLAttributeDecl.datatypeValidator, xMLAttributeDecl.list);
        }
        return 0;
    }

    private int traverseAttributeGroupDecl(Element element, ComplexTypeInfo complexTypeInfo, Vector vector) throws Exception {
        Object object;
        int n = this.isTopLevel(element) ? GeneralAttrCheck.ELE_CONTEXT_GLOBAL : GeneralAttrCheck.ELE_CONTEXT_LOCAL;
        Hashtable hashtable = this.generalCheck(element, n);
        String string = element.getAttribute("name");
        int n2 = this.fStringPool.addSymbol(string);
        String string2 = element.getAttribute("ref");
        Element element2 = this.checkContent(element, XUtil.getFirstChildElement(element), true);
        if (string2.length() != 0) {
            String string3;
            if (this.isTopLevel(element)) {
                this.reportGenericSchemaError("An attributeGroup with \"ref\" present must not have <schema> or <redefine> as its parent");
            }
            if (string.length() != 0) {
                this.reportGenericSchemaError("attributeGroup " + string + " cannot refer to another attributeGroup, but it refers to " + string2);
            }
            if (XUtil.getFirstChildElement(element) != null || element.getNodeValue() != null) {
                this.reportGenericSchemaError("An attributeGroup with \"ref\" present must be empty");
            }
            object = "";
            String string4 = string2;
            int n3 = string2.indexOf(":");
            if (n3 > 0) {
                object = string2.substring(0, n3);
                string4 = string2.substring(n3 + 1);
            }
            if (!(string3 = this.resolvePrefixToURI((String)object)).equals(this.fTargetNSURIString)) {
                this.traverseAttributeGroupDeclFromAnotherSchema(string4, string3, complexTypeInfo, vector);
                return -1;
            }
            Element element3 = (Element)element.getParentNode();
            if (element3.getLocalName().equals("attributeGroup") && element3.getAttribute("name").equals(string4)) {
                if (!((Element)element3.getParentNode()).getLocalName().equals("redefine")) {
                    this.reportGenericSchemaError("src-attribute_group.3: Circular group reference is disallowed outside <redefine> -- " + string2);
                }
                return -1;
            }
            if (complexTypeInfo != null) {
                element3 = this.getTopLevelComponentByName("attributeGroup", string4);
                if (element3 != null) {
                    this.traverseAttributeGroupDecl(element3, complexTypeInfo, vector);
                } else {
                    this.reportGenericSchemaError("Couldn't find top level attributeGroup " + string2);
                }
                return -1;
            }
        } else if (string.length() == 0) {
            this.reportGenericSchemaError("an attributeGroup must have a name or a ref attribute present");
        }
        while (element2 != null) {
            if (element2.getLocalName().equals("attribute")) {
                this.traverseAttributeDecl(element2, complexTypeInfo, false);
            } else {
                if (!element2.getLocalName().equals("attributeGroup")) break;
                object = (NamespacesScope)this.fNamespacesScope.clone();
                this.traverseAttributeGroupDecl(element2, complexTypeInfo, vector);
                this.fNamespacesScope = object;
            }
            element2 = XUtil.getNextSiblingElement(element2);
        }
        if (element2 != null) {
            if (element2.getLocalName().equals("anyAttribute")) {
                if (vector != null) {
                    vector.addElement(this.traverseAnyAttribute(element2));
                }
                if (XUtil.getNextSiblingElement(element2) != null) {
                    this.reportGenericSchemaError("src-attribute_group.0: The content of an attributeGroup declaration must match (annotation?, ((attribute | attributeGroup)*, anyAttribute?))");
                }
                return -1;
            }
            this.reportGenericSchemaError("src-attribute_group.0: The content of an attributeGroup declaration must match (annotation?, ((attribute | attributeGroup)*, anyAttribute?))");
        }
        return -1;
    }

    private int traverseAttributeGroupDeclFromAnotherSchema(String string, String string2, ComplexTypeInfo complexTypeInfo, Vector vector) throws Exception {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarResolver.getGrammar(string2);
        if (string2 == null || schemaGrammar == null || !(schemaGrammar instanceof SchemaGrammar)) {
            this.reportGenericSchemaError("!!Schema not found in #traverseAttributeGroupDeclFromAnotherSchema, schema uri : " + string2);
            return -1;
        }
        Element element = (Element)schemaGrammar.topLevelAttrGrpDecls.get(string);
        if (element == null) {
            this.reportGenericSchemaError("no attribute group named \"" + string + "\" was defined in schema : " + string2);
            return -1;
        }
        NamespacesScope namespacesScope = this.fNamespacesScope;
        int n = this.fTargetNSURI;
        this.fTargetNSURI = this.fStringPool.addSymbol(schemaGrammar.getTargetNamespaceURI());
        this.fNamespacesScope = schemaGrammar.getNamespacesScope();
        int n2 = -1;
        int n3 = -1;
        Element element2 = this.checkContent(element, XUtil.getFirstChildElement(element), true);
        while (element2 != null) {
            if (element2.getLocalName().equals("attribute")) {
                String string3 = element2.getAttribute("name");
                if (string3.length() > 0) {
                    Hashtable hashtable = schemaGrammar.getAttributeDeclRegistry();
                    if (hashtable != null && hashtable.get(string3) != null) {
                        this.addAttributeDeclFromAnotherSchema(string3, string2, complexTypeInfo);
                        this.fNamespacesScope = namespacesScope;
                        this.fTargetNSURI = n;
                        return -1;
                    }
                    this.traverseAttributeDecl(element2, complexTypeInfo, false);
                } else {
                    this.traverseAttributeDecl(element2, complexTypeInfo, false);
                }
            } else if (element2.getLocalName().equals("attributeGroup")) {
                this.traverseAttributeGroupDecl(element2, complexTypeInfo, vector);
            } else {
                if (element2.getLocalName().equals("anyAttribute")) {
                    vector.addElement(this.traverseAnyAttribute(element2));
                    break;
                }
                this.reportGenericSchemaError("Invalid content for attributeGroup");
            }
            element2 = XUtil.getNextSiblingElement(element2);
        }
        this.fNamespacesScope = namespacesScope;
        this.fTargetNSURI = n;
        if (element2 != null) {
            this.reportGenericSchemaError("Invalid content for attributeGroup");
        }
        return -1;
    }

    private Element findAttributeSimpleType(Element element) throws Exception {
        Element element2 = this.checkContent(element, XUtil.getFirstChildElement(element), true);
        if (element2 == null) {
            return null;
        }
        if (!element2.getLocalName().equals("simpleType") || XUtil.getNextSiblingElement(element2) != null) {
            this.reportGenericSchemaError("src-attribute.0: the content must match (annotation?, (simpleType?)) -- attribute declaration '" + element.getAttribute("name") + "'");
        }
        if (element2.getLocalName().equals("simpleType")) {
            return element2;
        }
        return null;
    }

    private QName traverseElementDecl(Element element) throws Exception {
        Element element2;
        int n;
        Object object;
        Object object2;
        Object object3;
        String string;
        String string2;
        int n2;
        int n3;
        int n4 = this.isTopLevel(element) ? GeneralAttrCheck.ELE_CONTEXT_GLOBAL : GeneralAttrCheck.ELE_CONTEXT_LOCAL;
        Hashtable hashtable = this.generalCheck(element, n4);
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -2;
        DatatypeValidator datatypeValidator = null;
        String string3 = element.getAttribute("abstract");
        String string4 = element.getAttribute("block");
        String string5 = element.getAttribute("default");
        String string6 = element.getAttribute("final");
        String string7 = element.getAttribute("fixed");
        String string8 = element.getAttribute("form");
        String string9 = element.getAttribute("maxOccurs");
        String string10 = element.getAttribute("minOccurs");
        String string11 = element.getAttribute("name");
        String string12 = element.getAttribute("nillable");
        String string13 = element.getAttribute("ref");
        String string14 = element.getAttribute("substitutionGroup");
        String string15 = element.getAttribute("type");
        this.checkEnumerationRequiredNotation(string11, string15);
        Attr attr = element.getAttributeNode("abstract");
        Attr attr2 = element.getAttributeNode("block");
        Attr attr3 = element.getAttributeNode("default");
        Attr attr4 = element.getAttributeNode("final");
        Attr attr5 = element.getAttributeNode("fixed");
        Attr attr6 = element.getAttributeNode("form");
        Attr attr7 = element.getAttributeNode("maxOccurs");
        Attr attr8 = element.getAttributeNode("minOccurs");
        Attr attr9 = element.getAttributeNode("name");
        Attr attr10 = element.getAttributeNode("nillable");
        Attr attr11 = element.getAttributeNode("ref");
        Attr attr12 = element.getAttributeNode("substitutionGroup");
        Attr attr13 = element.getAttributeNode("type");
        if (attr3 != null && attr5 != null) {
            this.reportGenericSchemaError("src-element.1: an element cannot have both \"fixed\" and \"default\" present at the same time");
        }
        String string16 = null;
        if (this.isTopLevel(element)) {
            if (attr9 == null) {
                this.reportGenericSchemaError("globally-declared element must have a name");
            } else if (attr11 != null) {
                this.reportGenericSchemaError("globally-declared element " + string11 + " cannot have a ref attribute");
            }
            n3 = this.fStringPool.addSymbol(string11);
            n2 = this.fSchemaGrammar.getElementDeclIndex(this.fTargetNSURI, n3, -1);
            if (n2 > -1) {
                return new QName(-1, n3, n3, this.fTargetNSURI);
            }
        }
        if (attr2 == null) {
            string4 = null;
        }
        n3 = this.parseBlockSet(string4);
        if (string4 != null && string4.length() != 0 && !string4.equals("#all") && (n3 & 2) == 0 && (n3 & 1) == 0 && (n3 & 0x20) == 0) {
            this.reportGenericSchemaError("The values of the 'block' attribute of an element must be either #all or a list of 'substitution', 'restriction' and 'extension'; " + string4 + " was found");
        }
        if (attr4 == null) {
            string6 = null;
        }
        n2 = this.parseFinalSet(string6);
        if (string6 != null && string6.length() != 0 && !string6.equals("#all") && (n2 & 2) == 0 && (n2 & 1) == 0) {
            this.reportGenericSchemaError("The values of the 'final' attribute of an element must be either #all or a list of 'restriction' and 'extension'; " + string6 + " was found");
        }
        boolean bl = string12.equals("true");
        boolean bl2 = string3.equals("true");
        int n9 = 0;
        if (bl) {
            ++n9;
        }
        if (bl2) {
            n9 += 2;
        }
        if (attr5 != null) {
            n9 += 4;
        }
        if (attr11 != null) {
            Element element3;
            Element element4;
            if (attr != null || attr2 != null || attr3 != null || attr4 != null || attr5 != null || attr6 != null || attr10 != null || attr12 != null || attr13 != null) {
                this.reportSchemaError(16, null);
            }
            if (attr9 != null) {
                this.reportGenericSchemaError("src-element.2.1: element " + string11 + " cannot also have a ref attribute");
            }
            if ((element4 = XUtil.getFirstChildElement(element)) != null && element4.getLocalName().equals("annotation")) {
                if (XUtil.getNextSiblingElement(element4) != null) {
                    this.reportSchemaError(17, null);
                } else {
                    this.traverseAnnotationDecl(element4);
                }
            } else if (element4 != null) {
                this.reportSchemaError(17, null);
            }
            String string17 = "";
            String string18 = string13;
            int n10 = string13.indexOf(":");
            if (n10 > 0) {
                string17 = string13.substring(0, n10);
                string18 = string13.substring(n10 + 1);
            }
            int n11 = this.fStringPool.addSymbol(string18);
            String string19 = this.resolvePrefixToURI(string17);
            QName qName = new QName(string17 != null ? this.fStringPool.addSymbol(string17) : -1, n11, this.fStringPool.addSymbol(string13), string19 != null ? this.fStringPool.addSymbol(string19) : 0);
            if (!string19.equals(this.fTargetNSURIString)) {
                return qName;
            }
            int n12 = this.fSchemaGrammar.getElementDeclIndex(qName, -1);
            if (n12 == -1 && (element3 = this.getTopLevelComponentByName("element", string18)) == null) {
                this.reportGenericSchemaError("Element " + string18 + " not found in the Schema");
                return qName;
            }
            if (this.fCurrentScope != -1 && this.fFullConstraintChecking) {
                this.fTopLevelElementsRefdFromGroup.addElement(qName);
                this.fTopLevelElementsRefdFromGroup.addElement(new Integer(this.fCurrentScope));
            }
            return qName;
        }
        if (attr9 == null) {
            this.reportGenericSchemaError("src-element.2.1: a local element must have a name or a ref attribute present");
        }
        Element element5 = null;
        int n13 = -1;
        boolean bl3 = true;
        Object object4 = null;
        Element element6 = XUtil.getFirstChildElement(element);
        if (element6 != null && element6.getLocalName().equals("annotation")) {
            this.traverseAnnotationDecl(element6);
            element6 = XUtil.getNextSiblingElement(element6);
        }
        if (element6 != null && element6.getLocalName().equals("annotation")) {
            this.reportGenericSchemaError("element declarations can contain at most one annotation Element Information Item");
        }
        boolean bl4 = false;
        if (element6 != null) {
            string2 = element6.getLocalName();
            if (string2.equals("complexType")) {
                if (element6.getAttribute("name").length() > 0) {
                    bl3 = false;
                    this.reportGenericSchemaError("anonymous complexType in element '" + string11 + "' has a name attribute");
                } else {
                    string = this.genAnonTypeName(element6);
                    if (this.fCurrentTypeNameStack.search(string) > -1) {
                        int n14 = 0;
                        if (string8.equals("qualified") || this.fElementDefaultQualified) {
                            n14 = this.fTargetNSURI;
                        }
                        int n15 = this.fStringPool.addSymbol(string11);
                        QName qName = new QName(-1, n15, n15, n14);
                        int n16 = this.fSchemaGrammar.addElementDecl(qName, this.fCurrentScope, this.fCurrentScope, -1, -1, -1, null);
                        this.fElementRecurseComplex.addElement(new ElementInfo(n16, string));
                        return qName;
                    }
                    n7 = this.traverseComplexTypeDecl(element6);
                    if (n7 != -1) {
                        object4 = (ComplexTypeInfo)this.fComplexTypeRegistry.get(this.fStringPool.toString(n7));
                    } else {
                        bl3 = false;
                        this.reportGenericSchemaError("traverse complexType error in element '" + string11 + "'");
                    }
                }
                bl4 = true;
                element6 = XUtil.getNextSiblingElement(element6);
            } else if (string2.equals("simpleType")) {
                if (element6.getAttribute("name").length() > 0) {
                    bl3 = false;
                    this.reportGenericSchemaError("anonymous simpleType in element '" + string11 + "' has a name attribute");
                } else {
                    n7 = this.traverseSimpleTypeDecl(element6);
                }
                if (n7 != -1) {
                    datatypeValidator = this.fDatatypeRegistry.getDatatypeValidator(this.fStringPool.toString(n7));
                } else {
                    bl3 = false;
                    this.reportGenericSchemaError("traverse simpleType error in element '" + string11 + "'");
                }
                n5 = 5;
                bl4 = true;
                element6 = XUtil.getNextSiblingElement(element6);
            } else if (attr13 == null) {
                n5 = 1;
                n6 = -1;
            }
            if (element6 != null) {
                string2 = element6.getLocalName();
            }
            while (element6 != null && (string2.equals("key") || string2.equals("keyref") || string2.equals("unique"))) {
                if ((element6 = XUtil.getNextSiblingElement(element6)) == null) continue;
                string2 = element6.getLocalName();
            }
            if (element6 != null) {
                bl3 = false;
                this.reportGenericSchemaError("src-element.0: the content of an element information item must match (annotation?, (simpleType | complexType)?, (unique | key | keyref)*)");
            }
        }
        if (bl4 && attr13 != null) {
            bl3 = false;
            this.reportGenericSchemaError("src-element.3: Element '" + string11 + "' have both a type attribute and a annoymous type child");
        } else if (attr13 != null) {
            string2 = "";
            string = string15;
            int n17 = string15.indexOf(":");
            if (n17 > 0) {
                string2 = string15.substring(0, n17);
                string = string15.substring(n17 + 1);
            }
            if (!((String)(object3 = this.resolvePrefixToURI(string2))).equals(this.fTargetNSURIString) && !((String)object3).equals("http://www.w3.org/2001/XMLSchema") && ((String)object3).length() != 0) {
                string16 = object3;
                object4 = this.getTypeInfoFromNS((String)object3, string);
                if (object4 == null && (datatypeValidator = this.getTypeValidatorFromNS((String)object3, string)) == null) {
                    bl3 = false;
                    this.reportGenericSchemaError("Could not find type " + string + " in schema " + (String)object3);
                }
            } else {
                object4 = (ComplexTypeInfo)this.fComplexTypeRegistry.get((String)object3 + "," + string);
                if (object4 == null && (datatypeValidator = this.getDatatypeValidator((String)object3, string)) == null) {
                    if (((String)object3).equals("http://www.w3.org/2001/XMLSchema") && !this.fTargetNSURIString.equals("http://www.w3.org/2001/XMLSchema")) {
                        bl3 = false;
                        this.reportGenericSchemaError("type not found : " + (String)object3 + ":" + string);
                    } else {
                        object2 = this.getTopLevelComponentByName("complexType", string);
                        if (object2 != null) {
                            if (this.fCurrentTypeNameStack.search(string) > -1) {
                                int n18 = 0;
                                if (string8.equals("qualified") || this.fElementDefaultQualified) {
                                    n18 = this.fTargetNSURI;
                                }
                                int n19 = this.fStringPool.addSymbol(string11);
                                QName qName = new QName(-1, n19, n19, n18);
                                int n20 = this.fSchemaGrammar.addElementDecl(qName, this.fCurrentScope, this.fCurrentScope, -1, -1, -1, null);
                                this.fElementRecurseComplex.addElement(new ElementInfo(n20, string));
                                return qName;
                            }
                            object = null;
                            if (!this.fBaseTypeNameStack.isEmpty()) {
                                object = this.fBaseTypeNameStack;
                                this.fBaseTypeNameStack = new Stack();
                            }
                            n7 = this.traverseComplexTypeDecl((Element)object2, true);
                            if (object != null) {
                                this.fBaseTypeNameStack = object;
                            }
                            object4 = (ComplexTypeInfo)this.fComplexTypeRegistry.get(this.fStringPool.toString(n7));
                        } else {
                            object2 = this.getTopLevelComponentByName("simpleType", string);
                            if (object2 != null) {
                                n7 = this.traverseSimpleTypeDecl((Element)object2);
                                datatypeValidator = this.getDatatypeValidator((String)object3, string);
                            } else {
                                bl3 = false;
                                this.reportGenericSchemaError("type not found : " + (String)object3 + ":" + string);
                            }
                        }
                    }
                }
            }
        }
        string2 = null;
        string = null;
        String string20 = null;
        object3 = null;
        object2 = null;
        object = this.fSchemaGrammar;
        boolean bl5 = false;
        if (string14.length() > 0) {
            if (attr11 != null) {
                this.reportGenericSchemaError("a local element cannot have a substitutionGroup");
            }
            string2 = this.resolvePrefixToURI(this.getPrefix(string14));
            string = this.getLocalPart(string14);
            string20 = string2 + "," + string;
            if (!string2.equals(this.fTargetNSURIString)) {
                Grammar grammar = this.fGrammarResolver.getGrammar(string2);
                if (grammar != null && grammar instanceof SchemaGrammar) {
                    object = (SchemaGrammar)grammar;
                    n13 = ((Grammar)object).getElementDeclIndex(this.fStringPool.addSymbol(string2), this.fStringPool.addSymbol(string), -1);
                    if (n13 <= -1) {
                        bl3 = false;
                        this.reportGenericSchemaError("couldn't find substitutionGroup " + string + " referenced by element " + string11 + " in the SchemaGrammar " + string2);
                    } else {
                        object3 = this.getElementDeclTypeInfoFromNS(string2, string);
                        if (object3 == null && (object2 = this.getElementDeclTypeValidatorFromNS(string2, string)) == null) {
                            bl3 = false;
                            this.reportGenericSchemaError("Could not find type for element '" + string + "' in schema '" + string2 + "'");
                        }
                    }
                } else {
                    bl3 = false;
                    this.reportGenericSchemaError("couldn't find a schema grammar with target namespace " + string2);
                }
            } else {
                element5 = this.getTopLevelComponentByName("element", string);
                if (element5 == null) {
                    n13 = this.fSchemaGrammar.getElementDeclIndex(this.fTargetNSURI, this.getLocalPartIndex(string14), -1);
                    if (n13 == -1) {
                        bl3 = false;
                        this.reportGenericSchemaError("unable to locate substitutionGroup affiliation element " + string14 + " in element declaration " + string11);
                    }
                } else {
                    n13 = this.fSchemaGrammar.getElementDeclIndex(this.fTargetNSURI, this.getLocalPartIndex(string14), -1);
                    if (n13 == -1) {
                        if (this.fSubstitutionGroupRecursionRegistry.contains(this.fTargetNSURIString + "," + element5.getAttribute("name"))) {
                            bl5 = true;
                        } else {
                            this.fSubstitutionGroupRecursionRegistry.addElement(this.fTargetNSURIString + "," + element5.getAttribute("name"));
                            this.traverseElementDecl(element5);
                            n13 = this.fSchemaGrammar.getElementDeclIndex(this.fTargetNSURI, this.getLocalPartIndex(string14), -1);
                            this.fSubstitutionGroupRecursionRegistry.removeElement(this.fTargetNSURIString + "," + element5.getAttribute("name"));
                        }
                    }
                }
                if (!bl5 && n13 != -1 && (object3 = this.fSchemaGrammar.getElementComplexTypeInfo(n13)) == null) {
                    this.fSchemaGrammar.getElementDecl(n13, this.fTempElementDecl);
                    object2 = this.fTempElementDecl.datatypeValidator;
                    if (object2 == null) {
                        bl3 = false;
                        this.reportGenericSchemaError("Could not find type for element '" + string + "' in schema '" + string2 + "'");
                    }
                }
            }
            if (!bl5) {
                this.checkSubstitutionGroupOK(element, element5, bl3, n13, (SchemaGrammar)object, (ComplexTypeInfo)object4, (ComplexTypeInfo)object3, datatypeValidator, (DatatypeValidator)object2);
            }
        }
        if (bl3 && object4 == null && datatypeValidator == null) {
            object4 = object3;
            datatypeValidator = object2;
        }
        if (object4 == null && datatypeValidator == null) {
            if (bl3) {
                n5 = 1;
            } else {
                bl3 = false;
                this.reportGenericSchemaError("untyped element : " + string11);
            }
        }
        if (object4 != null) {
            n6 = ((ComplexTypeInfo)object4).contentSpecHandle;
            n5 = ((ComplexTypeInfo)object4).contentType;
            n8 = ((ComplexTypeInfo)object4).scopeDefined;
            datatypeValidator = ((ComplexTypeInfo)object4).datatypeValidator;
        }
        if (datatypeValidator != null) {
            n5 = 5;
            if (object4 == null) {
                string16 = null;
            }
        }
        if (attr5 != null) {
            string5 = string7;
        }
        if (string5.length() != 0) {
            if (object4 != null && ((ComplexTypeInfo)object4).contentType != 2 && ((ComplexTypeInfo)object4).contentType != 3 && ((ComplexTypeInfo)object4).contentType != 5) {
                this.reportGenericSchemaError("e-props-correct.2.1: element " + string11 + " has a fixed or default value and must have a mixed or simple content model");
            }
            if (!(object4 == null || ((ComplexTypeInfo)object4).contentType != 2 && ((ComplexTypeInfo)object4).contentType != 3 || this.particleEmptiable(((ComplexTypeInfo)object4).contentSpecHandle))) {
                this.reportGenericSchemaError("e-props-correct.2.2.2: for element " + string11 + ", the {content type} is mixed, then the {content type}'s particle must be emptiable");
            }
            try {
                if (datatypeValidator != null) {
                    datatypeValidator.validate(string5, null);
                }
            }
            catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                this.reportGenericSchemaError("e-props-correct.2: invalid fixed or default value '" + string5 + "' in element " + string11);
            }
        }
        if (string5.length() != 0 && datatypeValidator != null && datatypeValidator instanceof IDDatatypeValidator) {
            this.reportGenericSchemaError("e-props-correct.4: If the {type definition} or {type definition}'s {content type} is or is derived from ID then there must not be a {value constraint} -- element " + string11);
        }
        int n21 = n = this.fStringPool.addSymbol(string11);
        int n22 = 0;
        int n23 = this.fCurrentScope;
        if (this.isTopLevel(element)) {
            n22 = this.fTargetNSURI;
            n23 = -1;
        } else if (!string8.equals("unqualified") && (string8.equals("qualified") || this.fElementDefaultQualified)) {
            n22 = this.fTargetNSURI;
        }
        QName qName = new QName(-1, n21, n, n22);
        int n24 = this.fSchemaGrammar.getElementDeclIndex(qName.uri, qName.localpart, n23);
        if (n24 > -1 && !this.checkDuplicateElementTypes(n24, (ComplexTypeInfo)object4, datatypeValidator)) {
            bl3 = false;
            this.reportGenericSchemaError("duplicate element decl in the same scope with different types : " + this.fStringPool.toString(n21));
        }
        int n25 = -1;
        if (object4 != null) {
            n25 = ((ComplexTypeInfo)object4).attlistHead;
        }
        int n26 = this.fSchemaGrammar.addElementDecl(qName, n23, n8, n5, n6, n25, datatypeValidator);
        this.fSchemaGrammar.setElementComplexTypeInfo(n26, (ComplexTypeInfo)object4);
        this.fSchemaGrammar.setElementFromAnotherSchemaURI(n26, string16);
        this.fSchemaGrammar.setElementDeclBlockSet(n26, n3);
        this.fSchemaGrammar.setElementDeclFinalSet(n26, n2);
        this.fSchemaGrammar.setElementDeclMiscFlags(n26, n9);
        this.fSchemaGrammar.setElementDefault(n26, string5);
        this.fSchemaGrammar.setElementDeclSubstitutionGroupAffFullName(n26, string20);
        if (string14.length() > 0 && !bl5) {
            ((SchemaGrammar)object).addElementDeclOneSubstitutionGroupQName(n13, qName, this.fSchemaGrammar, n26);
        }
        if ((element2 = XUtil.getFirstChildElementNS(element, IDENTITY_CONSTRAINTS)) != null) {
            Integer n27 = new Integer(n26);
            Vector<Element> vector = (Vector<Element>)this.fIdentityConstraints.get(n27);
            if (vector == null) {
                vector = new Vector<Element>();
                this.fIdentityConstraints.put(n27, vector);
            }
            while (element2 != null) {
                vector.addElement(element2);
                element2 = XUtil.getNextSiblingElementNS(element2, IDENTITY_CONSTRAINTS);
            }
        }
        return qName;
    }

    private boolean checkDuplicateElementTypes(int n, ComplexTypeInfo complexTypeInfo, DatatypeValidator datatypeValidator) {
        this.fSchemaGrammar.getElementDecl(n, this.fTempElementDecl);
        DatatypeValidator datatypeValidator2 = this.fTempElementDecl.datatypeValidator;
        ComplexTypeInfo complexTypeInfo2 = this.fSchemaGrammar.getElementComplexTypeInfo(n);
        return (complexTypeInfo2 == null || complexTypeInfo2 == complexTypeInfo) && (datatypeValidator2 == null || datatypeValidator2 == datatypeValidator);
    }

    private void traverseIdentityNameConstraintsFor(int n, Vector vector) throws Exception {
        int n2;
        int n3 = n2 = vector != null ? vector.size() : 0;
        if (n2 > 0) {
            XMLElementDecl xMLElementDecl = new XMLElementDecl();
            this.fSchemaGrammar.getElementDecl(n, xMLElementDecl);
            int n4 = 0;
            while (n4 < n2) {
                Element element = (Element)vector.elementAt(n4);
                String string = element.getLocalName();
                if (string.equals("key")) {
                    this.traverseKey(element, xMLElementDecl);
                } else if (string.equals("unique")) {
                    this.traverseUnique(element, xMLElementDecl);
                }
                this.fSchemaGrammar.setElementDecl(n, xMLElementDecl);
                ++n4;
            }
        }
    }

    private void traverseIdentityRefConstraintsFor(int n, Vector vector) throws Exception {
        int n2;
        int n3 = n2 = vector != null ? vector.size() : 0;
        if (n2 > 0) {
            XMLElementDecl xMLElementDecl = new XMLElementDecl();
            this.fSchemaGrammar.getElementDecl(n, xMLElementDecl);
            int n4 = 0;
            while (n4 < n2) {
                Element element = (Element)vector.elementAt(n4);
                String string = element.getLocalName();
                if (string.equals("keyref")) {
                    this.traverseKeyRef(element, xMLElementDecl);
                }
                this.fSchemaGrammar.setElementDecl(n, xMLElementDecl);
                ++n4;
            }
        }
    }

    private void traverseUnique(Element element, XMLElementDecl xMLElementDecl) throws Exception {
        int n = GeneralAttrCheck.ELE_CONTEXT_LOCAL;
        Hashtable hashtable = this.generalCheck(element, n);
        String string = element.getAttribute("name");
        String string2 = this.getElementNameFor(element);
        Unique unique = new Unique(string, string2);
        if (this.fIdentityConstraintNames.get(this.fTargetNSURIString + "," + string) != null) {
            this.reportGenericSchemaError("More than one identity constraint named " + string);
        }
        this.fIdentityConstraintNames.put(this.fTargetNSURIString + "," + string, unique);
        this.traverseIdentityConstraint(unique, element);
        xMLElementDecl.unique.addElement(unique);
    }

    private void traverseKey(Element element, XMLElementDecl xMLElementDecl) throws Exception {
        int n = GeneralAttrCheck.ELE_CONTEXT_LOCAL;
        Hashtable hashtable = this.generalCheck(element, n);
        String string = element.getAttribute("name");
        String string2 = this.getElementNameFor(element);
        Key key = new Key(string, string2);
        if (this.fIdentityConstraintNames.get(this.fTargetNSURIString + "," + string) != null) {
            this.reportGenericSchemaError("More than one identity constraint named " + string);
        }
        this.fIdentityConstraintNames.put(this.fTargetNSURIString + "," + string, key);
        this.traverseIdentityConstraint(key, element);
        xMLElementDecl.key.addElement(key);
    }

    private void traverseKeyRef(Element element, XMLElementDecl xMLElementDecl) throws Exception {
        String string;
        IdentityConstraint identityConstraint;
        int n = GeneralAttrCheck.ELE_CONTEXT_LOCAL;
        Hashtable hashtable = this.generalCheck(element, n);
        String string2 = element.getAttribute("name");
        String string3 = element.getAttribute("refer");
        if (this.fIdentityConstraintNames.get(this.fTargetNSURIString + "," + string2) != null) {
            this.reportGenericSchemaError("More than one identity constraint named " + string2);
        }
        String string4 = "";
        String string5 = string3;
        int n2 = string3.indexOf(":");
        if (n2 > 0) {
            string4 = string3.substring(0, n2);
            string5 = string3.substring(n2 + 1);
        }
        if ((identityConstraint = (IdentityConstraint)this.fIdentityConstraintNames.get((string = this.resolvePrefixToURI(string4)) + "," + string5)) == null) {
            this.reportSchemaError(37, new Object[]{string2, string3});
            return;
        }
        String string6 = this.getElementNameFor(element);
        KeyRef keyRef = new KeyRef(string2, identityConstraint, string6);
        this.traverseIdentityConstraint(keyRef, element);
        xMLElementDecl.keyRef.addElement(keyRef);
        this.fIdentityConstraintNames.put(this.fTargetNSURIString + "," + string2, keyRef);
    }

    private void traverseIdentityConstraint(IdentityConstraint identityConstraint, Element element) throws Exception {
        Object object;
        int n = GeneralAttrCheck.ELE_CONTEXT_LOCAL;
        Hashtable hashtable = this.generalCheck(element, n);
        Element element2 = XUtil.getFirstChildElement(element);
        if (element2 == null) {
            this.reportGenericSchemaError("The content of an identity constraint must match (annotation?, selector, field+)");
            return;
        }
        element2 = this.checkContent(element, element2, false);
        hashtable = this.generalCheck(element2, n);
        if (!element2.getLocalName().equals("selector")) {
            this.reportGenericSchemaError("The content of an identity constraint must match (annotation?, selector, field+)");
        }
        this.checkContent(element, XUtil.getFirstChildElement(element2), true);
        String string = element2.getAttribute("xpath");
        string = string.trim();
        Selector.XPath xPath = null;
        try {
            xPath = new Selector.XPath(string, this.fStringPool, this.fNamespacesScope);
            object = new Selector(xPath, identityConstraint);
            identityConstraint.setSelector((Selector)object);
        }
        catch (XPathException xPathException) {
            this.reportGenericSchemaError(xPathException.getMessage());
            return;
        }
        object = XUtil.getNextSiblingElement(element2);
        if (object == null) {
            this.reportGenericSchemaError("The content of an identity constraint must match (annotation?, selector, field+)");
        }
        while (object != null) {
            hashtable = this.generalCheck((Element)object, n);
            if (!object.getLocalName().equals("field")) {
                this.reportGenericSchemaError("The content of an identity constraint must match (annotation?, selector, field+)");
            }
            this.checkContent(element, XUtil.getFirstChildElement((Node)object), true);
            String string2 = object.getAttribute("xpath");
            string2 = string2.trim();
            try {
                Field.XPath xPath2 = new Field.XPath(string2, this.fStringPool, this.fNamespacesScope);
                Field field = new Field(xPath2, identityConstraint);
                identityConstraint.addField(field);
            }
            catch (XPathException xPathException) {
                this.reportGenericSchemaError(xPathException.getMessage());
                return;
            }
            object = XUtil.getNextSiblingElement((Node)object);
        }
    }

    private String getElementNameFor(Element element) {
        Element element2 = (Element)element.getParentNode();
        String string = element2.getAttribute("name");
        if (string.length() == 0) {
            string = element2.getAttribute("ref");
        }
        return string;
    }

    int getLocalPartIndex(String string) {
        int n = string.indexOf(":");
        String string2 = string;
        if (n > -1) {
            string2 = string.substring(n + 1);
        }
        return this.fStringPool.addSymbol(string2);
    }

    String getLocalPart(String string) {
        int n = string.indexOf(":");
        String string2 = string;
        if (n > -1) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    int getPrefixIndex(String string) {
        int n = string.indexOf(":");
        String string2 = "";
        if (n > -1) {
            string2 = string.substring(0, n);
        }
        return this.fStringPool.addSymbol(string2);
    }

    String getPrefix(String string) {
        int n = string.indexOf(":");
        String string2 = "";
        if (n > -1) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    private void checkSubstitutionGroupOK(Element element, Element element2, boolean bl, int n, SchemaGrammar schemaGrammar, ComplexTypeInfo complexTypeInfo, ComplexTypeInfo complexTypeInfo2, DatatypeValidator datatypeValidator, DatatypeValidator datatypeValidator2) throws Exception {
        int n2 = schemaGrammar.getElementDeclFinalSet(n);
        if ((n2 & 2) != 0 && (n2 & 1) != 0) {
            this.reportGenericSchemaError("element " + element.getAttribute("name") + " cannot be part of the substitution group headed by " + element2.getAttribute("name"));
        }
        if (complexTypeInfo != null) {
            if (complexTypeInfo2 == complexTypeInfo) {
                return;
            }
            int n3 = complexTypeInfo.derivedBy;
            if (complexTypeInfo.baseComplexTypeInfo == null) {
                if (complexTypeInfo.baseDataTypeValidator != null) {
                    DatatypeValidator datatypeValidator3 = complexTypeInfo.baseDataTypeValidator;
                    while (datatypeValidator3 != null) {
                        if (datatypeValidator3 == datatypeValidator2) break;
                        datatypeValidator3 = datatypeValidator3.getBaseValidator();
                    }
                    if (datatypeValidator3 == null) {
                        if (datatypeValidator2 instanceof UnionDatatypeValidator) {
                            Vector vector = ((UnionDatatypeValidator)datatypeValidator2).getBaseValidators();
                            int n4 = vector.size();
                            boolean bl2 = false;
                            int n5 = 0;
                            while (n5 < n4 && !bl2) {
                                DatatypeValidator datatypeValidator4 = (DatatypeValidator)vector.elementAt(n5);
                                DatatypeValidator datatypeValidator5 = complexTypeInfo.baseDataTypeValidator;
                                while (datatypeValidator5 != null) {
                                    if (datatypeValidator4 == datatypeValidator5) {
                                        bl2 = true;
                                        break;
                                    }
                                    datatypeValidator5 = datatypeValidator5.getBaseValidator();
                                }
                                ++n5;
                            }
                            if (!bl2) {
                                this.reportGenericSchemaError("Element " + element.getAttribute("name") + " has a type which does not derive from the type of the element at the head of the substitution group");
                                bl = false;
                            }
                        } else {
                            this.reportGenericSchemaError("Element " + element.getAttribute("name") + " has a type which does not derive from the type of the element at the head of the substitution group");
                            bl = false;
                        }
                    } else if ((n3 & n2) != 0) {
                        bl = false;
                        this.reportGenericSchemaError("element " + element.getAttribute("name") + " cannot be part of the substitution group headed by " + element2.getAttribute("name"));
                    }
                } else {
                    this.reportGenericSchemaError("Element " + element.getAttribute("name") + " which is part of a substitution must have a type which derives from the type of the element at the head of the substitution group");
                    bl = false;
                }
            } else {
                String string = complexTypeInfo.baseComplexTypeInfo.typeName;
                ComplexTypeInfo complexTypeInfo3 = complexTypeInfo2;
                while (complexTypeInfo3 != null && !complexTypeInfo3.typeName.equals(string)) {
                    complexTypeInfo3 = complexTypeInfo3.baseComplexTypeInfo;
                }
                if (complexTypeInfo3 == null) {
                    this.reportGenericSchemaError("Element " + element.getAttribute("name") + " has a type whose base is " + string + "; this basetype does not derive from the type of the element at the head of the substitution group");
                    bl = false;
                } else if ((n3 & n2) != 0) {
                    bl = false;
                    this.reportGenericSchemaError("element " + element.getAttribute("name") + " cannot be part of the substitution group headed by " + element2.getAttribute("name"));
                }
            }
        } else if (datatypeValidator != null) {
            if (datatypeValidator == datatypeValidator2) {
                return;
            }
            if (!this.checkSimpleTypeDerivationOK(datatypeValidator, datatypeValidator2)) {
                this.reportGenericSchemaError("Element " + element.getAttribute("name") + " has a type which does not derive from the type of the element at the head of the substitution group");
                bl = false;
            } else if ((2 & n2) != 0) {
                bl = false;
                this.reportGenericSchemaError("element " + element.getAttribute("name") + " cannot be part of the substitution group headed by " + element2.getAttribute("name"));
            }
        }
    }

    private boolean checkSimpleTypeDerivationOK(DatatypeValidator datatypeValidator, DatatypeValidator datatypeValidator2) {
        DatatypeValidator datatypeValidator3 = datatypeValidator;
        while (datatypeValidator3 != null) {
            if (datatypeValidator3 == datatypeValidator2) break;
            datatypeValidator3 = datatypeValidator3.getBaseValidator();
        }
        if (datatypeValidator3 == null) {
            if (datatypeValidator2 instanceof UnionDatatypeValidator) {
                Vector vector = ((UnionDatatypeValidator)datatypeValidator2).getBaseValidators();
                int n = vector.size();
                boolean bl = false;
                int n2 = 0;
                while (n2 < n && !bl) {
                    DatatypeValidator datatypeValidator4 = (DatatypeValidator)vector.elementAt(n2);
                    DatatypeValidator datatypeValidator5 = datatypeValidator;
                    while (datatypeValidator5 != null) {
                        if (datatypeValidator4 == datatypeValidator5) {
                            bl = true;
                            break;
                        }
                        datatypeValidator5 = datatypeValidator5.getBaseValidator();
                    }
                    ++n2;
                }
                if (!bl) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private Element getTopLevelComponentByName(String var1_1, String var2_2) throws Exception {
        var3_3 = null;
        var4_4 = this.fSchemaInfoListRoot;
        while (var4_4 != null || var4_4 == this.fSchemaInfoListRoot) {
            block17: {
                if (var4_4 != null) {
                    var4_4.restore();
                }
                if (var1_1.equals("group")) {
                    var3_3 = (Element)this.fSchemaGrammar.topLevelGroupDecls.get(var2_2);
                } else if (var1_1.equals("attributeGroup") && this.fSchemaInfoListRoot == null) {
                    var3_3 = (Element)this.fSchemaGrammar.topLevelAttrGrpDecls.get(var2_2);
                } else if (var1_1.equals("attribute")) {
                    var3_3 = (Element)this.fSchemaGrammar.topLevelAttrDecls.get(var2_2);
                }
                if (var3_3 != null) break;
                var3_3 = XUtil.getFirstChildElement(this.fSchemaRootElement);
                if (var3_3 != null) ** GOTO lbl32
                break block17;
lbl-1000:
                // 1 sources

                {
                    if (var3_3.getLocalName().equals(var1_1)) {
                        if (var3_3.getAttribute("name").equals(var2_2)) {
                            break;
                        }
                    } else if (this.fRedefineSucceeded && var3_3.getLocalName().equals("redefine")) {
                        var5_5 = XUtil.getFirstChildElement(var3_3);
                        while (var5_5 != null) {
                            if (var5_5.getLocalName().equals(var1_1) && var5_5.getAttribute("name").equals(var2_2)) break;
                            var5_5 = XUtil.getNextSiblingElement(var5_5);
                        }
                        if (var5_5 != null) {
                            var3_3 = var5_5;
                            break;
                        }
                    }
                    var3_3 = XUtil.getNextSiblingElement(var3_3);
lbl32:
                    // 2 sources

                    ** while (var3_3 != null)
                }
lbl33:
                // 3 sources

                if (var3_3 != null || this.fSchemaInfoListRoot == null) break;
            }
            var4_4 = var4_4.getNext();
        }
        if (var4_4 != null) {
            var4_4.restore();
        } else if (this.fSchemaInfoListRoot != null) {
            this.fSchemaInfoListRoot.restore();
        }
        return var3_3;
    }

    private boolean isTopLevel(Element element) {
        String string = element.getParentNode().getLocalName();
        return string.endsWith("schema") || string.endsWith("redefine");
    }

    DatatypeValidator getTypeValidatorFromNS(String string, String string2) throws Exception {
        return this.getDatatypeValidator(string, string2);
    }

    ComplexTypeInfo getTypeInfoFromNS(String string, String string2) throws Exception {
        Grammar grammar = this.fGrammarResolver.getGrammar(string);
        if (grammar != null && grammar instanceof SchemaGrammar) {
            SchemaGrammar schemaGrammar = (SchemaGrammar)grammar;
            ComplexTypeInfo complexTypeInfo = (ComplexTypeInfo)schemaGrammar.getComplexTypeRegistry().get(string + "," + string2);
            return complexTypeInfo;
        }
        this.reportGenericSchemaError("could not resolve URI : " + string + " to a SchemaGrammar in getTypeInfoFromNS");
        return null;
    }

    DatatypeValidator getElementDeclTypeValidatorFromNS(String string, String string2) throws Exception {
        Grammar grammar = this.fGrammarResolver.getGrammar(string);
        if (grammar != null && grammar instanceof SchemaGrammar) {
            SchemaGrammar schemaGrammar = (SchemaGrammar)grammar;
            int n = schemaGrammar.getElementDeclIndex(this.fStringPool.addSymbol(string), this.fStringPool.addSymbol(string2), -1);
            DatatypeValidator datatypeValidator = null;
            if (n > -1) {
                schemaGrammar.getElementDecl(n, this.fTempElementDecl);
                datatypeValidator = this.fTempElementDecl.datatypeValidator;
            } else {
                this.reportGenericSchemaError("could not find global element : '" + string2 + " in the SchemaGrammar " + string);
            }
            return datatypeValidator;
        }
        this.reportGenericSchemaError("could not resolve URI : " + string + " to a SchemaGrammar in getELementDeclTypeValidatorFromNS");
        return null;
    }

    ComplexTypeInfo getElementDeclTypeInfoFromNS(String string, String string2) throws Exception {
        Grammar grammar = this.fGrammarResolver.getGrammar(string);
        if (grammar != null && grammar instanceof SchemaGrammar) {
            SchemaGrammar schemaGrammar = (SchemaGrammar)grammar;
            int n = schemaGrammar.getElementDeclIndex(this.fStringPool.addSymbol(string), this.fStringPool.addSymbol(string2), -1);
            ComplexTypeInfo complexTypeInfo = null;
            if (n > -1) {
                complexTypeInfo = schemaGrammar.getElementComplexTypeInfo(n);
            } else {
                this.reportGenericSchemaError("could not find global element : '" + string2 + " in the SchemaGrammar " + string);
            }
            return complexTypeInfo;
        }
        this.reportGenericSchemaError("could not resolve URI : " + string + " to a SchemaGrammar in getElementDeclTypeInfoFromNS");
        return null;
    }

    private String traverseNotationDecl(Element element) throws Exception {
        String string;
        int n = GeneralAttrCheck.ELE_CONTEXT_LOCAL;
        Hashtable hashtable = this.generalCheck(element, n);
        String string2 = string = element.getAttribute("name");
        if (this.fTargetNSURIString.length() != 0) {
            string2 = this.fTargetNSURIString + ":" + string;
        }
        if (this.fNotationRegistry.get(string2) != null) {
            return string;
        }
        String string3 = element.getAttribute("public");
        String string4 = element.getAttribute("system");
        if (string3.length() == 0 && string4.length() == 0) {
            this.reportGenericSchemaError("<notation> declaration is invalid");
        }
        if (string.length() == 0) {
            this.reportGenericSchemaError("<notation> declaration does not have a name");
        }
        this.fNotationRegistry.put(string2, string);
        this.checkContent(element, XUtil.getFirstChildElement(element), true);
        return string;
    }

    private String traverseNotationFromAnotherSchema(String string, String string2) throws Exception {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarResolver.getGrammar(string2);
        if (string2 == null || schemaGrammar == null || !(schemaGrammar instanceof SchemaGrammar)) {
            this.reportGenericSchemaError("!!Schema not found in #traverseNotationDeclFromAnotherSchema, schema uri: " + string2 + ", groupName: " + string);
            return "";
        }
        String string3 = this.fTargetNSURIString;
        this.fTargetNSURIString = this.fStringPool.toString(this.fStringPool.addSymbol(schemaGrammar.getTargetNamespaceURI()));
        String string4 = this.fTargetNSURIString + ":" + string;
        String string5 = (String)this.fNotationRegistry.get(string4);
        if (string5 != null) {
            return string5;
        }
        Element element = (Element)schemaGrammar.topLevelNotationDecls.get(string);
        if (element == null) {
            this.reportGenericSchemaError("no notation named \"" + string + "\" was defined in schema : " + string2);
            return "";
        }
        string5 = this.traverseNotationDecl(element);
        this.fTargetNSURIString = string3;
        return string5;
    }

    private GroupInfo traverseGroupDecl(Element element) throws Exception {
        String string;
        int n = this.isTopLevel(element) ? GeneralAttrCheck.ELE_CONTEXT_GLOBAL : GeneralAttrCheck.ELE_CONTEXT_LOCAL;
        Hashtable hashtable = this.generalCheck(element, n);
        String string2 = element.getAttribute("name");
        String string3 = element.getAttribute("ref");
        GroupInfo groupInfo = null;
        Element element2 = this.checkContent(element, XUtil.getFirstChildElement(element), true);
        if (string3.length() != 0) {
            if (this.isTopLevel(element)) {
                this.reportGenericSchemaError("A group with \"ref\" present must not have <schema> or <redefine> as its parent");
            }
            if (string2.length() != 0) {
                this.reportGenericSchemaError("group " + string2 + " cannot refer to another group, but it refers to " + string3);
            }
            if (XUtil.getFirstChildElement(element) != null) {
                this.reportGenericSchemaError("A group with \"ref\" present must not have children");
            }
            String string4 = "";
            String string5 = string3;
            int n2 = string3.indexOf(":");
            if (n2 > 0) {
                string4 = string3.substring(0, n2);
                string5 = string3.substring(n2 + 1);
            }
            int n3 = this.fStringPool.addSymbol(string5);
            String string6 = this.resolvePrefixToURI(string4);
            if (!string6.equals(this.fTargetNSURIString)) {
                groupInfo = this.traverseGroupDeclFromAnotherSchema(string5, string6);
                if (groupInfo != null) {
                    this.findAndCreateElements(groupInfo.contentSpecIndex, groupInfo.scope);
                }
                return groupInfo;
            }
            try {
                groupInfo = (GroupInfo)this.fGroupNameRegistry.get(string6 + "," + string5);
                if (groupInfo != null) {
                    this.findAndCreateElements(groupInfo.contentSpecIndex, groupInfo.scope);
                    return groupInfo;
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            if (this.fCurrentGroupNameStack.search(string5) > -1) {
                this.reportGenericSchemaError("mg-props-correct: Circular definition for group " + string5);
                return null;
            }
            int n4 = -1;
            Element element3 = this.getTopLevelComponentByName("group", string5);
            if (element3 == null) {
                this.reportGenericSchemaError("Group " + string5 + " not found in the Schema");
            } else {
                groupInfo = this.traverseGroupDecl(element3);
            }
            if (groupInfo != null) {
                this.findAndCreateElements(groupInfo.contentSpecIndex, groupInfo.scope);
            }
            return groupInfo;
        }
        if (string2.length() == 0) {
            this.reportGenericSchemaError("a <group> must have a name or a ref present");
        }
        String string7 = this.fTargetNSURIString + "," + string2;
        try {
            groupInfo = (GroupInfo)this.fGroupNameRegistry.get(string7);
            if (groupInfo != null) {
                this.findAndCreateElements(groupInfo.contentSpecIndex, groupInfo.scope);
                return groupInfo;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.fCurrentGroupNameStack.push(string2);
        int n5 = this.fCurrentScope;
        this.fCurrentScope = this.fScopeCount++;
        int n6 = -2;
        boolean bl = false;
        String string8 = string = element2 != null ? element2.getLocalName() : "";
        if (string.equals("all")) {
            n6 = this.traverseAll(element2);
        } else if (string.equals("choice")) {
            n6 = this.traverseChoice(element2);
        } else if (string.equals("sequence")) {
            n6 = this.traverseSequence(element2);
        } else if (string.length() != 0 || element2 != null && XUtil.getNextSiblingElement(element2) != null) {
            bl = true;
            this.reportSchemaError(14, new Object[]{"group", string});
        }
        if (element2 == null) {
            this.reportGenericSchemaError("Named group must contain an 'all', 'choice' or 'sequence' child");
        } else if (XUtil.getNextSiblingElement(element2) != null) {
            bl = true;
            this.reportSchemaError(14, new Object[]{"group", string});
        }
        if (!bl && element2 != null) {
            n6 = this.handleOccurrences(n6, element2, 4);
        }
        groupInfo = new GroupInfo();
        groupInfo.contentSpecIndex = n6;
        groupInfo.scope = this.fCurrentScope;
        this.fCurrentScope = n5;
        this.fCurrentGroupNameStack.pop();
        this.fGroupNameRegistry.put(string7, groupInfo);
        return groupInfo;
    }

    private void findAndCreateElements(int n, int n2) {
        if (n < 0 || this.fCurrentScope == -1) {
            return;
        }
        this.fSchemaGrammar.getContentSpec(n, this.tempContentSpec1);
        int n3 = this.tempContentSpec1.type;
        int n4 = this.tempContentSpec1.value;
        int n5 = this.tempContentSpec1.otherValue;
        if (n3 == 0) {
            int n6 = this.fSchemaGrammar.getElementDeclIndex(n5, n4, n2);
            if (n6 < 0) {
                return;
            }
            this.fSchemaGrammar.cloneElementDecl(n6, this.fCurrentScope);
        } else if (n3 == 4 || n3 == 9 || n3 == 5) {
            this.findAndCreateElements(n4, n2);
            if (n5 != -2) {
                this.findAndCreateElements(n5, n2);
            }
        }
    }

    private GroupInfo traverseGroupDeclFromAnotherSchema(String string, String string2) throws Exception {
        String string3;
        GroupInfo groupInfo = null;
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarResolver.getGrammar(string2);
        if (string2 == null || schemaGrammar == null || !(schemaGrammar instanceof SchemaGrammar)) {
            this.reportGenericSchemaError("!!Schema not found in #traverseGroupDeclFromAnotherSchema, schema uri: " + string2 + ", groupName: " + string);
            return null;
        }
        Element element = (Element)schemaGrammar.topLevelGroupDecls.get(string);
        if (element == null) {
            this.reportGenericSchemaError("no group named \"" + string + "\" was defined in schema : " + string2);
            return null;
        }
        NamespacesScope namespacesScope = this.fNamespacesScope;
        int n = this.fTargetNSURI;
        this.fTargetNSURI = this.fStringPool.addSymbol(schemaGrammar.getTargetNamespaceURI());
        this.fNamespacesScope = schemaGrammar.getNamespacesScope();
        Element element2 = this.checkContent(element, XUtil.getFirstChildElement(element), true);
        String string4 = this.fTargetNSURIString + "," + string;
        try {
            groupInfo = (GroupInfo)this.fGroupNameRegistry.get(string4);
            if (groupInfo != null) {
                return groupInfo;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        int n2 = -2;
        int n3 = this.fCurrentScope;
        this.fCurrentScope = this.fScopeCount++;
        boolean bl = false;
        String string5 = string3 = element2 != null ? element2.getLocalName() : "";
        if (string3.equals("all")) {
            n2 = this.traverseAll(element2);
        } else if (string3.equals("choice")) {
            n2 = this.traverseChoice(element2);
        } else if (string3.equals("sequence")) {
            n2 = this.traverseSequence(element2);
        } else if (string3.length() != 0 || element2 != null && XUtil.getNextSiblingElement(element2) != null) {
            bl = true;
            this.reportSchemaError(14, new Object[]{"group", string3});
        }
        if (!bl && element2 != null) {
            n2 = this.handleOccurrences(n2, element2);
        }
        groupInfo = new GroupInfo();
        groupInfo.contentSpecIndex = n2;
        groupInfo.scope = this.fCurrentScope;
        this.fCurrentScope = n3;
        this.fGroupNameRegistry.put(string4, groupInfo);
        this.fNamespacesScope = namespacesScope;
        this.fTargetNSURI = n;
        return groupInfo;
    }

    /*
     * Unable to fully structure code
     */
    int traverseSequence(Element var1_1) throws Exception {
        var2_2 = GeneralAttrCheck.ELE_CONTEXT_LOCAL;
        var3_3 = this.generalCheck(var1_1, var2_2);
        var4_4 = this.checkContent(var1_1, XUtil.getFirstChildElement(var1_1), true);
        var5_5 = 5;
        var6_6 = -2;
        var7_7 = -2;
        var8_8 = false;
        while (var4_4 != null) {
            block13: {
                block15: {
                    block14: {
                        block11: {
                            block12: {
                                block10: {
                                    var9_9 = -2;
                                    var10_10 = false;
                                    var11_11 = var4_4.getLocalName();
                                    if (!var11_11.equals("element")) break block10;
                                    var12_12 = this.traverseElementDecl(var4_4);
                                    var9_9 = this.fSchemaGrammar.addContentSpecNode(0, var12_12.localpart, var12_12.uri, false);
                                    var10_10 = true;
                                    ** GOTO lbl43
                                }
                                if (!var11_11.equals("group")) break block11;
                                var12_12 = this.traverseGroupDecl(var4_4);
                                v0 = var9_9 = var12_12 != null ? var12_12.contentSpecIndex : -2;
                                if (!this.hasAllContent(var9_9)) break block12;
                                this.reportSchemaError(48, new Object[]{"sequence"});
                                break block13;
                            }
                            var10_10 = true;
                            ** GOTO lbl43
                        }
                        if (!var11_11.equals("choice")) break block14;
                        var9_9 = this.traverseChoice(var4_4);
                        var10_10 = true;
                        ** GOTO lbl43
                    }
                    if (!var11_11.equals("sequence")) break block15;
                    var9_9 = this.traverseSequence(var4_4);
                    var10_10 = true;
                    ** GOTO lbl43
                }
                if (!var11_11.equals("any")) {
                    this.reportSchemaError(46, new Object[]{"sequence", var11_11});
                } else {
                    var9_9 = this.traverseAny(var4_4);
                    var10_10 = true;
lbl43:
                    // 5 sources

                    if (var9_9 != -2) {
                        var8_8 = true;
                    }
                    if (var10_10) {
                        var9_9 = this.handleOccurrences(var9_9, var4_4);
                    }
                    if (var6_6 == -2) {
                        var6_6 = var9_9;
                    } else if (var7_7 == -2) {
                        var7_7 = var9_9;
                    } else {
                        var6_6 = this.fSchemaGrammar.addContentSpecNode(var5_5, var6_6, var7_7, false);
                        var7_7 = var9_9;
                    }
                }
            }
            var4_4 = XUtil.getNextSiblingElement(var4_4);
        }
        if (var8_8 && (var7_7 != -2 || this.fSchemaGrammar.getDeferContentSpecExpansion())) {
            var6_6 = this.fSchemaGrammar.addContentSpecNode(var5_5, var6_6, var7_7, false);
        }
        return var6_6;
    }

    /*
     * Unable to fully structure code
     */
    int traverseChoice(Element var1_1) throws Exception {
        var2_2 = GeneralAttrCheck.ELE_CONTEXT_LOCAL;
        var3_3 = this.generalCheck(var1_1, var2_2);
        var4_4 = this.checkContent(var1_1, XUtil.getFirstChildElement(var1_1), true);
        var5_5 = 4;
        var6_6 = -2;
        var7_7 = -2;
        var8_8 = false;
        while (var4_4 != null) {
            block13: {
                block15: {
                    block14: {
                        block11: {
                            block12: {
                                block10: {
                                    var9_9 = -2;
                                    var10_10 = false;
                                    var11_11 = var4_4.getLocalName();
                                    if (!var11_11.equals("element")) break block10;
                                    var12_12 = this.traverseElementDecl(var4_4);
                                    var9_9 = this.fSchemaGrammar.addContentSpecNode(0, var12_12.localpart, var12_12.uri, false);
                                    var10_10 = true;
                                    ** GOTO lbl43
                                }
                                if (!var11_11.equals("group")) break block11;
                                var12_12 = this.traverseGroupDecl(var4_4);
                                v0 = var9_9 = var12_12 != null ? var12_12.contentSpecIndex : -2;
                                if (!this.hasAllContent(var9_9)) break block12;
                                this.reportSchemaError(48, new Object[]{"choice"});
                                break block13;
                            }
                            var10_10 = true;
                            ** GOTO lbl43
                        }
                        if (!var11_11.equals("choice")) break block14;
                        var9_9 = this.traverseChoice(var4_4);
                        var10_10 = true;
                        ** GOTO lbl43
                    }
                    if (!var11_11.equals("sequence")) break block15;
                    var9_9 = this.traverseSequence(var4_4);
                    var10_10 = true;
                    ** GOTO lbl43
                }
                if (!var11_11.equals("any")) {
                    this.reportSchemaError(46, new Object[]{"choice", var11_11});
                } else {
                    var9_9 = this.traverseAny(var4_4);
                    var10_10 = true;
lbl43:
                    // 5 sources

                    if (var9_9 != -2) {
                        var8_8 = true;
                    }
                    if (var10_10) {
                        var9_9 = this.handleOccurrences(var9_9, var4_4);
                    }
                    if (var6_6 == -2) {
                        var6_6 = var9_9;
                    } else if (var7_7 == -2) {
                        var7_7 = var9_9;
                    } else {
                        var6_6 = this.fSchemaGrammar.addContentSpecNode(var5_5, var6_6, var7_7, false);
                        var7_7 = var9_9;
                    }
                }
            }
            var4_4 = XUtil.getNextSiblingElement(var4_4);
        }
        if (var8_8 && (var7_7 != -2 || this.fSchemaGrammar.getDeferContentSpecExpansion())) {
            var6_6 = this.fSchemaGrammar.addContentSpecNode(var5_5, var6_6, var7_7, false);
        }
        return var6_6;
    }

    int traverseAll(Element element) throws Exception {
        int n = GeneralAttrCheck.ELE_CONTEXT_LOCAL;
        Hashtable hashtable = this.generalCheck(element, n);
        Element element2 = this.checkContent(element, XUtil.getFirstChildElement(element), true);
        int n2 = 9;
        int n3 = -2;
        int n4 = -2;
        boolean bl = false;
        while (element2 != null) {
            int n5 = -2;
            String string = element2.getLocalName();
            if (!string.equals("element")) {
                this.reportSchemaError(47, new Object[]{string});
            } else {
                QName qName = this.traverseElementDecl(element2);
                n5 = this.fSchemaGrammar.addContentSpecNode(0, qName.localpart, qName.uri, false);
                n5 = this.handleOccurrences(n5, element2, 1);
                bl = true;
                if (n3 == -2) {
                    n3 = n5;
                } else if (n4 == -2) {
                    n4 = n5;
                } else {
                    n3 = this.fSchemaGrammar.addContentSpecNode(n2, n3, n4, false);
                    n4 = n5;
                }
            }
            element2 = XUtil.getNextSiblingElement(element2);
        }
        if (bl && (n4 != -2 || this.fSchemaGrammar.getDeferContentSpecExpansion())) {
            n3 = this.fSchemaGrammar.addContentSpecNode(n2, n3, n4, false);
        }
        return n3;
    }

    private boolean hasAllContent(int n) {
        if (n > -1) {
            XMLContentSpec xMLContentSpec = new XMLContentSpec();
            this.fSchemaGrammar.getContentSpec(n, xMLContentSpec);
            if (xMLContentSpec.type == 1) {
                this.fSchemaGrammar.getContentSpec(xMLContentSpec.value, xMLContentSpec);
            }
            return xMLContentSpec.type == 9;
        }
        return false;
    }

    private Hashtable generalCheck(Element element, int n) throws Exception {
        String string = element.getNamespaceURI();
        if (string == null || !string.equals("http://www.w3.org/2001/XMLSchema")) {
            this.reportGenericSchemaError("The namespce name for '" + element.getLocalName() + "' must be " + "http://www.w3.org/2001/XMLSchema");
        }
        return this.fGeneralAttrCheck.checkAttributes(element, n);
    }

    private int parseInt(String string) throws Exception {
        if (string.equals("*")) {
            return -1;
        }
        return Integer.parseInt(string);
    }

    private int parseSimpleFinal(String string) throws Exception {
        if (string.equals("#all")) {
            return 26;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("restriction")) {
                if (n2 == 0) {
                    n2 = 2;
                    continue;
                }
                this.reportGenericSchemaError("restriction in set twice");
                continue;
            }
            if (string2.equals("list")) {
                if (n3 == 0) {
                    n3 = 8;
                    continue;
                }
                this.reportGenericSchemaError("list in set twice");
                continue;
            }
            this.reportGenericSchemaError("Invalid value (" + string + ")");
        }
        return n + n3;
    }

    private int parseDerivationSet(String string) throws Exception {
        if (string.equals("#all")) {
            return 3;
        }
        int n = 0;
        int n2 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("extension")) {
                if (n == 0) {
                    n = 1;
                    continue;
                }
                this.reportGenericSchemaError("extension already in set");
                continue;
            }
            if (string2.equals("restriction")) {
                if (n2 == 0) {
                    n2 = 2;
                    continue;
                }
                this.reportGenericSchemaError("restriction already in set");
                continue;
            }
            this.reportGenericSchemaError("Invalid final value (" + string + ")");
        }
        return n + n2;
    }

    private int parseBlockSet(String string) throws Exception {
        if (string == null) {
            return this.fBlockDefault;
        }
        if (string.equals("#all")) {
            return 35;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("substitution")) {
                if (n3 == 0) {
                    n3 = 32;
                    continue;
                }
                this.reportGenericSchemaError("The value 'substitution' already in the list");
                continue;
            }
            if (string2.equals("extension")) {
                if (n == 0) {
                    n = 1;
                    continue;
                }
                this.reportGenericSchemaError("The value 'extension' is already in the list");
                continue;
            }
            if (string2.equals("restriction")) {
                if (n2 == 0) {
                    n2 = 2;
                    continue;
                }
                this.reportGenericSchemaError("The value 'restriction' is already in the list");
                continue;
            }
            this.reportGenericSchemaError("Invalid block value (" + string + ")");
        }
        int n4 = n + n2 + n3;
        return n4 == 0 ? this.fBlockDefault : n4;
    }

    private int parseFinalSet(String string) throws Exception {
        if (string == null) {
            return this.fFinalDefault;
        }
        if (string.equals("#all")) {
            return 15;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("union")) {
                if (n4 == 0) {
                    n4 = 4;
                    continue;
                }
                this.reportGenericSchemaError("The value 'union' is already in the list");
                continue;
            }
            if (string2.equals("extension")) {
                if (n == 0) {
                    n = 1;
                    continue;
                }
                this.reportGenericSchemaError("The value 'extension' is already in the list");
                continue;
            }
            if (string2.equals("list")) {
                if (n3 == 0) {
                    n3 = 8;
                    continue;
                }
                this.reportGenericSchemaError("The value 'list' is already in the list");
                continue;
            }
            if (string2.equals("restriction")) {
                if (n2 == 0) {
                    n2 = 2;
                    continue;
                }
                this.reportGenericSchemaError("The value 'restriction' is already in the list");
                continue;
            }
            this.reportGenericSchemaError("Invalid final value (" + string + ")");
        }
        int n5 = n + n2 + n3 + n4;
        return n5 == 0 ? this.fFinalDefault : n5;
    }

    private void reportGenericSchemaError(String string) throws Exception {
        if (this.fErrorReporter == null) {
            System.err.println("__TraverseSchemaError__ : " + string);
        } else {
            this.reportSchemaError(23, new Object[]{string});
        }
    }

    private void reportSchemaError(int n, Object[] objectArray) throws Exception {
        if (this.fErrorReporter == null) {
            System.out.println("__TraverseSchemaError__ : " + SchemaMessageProvider.fgMessageKeys[n]);
            int n2 = 0;
            while (n2 < objectArray.length) {
                System.out.println((String)objectArray[n2]);
                ++n2;
            }
        } else {
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/xml-schema-1", n, 0, objectArray, 1);
        }
    }

    public class SchemaInfo {
        private Element saveRoot;
        private SchemaInfo nextRoot;
        private SchemaInfo prevRoot;
        private String savedSchemaURL;
        private boolean saveElementDefaultQualified;
        private boolean saveAttributeDefaultQualified;
        private int saveBlockDefault;
        private int saveFinalDefault;
        private NamespacesScope saveNamespacesScope;

        public SchemaInfo(boolean bl, boolean bl2, int n, int n2, String string, Element element, NamespacesScope namespacesScope, SchemaInfo schemaInfo, SchemaInfo schemaInfo2) {
            this.savedSchemaURL = TraverseSchema.this.fCurrentSchemaURL;
            this.saveElementDefaultQualified = TraverseSchema.this.fElementDefaultQualified;
            this.saveAttributeDefaultQualified = TraverseSchema.this.fAttributeDefaultQualified;
            this.saveBlockDefault = TraverseSchema.this.fBlockDefault;
            this.saveFinalDefault = TraverseSchema.this.fFinalDefault;
            this.saveNamespacesScope = TraverseSchema.this.fNamespacesScope;
            this.saveElementDefaultQualified = bl;
            this.saveAttributeDefaultQualified = bl2;
            this.saveBlockDefault = n;
            this.saveFinalDefault = n2;
            this.savedSchemaURL = string;
            this.saveRoot = element;
            if (namespacesScope != null) {
                this.saveNamespacesScope = (NamespacesScope)namespacesScope.clone();
            }
            this.nextRoot = schemaInfo;
            this.prevRoot = schemaInfo2;
        }

        public void setNext(SchemaInfo schemaInfo) {
            this.nextRoot = schemaInfo;
        }

        public SchemaInfo getNext() {
            return this.nextRoot;
        }

        public void setPrev(SchemaInfo schemaInfo) {
            this.prevRoot = schemaInfo;
        }

        public String getCurrentSchemaURL() {
            return this.savedSchemaURL;
        }

        public SchemaInfo getPrev() {
            return this.prevRoot;
        }

        public Element getRoot() {
            return this.saveRoot;
        }

        public void restore() {
            TraverseSchema.this.fCurrentSchemaURL = this.savedSchemaURL;
            TraverseSchema.this.fElementDefaultQualified = this.saveElementDefaultQualified;
            TraverseSchema.this.fAttributeDefaultQualified = this.saveAttributeDefaultQualified;
            TraverseSchema.this.fBlockDefault = this.saveBlockDefault;
            TraverseSchema.this.fFinalDefault = this.saveFinalDefault;
            TraverseSchema.this.fNamespacesScope = (NamespacesScope)this.saveNamespacesScope.clone();
            TraverseSchema.this.fSchemaRootElement = this.saveRoot;
        }
    }

    static class IgnoreWhitespaceParser
    extends DOMParser {
        IgnoreWhitespaceParser() {
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) {
        }

        public void ignorableWhitespace(int n) {
        }
    }

    static class ErrorHandler
    implements org.xml.sax.ErrorHandler {
        ErrorHandler() {
        }

        public void warning(SAXParseException sAXParseException) {
            System.err.println("[Warning] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        }

        public void error(SAXParseException sAXParseException) {
            System.err.println("[Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            System.err.println("[Fatal Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
            throw sAXParseException;
        }

        private String getLocationString(SAXParseException sAXParseException) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = sAXParseException.getSystemId();
            if (string != null) {
                int n = string.lastIndexOf(47);
                if (n != -1) {
                    string = string.substring(n + 1);
                }
                stringBuffer.append(string);
            }
            stringBuffer.append(':');
            stringBuffer.append(sAXParseException.getLineNumber());
            stringBuffer.append(':');
            stringBuffer.append(sAXParseException.getColumnNumber());
            return stringBuffer.toString();
        }
    }

    static class Resolver
    implements EntityResolver {
        private static final String[] SYSTEM = new String[]{"http://www.w3.org/TR/2000/WD-xmlschema-1-20000407/structures.dtd", "http://www.w3.org/TR/2000/WD-xmlschema-1-20000407/datatypes.dtd", "http://www.w3.org/TR/2000/WD-xmlschema-1-20000407/versionInfo.ent"};
        private static final String[] PATH = new String[]{"structures.dtd", "datatypes.dtd", "versionInfo.ent"};

        Resolver() {
        }

        public InputSource resolveEntity(String string, String string2) throws IOException {
            int n = 0;
            while (n < SYSTEM.length) {
                if (string2.equals(SYSTEM[n])) {
                    InputSource inputSource = new InputSource(this.getClass().getResourceAsStream(PATH[n]));
                    inputSource.setPublicId(string);
                    inputSource.setSystemId(string2);
                    return inputSource;
                }
                ++n;
            }
            return null;
        }
    }

    private class ElementInfo {
        int elementIndex;
        String typeName;

        private ElementInfo(int n, String string) {
            this.elementIndex = n;
            this.typeName = string;
        }
    }

    private class GroupInfo {
        int contentSpecIndex = -1;
        int scope = -1;

        private GroupInfo() {
        }
    }

    private class ParticleRecoverableError
    extends Exception {
        ParticleRecoverableError(String string) {
            super(string);
        }
    }

    private class ComplexTypeRecoverableError
    extends Exception {
        ComplexTypeRecoverableError() {
        }

        ComplexTypeRecoverableError(String string) {
            super(string);
        }
    }

    public class ComplexTypeInfo {
        public String typeName;
        public DatatypeValidator baseDataTypeValidator;
        public ComplexTypeInfo baseComplexTypeInfo;
        public int derivedBy = 0;
        public int blockSet = 0;
        public int finalSet = 0;
        public int miscFlags = 0;
        public int scopeDefined = -1;
        public int contentType;
        public int contentSpecHandle = -1;
        public int templateElementIndex = -1;
        public int attlistHead = -1;
        public DatatypeValidator datatypeValidator;

        public boolean isAbstractType() {
            return (this.miscFlags & 1) != 0;
        }

        public boolean containsAttrTypeID() {
            return (this.miscFlags & 2) != 0;
        }

        public boolean declSeen() {
            return (this.miscFlags & 4) != 0;
        }

        public void setIsAbstractType() {
            this.miscFlags |= 1;
        }

        public void setContainsAttrTypeID() {
            this.miscFlags |= 2;
        }

        public void setDeclSeen() {
            this.miscFlags |= 4;
        }
    }
}

