/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.common;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xerces.framework.XMLAttrList;
import org.apache.xerces.framework.XMLContentSpec;
import org.apache.xerces.framework.XMLDocumentHandler;
import org.apache.xerces.framework.XMLDocumentScanner;
import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.readers.DefaultEntityHandler;
import org.apache.xerces.readers.XMLEntityHandler;
import org.apache.xerces.utils.IntStack;
import org.apache.xerces.utils.NamespacesScope;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.validators.common.CMException;
import org.apache.xerces.validators.common.ContentLeafNameTypeVector;
import org.apache.xerces.validators.common.DFAContentModel;
import org.apache.xerces.validators.common.Grammar;
import org.apache.xerces.validators.common.GrammarResolver;
import org.apache.xerces.validators.common.InsertableElementsInfo;
import org.apache.xerces.validators.common.XMLAttributeDecl;
import org.apache.xerces.validators.common.XMLContentModel;
import org.apache.xerces.validators.common.XMLElementDecl;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.DatatypeValidatorFactoryImpl;
import org.apache.xerces.validators.datatype.ENTITYDatatypeValidator;
import org.apache.xerces.validators.datatype.IDDatatypeValidator;
import org.apache.xerces.validators.datatype.IDREFDatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;
import org.apache.xerces.validators.datatype.NOTATIONDatatypeValidator;
import org.apache.xerces.validators.datatype.StateMessageDatatype;
import org.apache.xerces.validators.datatype.UnionDatatypeValidator;
import org.apache.xerces.validators.dtd.DTDGrammar;
import org.apache.xerces.validators.schema.GeneralAttrCheck;
import org.apache.xerces.validators.schema.SchemaGrammar;
import org.apache.xerces.validators.schema.SubstitutionGroupComparator;
import org.apache.xerces.validators.schema.TraverseSchema;
import org.apache.xerces.validators.schema.identity.Field;
import org.apache.xerces.validators.schema.identity.FieldActivator;
import org.apache.xerces.validators.schema.identity.IDValue;
import org.apache.xerces.validators.schema.identity.IdentityConstraint;
import org.apache.xerces.validators.schema.identity.Key;
import org.apache.xerces.validators.schema.identity.KeyRef;
import org.apache.xerces.validators.schema.identity.Selector;
import org.apache.xerces.validators.schema.identity.Unique;
import org.apache.xerces.validators.schema.identity.ValueStore;
import org.apache.xerces.validators.schema.identity.XPathMatcher;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

public final class XMLValidator
implements DefaultEntityHandler.EventHandler,
XMLEntityHandler.CharDataHandler,
XMLDocumentScanner.EventHandler,
NamespacesScope.NamespacesHandler,
FieldActivator {
    private static final boolean PRINT_EXCEPTION_STACK_TRACE = false;
    private static final boolean DEBUG_PRINT_ATTRIBUTES = false;
    private static final boolean DEBUG_PRINT_CONTENT = false;
    private static final boolean DEBUG_SCHEMA_VALIDATION = false;
    private static final boolean DEBUG_ELEMENT_CHILDREN = false;
    protected static final boolean DEBUG_IDENTITY_CONSTRAINTS = false;
    protected static final boolean DEBUG_VALUE_STORES = false;
    private static final int CHUNK_SHIFT = 8;
    private static final int CHUNK_SIZE = 256;
    private static final int CHUNK_MASK = 255;
    private static final int INITIAL_CHUNK_COUNT = 4;
    private Hashtable fIdDefs = new Hashtable();
    private Hashtable fIdREFDefs = new Hashtable();
    private StateMessageDatatype fValidateIDRef = new StateMessageDatatype(){
        private Hashtable fIdDefs;

        public Object getDatatypeObject() {
            return this.fIdDefs;
        }

        public int getDatatypeState() {
            return 0;
        }

        public void setDatatypeObject(Object object) {
            this.fIdDefs = (Hashtable)object;
        }
    };
    private StateMessageDatatype fCheckIDRef = new StateMessageDatatype(){
        private Object[] fLists;

        public Object getDatatypeObject() {
            return this.fLists;
        }

        public int getDatatypeState() {
            return 1;
        }

        public void setDatatypeObject(Object object) {
            this.fLists = (Object[])object;
        }
    };
    private StateMessageDatatype fValidateEntity = new StateMessageDatatype(){
        private Object fData;

        public Object getDatatypeObject() {
            return this.fData;
        }

        public int getDatatypeState() {
            return 0;
        }

        public void setDatatypeObject(Object object) {
            this.fData = object;
        }
    };
    private AttributeValidator fAttValidatorNOTATION = new AttValidatorNOTATION();
    private AttributeValidator fAttValidatorENUMERATION = new AttValidatorENUMERATION();
    private AttributeValidator fAttValidatorDATATYPE = null;
    StringPool fStringPool = null;
    boolean fValidating = false;
    boolean fInElementContent = false;
    int fStandaloneReader = -1;
    private boolean fValidationEnabled = false;
    private boolean fDynamicValidation = false;
    private boolean fSchemaValidation = true;
    private boolean fSchemaValidationFullChecking = false;
    private boolean fValidationEnabledByDynamic = false;
    private boolean fDynamicDisabledByValidation = false;
    private boolean fWarningOnDuplicateAttDef = false;
    private boolean fWarningOnUndeclaredElements = false;
    private boolean fNormalizeAttributeValues = true;
    private boolean fLoadDTDGrammar = true;
    private Hashtable fLocationUriPairs = new Hashtable(10);
    private String fExternalSchemas = null;
    private String fExternalNoNamespaceSchema = null;
    private DOMParser fSchemaGrammarParser = null;
    private int[] fDeclaration;
    private XMLErrorReporter fErrorReporter = null;
    private DefaultEntityHandler fEntityHandler = null;
    private QName fCurrentElement = new QName();
    private ContentLeafNameTypeVector[] fContentLeafStack = new ContentLeafNameTypeVector[8];
    private XMLContentModel[] fContentModelStack = new XMLContentModel[8];
    private int[] fContentModelStateStack = new int[8];
    private int[] fContentModelEleCount = new int[8];
    private int[] fValidationFlagStack = new int[8];
    private int[] fScopeStack = new int[8];
    private int[] fGrammarNameSpaceIndexStack = new int[8];
    private int[] fElementEntityStack = new int[8];
    private int[] fElementIndexStack = new int[8];
    private int[] fContentSpecTypeStack = new int[8];
    private static final int sizeQNameParts = 8;
    private QName[] fElementQNamePartsStack = new QName[8];
    private QName[] fElementChildren = new QName[32];
    private int fElementChildrenLength = 0;
    private int[] fElementChildrenOffsetStack = new int[32];
    private int fElementDepth = -1;
    private boolean fNamespacesEnabled = false;
    private NamespacesScope fNamespacesScope = null;
    private int fNamespacesPrefix = -1;
    private QName fRootElement = new QName();
    private int fAttrListHandle = -1;
    private int fCurrentElementEntity = -1;
    private int fCurrentElementIndex = -1;
    private int fCurrentContentSpecType = -1;
    private boolean fSeenDoctypeDecl = false;
    private final int TOP_LEVEL_SCOPE = -1;
    private int fCurrentScope = -1;
    private int fCurrentSchemaURI = 0;
    private int fEmptyURI = 0;
    private int fXsiPrefix = -1;
    private int fXsiURI = -2;
    private int fXsiTypeAttValue = -1;
    private DatatypeValidator fXsiTypeValidator = null;
    private boolean fNil = false;
    private Grammar fGrammar = null;
    private int fGrammarNameSpaceIndex = 0;
    private GrammarResolver fGrammarResolver = null;
    private boolean fScanningDTD = false;
    private XMLDocumentScanner fDocumentScanner = null;
    private boolean fCalledStartDocument = false;
    private XMLDocumentHandler fDocumentHandler = null;
    private XMLDocumentHandler.DTDHandler fDTDHandler = null;
    private boolean fSeenRootElement = false;
    private XMLAttrList fAttrList = null;
    private int fXMLLang = -1;
    private LocatorImpl fAttrNameLocator = null;
    private boolean fCheckedForSchema = false;
    private boolean fDeclsAreExternal = false;
    private StringPool.CharArrayRange fCurrentElementCharArrayRange = null;
    private char[] fCharRefData = null;
    private boolean fSendCharDataAsCharArray = false;
    private boolean fBufferDatatype = false;
    private StringBuffer fDatatypeBuffer = new StringBuffer();
    private QName fTempQName = new QName();
    private XMLAttributeDecl fTempAttDecl = new XMLAttributeDecl();
    private XMLAttributeDecl fTempAttributeDecl = new XMLAttributeDecl();
    private XMLElementDecl fTempElementDecl = new XMLElementDecl();
    private boolean fGrammarIsDTDGrammar = false;
    private boolean fGrammarIsSchemaGrammar = false;
    private boolean fNeedValidationOff = false;
    private static final boolean DEBUG_NORMALIZATION = false;
    private DatatypeValidator fCurrentDV = null;
    private boolean fFirstChunk = true;
    private boolean fTrailing = false;
    private short fWhiteSpace = (short)2;
    private StringBuffer fStringBuffer = new StringBuffer(256);
    private StringBuffer fTempBuffer = new StringBuffer(256);
    private int fEMPTYSymbol = -1;
    private int fANYSymbol = -1;
    private int fMIXEDSymbol = -1;
    private int fCHILDRENSymbol = -1;
    private int fCDATASymbol = -1;
    private int fIDSymbol = -1;
    private int fIDREFSymbol = -1;
    private int fIDREFSSymbol = -1;
    private int fENTITYSymbol = -1;
    private int fENTITIESSymbol = -1;
    private int fNMTOKENSymbol = -1;
    private int fNMTOKENSSymbol = -1;
    private int fNOTATIONSymbol = -1;
    private int fENUMERATIONSymbol = -1;
    private int fREQUIREDSymbol = -1;
    private int fFIXEDSymbol = -1;
    private int fDATATYPESymbol = -1;
    private int fEpsilonIndex = -1;
    private DatatypeValidatorFactoryImpl fDataTypeReg = null;
    private DatatypeValidator fValID = null;
    private DatatypeValidator fValIDRef = null;
    private DatatypeValidator fValIDRefs = null;
    private DatatypeValidator fValENTITY = null;
    private DatatypeValidator fValENTITIES = null;
    private DatatypeValidator fValNMTOKEN = null;
    private DatatypeValidator fValNMTOKENS = null;
    private DatatypeValidator fValNOTATION = null;
    protected XPathMatcherStack fMatcherStack = new XPathMatcherStack();
    protected ValueStoreCache fValueStoreCache = new ValueStoreCache();
    protected SubstitutionGroupComparator fSGComparator = null;

    public XMLValidator(StringPool stringPool, XMLErrorReporter xMLErrorReporter, DefaultEntityHandler defaultEntityHandler, XMLDocumentScanner xMLDocumentScanner) {
        this.fStringPool = stringPool;
        this.fErrorReporter = xMLErrorReporter;
        this.fEntityHandler = defaultEntityHandler;
        this.fDocumentScanner = xMLDocumentScanner;
        this.fValidateEntity.setDatatypeObject(new Object[]{defaultEntityHandler, stringPool});
        this.fValidateIDRef.setDatatypeObject(this.fIdREFDefs);
        this.fCheckIDRef.setDatatypeObject(new Object[]{this.fIdDefs, this.fIdREFDefs});
        this.fEmptyURI = this.fStringPool.addSymbol("");
        this.fXsiURI = this.fStringPool.addSymbol("http://www.w3.org/2001/XMLSchema-instance");
        this.fAttrList = new XMLAttrList(this.fStringPool);
        defaultEntityHandler.setEventHandler(this);
        defaultEntityHandler.setCharDataHandler(this);
        this.fDocumentScanner.setEventHandler(this);
        int n = 0;
        while (n < 8) {
            this.fElementQNamePartsStack[n] = new QName();
            ++n;
        }
        this.init();
    }

    public void setGrammarResolver(GrammarResolver grammarResolver) {
        this.fGrammarResolver = grammarResolver;
        this.fSGComparator = new SubstitutionGroupComparator(this.fGrammarResolver, this.fStringPool, this.fErrorReporter);
        if (this.fValidating) {
            this.initDataTypeValidators();
        }
    }

    public void initHandlers(boolean bl, XMLDocumentHandler xMLDocumentHandler, XMLDocumentHandler.DTDHandler dTDHandler) {
        this.fSendCharDataAsCharArray = bl;
        this.fEntityHandler.setSendCharDataAsCharArray(this.fSendCharDataAsCharArray);
        this.fDocumentHandler = xMLDocumentHandler;
        this.fDTDHandler = dTDHandler;
    }

    public void resetOrCopy(StringPool stringPool) throws Exception {
        this.fAttrList = new XMLAttrList(stringPool);
        this.resetCommon(stringPool);
    }

    public void reset(StringPool stringPool) throws Exception {
        this.fAttrList.reset(stringPool);
        this.resetCommon(stringPool);
    }

    public void setValidationEnabled(boolean bl) throws Exception {
        this.fValidationEnabled = bl;
        this.fValidationEnabledByDynamic = false;
        if (this.fValidationEnabled) {
            if (this.fDynamicDisabledByValidation) {
                this.fDynamicValidation = true;
                this.fDynamicDisabledByValidation = false;
            }
        } else if (this.fDynamicValidation) {
            this.fDynamicValidation = false;
            this.fDynamicDisabledByValidation = true;
        }
        this.fValidating = this.fValidationEnabled;
        if (this.fValidating) {
            this.initDataTypeValidators();
        }
    }

    public boolean getValidationEnabled() {
        return this.fValidationEnabled;
    }

    public void setSchemaValidationEnabled(boolean bl) {
        this.fSchemaValidation = bl;
    }

    public boolean getSchemaValidationEnabled() {
        return this.fSchemaValidation;
    }

    public void setSchemaFullCheckingEnabled(boolean bl) {
        this.fSchemaValidationFullChecking = bl;
    }

    public void setExternalSchemas(Object object) {
        this.fExternalSchemas = (String)object;
    }

    public void setExternalNoNamespaceSchema(Object object) {
        this.fExternalNoNamespaceSchema = (String)object;
    }

    public boolean getSchemaFullCheckingEnabled() {
        return this.fSchemaValidationFullChecking;
    }

    public void setDynamicValidationEnabled(boolean bl) throws Exception {
        this.fDynamicValidation = bl;
        this.fDynamicDisabledByValidation = false;
        if (!this.fDynamicValidation) {
            if (this.fValidationEnabledByDynamic) {
                this.fValidationEnabled = false;
                this.fValidationEnabledByDynamic = false;
            }
        } else if (!this.fValidationEnabled) {
            this.fValidationEnabled = true;
            this.fValidationEnabledByDynamic = true;
        }
        this.fValidating = this.fValidationEnabled;
        if (this.fValidating) {
            this.initDataTypeValidators();
        }
    }

    public boolean getDynamicValidationEnabled() {
        return this.fDynamicValidation;
    }

    public void setNormalizeAttributeValues(boolean bl) {
        this.fNormalizeAttributeValues = bl;
    }

    public void setLoadDTDGrammar(boolean bl) {
        this.fLoadDTDGrammar = this.fValidating ? true : bl;
    }

    public boolean getLoadDTDGrammar() {
        return this.fLoadDTDGrammar;
    }

    public void setNamespacesEnabled(boolean bl) {
        this.fNamespacesEnabled = bl;
    }

    public boolean getNamespacesEnabled() {
        return this.fNamespacesEnabled;
    }

    public void setWarningOnDuplicateAttDef(boolean bl) {
        this.fWarningOnDuplicateAttDef = bl;
    }

    public boolean getWarningOnDuplicateAttDef() {
        return this.fWarningOnDuplicateAttDef;
    }

    public void setWarningOnUndeclaredElements(boolean bl) {
        this.fWarningOnUndeclaredElements = bl;
    }

    public boolean getWarningOnUndeclaredElements() {
        return this.fWarningOnUndeclaredElements;
    }

    public void startValueScopeFor(IdentityConstraint identityConstraint) throws Exception {
        int n = 0;
        while (n < identityConstraint.getFieldCount()) {
            Field field = identityConstraint.getFieldAt(n);
            ValueStoreBase valueStoreBase = this.fValueStoreCache.getValueStoreFor(field);
            valueStoreBase.startValueScope();
            ++n;
        }
    }

    public XPathMatcher activateField(Field field) throws Exception {
        ValueStoreBase valueStoreBase = this.fValueStoreCache.getValueStoreFor(field);
        field.setMayMatch(true);
        XPathMatcher xPathMatcher = field.createMatcher(valueStoreBase);
        this.fMatcherStack.addMatcher(xPathMatcher);
        xPathMatcher.startDocumentFragment(this.fStringPool);
        return xPathMatcher;
    }

    public void endValueScopeFor(IdentityConstraint identityConstraint) throws Exception {
        ValueStoreBase valueStoreBase = this.fValueStoreCache.getValueStoreFor(identityConstraint);
        valueStoreBase.endValueScope();
    }

    public void startEntityReference(int n, int n2, int n3) throws Exception {
        this.fDocumentHandler.startEntityReference(n, n2, n3);
    }

    public void endEntityReference(int n, int n2, int n3) throws Exception {
        this.fDocumentHandler.endEntityReference(n, n2, n3);
    }

    public void sendEndOfInputNotifications(int n, boolean bl) throws Exception {
        this.fDocumentScanner.endOfInput(n, bl);
    }

    public void sendReaderChangeNotifications(XMLEntityHandler.EntityReader entityReader, int n) throws Exception {
        this.fDocumentScanner.readerChange(entityReader, n);
    }

    public boolean externalEntityStandaloneCheck() {
        return this.fStandaloneReader != -1 && this.fValidating;
    }

    public boolean getValidating() {
        return this.fValidating;
    }

    private int normalizeWhitespace(StringBuffer stringBuffer, boolean bl) {
        int n;
        int n2 = this.fTempBuffer.length();
        this.fStringBuffer.setLength(0);
        boolean bl2 = bl;
        boolean bl3 = false;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            n = stringBuffer.charAt(n5);
            if (n == 32 || n == 13 || n == 10 || n == 9) {
                if (!bl2) {
                    this.fStringBuffer.append(' ');
                    bl2 = bl;
                }
                if (!bl3) {
                    n3 = 1;
                }
            } else {
                this.fStringBuffer.append((char)n);
                bl2 = false;
                bl3 = true;
            }
            ++n5;
        }
        if (bl2) {
            n = this.fStringBuffer.length();
            if (n != 0) {
                this.fStringBuffer.setLength(--n);
                n4 = 2;
            } else if (n3 != 0 && !bl3) {
                n4 = 2;
            }
        }
        return bl ? n3 + n4 : 0;
    }

    public void processCharacters(char[] cArray, int n, int n2) throws Exception {
        if (this.fValidating) {
            if (this.fInElementContent || this.fCurrentContentSpecType == 0) {
                this.charDataInContent();
            }
            if (this.fBufferDatatype) {
                if (this.fFirstChunk && this.fGrammar != null) {
                    this.fGrammar.getElementDecl(this.fCurrentElementIndex, this.fTempElementDecl);
                    this.fCurrentDV = this.fTempElementDecl.datatypeValidator;
                    if (this.fCurrentDV != null) {
                        this.fWhiteSpace = this.fCurrentDV.getWSFacet();
                    }
                }
                if (this.fWhiteSpace == 0) {
                    this.fDatatypeBuffer.append(cArray, n, n2);
                } else {
                    this.fTempBuffer.setLength(0);
                    this.fTempBuffer.append(cArray, n, n2);
                    int n3 = this.normalizeWhitespace(this.fTempBuffer, this.fWhiteSpace == 2);
                    int n4 = this.fStringBuffer.length();
                    if (n4 > 0) {
                        if (!this.fFirstChunk && this.fWhiteSpace == 2 && this.fTrailing) {
                            this.fStringBuffer.insert(0, ' ');
                            ++n4;
                        }
                        if (n2 - n != n4) {
                            char[] cArray2 = new char[n4];
                            this.fStringBuffer.getChars(0, n4, cArray2, 0);
                            cArray = cArray2;
                            n = 0;
                            n2 = n4;
                        } else {
                            this.fStringBuffer.getChars(0, n4, cArray, 0);
                        }
                        this.fDatatypeBuffer.append(cArray, n, n2);
                        this.fDocumentHandler.characters(cArray, n, n2);
                        int n5 = this.fMatcherStack.getMatcherCount();
                        int n6 = 0;
                        while (n6 < n5) {
                            XPathMatcher xPathMatcher = this.fMatcherStack.getMatcherAt(n6);
                            xPathMatcher.characters(cArray, n, n2);
                            ++n6;
                        }
                    }
                    this.fTrailing = n3 > 1;
                    this.fFirstChunk = false;
                    return;
                }
            }
        }
        this.fFirstChunk = false;
        this.fDocumentHandler.characters(cArray, n, n2);
        int n7 = this.fMatcherStack.getMatcherCount();
        int n8 = 0;
        while (n8 < n7) {
            XPathMatcher xPathMatcher = this.fMatcherStack.getMatcherAt(n8);
            xPathMatcher.characters(cArray, n, n2);
            ++n8;
        }
    }

    public void processCharacters(int n) throws Exception {
        if (this.fValidating) {
            if (this.fInElementContent || this.fCurrentContentSpecType == 0) {
                this.charDataInContent();
            }
            if (this.fBufferDatatype) {
                this.fGrammar.getElementDecl(this.fCurrentElementIndex, this.fTempElementDecl);
                this.fCurrentDV = this.fTempElementDecl.datatypeValidator;
                if (this.fCurrentDV != null) {
                    this.fWhiteSpace = this.fCurrentDV.getWSFacet();
                }
                if (this.fWhiteSpace == 0) {
                    this.fDatatypeBuffer.append(this.fStringPool.toString(n));
                } else {
                    String string = this.fStringPool.toString(n);
                    int n2 = string.length();
                    this.fTempBuffer.setLength(0);
                    this.fTempBuffer.append(string);
                    int n3 = this.normalizeWhitespace(this.fTempBuffer, this.fWhiteSpace == 2);
                    if (this.fWhiteSpace != 0) {
                        this.fStringPool.releaseString(n);
                        n = this.fStringPool.addString(this.fStringBuffer.toString());
                    }
                    this.fDatatypeBuffer.append(this.fStringBuffer.toString());
                }
            }
        }
        this.fDocumentHandler.characters(n);
        int n4 = this.fMatcherStack.getMatcherCount();
        if (n4 > 0) {
            String string = this.fStringPool.toString(n);
            char[] cArray = new char[string.length()];
            int n5 = 0;
            int n6 = cArray.length;
            string.getChars(n5, n6, cArray, n5);
            int n7 = 0;
            while (n7 < n4) {
                XPathMatcher xPathMatcher = this.fMatcherStack.getMatcherAt(n7);
                xPathMatcher.characters(cArray, n5, n6);
                ++n7;
            }
        }
    }

    public void processWhitespace(char[] cArray, int n, int n2) throws Exception {
        if (this.fInElementContent) {
            if (this.fStandaloneReader != -1 && this.fValidating && this.getElementDeclIsExternal(this.fCurrentElementIndex)) {
                this.reportRecoverableXMLError(143, 80);
            }
            this.fDocumentHandler.ignorableWhitespace(cArray, n, n2);
        } else {
            if (this.fCurrentContentSpecType == 0) {
                this.charDataInContent();
            }
            this.fDocumentHandler.characters(cArray, n, n2);
            int n3 = this.fMatcherStack.getMatcherCount();
            int n4 = 0;
            while (n4 < n3) {
                XPathMatcher xPathMatcher = this.fMatcherStack.getMatcherAt(n4);
                xPathMatcher.characters(cArray, n, n2);
                ++n4;
            }
        }
    }

    public void processWhitespace(int n) throws Exception {
        if (this.fInElementContent) {
            if (this.fStandaloneReader != -1 && this.fValidating && this.getElementDeclIsExternal(this.fCurrentElementIndex)) {
                this.reportRecoverableXMLError(143, 80);
            }
            this.fDocumentHandler.ignorableWhitespace(n);
        } else {
            if (this.fCurrentContentSpecType == 0) {
                this.charDataInContent();
            }
            this.fDocumentHandler.characters(n);
            int n2 = this.fMatcherStack.getMatcherCount();
            if (n2 > 0) {
                String string = this.fStringPool.toString(n);
                char[] cArray = new char[string.length()];
                int n3 = 0;
                int n4 = cArray.length;
                string.getChars(n4, n4, cArray, n3);
                int n5 = 0;
                while (n5 < n2) {
                    XPathMatcher xPathMatcher = this.fMatcherStack.getMatcherAt(n5);
                    xPathMatcher.characters(cArray, n3, n4);
                    ++n5;
                }
            }
        }
    }

    public void scanElementType(XMLEntityHandler.EntityReader entityReader, char c, QName qName) throws Exception {
        if (!this.fNamespacesEnabled) {
            qName.clear();
            qName.rawname = qName.localpart = entityReader.scanName(c);
        } else {
            entityReader.scanQName(c, qName);
            if (entityReader.lookingAtChar(':', false)) {
                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 126, 139, null, 2);
                entityReader.skipPastNmtoken(' ');
            }
        }
    }

    public boolean scanExpectedElementType(XMLEntityHandler.EntityReader entityReader, char c, QName qName) throws Exception {
        if (this.fCurrentElementCharArrayRange == null) {
            this.fCurrentElementCharArrayRange = this.fStringPool.createCharArrayRange();
        }
        this.fStringPool.getCharArrayRange(this.fCurrentElement.rawname, this.fCurrentElementCharArrayRange);
        return entityReader.scanExpectedName(c, this.fCurrentElementCharArrayRange);
    }

    public void scanAttributeName(XMLEntityHandler.EntityReader entityReader, QName qName, QName qName2) throws Exception {
        if (!this.fSeenRootElement) {
            this.fSeenRootElement = true;
            this.rootElementSpecified(qName);
            this.fStringPool.resetShuffleCount();
        }
        if (!this.fNamespacesEnabled) {
            qName2.clear();
            qName2.rawname = qName2.localpart = entityReader.scanName('=');
        } else {
            entityReader.scanQName('=', qName2);
            if (entityReader.lookingAtChar(':', false)) {
                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 126, 139, null, 2);
                entityReader.skipPastNmtoken(' ');
            }
        }
    }

    public void callStartDocument() throws Exception {
        if (!this.fCalledStartDocument) {
            this.fDocumentHandler.startDocument();
            this.fCalledStartDocument = true;
            if (this.fValidating) {
                this.fValueStoreCache.startDocument();
            }
        }
    }

    public void callEndDocument() throws Exception {
        if (this.fCalledStartDocument) {
            if (this.fValidating) {
                this.fValueStoreCache.endDocument();
            }
            this.fDocumentHandler.endDocument();
        }
    }

    public void callXMLDecl(int n, int n2, int n3) throws Exception {
        this.fDocumentHandler.xmlDecl(n, n2, n3);
    }

    public void callStandaloneIsYes() throws Exception {
        this.fStandaloneReader = this.fEntityHandler.getReaderId();
    }

    public void callTextDecl(int n, int n2) throws Exception {
        this.fDocumentHandler.textDecl(n, n2);
    }

    public void element(QName qName) throws Exception {
        this.fAttrListHandle = -1;
    }

    public boolean attribute(QName qName, QName qName2, int n) throws Exception {
        if (this.fAttrListHandle == -1) {
            this.fAttrListHandle = this.fAttrList.startAttrList();
        }
        return this.fAttrList.addAttr(qName2, n, this.fCDATASymbol, true, true) == -1;
    }

    public void callStartElement(QName qName) throws Exception {
        int n;
        if (!this.fSeenRootElement) {
            this.rootElementSpecified(qName);
            this.fStringPool.resetShuffleCount();
        }
        if (this.fGrammar != null && this.fGrammarIsDTDGrammar) {
            this.fAttrListHandle = this.addDTDDefaultAttributes(qName, this.fAttrList, this.fAttrListHandle, this.fValidating, this.fStandaloneReader != -1);
        }
        this.fCheckedForSchema = true;
        if (this.fNamespacesEnabled) {
            this.bindNamespacesToElementAndAttributes(qName, this.fAttrList);
        }
        if (!this.fSeenRootElement) {
            this.fSeenRootElement = true;
        }
        this.validateElementAndAttributes(qName, this.fAttrList);
        if (this.fAttrListHandle != -1) {
            this.fAttrList.endAttrList();
        }
        if (this.fValidating && this.fGrammar != null && this.fGrammarIsSchemaGrammar) {
            int n2;
            this.fValueStoreCache.startElement();
            this.fMatcherStack.pushContext();
            int n3 = this.fGrammar.getElementDeclIndex(qName, -1);
            if (n3 != -1) {
                this.fGrammar.getElementDecl(n3, this.fTempElementDecl);
                this.fValueStoreCache.initValueStoresFor(this.fTempElementDecl);
                n = this.fTempElementDecl.unique.size();
                n2 = 0;
                while (n2 < n) {
                    this.activateSelectorFor((IdentityConstraint)this.fTempElementDecl.unique.elementAt(n2));
                    ++n2;
                }
                int n4 = this.fTempElementDecl.key.size();
                int n5 = 0;
                while (n5 < n4) {
                    this.activateSelectorFor((IdentityConstraint)this.fTempElementDecl.key.elementAt(n5));
                    ++n5;
                }
                int n6 = this.fTempElementDecl.keyRef.size();
                int n7 = 0;
                while (n7 < n6) {
                    this.activateSelectorFor((IdentityConstraint)this.fTempElementDecl.keyRef.elementAt(n7));
                    ++n7;
                }
            }
            n = this.fMatcherStack.getMatcherCount();
            n2 = 0;
            while (n2 < n) {
                XPathMatcher xPathMatcher = this.fMatcherStack.getMatcherAt(n2);
                xPathMatcher.startElement(qName, this.fAttrList, this.fAttrListHandle, this.fCurrentElementIndex, (SchemaGrammar)this.fGrammar);
                ++n2;
            }
        }
        this.fDocumentHandler.startElement(qName, this.fAttrList, this.fAttrListHandle);
        ++this.fElementDepth;
        this.fAttrListHandle = -1;
        if (this.fValidating) {
            QName qName2;
            if (this.fElementChildrenOffsetStack.length <= this.fElementDepth) {
                int[] nArray = new int[this.fElementChildrenOffsetStack.length * 2];
                System.arraycopy(this.fElementChildrenOffsetStack, 0, nArray, 0, this.fElementChildrenOffsetStack.length);
                this.fElementChildrenOffsetStack = nArray;
            }
            this.fElementChildrenOffsetStack[this.fElementDepth] = this.fElementChildrenLength;
            if (this.fElementChildren.length <= this.fElementChildrenLength) {
                QName[] qNameArray = new QName[this.fElementChildrenLength * 2];
                System.arraycopy(this.fElementChildren, 0, qNameArray, 0, this.fElementChildren.length);
                this.fElementChildren = qNameArray;
            }
            if ((qName2 = this.fElementChildren[this.fElementChildrenLength]) == null) {
                n = this.fElementChildrenLength;
                while (n < this.fElementChildren.length) {
                    this.fElementChildren[n] = new QName();
                    ++n;
                }
                qName2 = this.fElementChildren[this.fElementChildrenLength];
            }
            qName2.setValues(qName);
            ++this.fElementChildrenLength;
        }
        this.ensureStackCapacity(this.fElementDepth);
        this.fCurrentElement.setValues(qName);
        this.fCurrentElementEntity = this.fEntityHandler.getReaderId();
        this.fElementQNamePartsStack[this.fElementDepth].setValues(this.fCurrentElement);
        this.fElementEntityStack[this.fElementDepth] = this.fCurrentElementEntity;
        this.fElementIndexStack[this.fElementDepth] = this.fCurrentElementIndex;
        this.fContentSpecTypeStack[this.fElementDepth] = this.fCurrentContentSpecType;
        if (this.fNeedValidationOff) {
            this.fValidating = false;
            this.fNeedValidationOff = false;
        }
        if (this.fValidating && this.fGrammarIsSchemaGrammar) {
            this.pushContentLeafStack();
        } else {
            this.fContentModelStateStack[this.fElementDepth] = -2;
        }
        this.fValidationFlagStack[this.fElementDepth] = this.fValidating ? 0 : -1;
        this.fScopeStack[this.fElementDepth] = this.fCurrentScope;
        this.fGrammarNameSpaceIndexStack[this.fElementDepth] = this.fGrammarNameSpaceIndex;
    }

    private void activateSelectorFor(IdentityConstraint identityConstraint) throws Exception {
        Selector selector = identityConstraint.getSelector();
        XMLValidator xMLValidator = this;
        if (selector == null) {
            return;
        }
        XPathMatcher xPathMatcher = selector.createMatcher(xMLValidator);
        this.fMatcherStack.addMatcher(xPathMatcher);
        xPathMatcher.startDocumentFragment(this.fStringPool);
    }

    private void pushContentLeafStack() throws Exception {
        int n = this.getContentSpecType(this.fCurrentElementIndex);
        if (n == 4 || n == 3) {
            XMLContentModel xMLContentModel = this.getElementContentModel(this.fCurrentElementIndex);
            ContentLeafNameTypeVector contentLeafNameTypeVector = xMLContentModel.getContentLeafNameTypeVector();
            if (xMLContentModel != null) {
                this.fContentLeafStack[this.fElementDepth] = contentLeafNameTypeVector;
                this.fContentModelStack[this.fElementDepth] = xMLContentModel;
                this.fContentModelStateStack[this.fElementDepth] = xMLContentModel instanceof DFAContentModel && contentLeafNameTypeVector != null ? 0 : -2;
                this.fContentModelEleCount[this.fElementDepth] = 0;
            }
        } else {
            this.fContentModelStateStack[this.fElementDepth] = -2;
        }
    }

    private void ensureStackCapacity(int n) {
        if (n == this.fElementQNamePartsStack.length) {
            int[] nArray = new int[n * 2];
            System.arraycopy(this.fScopeStack, 0, nArray, 0, n);
            this.fScopeStack = nArray;
            nArray = new int[n * 2];
            System.arraycopy(this.fGrammarNameSpaceIndexStack, 0, nArray, 0, n);
            this.fGrammarNameSpaceIndexStack = nArray;
            QName[] qNameArray = new QName[n * 2];
            System.arraycopy(this.fElementQNamePartsStack, 0, qNameArray, 0, n);
            this.fElementQNamePartsStack = qNameArray;
            QName qName = this.fElementQNamePartsStack[n];
            if (qName == null) {
                int n2 = n;
                while (n2 < this.fElementQNamePartsStack.length) {
                    this.fElementQNamePartsStack[n2] = new QName();
                    ++n2;
                }
            }
            nArray = new int[n * 2];
            System.arraycopy(this.fElementEntityStack, 0, nArray, 0, n);
            this.fElementEntityStack = nArray;
            nArray = new int[n * 2];
            System.arraycopy(this.fElementIndexStack, 0, nArray, 0, n);
            this.fElementIndexStack = nArray;
            nArray = new int[n * 2];
            System.arraycopy(this.fContentSpecTypeStack, 0, nArray, 0, n);
            this.fContentSpecTypeStack = nArray;
            nArray = new int[n * 2];
            System.arraycopy(this.fValidationFlagStack, 0, nArray, 0, n);
            this.fValidationFlagStack = nArray;
            ContentLeafNameTypeVector[] contentLeafNameTypeVectorArray = new ContentLeafNameTypeVector[n * 2];
            System.arraycopy(this.fContentLeafStack, 0, contentLeafNameTypeVectorArray, 0, n);
            this.fContentLeafStack = contentLeafNameTypeVectorArray;
            XMLContentModel[] xMLContentModelArray = new XMLContentModel[n * 2];
            System.arraycopy(this.fContentModelStack, 0, xMLContentModelArray, 0, n);
            this.fContentModelStack = xMLContentModelArray;
            nArray = new int[n * 2];
            System.arraycopy(this.fContentModelStateStack, 0, nArray, 0, n);
            this.fContentModelStateStack = nArray;
            nArray = new int[n * 2];
            System.arraycopy(this.fContentModelEleCount, 0, nArray, 0, n);
            this.fContentModelEleCount = nArray;
        }
    }

    public void callEndElement(int n) throws Exception {
        int n2 = this.fCurrentElement.prefix;
        int n3 = this.fCurrentElement.rawname;
        if (this.fCurrentElementEntity != n) {
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 68, 68, new Object[]{this.fStringPool.toString(n3)}, 2);
        }
        --this.fElementDepth;
        if (this.fValidating) {
            int n4;
            int n5;
            int n6;
            QName[] qNameArray;
            int n7;
            int n8 = this.fCurrentElementIndex;
            if (n8 != -1 && this.fCurrentContentSpecType != -1 && (n7 = this.checkContent(n8, qNameArray = this.fElementChildren, n6 = this.fElementChildrenOffsetStack[this.fElementDepth + 1] + 1, n5 = this.fElementChildrenLength - n6)) != -1) {
                n4 = n7 != n5 ? 87 : 88;
                this.fGrammar.getElementDecl(n8, this.fTempElementDecl);
                if (this.fTempElementDecl.type == 0) {
                    this.reportRecoverableXMLError(n4, 0, this.fStringPool.toString(n3), "EMPTY");
                } else {
                    this.reportRecoverableXMLError(n4, 0, this.fStringPool.toString(n3), XMLContentSpec.toString(this.fGrammar, this.fStringPool, this.fTempElementDecl.contentSpecIndex));
                }
            }
            this.fElementChildrenLength = this.fElementChildrenOffsetStack[this.fElementDepth + 1] + 1;
            if (this.fGrammarIsSchemaGrammar) {
                Object object;
                int n9 = this.fMatcherStack.getMatcherCount();
                n6 = n9 - 1;
                while (n6 >= 0) {
                    XPathMatcher xPathMatcher = this.fMatcherStack.getMatcherAt(n6);
                    xPathMatcher.endElement(this.fCurrentElement, this.fCurrentElementIndex, (SchemaGrammar)this.fGrammar);
                    --n6;
                }
                if (this.fMatcherStack.size() > 0) {
                    this.fMatcherStack.popContext();
                }
                n5 = this.fMatcherStack.getMatcherCount();
                n7 = n9 - 1;
                while (n7 >= n5) {
                    XPathMatcher xPathMatcher = this.fMatcherStack.getMatcherAt(n7);
                    object = xPathMatcher.getIDConstraint();
                    if (object != null && ((IdentityConstraint)object).getType() != 2) {
                        xPathMatcher.endDocumentFragment();
                        this.fValueStoreCache.transplant((IdentityConstraint)object);
                    } else if (object == null) {
                        xPathMatcher.endDocumentFragment();
                    }
                    --n7;
                }
                n4 = n9 - 1;
                while (n4 >= n5) {
                    object = this.fMatcherStack.getMatcherAt(n4);
                    IdentityConstraint identityConstraint = ((XPathMatcher)object).getIDConstraint();
                    if (identityConstraint != null && identityConstraint.getType() == 2) {
                        ValueStoreBase valueStoreBase = this.fValueStoreCache.getValueStoreFor(identityConstraint);
                        if (valueStoreBase != null) {
                            valueStoreBase.endDocumentFragment();
                        }
                        ((XPathMatcher)object).endDocumentFragment();
                    }
                    --n4;
                }
                this.fValueStoreCache.endElement();
            }
        }
        this.fDocumentHandler.endElement(this.fCurrentElement);
        if (this.fNamespacesEnabled) {
            this.fNamespacesScope.decreaseDepth();
        }
        if (this.fElementDepth < -1) {
            throw new RuntimeException("FWK008 Element stack underflow");
        }
        if (this.fElementDepth < 0) {
            this.fCurrentElement.clear();
            this.fCurrentElementEntity = -1;
            this.fCurrentElementIndex = -1;
            this.fCurrentContentSpecType = -1;
            this.fInElementContent = false;
            if (this.fValidating) {
                try {
                    this.fValIDRef.validate(null, this.fCheckIDRef);
                    this.fIdDefs.clear();
                    this.fIdREFDefs.clear();
                }
                catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                    this.reportRecoverableXMLError(invalidDatatypeValueException.getMajorCode(), invalidDatatypeValueException.getMinorCode(), invalidDatatypeValueException.getMessage());
                }
            }
            return;
        }
        this.fCurrentElement.prefix = -1;
        this.fCurrentElement.localpart = this.fNamespacesEnabled ? this.fElementQNamePartsStack[this.fElementDepth].localpart : this.fElementQNamePartsStack[this.fElementDepth].rawname;
        this.fCurrentElement.rawname = this.fElementQNamePartsStack[this.fElementDepth].rawname;
        this.fCurrentElement.uri = this.fElementQNamePartsStack[this.fElementDepth].uri;
        this.fCurrentElement.prefix = this.fElementQNamePartsStack[this.fElementDepth].prefix;
        this.fCurrentElementEntity = this.fElementEntityStack[this.fElementDepth];
        this.fCurrentElementIndex = this.fElementIndexStack[this.fElementDepth];
        this.fCurrentContentSpecType = this.fContentSpecTypeStack[this.fElementDepth];
        this.fValidating = this.fValidationFlagStack[this.fElementDepth] == 0;
        this.fCurrentScope = this.fScopeStack[this.fElementDepth];
        if (this.fGrammarNameSpaceIndex != this.fGrammarNameSpaceIndexStack[this.fElementDepth]) {
            this.fGrammarNameSpaceIndex = this.fGrammarNameSpaceIndexStack[this.fElementDepth];
            if (this.fValidating && this.fGrammarIsSchemaGrammar) {
                if (this.fGrammarNameSpaceIndex < 0) {
                    this.fGrammar = null;
                    this.fGrammarIsSchemaGrammar = false;
                    this.fGrammarIsDTDGrammar = false;
                } else if (!this.switchGrammar(this.fGrammarNameSpaceIndex)) {
                    this.reportRecoverableXMLError(169, 146, "Grammar with uri 1: " + this.fStringPool.toString(this.fGrammarNameSpaceIndex) + " , can not be found");
                }
            }
        }
        if (this.fValidating) {
            this.fBufferDatatype = false;
        }
        this.fInElementContent = this.fCurrentContentSpecType == 4;
    }

    public void callStartCDATA() throws Exception {
        if (this.fValidating && this.fInElementContent) {
            this.charDataInContent();
        }
        this.fDocumentHandler.startCDATA();
    }

    public void callEndCDATA() throws Exception {
        this.fDocumentHandler.endCDATA();
    }

    public void callCharacters(int n) throws Exception {
        int n2;
        int n3;
        if (this.fCharRefData == null) {
            this.fCharRefData = new char[2];
        }
        int n4 = n3 = n < 65536 ? 1 : 2;
        if (n3 == 1) {
            this.fCharRefData[0] = (char)n;
        } else {
            this.fCharRefData[0] = (char)((n - 65536 >> 10) + 55296);
            this.fCharRefData[1] = (char)((n - 65536 & 0x3FF) + 56320);
        }
        if (this.fValidating && (this.fInElementContent || this.fCurrentContentSpecType == 0)) {
            this.charDataInContent();
        }
        if (this.fValidating && this.fBufferDatatype) {
            this.fDatatypeBuffer.append(this.fCharRefData, 0, 1);
        }
        if (this.fSendCharDataAsCharArray) {
            this.fDocumentHandler.characters(this.fCharRefData, 0, n3);
        } else {
            n2 = this.fStringPool.addString(new String(this.fCharRefData, 0, n3));
            this.fDocumentHandler.characters(n2);
        }
        n2 = this.fMatcherStack.getMatcherCount();
        int n5 = 0;
        while (n5 < n2) {
            XPathMatcher xPathMatcher = this.fMatcherStack.getMatcherAt(n5);
            xPathMatcher.characters(this.fCharRefData, 0, n3);
            ++n5;
        }
    }

    public void callProcessingInstruction(int n, int n2) throws Exception {
        this.fDocumentHandler.processingInstruction(n, n2);
    }

    public void callComment(int n) throws Exception {
        this.fDocumentHandler.comment(n);
    }

    public void startNamespaceDeclScope(int n, int n2) throws Exception {
        this.fDocumentHandler.startNamespaceDeclScope(n, n2);
    }

    public void endNamespaceDeclScope(int n) throws Exception {
        this.fDocumentHandler.endNamespaceDeclScope(n);
    }

    public void setRootElementType(QName qName) {
        this.fRootElement.setValues(qName);
    }

    private boolean getElementDeclIsExternal(int n) {
        if (this.fGrammarIsDTDGrammar) {
            return ((DTDGrammar)this.fGrammar).getElementDeclIsExternal(n);
        }
        return false;
    }

    public int getContentSpecType(int n) {
        int n2 = -1;
        if (n > -1 && this.fGrammar.getElementDecl(n, this.fTempElementDecl)) {
            n2 = this.fTempElementDecl.type;
        }
        return n2;
    }

    public int getContentSpecHandle(int n) {
        int n2 = -1;
        if (n > -1 && this.fGrammar.getElementDecl(n, this.fTempElementDecl)) {
            n2 = this.fTempElementDecl.contentSpecIndex;
        }
        return n2;
    }

    private void reportSchemaError(int n, Object[] objectArray) throws Exception {
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/xml-schema-1", n, 0, objectArray, 1);
    }

    protected void reportRecoverableXMLError(int n, int n2) throws Exception {
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", n, n2, null, 1);
    }

    protected void reportRecoverableXMLError(int n, int n2, int n3) throws Exception {
        Object[] objectArray = new Object[]{this.fStringPool.toString(n3)};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", n, n2, objectArray, 1);
    }

    protected void reportRecoverableXMLError(int n, int n2, String string) throws Exception {
        Object[] objectArray = new Object[]{string};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", n, n2, objectArray, 1);
    }

    protected void reportRecoverableXMLError(int n, int n2, int n3, int n4) throws Exception {
        Object[] objectArray = new Object[]{this.fStringPool.toString(n3), this.fStringPool.toString(n4)};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", n, n2, objectArray, 1);
    }

    protected void reportRecoverableXMLError(int n, int n2, String string, String string2) throws Exception {
        Object[] objectArray = new Object[]{string, string2};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", n, n2, objectArray, 1);
    }

    protected void reportRecoverableXMLError(int n, int n2, String string, String string2, String string3) throws Exception {
        Object[] objectArray = new Object[]{string, string2, string3};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", n, n2, objectArray, 1);
    }

    protected int whatCanGoHere(int n, boolean bl, InsertableElementsInfo insertableElementsInfo) throws Exception {
        if (insertableElementsInfo.insertAt > insertableElementsInfo.childCount || insertableElementsInfo.curChildren == null || insertableElementsInfo.childCount < 1 || insertableElementsInfo.childCount > insertableElementsInfo.curChildren.length) {
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.apache.org/xml/xerces.html", 13, 0, null, 2);
        }
        int n2 = 0;
        try {
            XMLContentModel xMLContentModel = this.getElementContentModel(n);
            n2 = xMLContentModel.whatCanGoHere(bl, insertableElementsInfo);
        }
        catch (CMException cMException) {
            int n3 = cMException.getErrorCode();
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.apache.org/xml/xerces.html", n3, 0, null, 2);
            throw cMException;
        }
        return n2;
    }

    protected boolean getAttDefIsExternal(QName qName, QName qName2) {
        int n = this.getAttDef(qName, qName2);
        if (this.fGrammarIsDTDGrammar) {
            return ((DTDGrammar)this.fGrammar).getAttributeDeclIsExternal(n);
        }
        return false;
    }

    private boolean usingStandaloneReader() {
        return this.fStandaloneReader == -1 || this.fEntityHandler.getReaderId() == this.fStandaloneReader;
    }

    private LocatorImpl getLocatorImpl(LocatorImpl locatorImpl) {
        Locator locator = this.fErrorReporter.getLocator();
        if (locatorImpl == null) {
            return new LocatorImpl(locator);
        }
        locatorImpl.setPublicId(locator.getPublicId());
        locatorImpl.setSystemId(locator.getSystemId());
        locatorImpl.setLineNumber(locator.getLineNumber());
        locatorImpl.setColumnNumber(locator.getColumnNumber());
        return locatorImpl;
    }

    private void poolReset() {
        if (this.fValidating) {
            this.fIdDefs.clear();
            this.fIdREFDefs.clear();
        }
    }

    private void resetCommon(StringPool stringPool) throws Exception {
        this.fStringPool = stringPool;
        this.fValidateEntity.setDatatypeObject(new Object[]{this.fEntityHandler, stringPool});
        this.fValidating = this.fValidationEnabled;
        this.fValidationEnabledByDynamic = false;
        this.fDynamicDisabledByValidation = false;
        this.poolReset();
        this.fCalledStartDocument = false;
        this.fStandaloneReader = -1;
        this.fElementChildrenLength = 0;
        this.fElementDepth = -1;
        this.fSeenRootElement = false;
        this.fSeenDoctypeDecl = false;
        this.fNamespacesScope = null;
        this.fNamespacesPrefix = -1;
        this.fRootElement.clear();
        this.fAttrListHandle = -1;
        this.fCheckedForSchema = false;
        this.fCurrentScope = -1;
        this.fCurrentSchemaURI = 0;
        this.fEmptyURI = 0;
        this.fXsiPrefix = -1;
        this.fXsiTypeValidator = null;
        this.fNil = false;
        this.fGrammar = null;
        this.fGrammarNameSpaceIndex = 0;
        this.fGrammarIsDTDGrammar = false;
        this.fGrammarIsSchemaGrammar = false;
        this.fCurrentDV = null;
        this.fFirstChunk = true;
        this.fTrailing = false;
        this.fWhiteSpace = (short)2;
        this.fMatcherStack.clear();
        this.init();
    }

    private void init() {
        this.fEmptyURI = this.fStringPool.addSymbol("");
        this.fXsiURI = this.fStringPool.addSymbol("http://www.w3.org/2001/XMLSchema-instance");
        this.fEMPTYSymbol = this.fStringPool.addSymbol("EMPTY");
        this.fANYSymbol = this.fStringPool.addSymbol("ANY");
        this.fMIXEDSymbol = this.fStringPool.addSymbol("MIXED");
        this.fCHILDRENSymbol = this.fStringPool.addSymbol("CHILDREN");
        this.fCDATASymbol = this.fStringPool.addSymbol("CDATA");
        this.fIDSymbol = this.fStringPool.addSymbol("ID");
        this.fIDREFSymbol = this.fStringPool.addSymbol("IDREF");
        this.fIDREFSSymbol = this.fStringPool.addSymbol("IDREFS");
        this.fENTITYSymbol = this.fStringPool.addSymbol("ENTITY");
        this.fENTITIESSymbol = this.fStringPool.addSymbol("ENTITIES");
        this.fNMTOKENSymbol = this.fStringPool.addSymbol("NMTOKEN");
        this.fNMTOKENSSymbol = this.fStringPool.addSymbol("NMTOKENS");
        this.fNOTATIONSymbol = this.fStringPool.addSymbol("NOTATION");
        this.fENUMERATIONSymbol = this.fStringPool.addSymbol("ENUMERATION");
        this.fREQUIREDSymbol = this.fStringPool.addSymbol("#REQUIRED");
        this.fFIXEDSymbol = this.fStringPool.addSymbol("#FIXED");
        this.fDATATYPESymbol = this.fStringPool.addSymbol("<<datatype>>");
        this.fEpsilonIndex = this.fStringPool.addSymbol("<<CMNODE_EPSILON>>");
        this.fXMLLang = this.fStringPool.addSymbol("xml:lang");
    }

    private void initDataTypeValidators() {
        if (this.fGrammarResolver != null) {
            this.fDataTypeReg = (DatatypeValidatorFactoryImpl)this.fGrammarResolver.getDatatypeRegistry();
            this.fDataTypeReg.initializeDTDRegistry();
        }
        if (this.fDataTypeReg != null) {
            this.fValID = this.fDataTypeReg.getDatatypeValidator("ID");
            this.fValIDRef = this.fDataTypeReg.getDatatypeValidator("IDREF");
            this.fValIDRefs = this.fDataTypeReg.getDatatypeValidator("IDREFS");
            this.fValENTITY = this.fDataTypeReg.getDatatypeValidator("ENTITY");
            this.fValENTITIES = this.fDataTypeReg.getDatatypeValidator("ENTITIES");
            this.fValNMTOKEN = this.fDataTypeReg.getDatatypeValidator("NMTOKEN");
            this.fValNMTOKENS = this.fDataTypeReg.getDatatypeValidator("NMTOKENS");
            this.fValNOTATION = this.fDataTypeReg.getDatatypeValidator("NOTATION");
        }
    }

    private int addDefaultAttributes(int n, XMLAttrList xMLAttrList, int n2, boolean bl, boolean bl2) throws Exception {
        this.fGrammar.getElementDecl(n, this.fTempElementDecl);
        int n3 = this.fTempElementDecl.name.localpart;
        int n4 = this.fGrammar.getFirstAttributeDeclIndex(n);
        int n5 = n2;
        int n6 = -1;
        while (n4 != -1) {
            int n7;
            boolean bl3;
            this.fGrammar.getAttributeDecl(n4, this.fTempAttDecl);
            int n8 = this.fTempAttDecl.name.prefix;
            int n9 = this.fTempAttDecl.name.localpart;
            int n10 = this.attributeTypeName(this.fTempAttDecl);
            int n11 = this.fTempAttDecl.defaultType;
            int n12 = -1;
            if (this.fTempAttDecl.defaultValue != null) {
                n12 = this.fStringPool.addSymbol(this.fTempAttDecl.defaultValue);
            }
            boolean bl4 = false;
            boolean bl5 = (n11 & 2) > 0;
            boolean bl6 = (n11 & 4) > 0;
            boolean bl7 = bl3 = (n11 & 0x10) > 0;
            if (n5 != -1) {
                int n13 = n7 = n10 == this.fCDATASymbol ? 1 : 0;
                if (n7 == 0 || bl5 || bl6 || n12 != -1) {
                    int n14 = xMLAttrList.getFirstAttr(n5);
                    while (n14 != -1 && (n6 == -1 || n14 <= n6)) {
                        if (this.fGrammarIsDTDGrammar && xMLAttrList.getAttrName(n14) == this.fTempAttDecl.name.rawname || this.fStringPool.equalNames(xMLAttrList.getAttrLocalpart(n14), n9) && this.fStringPool.equalNames(xMLAttrList.getAttrURI(n14), this.fTempAttDecl.name.uri)) {
                            if (bl6 && bl) {
                                Object[] objectArray = new Object[]{this.fStringPool.toString(n3), this.fStringPool.toString(n9)};
                                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/xml-schema-1", 28, 0, objectArray, 1);
                            }
                            bl4 = true;
                            break;
                        }
                        n14 = xMLAttrList.getNextAttr(n14);
                    }
                }
            }
            if (!bl4) {
                if (bl5) {
                    if (bl) {
                        Object[] objectArray = new Object[]{this.fStringPool.toString(n3), this.fStringPool.toString(n9)};
                        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 94, 88, objectArray, 1);
                    }
                } else if (n12 != -1) {
                    if (bl && bl2 && this.fGrammarIsDTDGrammar && ((DTDGrammar)this.fGrammar).getAttributeDeclIsExternal(n4)) {
                        Object[] objectArray = new Object[]{this.fStringPool.toString(n3), this.fStringPool.toString(n9)};
                        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 95, 80, objectArray, 1);
                    }
                    if (bl) {
                        this.validateUsingDV(this.fTempAttDecl.datatypeValidator, this.fStringPool.toString(n12), true);
                    }
                    if (n2 == -1) {
                        n2 = xMLAttrList.startAttrList();
                    }
                    this.fTempQName.setValues(n8, n9, n9, this.fTempAttDecl.name.uri);
                    n7 = xMLAttrList.addAttr(this.fTempQName, n12, n10, false, false);
                    if (n6 == -1) {
                        n6 = n7;
                    }
                }
            }
            n4 = this.fGrammar.getNextAttributeDeclIndex(n4);
        }
        return n2;
    }

    private int addDTDDefaultAttributes(QName qName, XMLAttrList xMLAttrList, int n, boolean bl, boolean bl2) throws Exception {
        int n2 = this.fGrammar.getElementDeclIndex(qName, -1);
        if (n2 == -1) {
            return n;
        }
        this.fGrammar.getElementDecl(n2, this.fTempElementDecl);
        int n3 = this.fTempElementDecl.name.rawname;
        int n4 = this.fGrammar.getFirstAttributeDeclIndex(n2);
        int n5 = n;
        int n6 = -1;
        while (n4 != -1) {
            int n7;
            boolean bl3;
            this.fGrammar.getAttributeDecl(n4, this.fTempAttDecl);
            int n8 = this.fTempAttDecl.name.prefix;
            int n9 = this.fTempAttDecl.name.rawname;
            int n10 = this.fTempAttDecl.name.localpart;
            int n11 = this.attributeTypeName(this.fTempAttDecl);
            int n12 = this.fTempAttDecl.defaultType;
            int n13 = -1;
            if (this.fTempAttDecl.defaultValue != null) {
                n13 = this.fStringPool.addSymbol(this.fTempAttDecl.defaultValue);
            }
            boolean bl4 = false;
            boolean bl5 = bl3 = (n12 & 2) > 0;
            if (n5 != -1) {
                int n14 = n7 = n11 == this.fCDATASymbol ? 1 : 0;
                if (n7 == 0 || bl3 || n13 != -1) {
                    int n15 = xMLAttrList.getFirstAttr(n5);
                    while (n15 != -1 && (n6 == -1 || n15 <= n6)) {
                        if (xMLAttrList.getAttrName(n15) == this.fTempAttDecl.name.rawname) {
                            int n16;
                            if (bl && (n12 & 0x10) > 0 && (n16 = xMLAttrList.getAttValue(n15)) != n13 && !this.fStringPool.toString(n16).equals(this.fStringPool.toString(n13))) {
                                Object[] objectArray = new Object[]{this.fStringPool.toString(n3), this.fStringPool.toString(n9), this.fStringPool.toString(n16), this.fStringPool.toString(n13)};
                                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 93, 87, objectArray, 1);
                            }
                            bl4 = true;
                            break;
                        }
                        n15 = xMLAttrList.getNextAttr(n15);
                    }
                }
            }
            if (!bl4) {
                if (bl3) {
                    if (bl) {
                        Object[] objectArray = new Object[]{this.fStringPool.toString(n3), this.fStringPool.toString(n9)};
                        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 94, 88, objectArray, 1);
                    }
                } else if (n13 != -1) {
                    if (bl && bl2 && this.fGrammarIsDTDGrammar && ((DTDGrammar)this.fGrammar).getAttributeDeclIsExternal(n4)) {
                        Object[] objectArray = new Object[]{this.fStringPool.toString(n3), this.fStringPool.toString(n9)};
                        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 95, 80, objectArray, 1);
                    }
                    if (bl) {
                        this.validateUsingDV(this.fTempAttDecl.datatypeValidator, this.fStringPool.toString(n13), true);
                    }
                    if (n == -1) {
                        n = xMLAttrList.startAttrList();
                    }
                    this.fTempQName.setValues(n8, n10, n9, this.fTempAttDecl.name.uri);
                    n7 = xMLAttrList.addAttr(this.fTempQName, n13, n11, false, false);
                    if (n6 == -1) {
                        n6 = n7;
                    }
                }
            }
            n4 = this.fGrammar.getNextAttributeDeclIndex(n4);
        }
        return n;
    }

    private XMLContentModel getElementContentModel(int n) throws Exception {
        XMLContentModel xMLContentModel = null;
        if (n > -1 && this.fGrammar.getElementDecl(n, this.fTempElementDecl)) {
            xMLContentModel = this.fGrammar.getElementContentModel(n, this.fSGComparator);
        }
        return xMLContentModel;
    }

    private int getAttDef(QName qName, QName qName2) {
        if (this.fGrammar != null) {
            int n;
            int n2 = this.fCurrentScope;
            if (qName.uri > -1) {
                n2 = -1;
            }
            if ((n = this.fGrammar.getElementDeclIndex(qName, n2)) == -1) {
                return -1;
            }
            int n3 = this.fGrammar.getFirstAttributeDeclIndex(n);
            while (n3 != -1) {
                this.fGrammar.getAttributeDecl(n3, this.fTempAttributeDecl);
                if (this.fTempAttributeDecl.name.localpart == qName2.localpart && this.fTempAttributeDecl.name.uri == qName2.uri) {
                    return n3;
                }
                n3 = this.fGrammar.getNextAttributeDeclIndex(n3);
            }
        }
        return -1;
    }

    private int getAttDefByElementIndex(int n, QName qName) {
        if (this.fGrammar != null && n > -1) {
            if (n == -1) {
                return -1;
            }
            int n2 = this.fGrammar.getFirstAttributeDeclIndex(n);
            while (n2 != -1) {
                this.fGrammar.getAttributeDecl(n2, this.fTempAttDecl);
                if (this.fGrammarIsDTDGrammar ? this.fTempAttDecl.name.rawname == qName.rawname : this.fTempAttDecl.name.localpart == qName.localpart && this.fTempAttDecl.name.uri == qName.uri) {
                    return n2;
                }
                if (this.fGrammarIsSchemaGrammar) {
                    if (this.fTempAttDecl.type == 8) {
                        return n2;
                    }
                    if (this.fTempAttDecl.type == 9 ? qName.uri != this.fTempAttDecl.name.uri : this.fTempAttDecl.type == 11 && this.fStringPool.stringInList(this.fTempAttDecl.enumeration, qName.uri)) {
                        return n2;
                    }
                }
                n2 = this.fGrammar.getNextAttributeDeclIndex(n2);
            }
        }
        return -1;
    }

    private void rootElementSpecified(QName qName) throws Exception {
        String string;
        String string2;
        if (this.fLoadDTDGrammar && this.fGrammar == null) {
            this.fGrammar = this.fGrammarResolver.getGrammar("");
            if (this.fDynamicValidation && this.fGrammar == null) {
                this.fValidating = false;
            }
            if (this.fGrammar != null) {
                if (this.fGrammar instanceof DTDGrammar) {
                    this.fGrammarIsDTDGrammar = true;
                    this.fGrammarIsSchemaGrammar = false;
                } else if (this.fGrammar instanceof SchemaGrammar) {
                    this.fGrammarIsSchemaGrammar = true;
                    this.fGrammarIsDTDGrammar = false;
                }
                this.fGrammarNameSpaceIndex = this.fEmptyURI;
            }
        }
        if (this.fValidating && this.fGrammarIsDTDGrammar && ((DTDGrammar)this.fGrammar).getRootElementQName(this.fRootElement) && !(string2 = this.fStringPool.toString(this.fRootElement.rawname)).equals(string = this.fStringPool.toString(qName.rawname))) {
            this.reportRecoverableXMLError(3, 1, this.fRootElement.rawname, qName.rawname);
        }
        if (this.fNamespacesEnabled && this.fNamespacesScope == null) {
            this.fNamespacesScope = new NamespacesScope(this);
            this.fNamespacesPrefix = this.fStringPool.addSymbol("xmlns");
            this.fNamespacesScope.setNamespaceForPrefix(this.fNamespacesPrefix, -1);
            int n = this.fStringPool.addSymbol("xml");
            int n2 = this.fStringPool.addSymbol("http://www.w3.org/XML/1998/namespace");
            this.fNamespacesScope.setNamespaceForPrefix(n, n2);
        }
    }

    private boolean switchGrammar(int n) throws Exception {
        Grammar grammar = this.fGrammarResolver.getGrammar(this.fStringPool.toString(n));
        if (grammar == null) {
            grammar = this.fGrammarResolver.getGrammar("");
        }
        if (grammar == null) {
            return false;
        }
        this.fGrammar = grammar;
        if (this.fGrammar instanceof DTDGrammar) {
            this.fGrammarIsDTDGrammar = true;
            this.fGrammarIsSchemaGrammar = false;
        } else if (this.fGrammar instanceof SchemaGrammar) {
            this.fGrammarIsSchemaGrammar = true;
            this.fGrammarIsDTDGrammar = false;
        }
        return true;
    }

    private void bindNamespacesToElementAndAttributes(QName qName, XMLAttrList xMLAttrList) throws Exception {
        Object[] objectArray;
        Object[] objectArray2;
        int n;
        int n2;
        int n3;
        int n4;
        this.fNamespacesScope.increaseDepth();
        if (this.fAttrListHandle != -1) {
            n4 = xMLAttrList.getFirstAttr(this.fAttrListHandle);
            while (n4 != -1) {
                int n5 = xMLAttrList.getAttrName(n4);
                int n6 = xMLAttrList.getAttrPrefix(n4);
                if (!this.fStringPool.equalNames(n5, this.fXMLLang)) {
                    if (this.fStringPool.equalNames(n5, this.fNamespacesPrefix)) {
                        n3 = this.fStringPool.addSymbol(xMLAttrList.getAttValue(n4));
                        this.fNamespacesScope.setNamespaceForPrefix(0, n3);
                    } else if (n6 == this.fNamespacesPrefix) {
                        n3 = xMLAttrList.getAttrLocalpart(n4);
                        n2 = this.fStringPool.addSymbol(xMLAttrList.getAttValue(n4));
                        this.fNamespacesScope.setNamespaceForPrefix(n3, n2);
                        if (this.fValidating && this.fSchemaValidation) {
                            n = 0;
                            objectArray2 = this.fStringPool.toString(xMLAttrList.getAttValue(n4));
                            if (objectArray2.equals("http://www.w3.org/2001/XMLSchema-instance")) {
                                this.fXsiPrefix = n3;
                                n = 1;
                            }
                        }
                    }
                }
                n4 = xMLAttrList.getNextAttr(n4);
            }
            Object var4_5 = null;
            objectArray = null;
            if (this.fValidating && this.fSchemaValidation) {
                this.fLocationUriPairs.clear();
                if (!this.fSeenRootElement) {
                    if (this.fExternalSchemas != null && this.fExternalSchemas.length() != 0) {
                        this.parseSchemaLocation(this.fExternalSchemas);
                    }
                    if (this.fExternalNoNamespaceSchema != null && this.fExternalNoNamespaceSchema.length() != 0) {
                        this.fLocationUriPairs.put(this.fExternalNoNamespaceSchema, "");
                        if (this.fNamespacesScope != null) {
                            this.fNamespacesScope.setNamespaceForPrefix(this.fStringPool.addSymbol(""), this.fStringPool.addSymbol(""));
                        }
                    }
                    this.parseSchemas();
                    this.fLocationUriPairs.clear();
                }
                this.fXsiTypeAttValue = -1;
                n4 = xMLAttrList.getFirstAttr(this.fAttrListHandle);
                while (n4 != -1) {
                    n3 = xMLAttrList.getAttrName(n4);
                    n2 = xMLAttrList.getAttrPrefix(n4);
                    if (!this.fStringPool.equalNames(n3, this.fNamespacesPrefix) && this.fXsiPrefix != -1 && n2 == this.fXsiPrefix) {
                        n = xMLAttrList.getAttrLocalpart(n4);
                        if (n == this.fStringPool.addSymbol("schemaLocation")) {
                            this.parseSchemaLocation(this.fStringPool.toString(xMLAttrList.getAttValue(n4)));
                        } else if (n == this.fStringPool.addSymbol("noNamespaceSchemaLocation")) {
                            this.fLocationUriPairs.put(this.fStringPool.toString(xMLAttrList.getAttValue(n4)), "");
                            if (this.fNamespacesScope != null) {
                                this.fNamespacesScope.setNamespaceForPrefix(this.fStringPool.addSymbol(""), this.fStringPool.addSymbol(""));
                            }
                        } else if (n == this.fStringPool.addSymbol("type")) {
                            this.fXsiTypeAttValue = xMLAttrList.getAttValue(n4);
                        } else if (n == this.fStringPool.addSymbol("nil")) {
                            this.fNil = this.fStringPool.toString(xMLAttrList.getAttValue(n4)).equals("true");
                        }
                    }
                    n4 = xMLAttrList.getNextAttr(n4);
                }
                this.parseSchemas();
            }
        }
        n4 = qName.prefix != -1 ? qName.prefix : 0;
        int n7 = this.fNamespacesScope.getNamespaceForPrefix(n4);
        if (qName.prefix != -1 || n7 != 0) {
            qName.uri = n7;
            if (qName.uri == 0) {
                objectArray = new Object[]{this.fStringPool.toString(qName.prefix)};
                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1999/REC-xml-names-19990114", 167, 144, objectArray, 1);
            }
        }
        if (this.fAttrListHandle != -1) {
            int n8 = xMLAttrList.getFirstAttr(this.fAttrListHandle);
            while (n8 != -1) {
                n3 = xMLAttrList.getAttrName(n8);
                if (!this.fStringPool.equalNames(n3, this.fNamespacesPrefix) && (n2 = xMLAttrList.getAttrPrefix(n8)) != this.fNamespacesPrefix && n2 != -1) {
                    n = this.fNamespacesScope.getNamespaceForPrefix(n2);
                    if (n == -1) {
                        objectArray2 = new Object[]{this.fStringPool.toString(n2)};
                        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1999/REC-xml-names-19990114", 167, 144, objectArray2, 1);
                    }
                    xMLAttrList.setAttrURI(n8, n);
                }
                n8 = xMLAttrList.getNextAttr(n8);
            }
        }
    }

    private void parseSchemas() throws Exception {
        Enumeration enumeration = this.fLocationUriPairs.keys();
        String string = null;
        String string2 = null;
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            string2 = (String)this.fLocationUriPairs.get(string);
            this.resolveSchemaGrammar(string, string2);
        }
    }

    private void parseSchemaLocation(String string) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \n\t\r", false);
        int n = stringTokenizer.countTokens();
        if (n % 2 != 0) {
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/xml-schema-1", 51, 0, new Object[]{string}, 1);
        } else {
            String string2 = null;
            String string3 = null;
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                string3 = stringTokenizer.nextToken();
                this.fLocationUriPairs.put(string3, string2);
            }
        }
    }

    private void resolveSchemaGrammar(String string, String string2) throws Exception {
        SchemaGrammar schemaGrammar = null;
        if (string2 != null) {
            schemaGrammar = (SchemaGrammar)this.fGrammarResolver.getGrammar(string2);
        }
        if (schemaGrammar == null) {
            if (this.fSchemaGrammarParser == null) {
                this.fSchemaGrammarParser = new DOMParser();
                this.fSchemaGrammarParser.setEntityResolver(new Resolver(this.fEntityHandler));
                this.fSchemaGrammarParser.setErrorHandler(new ErrorHandler());
                try {
                    this.fSchemaGrammarParser.setFeature("http://xml.org/sax/features/validation", false);
                    this.fSchemaGrammarParser.setFeature("http://xml.org/sax/features/namespaces", true);
                    this.fSchemaGrammarParser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    sAXNotRecognizedException.printStackTrace();
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                    sAXNotSupportedException.printStackTrace();
                }
            }
            InputSource inputSource = null;
            EntityResolver entityResolver = this.fSchemaGrammarParser.getEntityResolver();
            if (entityResolver != null) {
                inputSource = entityResolver.resolveEntity("", string);
            }
            if (inputSource == null) {
                string = this.fEntityHandler.expandSystemId(string);
                inputSource = new InputSource(string);
            }
            try {
                this.fSchemaGrammarParser.parse(inputSource);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (SAXException sAXException) {
                this.reportRecoverableXMLError(169, 146, sAXException.getMessage());
            }
            Document document = this.fSchemaGrammarParser.getDocument();
            TraverseSchema traverseSchema = null;
            Element element = null;
            if (document != null) {
                element = document.getDocumentElement();
            }
            if (element == null) {
                this.reportRecoverableXMLError(169, 146, "Can't get back Schema document's root element :" + string);
            } else {
                if (string2 != null && !string2.equals(element.getAttribute("targetNamespace"))) {
                    this.reportRecoverableXMLError(169, 146, "Schema in " + string + " has a different target namespace " + "from the one specified in the instance document :" + string2);
                }
                schemaGrammar = new SchemaGrammar();
                schemaGrammar.setGrammarDocument(document);
                this.fGrammarIsSchemaGrammar = true;
                this.fGrammarIsDTDGrammar = false;
                GeneralAttrCheck generalAttrCheck = new GeneralAttrCheck(this.fErrorReporter, this.fDataTypeReg);
                traverseSchema = new TraverseSchema(element, this.fStringPool, schemaGrammar, this.fGrammarResolver, this.fErrorReporter, inputSource.getSystemId(), entityResolver, this.getSchemaFullCheckingEnabled(), generalAttrCheck);
                generalAttrCheck.checkNonSchemaAttributes(this.fGrammarResolver);
                String string3 = element.getAttribute("targetNamespace");
                this.fGrammarNameSpaceIndex = this.fStringPool.addSymbol(string3);
                this.fGrammarResolver.putGrammar(string3, schemaGrammar);
                this.fGrammar = schemaGrammar;
                if (this.fSchemaValidationFullChecking) {
                    try {
                        Enumeration enumeration = this.fGrammarResolver.nameSpaceKeys();
                        while (enumeration.hasMoreElements()) {
                            String string4 = (String)enumeration.nextElement();
                            Grammar grammar = this.fGrammarResolver.getGrammar(string4);
                            if (!(grammar instanceof SchemaGrammar)) continue;
                            SchemaGrammar schemaGrammar2 = (SchemaGrammar)grammar;
                            Hashtable hashtable = schemaGrammar2.getComplexTypeRegistry();
                            int n = hashtable.size();
                            Enumeration enumeration2 = hashtable.elements();
                            while (enumeration2.hasMoreElements()) {
                                TraverseSchema.ComplexTypeInfo complexTypeInfo = (TraverseSchema.ComplexTypeInfo)enumeration2.nextElement();
                                schemaGrammar2.getContentModel(complexTypeInfo.contentSpecHandle, complexTypeInfo.contentType, this.fSGComparator);
                            }
                        }
                    }
                    catch (CMException cMException) {
                        int n = cMException.getErrorCode();
                        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.apache.org/xml/xerces.html", n, 0, null, 2);
                    }
                }
            }
        }
    }

    private String bindNotationURI(String string) throws Exception {
        int n = string.indexOf(":");
        String string2 = "";
        String string3 = string;
        if (n > -1) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        String string4 = "";
        int n2 = 0;
        if (this.fNamespacesScope != null) {
            n2 = this.fNamespacesScope.getNamespaceForPrefix(this.fStringPool.addSymbol(string2));
            if (n2 > 0) {
                return this.fStringPool.toString(n2) + ":" + string3;
            }
            if (this.fGrammarNameSpaceIndex != -1) {
                return this.fStringPool.toString(this.fGrammarNameSpaceIndex) + ":" + string3;
            }
        }
        return string;
    }

    private int attributeTypeName(XMLAttributeDecl xMLAttributeDecl) {
        switch (xMLAttributeDecl.type) {
            case 1: {
                return xMLAttributeDecl.list ? this.fENTITIESSymbol : this.fENTITYSymbol;
            }
            case 2: {
                String string = this.fStringPool.stringListAsString(xMLAttributeDecl.enumeration);
                return this.fStringPool.addSymbol(string);
            }
            case 3: {
                return this.fIDSymbol;
            }
            case 4: {
                return xMLAttributeDecl.list ? this.fIDREFSSymbol : this.fIDREFSymbol;
            }
            case 5: {
                return xMLAttributeDecl.list ? this.fNMTOKENSSymbol : this.fNMTOKENSymbol;
            }
            case 6: {
                return this.fNOTATIONSymbol;
            }
        }
        return this.fCDATASymbol;
    }

    private void validateElementAndAttributes(QName qName, XMLAttrList xMLAttrList) throws Exception {
        int n;
        int n2;
        Object object;
        if (this.fGrammarIsSchemaGrammar && this.fElementDepth >= 0 && this.fValidationFlagStack[this.fElementDepth] != 0 || this.fGrammar == null && !this.fValidating && !this.fNamespacesEnabled) {
            this.fCurrentElementIndex = -1;
            this.fCurrentContentSpecType = -1;
            this.fInElementContent = false;
            if (this.fAttrListHandle != -1) {
                this.fAttrList.endAttrList();
                int n3 = this.fAttrList.getFirstAttr(this.fAttrListHandle);
                while (n3 != -1) {
                    if (this.fStringPool.equalNames(this.fAttrList.getAttrName(n3), this.fXMLLang)) {
                        this.fDocumentScanner.checkXMLLangAttributeValue(this.fAttrList.getAttValue(n3));
                        break;
                    }
                    n3 = this.fAttrList.getNextAttr(n3);
                }
            }
            return;
        }
        int n4 = -1;
        int n5 = -1;
        boolean bl = false;
        boolean bl2 = false;
        if (this.fGrammarIsSchemaGrammar && this.fElementDepth > -1 && this.fContentLeafStack[this.fElementDepth] != null) {
            object = this.fContentLeafStack[this.fElementDepth];
            if (this.fContentModelStateStack[this.fElementDepth] >= 0 && (n2 = ((DFAContentModel)this.fContentModelStack[this.fElementDepth]).oneTransition(qName, this.fContentModelStateStack, this.fElementDepth)) >= 0) {
                int n6 = this.fElementDepth;
                this.fContentModelEleCount[n6] = this.fContentModelEleCount[n6] + 1;
                switch (((ContentLeafNameTypeVector)object).leafTypes[n2]) {
                    case 38: 
                    case 39: 
                    case 40: {
                        bl = true;
                        break;
                    }
                    case 22: 
                    case 23: 
                    case 24: {
                        bl2 = true;
                    }
                }
            }
        }
        if (bl) {
            this.fNeedValidationOff = true;
        } else {
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            if (this.fNamespacesEnabled && this.fValidating && qName.uri != this.fGrammarNameSpaceIndex && qName.uri != 0) {
                this.fGrammarNameSpaceIndex = qName.uri;
                boolean bl3 = this.switchGrammar(this.fGrammarNameSpaceIndex);
                if (!bl3 && !bl2) {
                    this.reportRecoverableXMLError(169, 146, "Grammar with uri 2: " + this.fStringPool.toString(this.fGrammarNameSpaceIndex) + " , can not be found");
                }
            }
            if (this.fGrammar != null) {
                n4 = this.fGrammar.getElementDeclIndex(qName, this.fCurrentScope);
                if (n4 == -1) {
                    n4 = this.fGrammar.getElementDeclIndex(qName, -1);
                }
                if (n4 == -1) {
                    if (this.fGrammarIsSchemaGrammar && this.fCurrentElementIndex != -1) {
                        boolean bl4;
                        object = null;
                        object = ((SchemaGrammar)this.fGrammar).getElementComplexTypeInfo(this.fCurrentElementIndex);
                        n2 = this.fGrammarNameSpaceIndex;
                        while (object != null) {
                            n4 = this.fGrammar.getElementDeclIndex(qName, ((TraverseSchema.ComplexTypeInfo)object).scopeDefined);
                            if (n4 > -1) {
                                this.fGrammarNameSpaceIndex = n2;
                                break;
                            }
                            object = ((TraverseSchema.ComplexTypeInfo)object).baseComplexTypeInfo;
                            if (object != null && !((String)(object7 = ((TraverseSchema.ComplexTypeInfo)object).typeName)).startsWith("#") && (n2 = this.fStringPool.addSymbol(((String)object7).substring(0, n = ((String)object7).indexOf(44)).trim())) != this.fGrammarNameSpaceIndex && !this.switchGrammar(n2)) break;
                        }
                        if (n4 == -1 && qName.uri == 0 && (bl4 = this.switchGrammar(qName.uri))) {
                            this.fGrammarNameSpaceIndex = qName.uri;
                            n4 = this.fGrammar.getElementDeclIndex(qName.localpart, -1);
                        }
                    }
                    if (qName.uri == 0 && n4 == -1 && this.fNamespacesScope != null) {
                        n4 = this.fGrammar.getElementDeclIndex(qName.localpart, -1);
                        qName.uri = 0;
                    }
                    if (n4 == -1 && bl2) {
                        this.fNeedValidationOff = true;
                    }
                }
            }
            n5 = this.getContentSpecType(n4);
            if (this.fGrammarIsSchemaGrammar) {
                if (this.fXsiTypeAttValue > -1) {
                    object = this.fStringPool.toString(this.fXsiTypeAttValue);
                    n2 = ((String)object).indexOf(":");
                    object7 = "";
                    Object object8 = object;
                    if (n2 > -1) {
                        object7 = ((String)object).substring(0, n2);
                        object8 = ((String)object).substring(n2 + 1);
                    }
                    String string = "";
                    int n7 = 0;
                    if (this.fNamespacesScope != null && (n7 = this.fNamespacesScope.getNamespaceForPrefix(this.fStringPool.addSymbol((String)object7))) > 0) {
                        string = this.fStringPool.toString(n7);
                        if (n7 != this.fGrammarNameSpaceIndex) {
                            this.fGrammarNameSpaceIndex = this.fCurrentSchemaURI = n7;
                            boolean bl5 = this.switchGrammar(this.fCurrentSchemaURI);
                            if (!bl5 && !this.fNeedValidationOff) {
                                this.reportRecoverableXMLError(169, 146, "Grammar with uri 3: " + this.fStringPool.toString(this.fCurrentSchemaURI) + " , can not be found");
                            }
                        }
                    }
                    Hashtable hashtable = ((SchemaGrammar)this.fGrammar).getComplexTypeRegistry();
                    object6 = ((SchemaGrammar)this.fGrammar).getDatatypeRegistry();
                    if (hashtable == null || object6 == null) {
                        this.reportRecoverableXMLError(169, 146, this.fErrorReporter.getLocator().getSystemId() + " line" + this.fErrorReporter.getLocator().getLineNumber() + ", canot resolve xsi:type = " + (String)object + "  ---2");
                    } else {
                        int n8;
                        object5 = (TraverseSchema.ComplexTypeInfo)hashtable.get(string + "," + (String)object8);
                        if (object5 == null) {
                            this.fXsiTypeValidator = string.length() == 0 || string.equals("http://www.w3.org/2001/XMLSchema") ? object6.getDatatypeValidator((String)object8) : object6.getDatatypeValidator(string + "," + (String)object8);
                            if (this.fXsiTypeValidator == null) {
                                this.reportRecoverableXMLError(169, 146, "unresolved type : " + string + "," + (String)object8 + " found  in xsi:type handling");
                            } else if (n4 != -1) {
                                object4 = new XMLElementDecl();
                                this.fGrammar.getElementDecl(n4, (XMLElementDecl)object4);
                                object3 = ((XMLElementDecl)object4).datatypeValidator;
                                DatatypeValidator datatypeValidator = this.fXsiTypeValidator;
                                while (datatypeValidator != null) {
                                    if (datatypeValidator == object3) break;
                                    datatypeValidator = datatypeValidator.getBaseValidator();
                                }
                                if (datatypeValidator == null) {
                                    if (object3 instanceof UnionDatatypeValidator) {
                                        object2 = ((UnionDatatypeValidator)object3).getBaseValidators();
                                        int n9 = ((Vector)object2).size();
                                        boolean bl6 = false;
                                        n8 = 0;
                                        while (n8 < n9 && !bl6) {
                                            DatatypeValidator datatypeValidator2 = (DatatypeValidator)((Vector)object2).elementAt(n8);
                                            DatatypeValidator datatypeValidator3 = this.fXsiTypeValidator;
                                            while (datatypeValidator3 != null) {
                                                if (datatypeValidator2 == datatypeValidator3) {
                                                    bl6 = true;
                                                    break;
                                                }
                                                datatypeValidator3 = datatypeValidator3.getBaseValidator();
                                            }
                                            ++n8;
                                        }
                                        if (!bl6) {
                                            this.reportRecoverableXMLError(169, 146, "Type : " + string + "," + (String)object8 + " does not derive from the type of element " + this.fStringPool.toString(((XMLElementDecl)object4).name.localpart));
                                        }
                                    } else {
                                        this.reportRecoverableXMLError(169, 146, "Type : " + string + "," + (String)object8 + " does not derive from the type of element " + this.fStringPool.toString(((XMLElementDecl)object4).name.localpart));
                                    }
                                } else {
                                    if (datatypeValidator != null && this.fXsiTypeValidator != null && this.fGrammar.getFirstAttributeDeclIndex(n4) != -1) {
                                        this.reportRecoverableXMLError(169, 146, "Type : " + string + "," + (String)object8 + " does not derive from the type of element " + this.fStringPool.toString(((XMLElementDecl)object4).name.localpart));
                                    }
                                    if ((((SchemaGrammar)this.fGrammar).getElementDeclBlockSet(n4) & 2) != 0) {
                                        this.reportRecoverableXMLError(169, 146, "Element " + this.fStringPool.toString(((XMLElementDecl)object4).name.localpart) + "does not permit substitution by a type such as " + string + "," + (String)object8);
                                    }
                                }
                            }
                        } else {
                            if (object5.isAbstractType()) {
                                this.reportRecoverableXMLError(169, 146, "Abstract type " + (String)object + " should not be used in xsi:type");
                            }
                            if (n4 != -1) {
                                object4 = object5;
                                object3 = ((SchemaGrammar)this.fGrammar).getElementComplexTypeInfo(n4);
                                while (object4 != null && object3 != null) {
                                    if (((TraverseSchema.ComplexTypeInfo)object4).typeName.equals(((TraverseSchema.ComplexTypeInfo)object3).typeName)) break;
                                    object4 = ((TraverseSchema.ComplexTypeInfo)object4).baseComplexTypeInfo;
                                }
                                if (object4 == null) {
                                    this.reportRecoverableXMLError(169, 146, "Type : " + string + "," + (String)object8 + " does not derive from the type " + ((TraverseSchema.ComplexTypeInfo)object3).typeName);
                                } else if (object3 == null) {
                                    XMLElementDecl xMLElementDecl = new XMLElementDecl();
                                    this.fGrammar.getElementDecl(n4, xMLElementDecl);
                                    object2 = xMLElementDecl.datatypeValidator;
                                    DatatypeValidator datatypeValidator = this.fXsiTypeValidator;
                                    while (datatypeValidator != null) {
                                        if (datatypeValidator == object2) break;
                                        datatypeValidator = datatypeValidator.getBaseValidator();
                                    }
                                    if (datatypeValidator == null) {
                                        if (object2 instanceof UnionDatatypeValidator) {
                                            Vector vector = ((UnionDatatypeValidator)object2).getBaseValidators();
                                            n8 = vector.size();
                                            boolean bl7 = false;
                                            int n10 = 0;
                                            while (n10 < n8 && !bl7) {
                                                DatatypeValidator datatypeValidator4 = (DatatypeValidator)vector.elementAt(n10);
                                                DatatypeValidator datatypeValidator5 = this.fXsiTypeValidator;
                                                while (datatypeValidator5 != null) {
                                                    if (datatypeValidator4 == datatypeValidator5) {
                                                        bl7 = true;
                                                        break;
                                                    }
                                                    datatypeValidator5 = datatypeValidator5.getBaseValidator();
                                                }
                                                ++n10;
                                            }
                                            if (!bl7) {
                                                this.reportRecoverableXMLError(169, 146, "Type : " + string + "," + (String)object8 + " does not derive from the type of element " + this.fStringPool.toString(xMLElementDecl.name.localpart));
                                            }
                                        } else {
                                            this.reportRecoverableXMLError(169, 146, "Type : " + string + "," + (String)object8 + " does not derive from the type of element " + this.fStringPool.toString(xMLElementDecl.name.localpart));
                                        }
                                    }
                                } else if (object5 != object3) {
                                    int n11 = object5.derivedBy;
                                    if ((((SchemaGrammar)this.fGrammar).getElementDeclBlockSet(n4) & n11) != 0) {
                                        object2 = new XMLElementDecl();
                                        this.fGrammar.getElementDecl(n4, (XMLElementDecl)object2);
                                        this.reportRecoverableXMLError(169, 146, "Element " + this.fStringPool.toString(((XMLElementDecl)object2).name.localpart) + " does not permit xsi:type substitution in the manner required by type " + string + "," + (String)object8);
                                    } else if ((object5.baseComplexTypeInfo.blockSet & n11) != 0) {
                                        this.reportRecoverableXMLError(169, 146, "Type " + object5.baseComplexTypeInfo.typeName + " does not permit other types, such as " + string + "," + (String)object8 + " to be substituted for itself using xsi:type");
                                    }
                                }
                            }
                            n4 = object5.templateElementIndex;
                        }
                    }
                    this.fXsiTypeAttValue = -1;
                } else if (n4 != -1 && (object = ((SchemaGrammar)this.fGrammar).getElementComplexTypeInfo(n4)) != null && ((TraverseSchema.ComplexTypeInfo)object).isAbstractType()) {
                    this.reportRecoverableXMLError(169, 146, "Element " + this.fStringPool.toString(qName.rawname) + " is declared with a type that is abstract.  Use xsi:type to specify a non-abstract type");
                }
                if (n4 != -1) {
                    int n12 = ((SchemaGrammar)this.fGrammar).getElementDeclMiscFlags(n4);
                    if ((n12 & 2) != 0) {
                        this.reportRecoverableXMLError(169, 146, "A member of abstract element " + this.fStringPool.toString(qName.rawname) + "'s substitution group must be specified");
                    }
                    if (this.fNil && (n12 & 1) == 0) {
                        this.fNil = false;
                        this.reportRecoverableXMLError(169, 146, "xsi:nil must not be specified for the element " + this.fStringPool.toString(qName.rawname) + " with {nillable} equals 'false'");
                    }
                    this.fCurrentScope = ((SchemaGrammar)this.fGrammar).getElementDefinedScope(n4);
                    String string = ((SchemaGrammar)this.fGrammar).getElementFromAnotherSchemaURI(n4);
                    if (string != null && n5 != -1) {
                        object7 = ((SchemaGrammar)this.fGrammar).getElementComplexTypeInfo(n4);
                        if (object7 != null) {
                            n4 = ((TraverseSchema.ComplexTypeInfo)object7).templateElementIndex;
                        }
                        this.fGrammarNameSpaceIndex = this.fCurrentSchemaURI = this.fStringPool.addSymbol(string);
                        n = this.switchGrammar(this.fCurrentSchemaURI) ? 1 : 0;
                        if (n == 0 && !this.fNeedValidationOff) {
                            this.reportRecoverableXMLError(169, 146, "Grammar with uri 4: " + this.fStringPool.toString(this.fCurrentSchemaURI) + " , can not be found");
                        }
                    }
                }
            }
            if ((n5 = this.getContentSpecType(n4)) == -1 && this.fValidating && !this.fNeedValidationOff) {
                this.reportRecoverableXMLError(83, 79, qName.rawname);
            }
            if (this.fGrammar != null && this.fGrammarIsSchemaGrammar && n4 != -1) {
                this.fAttrListHandle = this.addDefaultAttributes(n4, xMLAttrList, this.fAttrListHandle, this.fValidating, this.fStandaloneReader != -1);
            }
            if (this.fAttrListHandle != -1) {
                this.fAttrList.endAttrList();
            }
            if (this.fAttrListHandle != -1 && !this.fNeedValidationOff) {
                int n13 = this.fAttrList.getFirstAttr(this.fAttrListHandle);
                while (n13 != -1) {
                    int n14;
                    int n15 = xMLAttrList.getAttrName(n13);
                    if (this.fStringPool.equalNames(n15, this.fXMLLang)) {
                        this.fDocumentScanner.checkXMLLangAttributeValue(xMLAttrList.getAttValue(n13));
                    }
                    if (n15 != (n14 = this.fStringPool.addSymbol("xmlns")) && xMLAttrList.getAttrPrefix(n13) != n14 && this.fGrammar != null) {
                        this.fTempQName.setValues(xMLAttrList.getAttrPrefix(n13), xMLAttrList.getAttrLocalpart(n13), xMLAttrList.getAttrName(n13), xMLAttrList.getAttrURI(n13));
                        n = this.getAttDefByElementIndex(n4, this.fTempQName);
                        if (this.fTempQName.uri != this.fXsiURI) {
                            if (n == -1) {
                                if (this.fValidating) {
                                    Object[] objectArray = new Object[]{this.fStringPool.toString(qName.rawname), this.fStringPool.toString(xMLAttrList.getAttrName(n13))};
                                    this.fAttrNameLocator = this.getLocatorImpl(this.fAttrNameLocator);
                                    this.fErrorReporter.reportError(this.fAttrNameLocator, "http://www.w3.org/TR/1998/REC-xml-19980210", 82, 78, objectArray, 1);
                                }
                            } else {
                                this.fGrammar.getAttributeDecl(n, this.fTempAttDecl);
                                int n16 = this.attributeTypeName(this.fTempAttDecl);
                                xMLAttrList.setAttType(n13, n16);
                                if (this.fValidating) {
                                    if (this.fGrammarIsDTDGrammar) {
                                        int n17 = this.validateDTDattribute(qName, xMLAttrList.getAttValue(n13), this.fTempAttDecl);
                                        xMLAttrList.setAttValue(n13, n17);
                                    } else if (this.fGrammarIsSchemaGrammar && (this.fTempAttDecl.type == 8 || this.fTempAttDecl.type == 11 || this.fTempAttDecl.type == 9)) {
                                        if ((this.fTempAttDecl.defaultType & 0x1000) <= 0 && ((this.fTempAttDecl.defaultType & 0x400) > 0 || (this.fTempAttDecl.defaultType & 0x800) > 0)) {
                                            boolean bl8 = false;
                                            boolean bl9 = (this.fTempAttDecl.defaultType & 0x400) > 0;
                                            object6 = this.fGrammarResolver.getGrammar(this.fStringPool.toString(this.fTempQName.uri));
                                            if (object6 == null || !(object6 instanceof SchemaGrammar)) {
                                                if (bl9) {
                                                    bl8 = true;
                                                }
                                            } else {
                                                object5 = (SchemaGrammar)object6;
                                                object4 = object5.getAttributeDeclRegistry();
                                                if (object4 == null) {
                                                    if (bl9) {
                                                        bl8 = true;
                                                    }
                                                } else {
                                                    object3 = (XMLAttributeDecl)((Hashtable)object4).get(this.fStringPool.toString(this.fTempQName.localpart));
                                                    if (object3 == null) {
                                                        if (bl9) {
                                                            bl8 = true;
                                                        }
                                                    } else {
                                                        DatatypeValidator datatypeValidator = ((XMLAttributeDecl)object3).datatypeValidator;
                                                        if (datatypeValidator == null) {
                                                            if (bl9) {
                                                                bl8 = true;
                                                            }
                                                        } else {
                                                            try {
                                                                object2 = this.fStringPool.toString(xMLAttrList.getAttValue(n13));
                                                                String string = ((String)object2).trim();
                                                                this.fWhiteSpace = datatypeValidator.getWSFacet();
                                                                if (this.fWhiteSpace == 1) {
                                                                    datatypeValidator.validate((String)object2, null);
                                                                } else {
                                                                    int n18 = this.fStringPool.addString(string);
                                                                    xMLAttrList.setAttValue(n13, n18);
                                                                    this.validateUsingDV(datatypeValidator, string, false);
                                                                }
                                                            }
                                                            catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                                                                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/xml-schema-1", 21, 0, new Object[]{invalidDatatypeValueException.getMessage()}, 1);
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                            if (bl8) {
                                                object6 = new Object[]{this.fStringPool.toString(qName.rawname), "ANY---" + this.fStringPool.toString(xMLAttrList.getAttrName(n13))};
                                                this.fAttrNameLocator = this.getLocatorImpl(this.fAttrNameLocator);
                                                this.fErrorReporter.reportError(this.fAttrNameLocator, "http://www.w3.org/TR/1998/REC-xml-19980210", 82, 78, (Object[])object6, 1);
                                            }
                                        }
                                    } else if (this.fTempAttDecl.datatypeValidator == null) {
                                        Object[] objectArray = new Object[]{this.fStringPool.toString(qName.rawname), this.fStringPool.toString(xMLAttrList.getAttrName(n13))};
                                        System.out.println("[Error] Datatypevalidator for attribute " + this.fStringPool.toString(xMLAttrList.getAttrName(n13)) + " not found in element type " + this.fStringPool.toString(qName.rawname));
                                        this.fAttrNameLocator = this.getLocatorImpl(this.fAttrNameLocator);
                                        this.fErrorReporter.reportError(this.fAttrNameLocator, "http://www.w3.org/TR/1998/REC-xml-19980210", 82, 78, objectArray, 1);
                                    } else {
                                        try {
                                            String string = this.fStringPool.toString(xMLAttrList.getAttValue(n13));
                                            String string2 = string.trim();
                                            object6 = this.fTempAttDecl.datatypeValidator;
                                            if ((this.fTempAttDecl.defaultType & 0x10) > 0 && object6.compare(string2, this.fTempAttDecl.defaultValue) != 0) {
                                                object5 = new Object[]{this.fStringPool.toString(qName.rawname), this.fStringPool.toString(xMLAttrList.getAttrName(n13)), string, this.fTempAttDecl.defaultValue};
                                                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 93, 87, (Object[])object5, 1);
                                            }
                                            this.fWhiteSpace = object6.getWSFacet();
                                            if (this.fWhiteSpace == 1) {
                                                object6.validate(string, null);
                                            } else {
                                                int n19 = this.fStringPool.addString(string2);
                                                xMLAttrList.setAttValue(n13, n19);
                                                this.validateUsingDV((DatatypeValidator)object6, string2, false);
                                            }
                                        }
                                        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                                            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/xml-schema-1", 21, 0, new Object[]{invalidDatatypeValueException.getMessage()}, 1);
                                        }
                                    }
                                }
                            }
                        }
                    }
                    n13 = this.fAttrList.getNextAttr(n13);
                }
            }
        }
        if (this.fAttrListHandle != -1) {
            int n20 = xMLAttrList.getFirstAttr(this.fAttrListHandle);
            while (n20 != -1) {
                int n21;
                n2 = xMLAttrList.getAttrName(n20);
                if (!this.fStringPool.equalNames(n2, this.fNamespacesPrefix) && (n21 = xMLAttrList.getAttrPrefix(n20)) != this.fNamespacesPrefix && n21 != -1) {
                    n = this.fNamespacesScope.getNamespaceForPrefix(n21);
                    if (n == 0) {
                        Object[] objectArray = new Object[]{this.fStringPool.toString(n21)};
                        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1999/REC-xml-names-19990114", 167, 144, objectArray, 1);
                    }
                    xMLAttrList.setAttrURI(n20, n);
                }
                n20 = xMLAttrList.getNextAttr(n20);
            }
        }
        this.fCurrentElementIndex = n4;
        this.fCurrentContentSpecType = n5;
        if (this.fValidating && n5 == 5) {
            this.fBufferDatatype = true;
            this.fDatatypeBuffer.setLength(0);
        }
        this.fInElementContent = n5 == 4;
    }

    private int validateDTDattribute(QName qName, int n, XMLAttributeDecl xMLAttributeDecl) throws Exception {
        int n2;
        AttributeValidator attributeValidator = null;
        switch (xMLAttributeDecl.type) {
            case 1: {
                n2 = xMLAttributeDecl.list;
                String string = this.fStringPool.toString(n);
                String string2 = string.trim();
                if (this.fValidationEnabled && string2 != string && this.invalidStandaloneAttDef(qName, xMLAttributeDecl.name)) {
                    this.reportRecoverableXMLError(123, 80, this.fStringPool.toString(xMLAttributeDecl.name.rawname), string, string2);
                }
                try {
                    if (n2 != 0) {
                        this.fValENTITIES.validate(string2, this.fValidateEntity);
                    } else {
                        this.fValENTITY.validate(string2, this.fValidateEntity);
                    }
                }
                catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                    if (invalidDatatypeValueException.getMajorCode() != 1 && invalidDatatypeValueException.getMinorCode() != -1) {
                        this.reportRecoverableXMLError(invalidDatatypeValueException.getMajorCode(), invalidDatatypeValueException.getMinorCode(), this.fStringPool.toString(xMLAttributeDecl.name.rawname), string2);
                    }
                    this.reportRecoverableXMLError(79, 77, this.fStringPool.toString(xMLAttributeDecl.name.rawname), string2);
                }
                if (!this.fNormalizeAttributeValues) break;
                if (xMLAttributeDecl.list) {
                    n = this.normalizeListAttribute(string2, n, string);
                    break;
                }
                if (string2 == string) break;
                n = this.fStringPool.addSymbol(string2);
                break;
            }
            case 2: {
                attributeValidator = this.fAttValidatorENUMERATION;
                break;
            }
            case 3: {
                String string = this.fStringPool.toString(n);
                String string3 = string.trim();
                if (this.fValidationEnabled && string3 != string && this.invalidStandaloneAttDef(qName, xMLAttributeDecl.name)) {
                    this.reportRecoverableXMLError(123, 80, this.fStringPool.toString(xMLAttributeDecl.name.rawname), string, string3);
                }
                try {
                    this.fValID.validate(string3, this.fIdDefs);
                    this.fValIDRef.validate(string3, this.fValidateIDRef);
                }
                catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                    this.reportRecoverableXMLError(75, 76, this.fStringPool.toString(xMLAttributeDecl.name.rawname), string3);
                }
                if (!this.fNormalizeAttributeValues || string3 == string) break;
                n = this.fStringPool.addSymbol(string3);
                break;
            }
            case 4: {
                String string = this.fStringPool.toString(n);
                String string4 = string.trim();
                boolean bl = xMLAttributeDecl.list;
                if (this.fValidationEnabled) {
                    if (string4 != string && this.invalidStandaloneAttDef(qName, xMLAttributeDecl.name)) {
                        this.reportRecoverableXMLError(123, 80, this.fStringPool.toString(xMLAttributeDecl.name.rawname), string, string4);
                    }
                    if (xMLAttributeDecl.list && string4.length() == 0) {
                        this.reportRecoverableXMLError(4, 2, this.fStringPool.toString(xMLAttributeDecl.name.rawname));
                    }
                }
                try {
                    if (bl) {
                        this.fValIDRefs.validate(string4, this.fValidateIDRef);
                    } else {
                        this.fValIDRef.validate(string4, this.fValidateIDRef);
                    }
                }
                catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                    if (invalidDatatypeValueException.getMajorCode() != 1 && invalidDatatypeValueException.getMinorCode() != -1) {
                        this.reportRecoverableXMLError(invalidDatatypeValueException.getMajorCode(), invalidDatatypeValueException.getMinorCode(), this.fStringPool.toString(xMLAttributeDecl.name.rawname), string4);
                    }
                    this.reportRecoverableXMLError(4, 2, this.fStringPool.toString(xMLAttributeDecl.name.rawname), string4);
                }
                if (!this.fNormalizeAttributeValues) break;
                if (xMLAttributeDecl.list) {
                    n = this.normalizeListAttribute(string4, n, string);
                    break;
                }
                if (string4 == string) break;
                n = this.fStringPool.addSymbol(string4);
                break;
            }
            case 6: {
                attributeValidator = this.fAttValidatorNOTATION;
                break;
            }
            case 5: {
                String string = this.fStringPool.toString(n);
                String string5 = string.trim();
                boolean bl = xMLAttributeDecl.list;
                if (this.fValidationEnabled) {
                    if (string5 != string && this.invalidStandaloneAttDef(qName, xMLAttributeDecl.name)) {
                        this.reportRecoverableXMLError(123, 80, this.fStringPool.toString(xMLAttributeDecl.name.rawname), string, string5);
                    }
                    if (xMLAttributeDecl.list && string5.length() == 0) {
                        this.reportRecoverableXMLError(5, 3, this.fStringPool.toString(xMLAttributeDecl.name.rawname));
                    }
                }
                try {
                    if (bl) {
                        this.fValNMTOKENS.validate(string5, null);
                    } else {
                        this.fValNMTOKEN.validate(string5, null);
                    }
                }
                catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                    this.reportRecoverableXMLError(78, 3, this.fStringPool.toString(xMLAttributeDecl.name.rawname), string5);
                }
                if (!this.fNormalizeAttributeValues) break;
                if (xMLAttributeDecl.list) {
                    n = this.normalizeListAttribute(string5, n, string);
                    break;
                }
                if (string5 == string) break;
                n = this.fStringPool.addSymbol(string5);
            }
        }
        if (attributeValidator != null) {
            n2 = attributeValidator.normalize(qName, xMLAttributeDecl.name, n, xMLAttributeDecl.type, xMLAttributeDecl.enumeration);
            if (this.fNormalizeAttributeValues) {
                n = n2;
            }
        }
        return n;
    }

    private int normalizeListAttribute(String string, int n, String string2) {
        int n2 = string.length();
        StringBuffer stringBuffer = null;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            char c = string.charAt(n5);
            if (c == ' ') {
                if (n3 == 0) {
                    n3 = 1;
                } else if (n3 == 1) {
                    n3 = 2;
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer(n2);
                    }
                    stringBuffer.append(string.substring(n4, n5));
                }
            } else {
                if (n3 == 2) {
                    n4 = n5;
                }
                n3 = 0;
            }
            ++n5;
        }
        if (stringBuffer == null) {
            return string == string2 ? n : this.fStringPool.addSymbol(string);
        }
        stringBuffer.append(string.substring(n4));
        return this.fStringPool.addSymbol(new String(stringBuffer));
    }

    private void charDataInContent() {
        Object object;
        if (this.fElementChildren.length <= this.fElementChildrenLength) {
            object = new QName[this.fElementChildren.length * 2];
            System.arraycopy(this.fElementChildren, 0, object, 0, this.fElementChildren.length);
            this.fElementChildren = object;
        }
        if ((object = this.fElementChildren[this.fElementChildrenLength]) == null) {
            int n = this.fElementChildrenLength;
            while (n < this.fElementChildren.length) {
                this.fElementChildren[n] = new QName();
                ++n;
            }
            object = this.fElementChildren[this.fElementChildrenLength];
        }
        object.clear();
        ++this.fElementChildrenLength;
    }

    private int checkContent(int n, QName[] qNameArray, int n2, int n3) throws Exception {
        int n4 = this.fCurrentElement.rawname;
        int n5 = this.fCurrentContentSpecType;
        if (n5 == 0) {
            if (n3 != 0) {
                return 0;
            }
        } else if (n5 != 1) {
            if (n5 == 2 || n5 == 3 || n5 == 4) {
                if (n3 == 0 && this.fNil) {
                    this.fNil = false;
                    return -1;
                }
                XMLContentModel xMLContentModel = null;
                try {
                    xMLContentModel = this.getElementContentModel(n);
                    int n6 = this.fContentModelStateStack[this.fElementDepth + 1];
                    if (n6 != -2) {
                        if (n6 == -1 || !((DFAContentModel)xMLContentModel).isFinalState(n6)) {
                            return this.fContentModelEleCount[this.fElementDepth + 1];
                        }
                        return -1;
                    }
                    int n7 = xMLContentModel.validateContent(qNameArray, n2, n3);
                    if (n7 != -1 && this.fGrammarIsSchemaGrammar) {
                        n7 = xMLContentModel.validateContentSpecial(qNameArray, n2, n3);
                    }
                    return n7;
                }
                catch (CMException cMException) {
                    int n8 = cMException.getErrorCode();
                    this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.apache.org/xml/xerces.html", n8, 0, null, 2);
                }
            } else if (n5 == -1) {
                this.reportRecoverableXMLError(83, 79, n4);
            } else if (n5 == 5) {
                Object var7_8 = null;
                if (n3 > 0) {
                    this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/xml-schema-1", 21, 0, new Object[]{"In element '" + this.fStringPool.toString(n4) + "' : " + "Can not have element children within a simple type content"}, 1);
                } else {
                    try {
                        if (this.fCurrentDV == null) {
                            this.fGrammar.getElementDecl(n, this.fTempElementDecl);
                            this.fCurrentDV = this.fTempElementDecl.datatypeValidator;
                        }
                        if (this.fXsiTypeValidator != null) {
                            this.fCurrentDV = this.fXsiTypeValidator;
                            this.fXsiTypeValidator = null;
                        }
                        if (this.fCurrentDV == null) {
                            System.out.println("Internal Error: this element have a simpletype but no datatypevalidator was found, element " + this.fTempElementDecl.name + ",locapart: " + this.fStringPool.toString(this.fTempElementDecl.name.localpart));
                        } else {
                            String string = this.fDatatypeBuffer.toString();
                            String string2 = ((SchemaGrammar)this.fGrammar).getElementDefaultValue(this.fCurrentElementIndex);
                            int n9 = ((SchemaGrammar)this.fGrammar).getElementDeclMiscFlags(this.fCurrentElementIndex) & 4;
                            if (this.fNil) {
                                if (string.length() != 0) {
                                    this.reportRecoverableXMLError(169, 146, "An element <" + this.fStringPool.toString(n4) + "> with attribute xsi:nil=\"true\" must be empty");
                                }
                                if (n9 != 0) {
                                    this.reportRecoverableXMLError(169, 146, "An element <" + this.fStringPool.toString(n4) + "> with attribute xsi:nil=\"true\" must not have fixed value constraint");
                                }
                                this.fNil = false;
                                return -1;
                            }
                            if (string2 == null || string2.length() == 0) {
                                this.validateUsingDV(this.fCurrentDV, string, false);
                            } else if (n9 != 0) {
                                if (string.length() == 0) {
                                    this.fDocumentHandler.characters(string2.toCharArray(), 0, string2.length());
                                    this.validateUsingDV(this.fCurrentDV, string2, true);
                                } else {
                                    if (this.fCurrentDV.compare(string, string2) != 0) {
                                        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/xml-schema-1", 38, 0, null, 1);
                                    }
                                    this.validateUsingDV(this.fCurrentDV, string, true);
                                }
                            } else if (string.length() == 0) {
                                this.fDocumentHandler.characters(string2.toCharArray(), 0, string2.length());
                                this.validateUsingDV(this.fCurrentDV, string2, true);
                            } else {
                                this.validateUsingDV(this.fCurrentDV, string, false);
                            }
                        }
                    }
                    catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/xml-schema-1", 21, 0, new Object[]{"In element '" + this.fStringPool.toString(n4) + "' : " + invalidDatatypeValueException.getMessage()}, 1);
                    }
                    this.fCurrentDV = null;
                    this.fFirstChunk = true;
                    this.fTrailing = false;
                }
            } else {
                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.apache.org/xml/xerces.html", 8, 0, null, 2);
            }
        }
        return -1;
    }

    private void printChildren() {
    }

    private void printStack() {
    }

    boolean invalidStandaloneAttDef(QName qName, QName qName2) {
        if (this.fStandaloneReader == -1) {
            return false;
        }
        if (qName.rawname == -1) {
            return false;
        }
        return this.getAttDefIsExternal(qName, qName2);
    }

    void validateUsingDV(DatatypeValidator datatypeValidator, String string, boolean bl) throws Exception, InvalidDatatypeValueException {
        if (datatypeValidator instanceof IDDatatypeValidator) {
            datatypeValidator.validate(string, this.fIdDefs);
        } else if (datatypeValidator instanceof IDREFDatatypeValidator) {
            datatypeValidator.validate(string, this.fValidateIDRef);
        } else if (datatypeValidator instanceof ENTITYDatatypeValidator) {
            datatypeValidator.validate(string, this.fValidateEntity);
        } else if (!bl) {
            if (datatypeValidator instanceof NOTATIONDatatypeValidator && string != null) {
                string = this.bindNotationURI(string);
            }
            datatypeValidator.validate(string, null);
        }
    }

    static final class OrderedHashtable
    implements Cloneable {
        private int fSize;
        private Entry[] fEntries = null;

        OrderedHashtable() {
        }

        public int size() {
            return this.fSize;
        }

        public void put(Field field, IDValue iDValue) {
            int n = this.indexOf(field);
            if (n == -1) {
                this.ensureCapacity(this.fSize);
                n = this.fSize++;
                this.fEntries[n].key = field;
            }
            this.fEntries[n].value = iDValue;
        }

        public IDValue get(Field field) {
            return this.fEntries[this.indexOf((Field)field)].value;
        }

        public int indexOf(Field field) {
            int n = 0;
            while (n < this.fSize) {
                if (this.fEntries[n].key == field) {
                    return n;
                }
                ++n;
            }
            return -1;
        }

        public Field keyAt(int n) {
            return this.fEntries[n].key;
        }

        public IDValue valueAt(int n) {
            return this.fEntries[n].value;
        }

        public void clear() {
            this.fSize = 0;
        }

        private void ensureCapacity(int n) {
            int n2 = -1;
            int n3 = -1;
            if (this.fEntries == null) {
                n2 = 0;
                n3 = 2;
                this.fEntries = new Entry[n3];
            } else if (this.fEntries.length <= n) {
                n2 = this.fEntries.length;
                n3 = 2 * n2;
                Entry[] entryArray = new Entry[n3];
                System.arraycopy(this.fEntries, 0, entryArray, 0, n2);
                this.fEntries = entryArray;
            }
            int n4 = n2;
            while (n4 < n3) {
                this.fEntries[n4] = new Entry();
                ++n4;
            }
        }

        public Object clone() {
            OrderedHashtable orderedHashtable = new OrderedHashtable();
            int n = 0;
            while (n < this.fSize) {
                orderedHashtable.put(this.fEntries[n].key, this.fEntries[n].value);
                ++n;
            }
            return orderedHashtable;
        }

        public String toString() {
            if (this.fSize == 0) {
                return "[]";
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('[');
            int n = 0;
            while (n < this.fSize) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append('{');
                stringBuffer.append(this.fEntries[n].key);
                stringBuffer.append(',');
                stringBuffer.append(this.fEntries[n].value);
                stringBuffer.append('}');
                ++n;
            }
            stringBuffer.append(']');
            return stringBuffer.toString();
        }

        public static final class Entry {
            public Field key;
            public IDValue value;
        }
    }

    protected class ValueStoreCache {
        protected final Vector fValueStores = new Vector();
        protected final Hashtable fIdentityConstraint2ValueStoreMap = new Hashtable();
        protected final Stack fGlobalMapStack = new Stack();
        protected final Hashtable fGlobalIDConstraintMap = new Hashtable();

        public void startDocument() throws Exception {
            this.fValueStores.removeAllElements();
            this.fIdentityConstraint2ValueStoreMap.clear();
            this.fGlobalIDConstraintMap.clear();
            this.fGlobalMapStack.removeAllElements();
        }

        public void startElement() {
            this.fGlobalMapStack.push(this.fGlobalIDConstraintMap.clone());
            this.fGlobalIDConstraintMap.clear();
        }

        public void endElement() {
            if (this.fGlobalMapStack.isEmpty()) {
                return;
            }
            Hashtable hashtable = (Hashtable)this.fGlobalMapStack.pop();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                IdentityConstraint identityConstraint = (IdentityConstraint)enumeration.nextElement();
                ValueStoreBase valueStoreBase = (ValueStoreBase)hashtable.get(identityConstraint);
                if (valueStoreBase == null) continue;
                ValueStoreBase valueStoreBase2 = (ValueStoreBase)this.fGlobalIDConstraintMap.get(identityConstraint);
                if (valueStoreBase2 == null) {
                    this.fGlobalIDConstraintMap.put(identityConstraint, valueStoreBase);
                    continue;
                }
                valueStoreBase2.append(valueStoreBase);
                this.fGlobalIDConstraintMap.put(identityConstraint, valueStoreBase2);
            }
        }

        public void initValueStoresFor(XMLElementDecl xMLElementDecl) throws Exception {
            Object object;
            Object object2;
            Vector vector = xMLElementDecl.unique;
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                object2 = (Unique)vector.elementAt(n2);
                UniqueValueStore uniqueValueStore = (UniqueValueStore)this.fIdentityConstraint2ValueStoreMap.get(object2);
                if (uniqueValueStore == null) {
                    uniqueValueStore = new UniqueValueStore((Unique)object2);
                    this.fValueStores.addElement(uniqueValueStore);
                    this.fIdentityConstraint2ValueStoreMap.put(object2, uniqueValueStore);
                }
                ++n2;
            }
            object2 = xMLElementDecl.key;
            int n3 = ((Vector)object2).size();
            int n4 = 0;
            while (n4 < n3) {
                object = (Key)((Vector)object2).elementAt(n4);
                KeyValueStore keyValueStore = (KeyValueStore)this.fIdentityConstraint2ValueStoreMap.get(object);
                if (keyValueStore == null) {
                    keyValueStore = new KeyValueStore((Key)object);
                    this.fValueStores.addElement(keyValueStore);
                    this.fIdentityConstraint2ValueStoreMap.put(object, keyValueStore);
                }
                ++n4;
            }
            object = xMLElementDecl.keyRef;
            int n5 = ((Vector)object).size();
            int n6 = 0;
            while (n6 < n5) {
                KeyRef keyRef = (KeyRef)((Vector)object).elementAt(n6);
                KeyRefValueStore keyRefValueStore = new KeyRefValueStore(keyRef, null);
                this.fValueStores.addElement(keyRefValueStore);
                this.fIdentityConstraint2ValueStoreMap.put(keyRef, keyRefValueStore);
                ++n6;
            }
        }

        public ValueStoreBase getValueStoreFor(Field field) {
            IdentityConstraint identityConstraint = field.getIdentityConstraint();
            return (ValueStoreBase)this.fIdentityConstraint2ValueStoreMap.get(identityConstraint);
        }

        public ValueStoreBase getValueStoreFor(IdentityConstraint identityConstraint) {
            return (ValueStoreBase)this.fIdentityConstraint2ValueStoreMap.get(identityConstraint);
        }

        public ValueStoreBase getGlobalValueStoreFor(IdentityConstraint identityConstraint) {
            return (ValueStoreBase)this.fGlobalIDConstraintMap.get(identityConstraint);
        }

        public void transplant(IdentityConstraint identityConstraint) throws Exception {
            if (identityConstraint.getType() == 2) {
                return;
            }
            ValueStoreBase valueStoreBase = (ValueStoreBase)this.fIdentityConstraint2ValueStoreMap.get(identityConstraint);
            this.fIdentityConstraint2ValueStoreMap.remove(identityConstraint);
            ValueStoreBase valueStoreBase2 = (ValueStoreBase)this.fGlobalIDConstraintMap.get(identityConstraint);
            if (valueStoreBase2 != null) {
                valueStoreBase2.append(valueStoreBase);
                this.fGlobalIDConstraintMap.put(identityConstraint, valueStoreBase2);
            } else {
                this.fGlobalIDConstraintMap.put(identityConstraint, valueStoreBase);
            }
        }

        public void endDocument() throws Exception {
            int n = this.fValueStores.size();
            int n2 = 0;
            while (n2 < n) {
                ValueStoreBase valueStoreBase = (ValueStoreBase)this.fValueStores.elementAt(n2);
                valueStoreBase.endDocument();
                ++n2;
            }
        }

        public String toString() {
            String string = super.toString();
            int n = string.lastIndexOf(36);
            if (n != -1) {
                return string.substring(n + 1);
            }
            int n2 = string.lastIndexOf(46);
            if (n2 != -1) {
                return string.substring(n2 + 1);
            }
            return string;
        }
    }

    protected class KeyRefValueStore
    extends ValueStoreBase {
        protected ValueStoreBase fKeyValueStore;

        public KeyRefValueStore(KeyRef keyRef, KeyValueStore keyValueStore) {
            super(keyRef);
            this.fKeyValueStore = keyValueStore;
        }

        public void endDocumentFragment() throws Exception {
            super.endDocumentFragment();
            this.fKeyValueStore = (ValueStoreBase)XMLValidator.this.fValueStoreCache.fGlobalIDConstraintMap.get(((KeyRef)this.fIdentityConstraint).getKey());
            if (this.fKeyValueStore == null) {
                int n = 41;
                String string = this.fIdentityConstraint.toString();
                XMLValidator.this.reportSchemaError(n, new Object[]{string});
                return;
            }
            int n = this.fValueTuples.size();
            int n2 = 0;
            while (n2 < n) {
                OrderedHashtable orderedHashtable = (OrderedHashtable)this.fValueTuples.elementAt(n2);
                if (!this.fKeyValueStore.contains(orderedHashtable)) {
                    int n3 = 35;
                    String string = this.toString(orderedHashtable);
                    String string2 = this.fIdentityConstraint.getElementName();
                    XMLValidator.this.reportSchemaError(n3, new Object[]{string, string2});
                }
                ++n2;
            }
        }

        public void endDocument() throws Exception {
            super.endDocument();
        }
    }

    protected class KeyValueStore
    extends ValueStoreBase {
        public KeyValueStore(Key key) {
            super(key);
        }

        protected void duplicateValue(OrderedHashtable orderedHashtable) throws Exception {
            int n = 34;
            String string = this.toString(orderedHashtable);
            String string2 = this.fIdentityConstraint.getElementName();
            XMLValidator.this.reportSchemaError(n, new Object[]{string, string2});
        }
    }

    protected class UniqueValueStore
    extends ValueStoreBase {
        public UniqueValueStore(Unique unique) {
            super(unique);
        }

        protected void duplicateValue(OrderedHashtable orderedHashtable) throws Exception {
            int n = 33;
            String string = this.toString(orderedHashtable);
            String string2 = this.fIdentityConstraint.getElementName();
            XMLValidator.this.reportSchemaError(n, new Object[]{string, string2});
        }
    }

    protected abstract class ValueStoreBase
    implements ValueStore {
        protected IDValue NOT_AN_IDVALUE = new IDValue("\uffff", null);
        protected IdentityConstraint fIdentityConstraint;
        protected final OrderedHashtable fValues = new OrderedHashtable();
        protected int fValuesCount;
        protected final Vector fValueTuples = new Vector();

        protected ValueStoreBase(IdentityConstraint identityConstraint) {
            this.fIdentityConstraint = identityConstraint;
        }

        public void destroy() {
            this.fValuesCount = 0;
            this.fValues.clear();
            this.fValueTuples.removeAllElements();
        }

        public void append(ValueStoreBase valueStoreBase) {
            int n = 0;
            while (n < valueStoreBase.fValueTuples.size()) {
                OrderedHashtable orderedHashtable = (OrderedHashtable)valueStoreBase.fValueTuples.elementAt(n);
                if (!this.contains(orderedHashtable)) {
                    this.fValueTuples.addElement(orderedHashtable);
                }
                ++n;
            }
        }

        public void startValueScope() throws Exception {
            this.fValuesCount = 0;
            int n = this.fIdentityConstraint.getFieldCount();
            int n2 = 0;
            while (n2 < n) {
                this.fValues.put(this.fIdentityConstraint.getFieldAt(n2), this.NOT_AN_IDVALUE);
                ++n2;
            }
        }

        public void endValueScope() throws Exception {
            if (this.fValuesCount == 0) {
                if (this.fIdentityConstraint.getType() == 1) {
                    int n = 42;
                    String string = this.fIdentityConstraint.getElementName();
                    XMLValidator.this.reportSchemaError(n, new Object[]{string});
                }
                return;
            }
            if (this.fValuesCount != this.fIdentityConstraint.getFieldCount()) {
                switch (this.fIdentityConstraint.getType()) {
                    case 0: {
                        int n = 29;
                        String string = this.fIdentityConstraint.getElementName();
                        XMLValidator.this.reportSchemaError(n, new Object[]{string});
                        break;
                    }
                    case 1: {
                        int n = 30;
                        Key key = (Key)this.fIdentityConstraint;
                        String string = this.fIdentityConstraint.getElementName();
                        String string2 = key.getIdentityConstraintName();
                        XMLValidator.this.reportSchemaError(n, new Object[]{string, string2});
                        break;
                    }
                    case 2: {
                        int n = 31;
                        KeyRef keyRef = (KeyRef)this.fIdentityConstraint;
                        String string = this.fIdentityConstraint.getElementName();
                        String string3 = keyRef.getKey().getIdentityConstraintName();
                        XMLValidator.this.reportSchemaError(n, new Object[]{string, string3});
                    }
                }
                return;
            }
        }

        public void endDocumentFragment() throws Exception {
        }

        public void endDocument() throws Exception {
        }

        public void reportNilError(IdentityConstraint identityConstraint) throws Exception {
            if (identityConstraint.getType() == 1) {
                int n = 43;
                XMLValidator.this.reportSchemaError(n, new Object[]{identityConstraint.getElementName()});
            }
        }

        public void addValue(Field field, IDValue iDValue) throws Exception {
            int n;
            if (!field.mayMatch()) {
                n = 40;
                XMLValidator.this.reportSchemaError(n, new Object[]{field.toString()});
            }
            if ((n = this.fValues.indexOf(field)) == -1) {
                int n2 = 36;
                XMLValidator.this.reportSchemaError(n2, new Object[]{field.toString()});
                return;
            }
            IDValue iDValue2 = this.fValues.valueAt(n);
            if (iDValue2.isDuplicateOf(this.NOT_AN_IDVALUE)) {
                ++this.fValuesCount;
            }
            this.fValues.put(field, iDValue);
            if (this.fValuesCount == this.fValues.size()) {
                if (this.contains(this.fValues)) {
                    this.duplicateValue(this.fValues);
                }
                OrderedHashtable orderedHashtable = (OrderedHashtable)this.fValues.clone();
                this.fValueTuples.addElement(orderedHashtable);
            }
        }

        public boolean contains(OrderedHashtable orderedHashtable) {
            int n = orderedHashtable.size();
            int n2 = this.fValueTuples.size();
            int n3 = 0;
            while (n3 < n2) {
                block3: {
                    OrderedHashtable orderedHashtable2 = (OrderedHashtable)this.fValueTuples.elementAt(n3);
                    int n4 = 0;
                    while (n4 < n) {
                        IDValue iDValue;
                        IDValue iDValue2 = orderedHashtable2.valueAt(n4);
                        if (iDValue2.isDuplicateOf(iDValue = orderedHashtable.valueAt(n4))) {
                            ++n4;
                            continue;
                        }
                        break block3;
                    }
                    return true;
                }
                ++n3;
            }
            return false;
        }

        protected void duplicateValue(OrderedHashtable orderedHashtable) throws Exception {
        }

        protected String toString(OrderedHashtable orderedHashtable) {
            int n = orderedHashtable.size();
            if (n == 0) {
                return "";
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < n) {
                if (n2 > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(orderedHashtable.valueAt(n2));
                ++n2;
            }
            return stringBuffer.toString();
        }

        public String toString() {
            int n;
            String string = super.toString();
            int n2 = string.lastIndexOf(36);
            if (n2 != -1) {
                string = string.substring(n2 + 1);
            }
            if ((n = string.lastIndexOf(46)) != -1) {
                string = string.substring(n + 1);
            }
            return string + '[' + this.fIdentityConstraint + ']';
        }
    }

    protected static class XPathMatcherStack {
        protected XPathMatcher[] fMatchers = new XPathMatcher[4];
        protected int fMatchersCount;
        protected IntStack fContextStack = new IntStack();

        public void clear() {
            int n = 0;
            while (n < this.fMatchersCount) {
                this.fMatchers[n] = null;
                ++n;
            }
            this.fMatchersCount = 0;
            this.fContextStack.clear();
        }

        public int size() {
            return this.fContextStack.size();
        }

        public int getMatcherCount() {
            return this.fMatchersCount;
        }

        public void addMatcher(XPathMatcher xPathMatcher) {
            this.ensureMatcherCapacity();
            this.fMatchers[this.fMatchersCount++] = xPathMatcher;
        }

        public XPathMatcher getMatcherAt(int n) {
            return this.fMatchers[n];
        }

        public void pushContext() {
            this.fContextStack.push(this.fMatchersCount);
        }

        public void popContext() {
            this.fMatchersCount = this.fContextStack.pop();
        }

        private void ensureMatcherCapacity() {
            if (this.fMatchersCount == this.fMatchers.length) {
                XPathMatcher[] xPathMatcherArray = new XPathMatcher[this.fMatchers.length * 2];
                System.arraycopy(this.fMatchers, 0, xPathMatcherArray, 0, this.fMatchers.length);
                this.fMatchers = xPathMatcherArray;
            }
        }
    }

    final class AttValidatorENUMERATION
    implements AttributeValidator {
        AttValidatorENUMERATION() {
        }

        public int normalize(QName qName, QName qName2, int n, int n2, int n3) throws Exception {
            String string = XMLValidator.this.fStringPool.toString(n);
            String string2 = string.trim();
            if (XMLValidator.this.fValidating) {
                if (string2 != string) {
                    if (this.invalidStandaloneAttDef(qName, qName2)) {
                        XMLValidator.this.reportRecoverableXMLError(123, 80, XMLValidator.this.fStringPool.toString(qName2.rawname), string, string2);
                    }
                    n = XMLValidator.this.fStringPool.addSymbol(string2);
                } else {
                    n = XMLValidator.this.fStringPool.addSymbol(n);
                }
                if (!XMLValidator.this.fStringPool.stringInList(n3, n)) {
                    XMLValidator.this.reportRecoverableXMLError(90, 86, XMLValidator.this.fStringPool.toString(qName2.rawname), string2, XMLValidator.this.fStringPool.stringListAsString(n3));
                }
            } else if (string2 != string) {
                n = XMLValidator.this.fStringPool.addSymbol(string2);
            }
            return n;
        }

        boolean invalidStandaloneAttDef(QName qName, QName qName2) {
            if (XMLValidator.this.fStandaloneReader == -1) {
                return false;
            }
            if (qName.rawname == -1) {
                return false;
            }
            return XMLValidator.this.getAttDefIsExternal(qName, qName2);
        }
    }

    final class AttValidatorNOTATION
    implements AttributeValidator {
        AttValidatorNOTATION() {
        }

        public int normalize(QName qName, QName qName2, int n, int n2, int n3) throws Exception {
            String string = XMLValidator.this.fStringPool.toString(n);
            String string2 = string.trim();
            if (XMLValidator.this.fValidating) {
                if (string2 != string) {
                    if (this.invalidStandaloneAttDef(qName, qName2)) {
                        XMLValidator.this.reportRecoverableXMLError(123, 80, XMLValidator.this.fStringPool.toString(qName2.rawname), string, string2);
                    }
                    n = XMLValidator.this.fStringPool.addSymbol(string2);
                } else {
                    n = XMLValidator.this.fStringPool.addSymbol(n);
                }
                if (!XMLValidator.this.fStringPool.stringInList(n3, n)) {
                    XMLValidator.this.reportRecoverableXMLError(90, 84, XMLValidator.this.fStringPool.toString(qName2.rawname), string2, XMLValidator.this.fStringPool.stringListAsString(n3));
                }
            } else if (string2 != string) {
                n = XMLValidator.this.fStringPool.addSymbol(string2);
            }
            return n;
        }

        boolean invalidStandaloneAttDef(QName qName, QName qName2) {
            if (XMLValidator.this.fStandaloneReader == -1) {
                return false;
            }
            if (qName.rawname == -1) {
                return false;
            }
            return XMLValidator.this.getAttDefIsExternal(qName, qName2);
        }
    }

    public static interface AttributeValidator {
        public int normalize(QName var1, QName var2, int var3, int var4, int var5) throws Exception;
    }

    static class ErrorHandler
    implements org.xml.sax.ErrorHandler {
        ErrorHandler() {
        }

        public void warning(SAXParseException sAXParseException) {
            System.err.println("[Warning] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        }

        public void error(SAXParseException sAXParseException) {
            System.err.println("[Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        }

        public void fatalError(SAXParseException sAXParseException) {
            System.err.println("[Fatal Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        }

        private String getLocationString(SAXParseException sAXParseException) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = sAXParseException.getSystemId();
            if (string != null) {
                int n = string.lastIndexOf(47);
                if (n != -1) {
                    string = string.substring(n + 1);
                }
                stringBuffer.append(string);
            }
            stringBuffer.append(':');
            stringBuffer.append(sAXParseException.getLineNumber());
            stringBuffer.append(':');
            stringBuffer.append(sAXParseException.getColumnNumber());
            return stringBuffer.toString();
        }
    }

    static class Resolver
    implements EntityResolver {
        private static final String[] SYSTEM = new String[]{"http://www.w3.org/2001/XMLSchema.dtd", "http://www.w3.org/XMLSchema/datatypes.dtd", "http://www.w3.org/XMLSchema/versionInfo.ent"};
        private static final String[] PATH = new String[]{"structures.dtd", "datatypes.dtd", "versionInfo.ent"};
        private DefaultEntityHandler fEntityHandler;

        public Resolver(DefaultEntityHandler defaultEntityHandler) {
            this.fEntityHandler = defaultEntityHandler;
        }

        public InputSource resolveEntity(String string, String string2) throws IOException, SAXException {
            InputSource inputSource;
            int n = 0;
            while (n < SYSTEM.length) {
                if (string2.equals(SYSTEM[n])) {
                    InputSource inputSource2 = new InputSource(this.getClass().getResourceAsStream(PATH[n]));
                    inputSource2.setPublicId(string);
                    inputSource2.setSystemId(string2);
                    return inputSource2;
                }
                ++n;
            }
            EntityResolver entityResolver = this.fEntityHandler.getEntityResolver();
            if (entityResolver != null && (inputSource = entityResolver.resolveEntity(string, string2)) != null) {
                return inputSource;
            }
            return new InputSource(this.fEntityHandler.expandSystemId(string2));
        }
    }
}

