/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;

public class TreeWalkerImpl
implements TreeWalker {
    private boolean fEntityReferenceExpansion = false;
    int fWhatToShow = -1;
    NodeFilter fNodeFilter;
    Node fCurrentNode;
    Node fRoot;

    public TreeWalkerImpl(Node node, int n, NodeFilter nodeFilter, boolean bl) {
        this.fCurrentNode = node;
        this.fRoot = node;
        this.fWhatToShow = n;
        this.fNodeFilter = nodeFilter;
        this.fEntityReferenceExpansion = bl;
    }

    public Node getRoot() {
        return this.fRoot;
    }

    public int getWhatToShow() {
        return this.fWhatToShow;
    }

    public NodeFilter getFilter() {
        return this.fNodeFilter;
    }

    public boolean getExpandEntityReferences() {
        return this.fEntityReferenceExpansion;
    }

    public Node getCurrentNode() {
        return this.fCurrentNode;
    }

    public void setCurrentNode(Node node) {
        this.fCurrentNode = node;
    }

    public Node parentNode() {
        if (this.fCurrentNode == null) {
            return null;
        }
        Node node = this.getParentNode(this.fCurrentNode);
        if (node != null) {
            this.fCurrentNode = node;
        }
        return node;
    }

    public Node firstChild() {
        if (this.fCurrentNode == null) {
            return null;
        }
        Node node = this.getFirstChild(this.fCurrentNode);
        if (node != null) {
            this.fCurrentNode = node;
        }
        return node;
    }

    public Node lastChild() {
        if (this.fCurrentNode == null) {
            return null;
        }
        Node node = this.getLastChild(this.fCurrentNode);
        if (node != null) {
            this.fCurrentNode = node;
        }
        return node;
    }

    public Node previousSibling() {
        if (this.fCurrentNode == null) {
            return null;
        }
        Node node = this.getPreviousSibling(this.fCurrentNode);
        if (node != null) {
            this.fCurrentNode = node;
        }
        return node;
    }

    public Node nextSibling() {
        if (this.fCurrentNode == null) {
            return null;
        }
        Node node = this.getNextSibling(this.fCurrentNode);
        if (node != null) {
            this.fCurrentNode = node;
        }
        return node;
    }

    public Node previousNode() {
        Node node;
        if (this.fCurrentNode == null) {
            return null;
        }
        Node node2 = this.getPreviousSibling(this.fCurrentNode);
        if (node2 == null) {
            node2 = this.getParentNode(this.fCurrentNode);
            if (node2 != null) {
                this.fCurrentNode = node2;
                return this.fCurrentNode;
            }
            return null;
        }
        Node node3 = node = this.getLastChild(node2);
        while (node != null) {
            node3 = node;
            node = this.getLastChild(node3);
        }
        node = node3;
        if (node != null) {
            this.fCurrentNode = node;
            return this.fCurrentNode;
        }
        if (node2 != null) {
            this.fCurrentNode = node2;
            return this.fCurrentNode;
        }
        return null;
    }

    public Node nextNode() {
        if (this.fCurrentNode == null) {
            return null;
        }
        Node node = this.getFirstChild(this.fCurrentNode);
        if (node != null) {
            this.fCurrentNode = node;
            return node;
        }
        node = this.getNextSibling(this.fCurrentNode);
        if (node != null) {
            this.fCurrentNode = node;
            return node;
        }
        Node node2 = this.getParentNode(this.fCurrentNode);
        while (node2 != null) {
            node = this.getNextSibling(node2);
            if (node != null) {
                this.fCurrentNode = node;
                return node;
            }
            node2 = this.getParentNode(node2);
        }
        return null;
    }

    Node getParentNode(Node node) {
        if (node == null || node == this.fRoot) {
            return null;
        }
        Node node2 = node.getParentNode();
        if (node2 == null) {
            return null;
        }
        short s = this.acceptNode(node2);
        if (s == 1) {
            return node2;
        }
        return this.getParentNode(node2);
    }

    Node getNextSibling(Node node) {
        if (node == null || node == this.fRoot) {
            return null;
        }
        Node node2 = node.getNextSibling();
        if (node2 == null) {
            node2 = node.getParentNode();
            if (node2 == null || node == this.fRoot) {
                return null;
            }
            short s = this.acceptNode(node2);
            if (s == 3) {
                return this.getNextSibling(node2);
            }
            return null;
        }
        short s = this.acceptNode(node2);
        if (s == 1) {
            return node2;
        }
        if (s == 3) {
            return this.getFirstChild(node2);
        }
        return this.getNextSibling(node2);
    }

    Node getPreviousSibling(Node node) {
        if (node == null || node == this.fRoot) {
            return null;
        }
        Node node2 = node.getPreviousSibling();
        if (node2 == null) {
            node2 = node.getParentNode();
            if (node2 == null || node == this.fRoot) {
                return null;
            }
            short s = this.acceptNode(node2);
            if (s == 3) {
                return this.getPreviousSibling(node2);
            }
            return null;
        }
        short s = this.acceptNode(node2);
        if (s == 1) {
            return node2;
        }
        if (s == 3) {
            Node node3 = this.getLastChild(node2);
            if (node3 == null) {
                return this.getPreviousSibling(node2);
            }
            return node3;
        }
        return this.getPreviousSibling(node2);
    }

    Node getFirstChild(Node node) {
        if (node == null) {
            return null;
        }
        if (!this.fEntityReferenceExpansion && node.getNodeType() == 5) {
            return null;
        }
        Node node2 = node.getFirstChild();
        if (node2 == null) {
            return this.getNextSibling(node);
        }
        short s = this.acceptNode(node2);
        if (s == 1) {
            return node2;
        }
        if (s == 3 && node2.hasChildNodes()) {
            return this.getFirstChild(node2);
        }
        return this.getNextSibling(node2);
    }

    Node getLastChild(Node node) {
        if (node == null) {
            return null;
        }
        if (!this.fEntityReferenceExpansion && node.getNodeType() == 5) {
            return null;
        }
        Node node2 = node.getLastChild();
        if (node2 == null) {
            return null;
        }
        short s = this.acceptNode(node2);
        if (s == 1) {
            return node2;
        }
        if (s == 3 && node2.hasChildNodes()) {
            return this.getLastChild(node2);
        }
        return this.getPreviousSibling(node2);
    }

    short acceptNode(Node node) {
        if (this.fNodeFilter == null) {
            if ((this.fWhatToShow & 1 << node.getNodeType() - 1) != 0) {
                return 1;
            }
            return 3;
        }
        if ((this.fWhatToShow & 1 << node.getNodeType() - 1) != 0) {
            return this.fNodeFilter.acceptNode(node);
        }
        return 3;
    }
}

