/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.util;

import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;

public class Log4jHandler
extends Handler {
    private static final int TRACE = java.util.logging.Level.FINER.intValue();
    private static final int DEBUG = java.util.logging.Level.FINE.intValue();
    private static final int INFO = java.util.logging.Level.INFO.intValue();
    private static final int WARN = java.util.logging.Level.WARNING.intValue();
    private static final int ERROR = java.util.logging.Level.SEVERE.intValue();

    public void publish(LogRecord record) {
        Logger logger = Logger.getLogger((String)record.getLoggerName());
        Level level = this.decode(record.getLevel().intValue());
        if (level.isGreaterOrEqual((Priority)logger.getEffectiveLevel())) {
            String message = record.getMessage();
            Throwable t = record.getThrown();
            long timestamp = record.getMillis();
            String fqcn = record.getSourceClassName();
            LoggingEvent event = new LoggingEvent(fqcn, (Category)logger, timestamp, (Priority)level, (Object)message, t);
            logger.callAppenders(event);
        }
    }

    private Level decode(int i) {
        if (i <= TRACE) {
            return Level.DEBUG;
        }
        if (i <= DEBUG) {
            return Level.DEBUG;
        }
        if (i <= INFO) {
            return Level.INFO;
        }
        if (i <= WARN) {
            return Level.WARN;
        }
        if (i <= ERROR) {
            return Level.ERROR;
        }
        return Level.INFO;
    }

    public void close() {
    }

    public void flush() {
    }
}

